#!/usr/bin/perl
# Domesday Installation Script for Unix based machines. Windows machines should
# have their own installation system, preferably installing precompiled
# binaries. 
#
################################################################################
## USER PREFERENCES - Feel free to edit
################################################################################

# Locale - This determines what language will be used for the installation
# strings. For valid locales, look for the translations at the end of this file,
# or read the documentation. 
my $locale = 'en';

# domesday script installation dir
my $install_dir = '/usr/local/bin';
# Jar file installation dir
my $jar_dir = '/usrlocal/share/java';
# Manual page installation path. 
my $man_dir = '/usr/local/man/';
# Domesday documentation installation path
my $doc_dir = '/usr/local/doc/domesday';

# Search path for reqired libraries. If you need to change this, please let me
# know.
my @lib_path = ('/usr/share/java/', );

# If this option is set to 1, the script will compile all files from source. If
# it is set to 0, the script will be in 'install mode', i.e. it will require
# precompiled jar files, but will not require the source code (hence precompiled
# binaries can be distributed).
my $do_compile = 1;
# java compiler
my $javac = 'javac';
# java runtime environment
my $java = 'java';
# Jar archiver
my $jar = 'jar';
# Javadoc documentation creator
my $javadoc = 'javadoc';
# javadoc options. The one below is good, but only works if you have net access,
# so default is empty.
# my $javadoc_options = '-link http://java.sun.com/products/jdk/1.4/docs/api -link /usr/share/doc/liboro-java/api/';
my $javadoc_options = '-link /usr/share/doc/liboro-java/api/';

################################################################################
# INSTALLATION CODE - You should not need to edit this. If you do, please let
# me know what changes you made.
################################################################################

# You *really* shouldn't have to change these. Let me know if you do.
my $oro_re = "oro-2\.0.*\.jar";
my $gnu_re_re = "gnu-regexp.*1\.1.*\.jar";
my $VERSION = '$Revision: 1.4 $';

my $oro_url = 'http://jakarta.apache.org/builds/jakarta-oro/release/v${oro.ver}/jakarta-oro-${oro.ver}.tar.gz';
my $gnuRE_url = 'ftp://ftp.tralfamadore.com/pub/java/gnu.regexp-${regex.ver}.tar.gz';

# The following will be populated by the functions of this script.
my $oro_jar = 0;
my $gnu_re_jar = 0;

# Starts the installation process.
sub main(){
	print "Domesday Installer $VERSION\n\n";

	my $build = 0;
	my $compile = 0;
	
	foreach my $item (@ARGV){
		if ($item =~ s/^--installdir=// ){
			$install_dir = $item;		
		}elsif($item =~ s/^--jardir=// ){
			$jar_dir = $item;
		}elsif($item =~ s/^--mandir=// ){
			$man_dir = $item;
		}elsif($item =~ s/^--docdir=//){
			$doc_dir = $item
		}elsif($item =~ m/build/){
			$build = 1;
		}elsif($item =~ m/install/){
			$install = 1;			
		}else{
			print("Unknown option - $item\n");
			print("usage: ./installer.pl <options>\nOptions:\n");
			print("--installdir=[dir]  - place to install the domesday script\n");
			print("--jardir=[dir]      - place to install jar archive\n");
			print("--mandir=[dir] 	   - place to install manual pages\n");
			print("--doc_dir=[dir]     - place to install documentation\n");
			print("build   - build (but not install packages)\n");
			print("install - install files. They must have been built first\n Default option builds then installs");
			exit(10);
		}
	}

	($build = $install = 1) unless ($build or $install);
	
	&get_lib_paths();
	if ($build){
		&compile() if $do_compile;
		&make_script();
	}
	if($install){
		&install();
		&clean if $do_compile;
	}
	print "\nDone.\n";
}

# Tries to determine library paths
sub get_lib_paths(){
	print "Looking for required libraries...\n";
	foreach my $dir (@lib_path){
		opendir DIR, $dir or warn "Unable to search dir for libs: $dir\: $!\n";
		my @files = readdir DIR;
		closedir DIR or warn "Error closing $dir :$!";
		foreach my $file (@files){
			unless ($oro_jar){
			if ( $file =~ m/$oro_re/){
				$oro_jar = "$dir$file";
				print "Found oro library: $oro_jar\n";
			}}
			unless ($gnu_re_jar){
			if ($file =~ m/$gnu_re_re/){
				$gnu_re_jar = "$dir$file";
				print "Found gnu.regexp library: $gnu_re_jar\n";
			}}
		}
	}
	unless ($oro_jar){
		getOro();
	}
	unless($gnu_re_jar){
		getGnuRE();
	}
}

# Compiles all files, generates jar file and javadoc output.
sub compile(){
	print "\nCompiling source...\n";
	`rm -rf build` if -e 'build';
	`mkdir build`;
	`$javac -classpath $oro_jar\:$gnu_re_jar\:\$CLASSPATH -d build -sourcepath src src/*.java`;
	exit(2) if $?;

	print "\nGenerating jar file...\n";
	`cp src/*.properties build`;
	`$jar cf domesday.jar -C build .`;
	exit(3) if $?;

	print "\nGenerating javadoc output\n";
	`mkdir build/api`;
	`$javadoc -doctitle "Domesday API Reference" -version -author -windowtitle "Domesday API Reference" -overview "src/overview.html" $javadoc_options -d build/api src/*.java`; 
	exit(4) if $?;
}

# Generates executable wrapper script.
sub make_script(){
	print "\nGenerating wrapper script...\n";
	open DOMESDAY, ">build/domesday" or die "Error opening >build/domesday: $!an";
	print DOMESDAY "#!/bin/sh\n",
			"# Domesday Wrapper script. Generated by Domesday Installer $VERSION\n",
			"$java -classpath $jar_dir/domesday.jar\:$oro_jar\:$gnu_re_jar\:\$CLASSPATH Domesday \$*;"; 
	close DOMESDAY;
}

# Installs all files
sub install(){
	print "\nInstalling Files...\n";
	`cp domesday.jar $jar_dir/`;
	exit(5) if $?;
	`cp build/domesday $install_dir/`;
	exit(5) if $?;
	`chmod +x $install_dir/domesday`;
	exit(5) if $?;
	`gzip -9c doc-user/domesday.1 > build/domesday.1.gz`;
	exit(5) if $?;
	`gzip -9c doc-user/domesday.project.5 > build/domesday.project.5.gz`;
	exit(5) if $?;
	`cp build/domesday.1.gz $man_dir/man1/`; 
	exit(5) if $?;
	`cp build/domesday.project.5.gz $man_dir/man5/`; 
	exit(5) if $?;
	unless (-e $doc_dir){
		`mkdir $doc_dir`;
		exit(5) if $?;
	}
	unless (-e "$doc_dir/api"){
		`mkdir $doc_dir/api`;
		exit(5) if $?;
	}
	`cp -r build/api/* $doc_dir/api/`;
	exit(5) if $?;
}

# cleans up
sub clean(){
	print "\nCleaning build environment...\n";
	`rm -rf build` if (-e build);
}

# download and install the oro library.
sub getOro(){
	print "Unable to find Jakarta oro library. If you already have it installed, please edit the \@lib_path setting at the top of the insteller.pl file. If you do not have it, please download it from $oro_url and install it then run this script again.";
	exit(1);
}

sub getGnuRE(){

		print "Unable to find gnu.regexp library. If you have a file with a name mathcing gnu-regexp*.jar on your system, please edit the installer.pl script to give a correct search path. If you do not have it installed, please download it from $gnuRE_url and install.";
		# todo 
		exit(1);
}
&main();
