import re
from dosage.modules.helpers import BasicComicModule as bcm

class SexyLosers(bcm.BasicComicModule, bcm.IndirectLatestMixin):
    baseUrl = 'http://www.sexylosers.com/'
    imageUrl = 'http://www.sexylosers.com/%s.html'
    imageSearch = re.compile(r'<img src\s*=\s*"\s*(comics/[\w\.]+?)"', re.IGNORECASE)
    prevSearch = re.compile(r'<a href="(/\d{3}\.\w+?)"><font color = FFAAAA><<', re.IGNORECASE)
    latestSearch = re.compile(r'latest comic</b>: <a href="(/[\w\.]+?)">', re.IGNORECASE)
    help = 'Index format: nnn'

    def getFilename(self, imageUrl, pageUrl):
        index = pageUrl.split('/')[-1].split('.')[0]
        title = imageUrl.split('/')[-1].split('.')[0]
        return index + '-' + title
