import re
from dosage.modules.helpers.BasicComicModule import BasicComicModule

class KeenSpot(BasicComicModule):
    imageUrl = 'd/%s.html'
    imageSearch = re.compile(r'<img[^>]+?src="([^"]*?comics/.+?)"', re.IGNORECASE)
    prevSearch = re.compile(r'<a href="([^"]*?d/\d{8}\.html)"[^>]*>(?:<img[^>]+?(?:name="previous_day"|alt="Previous"|src="[^"]*back[^"]*")|Previous comic)', re.IGNORECASE)
    help = 'Index format: yyyymmdd'

    submodules = {
        '24fps': 'http://filmbuff.keenspace.com/',
        '2WayMirror': 'http://tande.keenspace.com/',
        'ANT': 'http://ant.comicgenesis.com/',
        'Adventurers': 'http://www.adventurers-comic.com/',
        'Alice': 'http://www.alicecomics.com/',
        'AlienDice': 'http://www.aliendice.com/',
        'AlphaLuna': 'http://alphaluna.keenspace.com/',
        'Andiewear': 'http://andiewear.com/',
        'AngelTheDemoness': 'http://angelthedemoness.keenspace.com/',
        'AntiHeroForHire': 'http://www.antiheroforhire.com/',
        'Apotheosis': 'http://apotheosis.keenspace.com/',
        'Aquatica': 'http://aquatica.keenspace.com/',
        'Avalon': 'http://www.avalonhigh.com/',
        'BadlyDrawnKitties': 'http://www.badlydrawnkitties.com/',
        'BasilFlint': 'http://www.basilflint.com/',
        'Blindworks': 'http://blindworks.keenspace.com/',
        'BoomerExpress': 'http://boomerexpress.keenspace.com/',
        'BoyMeetsBoy': 'http://boymeetsboy.keenspot.com/',
        'BrunoTheBandit': 'http://www.brunothebandit.com/',
        'Candi': 'http://www.candicomics.com/',
        'CheckerboardNightmare': 'http://www.checkerboardnightmare.com/',
        'ChoppingBlock': 'http://choppingblock.org/',
        'ClanOfTheCats': 'http://www.clanofthecats.com/',
        'CollegeRoomiesFromHell': 'http://www.crfh.net/',
        'CountYourSheep': 'http://www.countyoursheep.com/',
        'DeltaVenture': 'http://www.alicecomics.com/adv',
        'DexLives': 'http://dexlives.keenspace.com/',
        'EdibleDirt': 'http://catmydog.keenspace.com/',
        'ElGoonishShive': 'http://elgoonishshive.com/',
        'ElfLife': 'http://www.elflife.com/',
        'ElfOnlyInn': 'http://www.elfonlyinn.net/',
        'EverythingJake': 'http://www.everythingjake.com/',
        'ExploitationNow': 'http://www.exploitationnow.com/',
        'FelicityFlint': 'http://www.secretagentgirl.org/',
        'FilthyLies': 'http://www.filthylies.net/',
        'Flem': 'http://flem.keenspace.com/',
        'FoxTails': 'http://foxtails.comicgenesis.com/',
        'FriendlyHostility': 'http://friendlyhostility.com/',
        'FunnyFarm': 'http://www.funnyfarmcomics.com/',
        'GamingGuardians': 'http://gamingguardians.com/',
        'GeneCatlow': 'http://www.genecatlow.com/',
        'GeneralProtectionFault': 'http://www.gpf-comics.com/',
        'Ghastly': 'http://www.ghastlycomic.com/',
        'GoblinHollow': 'http://utlt.keenspace.com/',
        'GreenAvenger': 'http://greenavenger.keenspace.com/',
        'GreystoneInn': 'http://www.greystoneinn.net/',
        'InAPerfectWorld': 'http://iapw.keenspace.com/',
        'ItsWalky': 'http://www.itswalky.com/',
        'JoeAverage': 'http://www.joeaverage.org/',
        'LangLang': 'http://langlang.keenspace.com/',
        'LimitedSpace': 'http://www.limitedspace.org/',
        'LostAndFound': 'http://www.lostandfoundcomic.com/',
        'Lowroad75': 'http://lowroad75.keenspace.com/',
        'MariposaRevelation': 'http://mariposa.keenspace.com/',
        'MenInHats': 'http://www.meninhats.com/',
        'NaughtFramed': 'http://www.damonk.com/',
        'NipAndTuck': 'http://nipandtuck.keenspace.com/',
        'OneOverZero': 'http://oneoverzero.keenspace.com/',
        'Picatrix': 'http://picatrix.keenspace.com/',
        'PurplePussy': 'http://www.purplepussy.net/',
        'QueenOfWands': 'http://www.queenofwands.net/',
        'RPGWorld': 'http://www.rpgworldcomic.com/',
        'RoadWaffles': 'http://www.roadwaffles.com/',
        'SaturdayMorningBreakfastCereal': 'http://smbc.keenspace.com/',
        'Saturnalia': 'http://saturnalia.keenspace.com/',
        'ScandalSheet': 'http://scandalsheet.keenspace.com/',
        'Scatterplot': 'http://scatterplot.keenspace.com/',
        'SchlockMercenary': 'http://www.schlockmercenary.com/',
        'Scrued': 'http://www.scrued.com/',
        'Shifters': 'http://shifters.keenspace.com/',
        'SinFest': 'http://www.sinfest.net/',
        'SkirtingDanger': 'http://www.skirtingdanger.com/',
        'SoapOnARope': 'http://www.soaprope.com/',
        'SoreThumbs': 'http://www.sorethumbsonline.com/',
        'StrangeCandy': 'http://www.strangecandy.net/',
        'Striptease': 'http://www.stripteasecomic.com/',
        'Stubble': 'http://www.stubblecomics.com/',
        'SuburbanJungle': 'http://www.suburbanjungle.com/',
        'TAVision': 'http://tav.keenspace.com/',
        'TalesOfTheQuestor': 'http://npc.keenspace.com/',
        'TangsWeeklyComic': 'http://tang.keenspace.com/',
        'TheClassMenagerie': 'http://www.theclassm.com/',
        'TheDevilsPanties': 'http://devilspanties.keenspot.com/',
        'TheLounge': 'http://thelounge.keenspace.com/',
        'TheShadows': 'http://www.alicecomics.com/shad',
        'ToddAndPenguin': 'http://www.toddandpenguin.com/',
        'TonjaSteele': 'http://tonjasteele.keenspace.com/',
        'TriquetraCats': 'http://triquetracats.comicgenesis.com/',
        'TwoLumps': 'http://www.twolumps.net/',
        'UberSoft': 'http://www.ubersoft.net/',
        'WapsiSquare': 'http://www.wapsisquare.com/',
        'Werechild': 'http://werechild.keenspace.com',
        'Wereworld': 'http://wereworld.keenspace.com/',
        'WorldOfFenninRo': 'http://wofr.keenspace.com/',
        'YouDamnKid': 'http://www.youdamnkid.com/',
        'ZebraGirl': 'http://zebragirl.keenspot.com/',
        'Zortic': 'http://www.zortic.com/',
    }

    latestUrls = {
        'Alice': 'http://www.alicecomics.com/today.html',
        'DeltaVenture': 'http://www.alicecomics.com/adventure.html',
        'ElfLife': 'http://www.elflife.com/today.html',
        'TheShadows': 'http://www.alicecomics.com/shadows.html',
    }

    def __init__(self, submodule):
        BasicComicModule.__init__(self)
        baseUrl = self.submodules[submodule]
        self.latestUrl = self.latestUrls.get(submodule, baseUrl)
        self.imageUrl = baseUrl + self.imageUrl
        self.name = 'KeenSpot' + '/' + submodule
