import re
from dosage import util
from dosage.modules.helpers.BasicComicModule import BasicComicModule

class UComics(BasicComicModule):
    homepage = 'http://www.ucomics.com/'
    baseUrl = 'http://www.ucomics.com/%s'
    latestUrl = '/'
    imageUrl = '/%s/'
    imageSearch = re.compile(r'(http://images.ucomics.com/comics/.+?/\d{4}/.+?\d{6}.gif)')
    prevSearch = re.compile(r'<a href = "(http://www\.ucomics\.com/.+?/\d{4}/\d{2}/\d{2}/)"(?: onClick="this\.href=FCx\(this\.href\);")?>(?:previous date|<IMG SRC="http://images\.ucomics\.com/images/mul/prevpage)')
    help = 'Index format: yyyy/mm/dd'

    submodules = (
        '9to5',
        'adamathome',
        'agnes',
        'andycapp',
        'animalcrackers',
        'animatedoliphant',
        'annie',
        'anntelnaes',
        'askshagg',
        'badreporter',
        'baldo',
        'ballardstreet',
        'barbarabrandon',
        'bc',
        'bensargent',
        'bigtop',
        'biographic',
        'bobthesquirrel',
        'boondocks',
        'bornlucky',
        'bottomliners',
        'boundandgagged',
        'brainwaves',
        'brendastarr',
        'brewsterrockit',
        'broomhilda',
        'brucehammond',
        'calvinandhobbes',
        'cathy',
        'ceodad',
        'cestlavie',
        'chanlowe',
        'charlie',
        'chipbok',
        'chuckasay',
        'citizendog',
        'clearbluewater',
        'cleats',
        'closetohome',
        'compu-toon',
        'cornered',
        'danasummers',
        'danwasserman',
        'davidhorsey',
        'dicklocher',
        'dicktracy',
        'dinetteset',
        'donwright',
        'doodles',
        'doonesbury',
        'dougmarlette',
        'drewsheneman',
        'duplex',
        'facesinthenews',
        'flightdeck',
        'floandfriends',
        'forbetterorforworse',
        'foxtrot',
        'frankandernest',
        'fredbasset',
        'garfield',
        'garyvarvel',
        'gasolinealley',
        'gilthorp',
        'gingermeggs',
        'glennmccoy',
        'heartofthecity',
        'heathcliff',
        'helen',
        'herbandjamaal',
        'housebroken',
        'hubertandabby',
        'idiotbox',
        'inkpen',
        'inthebleachers',
        'jackhiggins',
        'jackohman',
        'jeffdanziger',
        'kudzu',
        'lacucaracha',
        'laloalcaraz',
        'libertymeadows',
        'looseparts',
        'lostsheep',
        'luckycow',
        'mattdavies',
        'meaningoflila',
        'meehanstreak',
        'mixedmedia',
        'momma',
        'mullets',
        'muttandjeff',
        'naturalselection',
        'neurotica',
        'nonsequitur',
        'oddlyenough',
        'onebighappy',
        'overboard',
        'patoliphant',
        'paulconrad',
        'paulszep',
        'pluggers',
        'poochcafe',
        'popculture',
        'preteena',
        'pricklycity',
        'reallifeadventures',
        'reynoldsunwrapped',
        'rubes',
        'shoe',
        'shoecabbage',
        'smallworld',
        'speedbump',
        'stateoftheunion',
        'stevesack',
        'stonesoup',
        'strangebrew',
        'stuartcarlson',
        'suttonimpact',
        'sylvia',
        'tankmcnamara',
        'tedrall',
        'thebigpicture',
        'theelderberries',
        'thefifthwave',
        'theflyingmccoys',
        'thefuscobrothers',
        'themiddletons',
        'theothercoast',
        'thequigmans',
        'tomthedancingbug',
        'tomtoles',
        'tonyauth',
        'walthandelsman',
        'waynestayskal',
        'weepals',
        'wizardofid',
        'workingitout',
        'yenny',
        'zackhill',
        'ziggy',
    )

    def __init__(self, submodule):
        BasicComicModule.__init__(self)
        self.baseUrl = self.baseUrl % submodule
        self.latestUrl = self.baseUrl + self.latestUrl
        self.imageUrl = self.baseUrl + self.imageUrl
        self.name = 'UComics' + '/' + submodule

    def fetchSubmodules(cls):
        exclude = (
            'dearabby',
        )
        submoduleSearch = re.compile(r'<option value="http://www\.ucomics\.com/([^"^/]+)/?"(?: class="drop")?>')
        matches = util.fetchManyMatches(cls.homepage, (submoduleSearch,))[0]

        def fetchSubmodule(module):
            try:
                return util.fetchUrl(cls.baseUrl % module, cls.prevSearch)
            except:
                return False
        return [module for module in matches if fetchSubmodule(module) and module not in exclude]
    fetchSubmodules = classmethod(fetchSubmodules)

