import re
from dosage.modules.helpers.BasicComicModule import BasicComicModule

class EarthsongSaga(BasicComicModule):
    latestUrl = 'http://www.earthsongsaga.com/'
    imageSearch = re.compile(r'<img src="((?:\.\./)?images/Redux\d*/\w+\.jpg)"')
    prevSearch = re.compile(r'<a href="([^"]+\.html)"[^>]*><img src="(?:\.\./)?images/testing/prev')

    def getFilename(self, imageUrl, pageUrl):
        imgmatch = re.compile(r'images/([^/]*)/(\w+)\.[a-z]*$', re.IGNORECASE).search(imageUrl)
        return imgmatch.group(1) + '_' + imgmatch.group(2)

