import re
from dosage.modules.helpers.BasicComicModule import BasicComicModule, BounceMixin
from dosage.util import getQueryParams

class DrunkDuck(BasicComicModule, BounceMixin):
    imageUrl = 'index.php?p=%s'
    imageSearch = re.compile(r"<img src='(http://www.drunkduck.com/[^/]*/pages/[^'/]+)'>", re.IGNORECASE)
    linkSearchRe = r"<a href='(/[^/]*/index\.php\?p=\d+)' title='The %s page!'>"
    prevSearch = re.compile(linkSearchRe % "previous", re.IGNORECASE)
    nextSearch = re.compile(linkSearchRe % "next", re.IGNORECASE)
    help = 'Index format: xxxxx (some increasing number)'

    submodules = (
        '00_Wings',
        '20_Galaxies',
        '3rd_Party_Fantasy',
        'AACMAW',
        'Al_De_Baran',
        'Alpha_Glitch',
        'Anti_Glory',
        'Assassin_Assassin',
        'Blood_of_the_Dragon',
        'Bowsers_Plan_B',
        'ChaoScape',
        'Charby_the_Vampirate',
        'College_Zoo',
        'Culture_Shock',
        'Dogs_Eye_View',
        'Dribble_For_Kids',
        'Elijah_and_Azuu',
        'Elijah_and_Azuu_Classic',
        'fallaparts_parts',
        'Frightmoore_University',
        'Fusion',
        'Kingdom_Hearts_Chain_Of_Oddness',
        'Kong_Comic',
        'Laugh_It_Off',
        'Life_and_Death',
        'Locoma',
        'Luciefer',
        'Mad_World',
        'Mahrs_Miscellaneous_Mishaps',
        'MegaMan_Theater',
        'Megaman__the_comic',
        'MIKYAGU',
        'Mixed_Bag_Comics',
        'Mooks',
        'Neurotica',
        'Nightmistress',
        'NPC',
        'Pinky_TA',
        'Psychic_Headache',
        'Puppetry',
        'Rogue_Agent_Axl',
        'Shagy_Comics',
        'Slither_and_Friends',
        'SNAKES_ON_A_PLANE_THE_COMIC',
        'So_Fantastic_Pork_Show_9oCLOCK',
        'Starving_Artists',
        'The_Gods_of_ArrKelaan',
        'The_Roach_Ranch',
        'The_Whovian_Observer',
        'Tony_The_Hedgehog',
        'Too_Far',
        'trythesoup',
        'Vampire_Phantasm',
        'WeirdStar',
        'Wintergreen',
    )

    def __init__(self, submodule):
        BasicComicModule.__init__(self)
        self.baseUrl = 'http://www.drunkduck.com/' + submodule + '/'
        self.imageUrl = self.baseUrl + self.imageUrl
        self.name = 'DrunkDuck' + '/' + submodule

    def getFilename(self, imageUrl, pageUrl):
        '''DrunkDunk once had different naming shemes for older images. Since
        their last crash this is all gone and all the images have a strange
        128-bit hex string (md5?) as their name. So we use the number that is
        used in the page URL - this one does hopefully not change
        afterwards.'''
        nr = getQueryParams(pageUrl)['p'][0]
        return nr

