# -*- coding: iso-8859-1 -*-
# Copyright (C) 2004-2005 Tristan Seligmann and Jonathan Jacobs
# Copyright (C) 2012-2013 Bastian Kleineidam
from re import compile
from ..scraper import make_scraper
from ..util import tagre, quote, fetchUrl, case_insensitive_re, getPageContent

# SmackJeeves is a crawlers nightmare - users are allowed to edit HTML directly.
# That's why there are so much different search patterns.

_imageSearch = compile(tagre("img", "src", r'([^"]+)', after='id="comic_image"'))
_linkSearch = tagre("a", "href", r'([^>"]*/comics/\d+/[^>"]*)', quote='"?')
_attrs = dict(
    back = case_insensitive_re("back"),
    prev = case_insensitive_re("prev"),
    next = case_insensitive_re("next"),
)
_prevSearch = (
    compile(_linkSearch +
  r'(?:<img[^>]+alt="[^"]*%(prev)s|<img[^>]+(?:button_previous|naviButtons_Previous|nav_prev4|prev|previous|webbuttonback|PrevArrow)\.|[^<]*%(back)s|\s*<<? (?:%(back)s|%(prev)s)|[^<]*%(prev)s)' % _attrs),
    compile(_linkSearch + r'[^<]*Atras<'),
    compile(_linkSearch + tagre("img", "src", r'[^"]+/(?:backrg|JZj4a3C|b5175a677Zd6b)\.png')),
    compile(_linkSearch + tagre("img", "src", r"[^']+/(?:backnav)\.png", quote="'")),
    compile(_linkSearch + r"\s*" + tagre("img", "src", r'[^"]+/prev\.jpg')),
)
_nextSearch = (
    compile(_linkSearch +
  r'(?:<img[^>]+alt="%(next)s|<img[^>]+(?:button_next|naviButtons_Next|nav_next4|next|webbuttonnext-1|NextArrow)\.|\s*<?[^<]*%(next)s)' % _attrs),
    compile(_linkSearch + r'Siguiente'),
    compile(_linkSearch + tagre("img", "src", r'[^"]+/(?:arrow3_zps03f490e3|60ecbaed7gbJs)\.png[^"]*')),
    compile(_linkSearch + tagre("img", "src", r"[^']+/(?:forthnav)\.png[^']*", quote="'")),
)

def add(name, url, description, adult, bounce):
    classname = 'SmackJeeves_' + name

    def modifier(pageUrl):
        if adult:
            # mature content can be viewed directly with:
            # http://www.smackjeeves.com/mature.php?ref=<percent-encoded-url>
            return 'http://www.smackjeeves.com/mature.php?ref=' + quote(pageUrl)
        return pageUrl

    @classmethod
    def _starter(cls):
        """Get start URL."""
        url1 = modifier(url)
        data, baseUrl = getPageContent(url1, cls.session)
        url2 = fetchUrl(url1, data, baseUrl, cls.prevSearch)
        if bounce:
            data, baseUrl = getPageContent(url2, cls.session)
            url3 = fetchUrl(url2, data, baseUrl, _nextSearch)
            return modifier(url3)
        return modifier(url2)

    @classmethod
    def namer(cls, imageUrl, pageUrl):
        parts = pageUrl.split('/')
        name = parts[-2]
        num = parts[-3]
        return "%s_%s" % (name, num)

    globals()[classname] = make_scraper(classname,
        name = 'SmackJeeves/' + name,
        adult = adult,
        url = url,
        starter = _starter,
        prevUrlModifier = lambda cls, url: modifier(url),
        stripUrl = url + '%s/',
        imageSearch = _imageSearch,
        prevSearch = _prevSearch,
        prevUrlMatchesStripUrl = not adult,
        description = description,
        lang = 'es' if name.lower().endswith('spanish') else 'en',
        help = 'Index format: nnnn (some increasing number)',
        namer = namer,
    )


# do not edit anything below since these entries are generated from scripts/update.sh
# DO NOT REMOVE
add('1009sSpritersVacation', 'http://1009sspritersvacation.smackjeeves.com/comics/', u"Okay, so I have updated the site completely, other than the custom pages which I'll get to later at some later point in time. For now, it has no effect on the continuation of the comic, only thing affecting continuation is Sike who has not yet made a sprite sheet for a certain character that's needed for a future part in the plot. But anyway, comment, fav, and rate! That'd really be appreciated~ NOW ACCEPTING CAMEOS! supersonic1009 will update every Wednesday at about 2:00", False, False)
add('12years', 'http://12years.smackjeeves.com/comics/', u'LIKE [12 YEARS] ON FACEBOOK! http://facebook.com/12saimanga "our lovesick heroine, Tenjou Yanaki, is an ordinary 16 year old fortune-telling enthusiast who was given a mysteriously charming pendant from a surreptitiously strange and obscure old lady. yanaki soon wakes up only to find out that she\'s in her 28 year-old body ... 12 years from the future !" - - - - - OH MY. please forgive my typo errors;; i always forget to double check the pages after typesetting.. so if there are misspelled words or ridiculous grammar, please, don\'t mind it. //OTL *contains mushy romance* *may contain mild offensive language* * read from LEFT to RIGHT ~! * [12 years] (C) masayahingArtist 2012', False, True)
add('1cek1dsmuseumofreallycrazystuff', 'http://hai.smackjeeves.com/comics/', u'Hai. This is basicly a dump for my sprites, comics, game ideas, charectors, and basic everyday stuff. Except nothing is what YOU call everyday.', False, True)
add('20TimesKirby', 'http://20xkirby.smackjeeves.com/comics/', u"20 kirbies, considered different from all the others by Kirby, go on a journey to find out their past... At least that's what Kirby wants, since he can't stand the fact of knowing nothing about them all. The answers come slowly, the suspense builds, and the question is, are they going to find out everything? Or are they just going to have random adventures, and never know all of it? Updates Mondays, Thursdays and Saturdays.", False, True)
add('2Kingdoms', 'http://2kingdoms.smackjeeves.com/comics/', u'Lost in the middle of the dangerous seaweed forest of Lebanon, Uegon Prince Apollo is searching for the way home. Joined by his cousin Paris, his faithful pet Pyou, and a pair of Uegon sisters named Diane and Juno, the group must face a deceptive maze of seaweed trees, giant flesh eating monsters, the Unknown Dark Lands of the Herse, and the biggest hurdle of all, a war in the royal house of the High Waters! **UPDATES: Tuesdays NEWS>>2Kingdoms now has a group page on dA: http://2kingdoms.deviantart.com/ If you have a dA account, please show your support by joining the group. It has special extras that can only be found on dA :D', False, False)
add('355Days', 'http://355days.smackjeeves.com/comics/', u"This was originally a comic where I attempted to make an homage to Kurt Vonnegut's Timequake, but it slowly evolved into A Dada Humor comic, which has now evolved onto a actual storyline that has gone on since April 1st 2012. This is my experimental comic where I attempt to post a comic daily with anything I can get my hands on, just attempting to get at least one page up! ***ENDED AS OF 9/2/12*** If you liked this comic check out my new comic: Euphemistic Eephus. http://www.smackjeeves.com/comicprofile.php?id=127121", False, True)
add('60SecondComics', 'http://6tsc.smackjeeves.com/comics/', u'Every episode is completed within 60 seconds... and it even updates sometimes! http://www.vivianvideo.com', False, True)
add('7thLore', 'http://7thlore.smackjeeves.com/comics/', u'Izmiu is a young ithi prince whose mother has died in childbirth. He is raised in exile, in a white castle down by the sea side, by a two-headed scary teacher and by his grief struck introverted father, who has turned quite mad, due to the death of his wife. What becomes of the life of Izmiu, when he is suddenly summoned to return to the city of Tykauiid after his fathers death? Will the new found relatives take the clumsy book worm prince under their wings or drag him unprepared to the center of the conspirations of the ithi high court?', False, True)
add('8seconds', 'http://8seconds.smackjeeves.com/comics/', u"It only takes 8 seconds to change your life forever. Johnny is an average guy, who in just a day will experience events that will make him question the way he has lived. Now he'll have to face his fears in order to achieve the happiness he thought he had. Now with 50% more updates! Spellcheck by David Bradley.", False, True)
add('9ChancesforLove', 'http://9chances.smackjeeves.com/comics/', u'Finding the right person to love is quite a challenge. Approaching the person you love is an even bigger challenge. But the biggest challenge of them all is to keep that person by your side. When two strangers meet, they can decide to become friends, leave the other to be or become enemies, but what if they happen to share something, something they cannot control and not even really are aware of? (My English is not so good, if you find mistakes it would be great if you could point them out. :) Thank you!) (WARNING: 13/15+ BL)', False, True)
add('ADayOut', 'http://adayout.smackjeeves.com/comics/', u'Lizzy is an average soccer playing teen with issues. After distancing from a childhood friend, she must find out what kind of a person she really is, and along the way, discover true potential as a soccer Champion!', False, True)
add('AGirlAndHerShadow', 'http://agirlandhershadow.smackjeeves.com/comics/', u"There's something under the little girl's bed. It likes to play hide-and-seek and it's always hungry. It's also her best friend.", False, True)
add('AGirlontheServer', 'http://girlontheserver.smackjeeves.com/comics/', u"The true and mostly true stories of a girl playing online games and having to deal with all the crap that comes with it. Because apparently, girls don't exist on the Internet!", False, True)
add('AKirbyKomic', 'http://akirbykomic.smackjeeves.com/comics/', u"Join Kirby, Meta, and friends as they travel throughout the Kirby video game series and attempt to stop evil who are trying to destroy this series. It's a daily 4-panel adventure filled with science fiction, humor, and randomness.", False, True)
add('ALaMode', 'http://alamode.smackjeeves.com/comics/', u"Lamode sells talking pretzels to pay the rent. Her apprentice Schulz handles the wilder creations. Her new home Arryn, a college neighborhood pretending to be a town, helps Lamode discover love, acute distaste for movies, and the best way to a customer's stomach. A La Mode updates on Tuesdays and Thursdays.", False, False)
add('ALoonaticsTale', 'http://aloonaticstale.smackjeeves.com/comics/', u"A king needs a team of elite experts to help fight crime and uphold the peace of Mercia. Unfortunately, he hires crazy people for the job. This didn't quite pan out the way he thought it would.", False, True)
add('ANGELOU', 'http://angelou-esp.smackjeeves.com/comics/', u'ANGELOU Historia y dibujo: CaiN Personajes: CaiN y PatoBorracho Genero: Aventura, Fantasia, Humor y cuanta cosa se me ocurra jajaja Sipnosis: La historia se centra en Nikole Keitaro, una chica de 12 a\xf1os, qui\xe9n emprende un viaje en busca de la persona que asesin\xf3 a su padre, y tambi\xe9n para buscar el misterio se su origen.', False, True)
add('APPLESTRENGTH', 'http://apple-strength.smackjeeves.com/comics/', u"Sentenced to death, Naori Ketsueki doesn't expect miracle or redemption. Sure to close his eyes for the very last time, he wakes up yet into a strange world full of apples, where he will have to face his fate again, and the consequences of his actions. But what is the curse of Snow White ? And where will it lead him to ?", False, True)
add('APTComic', 'http://aptcomic.smackjeeves.com/comics/', u'The random adventures of a catgirl named Ammika [who goes by PrincesTomboy the adorable oxymoron], and a bunch of other people. Updates Fridays - If anyone wants to contact me, my email is "PrincesTomboy@yahoo.com " Please note that it and my username are short for \'Princess Tomboy\', not the plural of a prince. -- Until I figure out how to add "tags", here have a large block of things. Ammika Inferno \'ferny Ferny Kumi Kumimi Ally The Pampered Alley Cat Adventures Heroine on Heroin Ember Alex Overcast Helena Foxx High Billy Sometimes Yellow My His Name is Bobby Bunni Bunny Rabbit Candi Candy Sweet Cat Fox Wolf Dog Chicken Sonic the hedgehog Kirby Furry Anthro Cat girl Catgirl So Many Tags Animal ears tail cute cutesy kawaii Keroro gunsou magic updates on fridays.', False, True)
add('AQuestionOfCharacter', 'http://aqoc.smackjeeves.com/comics/', u"Authors ([23/25]); Slash Segary Shard kitsune fire Zmanwarrior BreakerLOLZ Snurple-the-Hedgehog Ultimate the Hedgehog AnXjak Fuzzy Fox aqua the hedgie Royle McCulloch ClockworkTH Scar M.Dailey DelSoul 55dubdub CreatorZone Nick Cypher The Flames EclipseTC Daniel Sokolov Kaizuto CM Punk Skate Light-Called-Hope -----PLACES OPEN UP EVERY SUNDAY AT 7PM EST IF ANYONE LEAVES/A PLACE IS MADE AVAILABLE----- THERE ARE CURRENTLY: 1 SLOT(S) AVAILABLE. IF YOU WISH TO APPLY FOR A SPOT, PLEASE SEND IN AN APPLICATION, EITHER VIA THE APP SYSTEM OR VIA PM TO ZMAN, SHARD OR CM Punk (Who's too busy to constantly check updates but will check for Apps once a day atm). YOUR APP MUST INCLUDE YOUR REASON FOR WANTING TO JOIN AS WELL AS AN EXAMPLE OF (COMIC) WORK YOU'VE DONE IN THE PAST. REMEMBER, WE WORK ON A 'FIRST COME FIRST SERVED' BASIS, SO IF YOU DON'T MAKE IT THIS TIME, FEEL FREE TO TRY AGAIN IN FUTURE!", False, True)
add('ASongforElise', 'http://asongforelise.smackjeeves.com/comics/', u"Andi, Marcus and Elise are best friends since high school. But it hasn't been an easy friendship... And it will get worse. How much change will their relationship be able to deal with, whether it's love or death? A yaoi manga with all the EMO that it requires! ;)", True, True)
add('AStrangeTypeofLove', 'http://strangelove.smackjeeves.com/comics/', u"Dory's life took a whole new turn as an old flame of his ends up living in his house after escaping an insane asylum. As time passes by,Dory tries to (Once again) win Damian's heart. Will he succeed? Or will their 'deal' get in the way? You can find out in ASToL. 18+ Content: Sex (GAY sex ohohoh) Language Nudity I am not English,So my speech may be a little bit off. And the comic itself might be too,At times. (It's my first comic after all)", True, False)
add('AYuriCollab', 'http://ayuricollabbitches.smackjeeves.com/comics/', u"Alright, so this is a collab, welcome to as many people who want to join. :3 This is a Yuri collab, so in other words, it's girl on girl. Don't like it, don't join it. Basic Story: Humans can have spirit protectors that arrive when they have life bad enough to protect them in partial human form (their spirit animal can be anything). Rules: Max of 3 characters State who you wish to reply to in comments When you apply, send a link for an example of your art NO FURRIES Thank you, and have fun. :3 I have the mature content warning on already just in case ;)", True, True)
add('Adalsysla', 'http://adalsysla.smackjeeves.com/comics/', u"there's a freckly guy who misses his girlfriend a lot and a blue girl who wants to find her brothers. on their way to wherever they're faced with a lot of trouble! drawn and written by piim, also known as Katarina Skott. updates wednesdays and saturdays!!", False, True)
add('AddictiveScience', 'http://addictivescience.smackjeeves.com/comics/', u'The day-to-day life of a mad scientist and her roommates, struggling with the daily crasy.', False, True)
add('AdventuresofMitch', 'http://adventuresofmitch.smackjeeves.com/comics/', u'The adventures of a fairly normal teenage boy and his host of crazy companions in a world that gives new meaning to the term "modern fantasy". Updates Tuesdays and Fridays; going on hiatus in August for 18 months.', False, False)
add('AlPoxalips', 'http://www.alpoxalips.com/comics/', u'A story about a man on a mission. A very well-to-do man, very well educated, and yet not very smart. His mission? To convince as many as possible that the globe is facing many man-caused catastrophes that can only be solved by everyone but Al cutting back on their life style. Dedicated to preserving the planet and his lifestyle, but with as little discomfort to himself as possible.', False, True)
add('Allthatglitters', 'http://atg.smackjeeves.com/comics/', u'The members of the rock band celebrating in the a little pub, despite their troublemaker past someone \'ll undertake to be their manager. The band\'s singer, Istv\xe1n meet with "Andrea", who could change the band\'s future. BL love! Yaoi warning! :) It was a one-shot hungarian BL antology competition, mine didn\'t pass into it. So I\'ll draw other chapters.', True, True)
add('AlwaysDamnedWebcomic', 'http://alwaysdamned.smackjeeves.com/comics/', u'"He\'s been single for as long as I\'ve known him and now that we\'re Seniors in High School, everybody and there MOM wants in his pant!?" Josh tries to confess his love to his childhood friend Demetrius, but it doesn\'t quite work out as he plans. Something or someone is always getting in his way! Will he be able to tell his best-friend how he feels? Or will he let himself be distracted from his goal? Silly comic that will try to update on Mondays (and maybe days in between!) WARNING! This is a BL (Boy\'s Love) comic with Het and GL (Girl\'s Love) as a side serving. Dirty (& improper)language, bad art, pingas, boobs. No smexy stuff yet, but its coming soon!', True, True)
add('AlwaysRainingHere', 'http://alwaysraininghere.smackjeeves.com/comics/', u'MOVED TO http://alwaysraininghere.com/ !! A totally original high school story about a couple of gay guys who annoy each other. Also massive amounts of UST. Updates every Thursday.', False, True)
add('AmorVincitOmnia', 'http://avo.smackjeeves.com/comics/', u"It is said, that on the day I was born an angel descended from the heavens. He delivered unto me a blessing... and a curse. Updates once weekly (Unless I say otherwise) (Oh, and most likely on weekends) Warnings: -This is a Bl comic. That means man on man action. So don't be suprised, 'kay? I may also do het and gl pairings later if I feel like it. -Rating WILL be boosted to mature later on. Also, it can be rated mature for anything. I like to keep my options open.", True, True)
add('AmsdenEstate', 'http://monsterous.smackjeeves.com/comics/', u"BL/YAOI COLLAB- SEEKING LODGERS~ --------------- An old safe house for hunted monsters and creatures is reopened for housing and living! (And not just for monsters anymore~) :D Come stay awhile~ we won't bite! ...Unless you want us to ;D", False, True)
#add('Amya', 'http://amya.smackjeeves.com/comics/', u'Amya is a high-fantasy graphic novel; following the adventures of a mute spell-touched and her unlikely companions as they are dragged into an adventure that is a little beyond them. Ultimately \x96 Amya is a story about self sacrifice for the greater good. It is also a story of how far one will go to obtain unearthly power; even if it includes throwing the world into a mythical war between fate and chaos. Amya updates every Wednesday.', False, True)
add('AnUnexpectedDevelopment', 'http://unexpecteddevelopment.smackjeeves.com/comics/', u'In a world where Megaman and Roll have swapped genders and become a pair of human teenagers, there is a need for new heroes to rise in order to protect the city from both new and old threats. Instead they get Sam and Alex. Two mischievous high-school students find themselves in a predicament which is quite the opposite of Rock and Roll\'s, but just as awkward. Will they be able to get used to their new-found "changes?" ______________________________________ Well, here it is. This is a little project I\'ve been working on for a bit. I guess you could call this my tribute to the old enjoyable Mega Man 7 style comics that popped up here and there during the golden age of spriting. Remember to read "Slight Miscalculation" by Mitchell00 in order to understand what\'s going on in this comic. http://www.smackjeeves.com/comicprofile.php?id=67755', False, True)
add('Anathemacomics', 'http://anathema-comics.smackjeeves.com/comics/', u'1810 England, the height of the Napoleonic wars. It was thought that humans walked the path of enlightenment leaving monsters and dark things behind. However, those monsters and night stalkers merely hide in the darkness, as a young maid, Bernadette, soon finds out.', False, True)
add('AngelGuardian', 'http://angel-guardian.smackjeeves.com/comics/', u'Kyrsiel is a young apprentice of Guardian Angel. His teacher, Gersiel, is responsible he achieves a successful test mission to graduate. Moreover, Gersiel may not continue his evolution as Angel until Kyrsiel, who is his last student, graduates. And this is not easy! Both will play an important mission on Earth: Protect Midori, a young student girl, from the demons that are chasing her. . Will Kyrsiel do it successfully or will he fail again? Story and drawings: \xa9 Reenave http://reenave.deviantart.com Translated into English by: Louise Brown http://cast-into-the-abyss.deviantart.com/', False, True)
add('AnimalAdventures', 'http://animaladventures.smackjeeves.com/comics/', u'In a world similar to Pokemon minus the humans, intelligent creatures called Animals must use their amazing powers to save the galaxy. Many of the characters and storyline resemble things from various media. Contains action, violence, gore, romance, clean humor, adventure, possibly a few swear words, and extreme cuteness. Is read from left to right. This comic contains a lot of characters. Note: This comic does not update any schedule. I update when a new page is done.', False, True)
add('Animayhem', 'http://animayhem.smackjeeves.com/comics/', u"Twelve-year-old social reject Vera and her best friend Maggie love anime more than life itself. Too bad they live in a world that's hostile to the magic of Japanese cartoons. And go to a school that contains a portal to the Underworld. And have to fight demons when they could be cosplaying or watching a Princess Neko-chan marathon... Vera and Maggie's adventures with the occult are twisted, gory...and so absurd, they can only result in total Animayhem! Written and illustrated by JoJo, currently set to update every other day until there ain't no more pages!", False, True)
add('Anythingaboutnothing', 'http://www.anythingcomic.com/comics/', u'A collection of comics and cartoons about anything and nothing.', False, True)
add('Aquapunk', 'http://aquapunk.smackjeeves.com/comics/', u'A high-tech, fantasy adventure about ghosts, robots, and aliens. - YES, this comic is being updated here on Smackjeeves again as a mirror to the full Aquapunk site, http://aquapunk.co. "What\'s up with the pages?" Well, in preparation for putting out books (Sand and Sieve will be wrapping up in just a few weeks), I\'ve decided to go and redo/touch-up all the old pages. A couple scenes have been extended/reworked also, so expect some bumps when reading for now. For a detailed view of my progress, check out http://aquapunk.co/redo "How often are you updating now?" At AP.co, 5 pages monthly. But here, I\'ll be spreading out those updates to once a week or so. So, odds are (4/5, to be precise) that there is more for you to read than what you see here!', False, True)
add('Aquasspritehostingplacethingy', 'http://spritehoster.smackjeeves.com/comics/', u'I\'m just using this comic so I can work on my HTML skills, and avatars (on-site/off-site). people can join and host their sprites/whatever they feel like posting, no major swearing or else your comment will be deleted (no "dude, what the f*** is that s*** supposed to be?"). continue and I shall delete ALL your comments. if guests swear too often, I will have no choice but to remove the option for guests commenting.', False, True)
add('ArchportCityChronicles', 'http://tjs.smackjeeves.com/comics/', u'Archport City is the interdenominational hub and there are always stories to tell... This first one is what happens when you just have to get that picture... Dissatisfied on what was supposed to be a fun trip it was only a matter of time until adventure lured Joe in. Now a group of discredited bounty hunters with a dangerous target have dragged him along for the ride.. updates T and Thr..', False, True)
add('Area9', 'http://area-9.smackjeeves.com/comics/', u"Taishi Iwaska had once dreamed of working in Area 9, a research facility surrounded by a huge wall that finds cures for dangerous viruses. Feeling useless, he has recently given up on his dream, but in a strange turn of events he finds himself trapped in Area 9 as a hostage with a crazy bomber called 'Bomb', who claims to be a terrorist that will blow up Area 9 if they don't give him what he wants. Is there anything Taishi can do before it's too late? Just who is Bomb, and why does he want to destroy Area 9? Taishi will have to overcome his feelings of helplessness if he's going to do anything about it, as well as make a few shocking discoveries along the way. This is a one-shot that has turned into an unusually long one-shot. There will be 3 parts with around 70 pages each. <<Reads from right to left<< Updates on Saturdays.", False, False)
add('Arkaedea', 'http://ark.smackjeeves.com/comics/', u'Roxene likes Seth. Seth likes Roxene. Viktoria likes causing trouble. Femslash/yuri/shoujo-ai/romance/fantasy fun ensues. ;)', False, True)
add('ArmyGags', 'http://armygags.smackjeeves.com/comics/', u'Army Gags is a tale of friendship, love, loss, war and peace as seen through the eyes of an emotionally oblivious eight-year-old. Basically this is a comic I did over ten years ago that was apparently about people in the army. Reading through it as an adult, I realised just how unintentionally hilarious it could be. From exploding orphanage nuns to comic book industry-based slavery, Army Gags is truly a window into the somewhat uneasy mind of my eight-year-old self.', False, True)
add('AtArmsLength', 'http://atarmslength.smackjeeves.com/comics/', u'The story of three magical ladies and their lives with their husbands, making it in the modern world and dealing with the occasional monster attack. Updated Tuesdays, Thursdays and Saturdays.', False, True)
add('Autophobia', 'http://autophobia.smackjeeves.com/comics/', u"The story of a dude named Louis who tries to accept himself for who he is and to learn to not let others step all over him. It follows him through the course of his life and the relationships he builds with others, particularly with his classmate Daniel. [Updates every Sunday] --- Warning: gay ppl, straight ppl, awkward ppl, a plethora of dialogue, profanity, sexual themes/content, and an absurd amount of fluff. /Mature content is on for some of the future themes explored, but there's nothing explicit./", True, False)
add('AwesomeSauce', 'http://tdawesomesauce.smackjeeves.com/comics/', u"Stupid comics from the dark depths of TD's notebooks. View at your own risk. Updates never.", False, True)
add('BLOT', 'http://blotcomic.smackjeeves.com/comics/', u"In the near future, robots fueled by human blood have begun their uprising - thankfully there's a few folks who won't take that sitting down.", False, True)
add('BURNiNation', 'http://burnination.smackjeeves.com/comics/', u'A rather shallow comic that now has a hint of a plot! Wooo!', False, True)
add('BabysittingFourDemons', 'http://babysitting4demons.smackjeeves.com/comics/', u'Ezz, also known as Ghost the Echidna on her Smackjeeves account, has become a babysitter. She\'s finally on her own, and starting a nice, steady babysitting service at her home. Little does she know is that the children she is to babysit happen to be four demons... Who are these four? Why, none other than Sonic, Amy, Knuckles and Tails! Open Author Spaces: NONE. DON\'T EVEN ASK. Don\'t even request. Don\'t comment "CAN I JOIN LAWLZ" or I\'ll come after you. Thanks! -Hope Status: No one banned. Please start updating more, people. I\'ve made up my mind that I\'m gonna update more, you guys can help out too. -Hope', False, True)
add('BadLucktheQuestfortheCodPipe', 'http://badluckthequest.smackjeeves.com/comics/', u'This is the story about Rade, your everyday average guy. He goes to school, plays sports, the only thing weird about him is his best friend Crimp. Things in his average life take a turn for the bizarre, when a young man with a cat show up at his door. Now all of a sudden Rade is caught up in a quest for a magical pipe that can grant a wish to anyone who asks. Not to mention the demon mercenaries following them. The closer they get to the Pipe, the darker and more entangled things become. What starts as a grand adventure, only seems to lead to Bad Luck. Updates Saturday', False, True)
add('BassComicAdventures', 'http://basscomicadventures.smackjeeves.com/comics/', u'A sprite comic that follows the (mis)-adventures of the Capcom characters of Bass, Mega Man, and the rest of the group. Featuring original storylines, new characters, a re-imagining of some classic games, and possible hilarity. Updates on Mondays, Wednesdays, and Fridays', False, True)
add('BattleSequence', 'http://battlesequence.smackjeeves.com/comics/', u'Trainer Rayne is working hard to train her pokemon to be the best they can be. Is she tough enough to take on all of these new challenges? Follow along with her on her journey to be the very best! UPDATES: Every four days.', False, True)
add('BearlyAbel', 'http://bearlyabel.smackjeeves.com/comics/', u'Abel is a American-Asian boy with an active imagination. He lives with his mom and sister and goes on adventures with his bear, Barry. This webcomic ran from August 2008 until Oct 2010.', False, False)
add('BeastHunt', 'http://beasthunt.smackjeeves.com/comics/', u'Once Astir found mysterious sword, he decided to become " the best warrior" in the whole world~ Task seemingly easy but with his overflowing lazyness and not much talent might become a bother. Psychopathic necromancer on his back and "girly" samurai as his training partner definately wont make it easier..', False, True)
add('BehindTheObsidianMirror', 'http://obsidian-mirror.smackjeeves.com/comics/', u"If you were to awake in a place unknown to you, without remembering anything... you would be happy to be taken in by someone, right? But what if this someone was a god? Aztec gods and BL. What more could you want? x3x Warnings for homosexual content, blood, violence, and possibly gore and sex in the future. Don't like, don't read. UPDATES EVERY MONDAY!! Although I have read a lot about Aztecs and their culture and mythology, I am hardly an expert on that subject. So forgive everything that might be off, or wrong, since I actually don't bother to get everything right or just change things to my liking. The Aztecs and their religion etc. depicted in this comic are far from realistic, and don't aim to be, although I'm trying to make it all seem plausible. Just so you know. Enjoy. ;) Remember to read from right to left, Japanese reading order. ;) Sketch/WIP tumblr: http://teejaystumbles.tumblr.com/", True, True)
add('Behindtheglasscurtain', 'http://g1ass.smackjeeves.com/comics/', u"Scarlet spent all her life in a dismal, dark prison that just so happens to be located in a dismal, dark realm bereft of all flora and fauna. One night she ignores the frog's rule to never look out the window when darkness approaches. What she sees next will change her life and everything she once knew. It's a comic that delves deep into other character's lives and reflects on their back stories. Even though the main story seems to branch off to smaller stories, there is a basic plot, which the reader has to decide on. updated on weekends, but best to check it on Monday. It's finished! COMPLETELY FINISHED! Don't keep on checking for updates. Yes the first 100 pages looked like crap but mind you I started this when I was 14!", False, True)
add('BettencourtHotel', 'http://www.welcometobettencourt.com/comics/', u'"You are advised not to leave your room from midnight to 2 a.m." A little horror story about pretty boys working in a murderous hotel. Some shounen-ai. ~Updates on Fridays~', False, True)
add('BetweenLightandDark', 'http://bld.smackjeeves.com/comics/', u"The adventures of 13 friends as evil turns against them. (Or they go looking for trouble, that's more like it!) Fantasy and adventure webcomic with some humor and romance in the middle. Updates every Sunday and Wednesday. PG-13 due to language here and there and some themes. There are also short comics updating every Tuesday here -> http://bldshortcomics.smackjeeves.com It is not mandatory to read those to know important things in this, but some strips are intended to be connected to the story!", False, True)
add('Betwin', 'http://be-twin.smackjeeves.com/comics/', u'Be-Twin is an amateur comic which smells of powder, shootings, and the mafia. Its true premise however, centers around two destinies which have, with difficulty, found their place in this dangerous world. Two individuals who are different in every way\u2026 or perhaps\u2026 not very different at all. I upload pages every two weeks, on Sundays. I\u2019m French, so please forgive any mistakes I may make. I really wanted to share this story with my non-French readers. ;-; Thank you so much for reading... >w<', False, True)
add('BeyondTemptation', 'http://beyondtemptation.smackjeeves.com/comics/', u"An accidental meeting turns Reimee's life up and down. She finds herself in the middle of an affair regarding enslaved demons, magical artefacts and many temptations of the modern world. Will she get tempted? Or will she be the one to tempt? And finally, will she find what she's looking for in the Eternal City of Rome? Inspired by eastern folklore, religion, Grimm tales and life itself, set in modern times Rome it's a paranormal action romance in which the borderline between good and evil is very thin. (plus guys don't sparkle and girls can kick your butt :D) NOTE: 1.This comic is fruit of immagination and does not reflect anyone's opinions nor real facts nor people. 2.Not marked mature (I find it annoying when I can't see the preview)but may contain some blood here and there and possibly some erotic scenes. 3.Commens are very appreciated. Reviewable if anyone wanted to attempt at it.", False, True)
add('BioRevelation', 'http://biorevelation.smackjeeves.com/comics/', u'Ever wonder what would happen if cloning was made legal? What could they do for mankind? Would they have the same rights as natural born people? Bio-Revelation tells the story of a distopian society of corruption, theocracy, and the underdog. Follow the story of Trevor Watson and his friends battle against the religious fanatics known as the FOH to gain the freedoms they dream of.', True, True)
add('BiscuitFox', 'http://biscuitfox.smackjeeves.com/comics/', u"There are no rules stipulating that women can't play professional men's hockey. Nikita Stefanova is determined to prove that she can skate with the big boys.", False, True)
add('Bitemeayaoi', 'http://bitemeyaoi.smackjeeves.com/comics/', u"Warning: YAOI, which means man on man action in bed. There will be graphic scenes later on in the story. There are also suggestive scenes as well. Also abuse. Please leave now if any of this bothers you. That's all. (and if you are looking for instant gratification, this probably isn't the story for you) Everything was normal....ish. It was just Kain and his mom against the cold cruel world. That was normal for them. At least, it was until his old friend comes back into Kain's life. Milo abruptly confronts Kain after years of being apart, but Kain doesn't remember his past and turns him away. Even after multiple times of Kain trying to push Milo away, Milo won't let go of his childhood crush. Will Milo finally break down the wall blocking Kain's memories and gain his love? Or will he let his love go because someone else already has taken his place? (art gets better as time goes. 2008-present) (This story is pre-planned from start to finish.) Attempting to update every sunday UPDATES RANDOMLY (deal with it) :D", True, True)
add('Bl3', 'http://bl3.smackjeeves.com/comics/', u'Mostly a crossover of BLEACH and BLAZBLUE (the title may be read as "bl3" or "bleablazblue") All characters here are the property of either Tite Kubo or Arc Systems Works, particularly Toshimichi Mori. There is one original character, but half of that is owned by Daisuke Ishiwatari. This takes place between the Deicide and Lost Agent arcs of BLEACH. Please read RIGHT TO LEFT, like a Japanese manga.', False, True)
add('BlackCollar', 'http://huntedblackcollar.smackjeeves.com/comics/', u"-Read from left to right- This is a comic for all you fantasy action lovers out there. Nobody asks for it, nobody in that messed up world. And yet they are all part of it... the game. Hunted, What does the word really mean? How can someone just be thrown into a place like this? And yet there are so many just like him. Unaware of what's really going on? There's a good amount of violence and blood in this. So be aware before reading. (There are no sexual themes) *NOTE*: The comic was started a while ago, so you will see a huge improvement in both the art spelling, and story by around chapter 2.", False, True)
add('BlackDragon', 'http://blackdragon.smackjeeves.com/comics/', u"Since mankind has subjugated dragons, men struggle for power by using dragons. Sora also wants to become a dragonrider and so he climbs the Dragon-Mountains to catch a dragon This is a manga. Read from the right to the left! If you can't wait, you can get the complete Manga on Amazon: http://www.amazon.com/dp/B007NZGBZ8 http://www.amazon.com/dp/B009MOQLLM http://www.amazon.com/dp/B00BRJHPTW Actually I'm working on this manga for about one and a half years and made about 21 chapters. So I'm gonna upload many pages in a short time until we reach the chapter I'm currently working on", False, True)
add('BlackFridayRule', 'http://blackfridayrule.smackjeeves.com/comics/', u'', False, True)
add('BlackandBlue', 'http://black-and-blue.smackjeeves.com/comics/', u'A sci-fi fairytale. A boys nightmare. So, this is about an Evil Empire soldier with a few problems... not the least of which is a slight gender issue and a weird entanglement with an astronaut. Awkwardness ensues. D: I thought "The Crying Game" was a comedy, you\'ve been warned. Ha! e_e Also I started this about 200 years ago and the art is pretty rough I\'M SO SORRY! ;_; FORGIVE ME!', False, True)
add('Blackdemon', 'http://blackdemoncomics.smackjeeves.com/comics/', u"everyone has a demon inside them, even the nicest people in the world has a demon. what happens if the demon inside takes total control of you? it could effect your life style, personality, and for artist's; imagination. that's what this comic is about. a girl with poor social skills and a large imagination, how will she fix both problems? (WARNING:some chapters in this comic are based on real events that occurred in the author's life) comic updates:Monday's, Wednesday's, and Friday's(if not updated, that means i got a LOT of HW or my laptop is damaged)", False, True)
add('BleachRedux', 'http://bleachredux.smackjeeves.com/comics/', u"Myself and others were extremely disappointed with Ulquiorra's death in the official Bleach manga, so I've taken it upon myself to draw out what could've possibly happened had Orihime pulled her head out of her ass and saved him. WARNING: UlquiHime. Any negative comments (or futile attempts at validating other ships that make even less sense (ie: IchiHime)) will be deleted. NOTE: READ RIGHT TO LEFT LIKE JAPANESE MANGA.", False, True)
add('BlindandBlue', 'http://blindandblue.smackjeeves.com/comics/', u"Boy's Love! (Gay relationship romance) Caecus (Case) woke up one morning to find that he was completely blind. He's picked on by the school bully, and things aren't so great. Fortunately for Case, he finds a friend - and eventually a boyfriend - in the new kid, Darryl, and together they make it through the things life throws at them. A smackjeeves mirror to the comic on DrunkDuck, which you can read [url=http://www.drunkduck.com/Case_1048_Blind_and_Blue/]here[/url] Comic contains swearing very rarely,so if you don't like it...you'll be fine actually And if you're homophobic...message me with your reasons why as I am very curious on the topic.", False, False)
add('BloomaPokemonConquestComic', 'http://bloomconquest.smackjeeves.com/comics/', u'According to the Legend of the Ransei region, if all 17 kingdoms of the region are united, the legendary Pokemon that formed the region would appear. Young Saku, along with her stubborn Axew, set off on the road of conquest. However, the warlord Nobunaga is only one kingdom away from uniting the region. Can Saku conquer Ransei before he does? ______________ There is a bit of violence later on, but hey, Pokemon has a certain lack of violence that they need to make up for. Nothing too bad. Also, I am constantly improving, so please ignore the bad art at the beginning. >.< Pokemon (c) Nintendo Updates Wednesdays and Saturdays.', False, True)
add('BlueWell', 'http://www.bluewellcomic.com/comics/', u'Leif Kavanaugh grew up in the country-side and came to the city to attend college. He moves into "The Blue Well" boarding home, which houses several other college students just like himself. While he hopes everything will go smoothly, Leif learns it\'s not the city that makes life crazy, it\'s the people.', False, False)
add('BoilingPointofBrain', 'http://bpob.smackjeeves.com/comics/', u"The company 'Brain' is going through terrible waves of financial depression as their only client 'Erika' has succumbed to the roadblocks in life. It is up to Sir and the Intern as well as the employees to help their client get back up on her feet.", False, True)
add('BoogeyDancingMonkeyPot', 'http://monkeypot.smackjeeves.com/comics/', u"Prince Jean-Patrick finds young Sarah's bedroom to frighten her. But Sarah isn't an eight year old girl running around in her socks. She's a young adult now and it certainly shows! Together, the Boogey man and human girl journey through their lives. One to become king of his kind and the other to find her place. Two roads cross and destiny determined to keep them together. Monsters do not solely exist in the darkness. rated mature for violence, language, partial nudity and some sexual tension", False, True)
add('Boywithasecret', 'http://www.bwascomic.com/comics/', u'Comic Title: BOY WITH A SECRET (Himitsu no Aru Otoko) Boy with a Secret is an engaging and modern comic that follows the life of a young boy and his hidden secrets. Only a few are privileged to know the truth, and to everyone else, he is a stranger. When Haruhi starts his new life at Fujimoto High School, he befriends the beautiful and compassionate Minako. Rejected by his fellow classmates and tormented by school bullies, Haruhi begins a life-changing journey to find out what real friends are made of. While his secrets unravel and his enemies grow by the day, a friend from the past comes to change everything... ********************************************************* Updates: Every Wednesday GMT -6(US Central Time) Genres: LGBT, Psychological, Romance, Drama, School Life. *warning* some adult situations Rated: 16+ Contain :Violence, Blood,Profanity All pages in FULL COLOR ********************************************************* *READ FROM LEFT TO RIGHT * Comments are always appreciated. :) THANKS!', False, False)
add('BreachofAgency', 'http://breachofagency.smackjeeves.com/comics/', u'Panacea has the gift of healing, which makes her a target for both sides of a civil war. The Minister, leader of the Agency, is determined to have her cure his fatal illness and prolong his life. Forever. But the Gunman and his accomplices want her dead. All Panacea wants is to find her own destiny. When she and her bodyguard, Aegis, stumble upon Traver, who takes them in after they narrowly escape a brush with death, Panacea believes she may have found a real home. But the Agency has eyes everywhere, the Gunman is always waiting in the shadows, and Panacea can never be sure who her allies are.', False, True)
add('BreakfastonaCliff', 'http://boac.smackjeeves.com/comics/', u'A boy named Cinna goes to a new school. See what happens! Updates: Fridays Or any other time ending with "day."', False, True)
add('BrightStars', 'http://www.brightstarscomic.com/comics/', u'A miscalculation sends Rory into the far reaches of outerspace. WARNING: May contain violence, language, and human-alien relationships.', False, False)
add('BrookeandKirby', 'http://brookeandkirby.smackjeeves.com/comics/', u"A comic about my fan character Brooke and Kirby. This is the first webcomic I ever posted here, so expect some mistakes. And don't expect updates daily. I can sometimes get Author's block.", False, True)
add('Bullet', 'http://bulletmanga.smackjeeves.com/comics/', u"Living far below the poverty line, having no friends, not enough food or even the love of a parent, Nikita hopes for no happiness. But as her family's ominous past slowly begins to unveil itself, happiness become the least of her worries, her only refuge becoming a man whom she cannot trust. A man with no heart. A murderer. ------------ Note: This is Not a BL/Gl manga.", False, True)
add('Burn', 'http://burn.smackjeeves.com/comics/', u'/ RATED TEEN / Occasional violence, "bad" language (lol), adult situations/themes, yaoi. .:. Spunky young college student Darryn Gainnes has just turned 20, and decided to tone his wild ways down a bit. All he needs in life are his two best friends, their band, his books, and his music! He thinks nothing of it when he literally bumps into a pretty (and gloomy) High-School-boy at the park. But soon, Darryn finds himself swept up in a world he had never even known existed, a world of intrigues and violence and magic! And of course what is sweeping both boys off their feet is their budding romance... and so many incredible obstacles thrown in their way. Where will it all lead? Who is on their side... and who will be left standing? .:. BL: This is a shonen-ai/Boys\' Love comic! If you don\'t like those, don\'t read this one! ^~ DIRECTION: This comic reads right to left, for no other reason than that I like it that way. ALSO: I never have as much time as I would like, so for the most part this comic is pencil sketches and a bit of photoshop. But I hope you enjoy it! ^^ ART: Improves as you go along! I promise. I started this thing a long time ago. ^^;', True, True)
add('Burningashes', 'http://burntashes.smackjeeves.com/comics/', u'A father tries to protect his family during a environmental catastrophe.', False, True)
add('Buzz', 'http://buzzboys.smackjeeves.com/comics/', u'A short comic about a Spider and a Lady bug.', True, True)
add('ByTheBook', 'http://bythebook.smackjeeves.com/comics/', u"After stumbling across a copy of 'The Adventurers Handbook 3.5' an orc, goblin and kobold decide to leave the dungeon and become mighty adventurers! Updates every Wednesday and Saturday.", False, False)
add('CHEAPTHRILLS', 'http://cheapthrills.smackjeeves.com/comics/', u'', False, True)
add('CRACKRPCOMICJOINNOW3', 'http://thehotelrp.smackjeeves.com/comics/', u'Crack RP comic that takes place in a Hotel... Pretty much anyone can join/co author!:D Read the description on Page 1 to learn more! JOIN before all positions are taken, and there is only a few left. :D Please be creative when making your characters and have fun!<3 C: Message me with any questions, ~Skittymitty', False, True)
add('CafeSuada', 'http://cafesuada.smackjeeves.com/comics/', u"Down by the riverside there is a quaint little teahouse run by our heroine, Geraldine, who's only desire is to spread her love of the golden beverage - But what's going to happen to her business when a new coffee house springs up right next door?! And what is the meaning of Cafe Suada? Guess you'd better read and find out, huh?", False, True)
add('CafeauLait', 'http://cafeaulait.smackjeeves.com/comics/', u'The comic strip with cat boy flavor! (updates saturdays) Illustrations of Milk, Coffee and the others are here: http://nadykun.deviantart.com/gallery/40865689', False, True)
add('CaptiveSoul', 'http://captive-soul.smackjeeves.com/comics/', u'A BL Pirate manga! :P Sai works on the ship "The Liberty", he was taken in at a young age after his town was burned down and he lost his family. The event was traumatizing and Sai lost his ability to speak. He has sworn to hunt down the pirates that destroyed his home and bring them to justice(however that seems a long ways away) However, recently the captain of the ship, Kuragi, has taken an interest in Sai! Will Kuragi\'s advances distract Sai from his goal to avenge his family? A stormy relationship ahead! Will update every tuesday :P', False, True)
add('CaravanaTaleofGodsandMen', 'http://www.caravantale.com/comics/', u"In a world of magic, mystery, and mayhem a sickly child and her protectors will attempt to transverse great deserts and expansive grasslands to reach the sea, and a hope for a cure. A witch, her sole purpose to protect the girl. A scarred man, beholden to the child who holds his stolen name. With each step they're drawn further into a mystery that will unravel truths about the lands in which they live. What will this world hold for them? Only time will tell.", False, True)
#add('Carciphona', 'http://carciphona.smackjeeves.com/comics/', u'In an era where magic is forbidden, a sorceress struggles to restore her once peaceful life.', False, True)
add('Cataclysm', 'http://cataclysm.smackjeeves.com/comics/', u'Set on the last remaining hospitable island on a frozen world, a covert faction known as Militia attempts to overthrow a utopian civilization and their benevolent rulers, The Council.', False, True)
add('Catnip', 'http://catnipmanga.smackjeeves.com/comics/', u'Ikita is a young and impressionable noble, who has been bound to a young lady by arranged marraige. Felix is his hired bodyguard; a quick witted and reliable one at that - but who has more to his past than he would like to reveal. As Felix follows Ikita as his bodyguard, they start to have mixed feelings about their positions, and where the future may lead... Based in an 19th centrury-esque alternate history, this tale consists of friendship, compassion, love and regret.', True, True)
add('Cement', 'http://blocksofsherst.smackjeeves.com/comics/', u"We are a legion of awesomeness, bro! >:{C -------------------------------- Welcome to Cement! A boredom webcomic to discuss/review ideas, movies, fanfiction, and other stuff/shit. We also have: - A sprite showcase, - Some tutorials, - Dreams that make sense, - Debates that make no sense, - Lotsa shitty shit bullshit, - Crack, - Heli-kun~ :3 - Anus - Hentai - Steak - Swagga - What Pumpkin - Overall Trash And much more... Feel free to apply as author if you'd like! (no wait, don't) Gooby plz. I'm touching the description! Hurrdurr! :B Thank you for still reading. Now.. have a nice day and go HoNk yourself. I touched it again - silentdusk c: Heil Helitler. Calm down Stalin' *shoots helitler in da face* :D Now go back to the top and re-read the description. HoNk hOnK Go dunk your head in a bucket, Gamzee - you sexy piece of shit, you. No one cares this desc motherfucking exists anyway. :o( gun in your face big disgrace, kicking your ass all over my place.~ Royle McCulloch Play with the description they said. It will be fun they said. And it was. Posers. I was messing with the description before it became cool! >:I", False, True)
add('CerberusCrescendo', 'http://elica.smackjeeves.com/comics/', u'a lot of supervillains who need to be a lot of dead', True, True)
add('ChadtheLimblessCat', 'http://chadthelimblesscat.smackjeeves.com/comics/', u'MAOW! :3 This comic started in 2011 at Wordpress but we now moved to here which is a much better place for us to be noticed! -------------------------------------------- A story about a cat without limbs who goes around encountering new creatures. Chad is grumpy, stubborn, lazy and hates just about everyone. Will he ever open up and return the kindness of those who gave it to him?', False, True)
add('ChampionsandHeroesAgeofDragons', 'http://championsandheroes.smackjeeves.com/comics/', u'In a land far away, or possibly in a dimension just next to us, lies the lands of Thedas. The world of Thedas is made up by endless possibilities - a man can be a mage, a rogue, a warrior, even a woman. From the Free Marches to Ferelden we find champions and heroes saving the world... poorly. Updates Mondays. All hail Bioware.', False, True)
add('ChaosAdventuresII', 'http://chaosadventuresii.smackjeeves.com/comics/', u'Creds to: Characters Chaos/Halo - Master Rezz - Nebula Ki - Megablueblastaa Tails - Hypero Sarah \x96 Foxx Etch \x96 No Details Blur - Cylent Nite Thorn/Young Thorn - Cylent Nite Omega - Hypero (customised by me!) The demons - Gardow Styxs - Sakura Courage Solo Backdrops- Wacky Workbench Zone - Shadowbot Green Hill Zone - kinny-man Chemical Plant Zone - Domenico Sky Canyon - kinny-man Emerald Alter - Apocalypse the Hedgehog Angel Island Zone - SkyLights Other Tails\x92 plane - Rogultgot', False, True)
add('ChaoticNation', 'http://chaoticnation.smackjeeves.com/comics/', u'Karians were first born during the cataclysm. Once human, the race mutated. They became stronger, faster, and changed in physical appearance and magical ability. In a world already devastated, a rebellion rises to defend the dwindling human race from the growing fear of the Karian army. Their one hope may lie in a mysterious mage whose kind heart has the courage to stand against the oppression and torture brought on by the impending war. WEEKLY UPDATES ON TUESDAYS Contents - Nudity, Language, Violence, Blood and Gore, Hentai, Yaoi', True, True)
add('CharacterHouse', 'http://characterhouse.smackjeeves.com/comics/', u"Welcome to Character House! A Rebirth of An Old Collab Comic of many people living under one roof! A mansion owned by a young woman opens it's doors to the many people looking for a place to live. Characters of all kinds are welcome here! ~All are Welcomed!~", False, True)
add('CharonTura', 'http://charontura.smackjeeves.com/comics/', u"Five girls are chased by a mysterious group searching for some strange scrolls... what are these scrolls and why do these people want them? They'll soon find themselves involved in something bigger than they could have ever thought, and they'll be forced to muster the strenght to face it! -Spanish Version here: http://charontura.subcultura.es/", True, True)
add('Chatuplines', 'http://chatuplines.smackjeeves.com/comics/', u'Welcome to "Chat-up lines"! A South Park Doujinshi from CraigTucker and me. Pairing: Craig x Stan Story: Stan hates Craig and his friends are fags! They haven\'t time for him.. Bad friends.. But in a chatroom.. he meet a guy.. and he is cool. ..and they will be friends...', False, True)
add('CheckoutLane', 'http://checkout-lane.smackjeeves.com/comics/', u"Ever worked in retail? Then I'm sure you'd remember all the crazy things that happened around your work place. Checkout Lane centers around Mandy, a cashier, and the crazy events that occur around Little Bit of Italy (a grocery store that specializes in Italian goods). Some of them have really happened to me and some I did just for humor's sake. But you never know! They could really happen! Happy reading everyone!", False, True)
add('CheneysGotaGun', 'http://cheney.smackjeeves.com/comics/', u"Cheney's back! Ever wonder what Dick Cheney is doing in his secure undisclosed location? The Hunting \ufffdaccident\ufffd was only the beginning. Dick Cheney has now found his true calling. Tag along as the vice president cleans out his guns, and dusts off the ammo boxes as he fights his way through a world of terrorists from Cidy Sheehan to Osama Bin Laden. This is a graphic novel I did a few years ago and have decided to give it a rerun.", False, True)
add('ChesterandFerdie', 'http://caf.smackjeeves.com/comics/', u'Chester and Ferdie updates once a week, usually on the weekend!', False, True)
add('ChickenScratches', 'http://chickenscratches.smackjeeves.com/comics/', u'A slice of life 4-panel comic. A journal about a young man and his troubles in life. Updates Monday to Friday. Sunday is a Sketchbook entry.', False, True)
add('ChildrenoftheEternalSpring', 'http://offspring.smackjeeves.com/comics/', u'Stories about a world made by a woman named Eternal. first chapter: Door Knocker Pendant "two girls in a quest to retrieve a world legend two children searching for each other one pendant to cross their paths and a door to take the children back to their homeland..." it focuses on the final adventure of Hi and her comrades Atta and Rote in their quest to retrieve the Door Knocker pendant from a man who\'s only will was to open one single door and isolate the power he believes he deserved. note: mild violence, dry humour, updates: every week, if possible...', False, True)
add('ChildrenoftheNight', 'http://cotn.smackjeeves.com/comics/', u'Vampires are at the brink of extinction ruled with a heavy hand by the Hunters, an order of vampire slayers that has existed since the beginning of mankind. The centuries-old law is very clear; a vampire can only feed off criminals whose names are on the lists provided by the Hunters. Any other interaction with humans means punishment and even execution if they are harmed. But when an unlikely friendship between a human girl and a vampire starts to grow into something much deeper, can these laws be obeyed? CotN is a romance webcomic set in the Victorian Era, depicting forbidden love amidst a clash between vampires and the Hunters, an order of vampire slayers. :It updates every Monday:', False, True)
add('ChimiMouryou', 'http://cmmr.thewebcomic.com/comics/', u'Near the top of one of Japan\'s many mountains away from all the human villages, there is a forest inhabited by youkai who are constantly learning how to deal with each other. Basically, "The Daily Lives of Crazy Youkai" This comic is a bunch of random short stories and not one continuous one. Everything is acted out in pantomime AKA there are no written words. Chimi mouryou can be roughly translated as "evil monsters in the mountains and rivers". The legend of it keeps the forest safe from humans. I am still researching more about the Edo period and youkai, so I apologize for unintentional inaccuracies. For now, the updates for this comic are random. I apologize!', False, True)
add('CityFolk', 'http://cityfolk.smackjeeves.com/comics/', u'Tired of a dull life in the wilderness of British Columbia, a beaver and a moose make the trip of a lifetime; into the heart of the city. This is their story. City Folk will not be updating for a while. My computer has finally given up on life and I have no way of scanning/editing/uploading. Life sucks until I can get a new tower.', False, True)
add('ClairetheFlare', 'http://clairetheflare.smackjeeves.com/comics/', u"Claire is new to this whole superhero thing, but she knows what it's all about. Getting famous! But with veteran heroine Bulldozer breathing down her neck its not going to be easy. Updates Three Days a Week! Monday, Wednesday and Friday.", False, False)
add('CleanCure', 'http://cleanpluscure.smackjeeves.com/comics/', u'-A few hundred years into the future, life has changed, but remained relatively the same from a social standpoint. Various government plans to deal with the changing global climate ended in many successes, but many more failures. As a result, certain mutations began to appear in humans as well as animals, and though most were bred out, some remain to the present. -Enter Ezra and Percy; two young men, cat-boys in fact, whom are facing a tough time not only surviving day to day, but making their dreams a reality. After losing their current job, they are offered a new one by a seemingly normal, but secretive man with a lot of money. Their new boss employs them as maids, frilly dresses and all, and makes them clean his and the mansions of others. It quickly becomes apparent that their boss is more interested in the ever mutating rat-like creatures which are making their homes in the dirty world of military cover-ups and powerful family connections. When these two get caught up in the lies and secrecy of their new occupation, will they be able to escape? And what is the connection between mutations and the incident 20 years ago? UPDATES SUNDAYS', False, True)
add('ClockworkAtrium', 'http://www.clockwork-atrium.com/comics/', u'In a misguided attempt to develop their full potential for success, students at a German university are forced to participate in a campus chess "game" in which they are the pieces and the captures could consist of murder. Updates Sundays.', False, True)
add('CloeRemembrance', 'http://cloe.smackjeeves.com/comics/', u"This story is set in the victorian era. Liam is an 11 year-old boy that arrives to a wealthy mansion to work with his father, the gardener. In this place he is asked to be the playmate of the youngest master, Edward, who's about his age. However, Edward turns out to be a spoilt and malicious kid that wants to keep all the attention to himself... What will Liam do to gain his trust and become his friend? ---------------------------------------- This is a young love shounen-ai (boy/boy) Manga format: *Please read from right to left* THIS STORY IS ALREADY FINISHED!", False, False)
add('ColdCoffee', 'http://coldcoffee.smackjeeves.com/comics/', u'The Story of Ed, the people around her and the beautiful monster her subconscious created. Warning: Crude language, Crude humor, Possibly nudity, Lots of awkward. This is a satirical comic against Shoujo, Yaoi and Romance.', False, True)
add('ColorBlind', 'http://cbcomic.smackjeeves.com/comics/', u'Five 13-year olds discover a world that makes theirs seem grey in comparison in a closet at their school. It is a world of magic, and adventure, and a war that the kids might have gotten sucked into accidentally. Main Site: http://colorblindcomic.com/ Updates are Mondays and Fridays.', False, True)
add('ConplicatedGeodeCornerFinal', 'http://conplicated.smackjeeves.com/comics/', u'When sarcastic but charitable Amber Pennicastle follows a handsome panhandler to his secret hideaway, her life turns upside-down in this action/romantic comedy.', False, True)
add('Contradiction', 'http://contradiction.smackjeeves.com/comics/', u"THIS MANGA IS READ FROM RIGHT TO LEFT (Updates every FRIDAY) Ruya Saki received an invitation to attend Teiou Gakuen in Setsuyamachi, a town for magic users. Not knowing the reason why she was invited, Ruya headed towards the mysterious town. A choice between Light and Darkness... an enthusiastic president and his rival... 'Contradiction', the story of Light and Darkness magical users, the story of friends, betrayal, hatred, past, loyalty, revenge, endurance and love.", False, True)
add('ConventionalWisdom', 'http://conventionalwisdom.smackjeeves.com/comics/', u'Ever wondered what goes on inside an anime convention, but are too afraid go anywhere near one yourself? Well, wonder no more! Conventional Wisdom is a comic that shows you what this strange, geeky world is really like, based ENTIRELY ON REAL LIFE! ...well, sort of. (Currently moving over from DrunkDuck, so please be patient)', False, True)
add('CostumeNinja', 'http://costumeninja.smackjeeves.com/comics/', u'Cosplaying gone wrong. A group of not so sneaky ninjas tries way too hard to enter, and win, a costume contest.', False, True)
add('Cramberries', 'http://cramberries.smackjeeves.com/comics/', u"Lucinda is just a normal girl who lives with her roommate in an apartment... until her childhood friend came back to visit here. Now, she has been cursed with a demonic eye and almost everyone seems to be after her. Could it be her eye that everyone is after or is it there something more to it? Follow Lucinda and her friends as they uncover dark secrets and traverse their way along a perilous journey filled with all manners of action, humour, evil and good, love and stupidity. Updates are now Mondays and (occasionally) Thursdays! KitKatMuffin: Artist and Creator Seranatis: Editor and Assistant NOTE: The Editor sometimes post some random art and leaves messages when I'm not available on the website; regardless, they are NOT canon.", False, True)
add('CrappilyDrawnMinicomics', 'http://cdminicomics.smackjeeves.com/comics/', u'Welcome to see the antics of Rob and Ian in their increasingly derpy day-to-day lives. Takes place in London 1999. Drawing and handwriting quality will range from semi-good to utterly crappy. Enjoy :)', True, False)
add('CrayonComicStory', 'http://crayoncomic.smackjeeves.com/comics/', u'A drawing comic about anything. If you REALLY must swear, censor it please. Violence is allowed, but not nudity or swearing.', False, True)
add('Crazyghosts', 'http://vbcomics.smackjeeves.com/comics/', u"Hi, my name's Vince and welcome to my comic Crazyghost's. A silly, perverted, goofy for equally silly, pervert, goofy people. I hope they give you a good laugh, or at least a chuckle! ^_^", True, True)
add('CrystalRift', 'http://crystalrift.smackjeeves.com/comics/', u'A group of four teenagers find out that reality is not as much as what it seems. Through the power of the purple, glowing Rift Crystals, dimensional cracks have appeared throughout the planet, interconnecting universes and planes that were once inaccessible. Follow Kelvin, Liam, Gordon, and Vishnu on their journey throughout multiple worlds, travelling to fix the world of its mistakes all the while seeking to uncover their destiny and awaken their true powers. Volume I - The Beginning Volume II - The Minna Crisis (Liam) Volume III - The Legends of Fumanchuman (Vishnu) Volume IV - Paladin of the North (Gordon) Volume V -', False, True)
add('Cuorevoodoo', 'http://voodoo.smackjeeves.com/comics/', u'A comic about Voodoo and Hyenas', False, True)
add('CupidsaMoron', 'http://cupidsamoron.smackjeeves.com/comics/', u"As the legends say, people's lives have always been handled with care by the Greek Gods and Goddnesses. Ever since, Cupid has been in charge of the mortals' Love. But can a 18-years-old-looking boy really deal with other's destiny ? And what will happen when he will have to help Seth, a 23-years-old loser, find his true Love ? Huge problems ahead... Beware. Following this comic would force you to face a twisted and apocalyptic mix of BL, butchered Mythology, crappy humor, cheesy moments, less-cheesy moments, crazy scenes, general weirdness, and unhealthy amounts of cakes. Authors will not be held responsible of any harm caused to you or any thing or person surrounding. Pursue at your own risk. Irregular updates, we'll try twice a week (read right to left <--) Story & Characters - by M-iikado Art - by Sybia French version can be found here : http://cupidsamoron.webcomics.fr/", False, False)
add('CupofOlea', 'http://cupofolea.smackjeeves.com/comics/', u"Cup of Olea is a text-based adventure game, taking place in the land of Olea! Take command of Cliff Gradel and his friends to serve your land and your king! And don't worry if you get confused; it makes the adventure that much more fun. Just submit a command and see what happens! Updates Wednesdays, Fridays, and Sundays.", False, True)
add('CurseLineage', 'http://curselineage.smackjeeves.com/comics/', u'Read from right to left. Ayla Exonuke, A young Yuzcazi is being chased by the Kirimangalou Empire, They think she is the last one of a long-lost lineage. Together with her brother Kokei (not related by blood) They try to survive to the empire attacks and any other things that get in their way. Genre:Action,Adventure,Fantasy. release schedule: Thursday.', False, True)
add('D00R', 'http://www.storyofthedoor.com/comics/', u'A pug falls into a toilet, thus releasing a rather snarky genie who had up until that point been bound body and soul to the extremely scummy receptacle.', False, False)
add('DBON', 'http://dbondoujin.smackjeeves.com/comics/', u'An 8 issue long crossover manga of Shounen Jump classics, Dragonball Z, Bleach, One Piece and Naruto. that i did a little while back as something iv always wanted to do/see, and also practice for my own original long running manga Ryak-Lo (Reads Right to Left) this is a fan comic, all characters belong to their respective creators.', False, True)
add('DDSR', 'http://ddsr.smackjeeves.com/comics/', u'A sprite comic that has no Sonic sprites! Seriously, all customly done. Join two friends and there crazy adventures involving demons, robots, explosions and shiny things.', False, True)
add('DOUBLEK', 'http://doublek.smackjeeves.com/comics/', u'Miami Vice meets Gurren Lagann in the most explosive, high-octane buddy cop comedy in the HISTORY OF POLICE and/or INTERNET FAN COMICS', False, True)
add('DanDanDan', 'http://dandandan.smackjeeves.com/comics/', u'DanDanDan is an adventure made only whit a pencil and a piece of paper in my sparetime! This is the biggest adventure in the lives of DANiela, DANte e DANdelion, the robot!!! I hope you enjoy!', False, True)
add('DanielleDark', 'http://danielledark.smackjeeves.com/comics/', u"Danielle Dark is a vampire trying to make it in the mortal world. It isn't easy, and she is discovering that she is different than other vampires in many ways.", False, True)
add('DavidDoesntGetIt', 'http://daviddoesntgetit.smackjeeves.com/comics/', u'A diary comic of me and my three siblings.', False, True)
add('DeadFishComics', 'http://watghosthunter.smackjeeves.com/comics/', u"I just put random comics I draw here. Mostly: Fancomics (Tiger and Bunny, video games etc) Also: a lot of original comic series: Adventures of a Supervillain In Love: Mad scientist meets guy who won't take off his helmet. Love ensues! Moira Adventures: girl get new job, meets crazies. Wat Ghost Hunter: Guy gets stalked by ghost who wants to take him to Tim Hortons. Succubooks: In a videogame world the tale of a man and his succubus/incubus/book. Pretty much anything could end up here. Contains Bl, yaoi, M/M sex, and nudity of both sexes.", True, True)
add('DeadLine', 'http://deadline12.smackjeeves.com/comics/', u'16 year old girl, goes to school, hangs out with friends, two loving parents and works for the department of death. Where all her jobs have a "deadline" Oh, there\'s also some yaoi/yuri in it, but later in the comic, you\'ll see. I also recommend that if your under the age of fifteen that you would discuss this with your parents due to sexual content and graphic violence', False, True)
add('DeathNoteIridescent', 'http://dn-iridescent.smackjeeves.com/comics/', u'Iridescent: Producing a display of lustrous, rainbowlike colors. Completed. Extra chapters in the making~', False, False)
add('DebtSettlement2OperationExtinction', 'http://debts2.smackjeeves.com/comics/', u'Character info and much more can be found at: http://sites.google.com/site/debtsettlementcomic Direct sequel to "Debt Settlement". (It is recommended to read that before this one): "3 years later. There is trouble on the way as the Red Star Security find their officers being gunned down. Seeing there is no other choice, they decide to make a direct approach towards their rival organization, Blue Labels and see if they know anything about these attakcs. With the old cast and a big list of new ones, DSOE opens up the reality Samantha is now living in. She and the rest of RSS has to learn to work with their old enemies and find a way to survive when someone obviously wants them all dead. Who are the Nightbringers and are they a threat? Can Samantha really deal with the responsibility she chose to carry in the crew? And is rest of her family really willing to let such new arrival just run them over in to the leaders position? A lot of questions are answered and secrets revealed."', True, True)
add('Debtsettlement', 'http://debts.smackjeeves.com/comics/', u'Character info and much more can be found at: http://sites.google.com/site/debtsettlementcomic DEBT SETTLEMENT " Samantha is 14-year-old girl with little to no hope for her own future. Her mother is an alcoholic in a debt trap and after getting even Samantha in to trouble because of her own mistakes, the only people who can help the girl now, are on the side of the family Samantha didn\'t even know existed. Problem is, does she really want their help? " DEBT SETTLEMENT:RUNAWAY BROTHERS " 27 pages long spin-off which will reveal you how did Kiran and Deepak, the brothers from a super religious Aditya family ended up working for RSS. "', True, True)
add('DefyingGravityTheFourGreatGuardians', 'http://defyinggravitycomic.smackjeeves.com/comics/', u'It is the year 3015, the sun has begun to fade and the world is cast into shadow. As prophecized, the fate of the world rests on the shoulders of the "Four Great Guardians" who are said to re-ignite the sun and bring an end to the war ravaging the planet. But just who are the four guardians? In mid-apocalyptic Europe, three half-human half-demon citizens are brought together by what can only be called fate. The only question that remains is: Who is the fourth Guardian? Meanwhile, a failed Russian experiment known as the "Dragon" is wreaking havoc upon the already helpless world. ****Updates 3 pages every Sunday****', False, True)
add('DemonCat', 'http://demoncat.smackjeeves.com/comics/', u"Hello Everyone! Yes, i have made me another webcomic - but this one will be very different compared to the others. I have already finished this comic... during class (in school... ) and now i'm just outlining it on photoshop, to make it look better. But i will be updating everything maybe 12 pages at a time? But not that much because it is a very short story... and as i've said... this is my first story... that is BL... so I wanted to tell everyone just so you guys no, that its not an intense BL... just a little sprinkle of it... i was just very curious to try it out... and i think it came out good... Anyway, i wanted to show it to you guys - Cause you're AWESOME! xD ~~~~ The story is about a Demon who runs away to Earth but finds out that he's turned into a cat... and finds that he's liking it. As well as the human who takes care of him, but his human's (master) friend is jealous and starts to develop plans to get rid of the cat. ~~~~~~ Warning: BL (not that much though) WARNING: SHORT STORY!", False, True)
add('DemonEater', 'http://demoneater.smackjeeves.com/comics/', u'A cannibalistic world where the inhabitants only food is each other.', True, False)
add('DenizensAttention', 'http://denizensattention.smackjeeves.com/comics/', u"Alicka and her little brother Winston are sent to Winterkill Boarding School. The number one dumping ground of unwanted troubled teens. A miniature Gormenghast filled with bad seeds and black sheep. +++++++ Winterkill: to kill by or die from exposure to cold winter weather. ++++++ This comic will update when i can. i'm trying for once a week, but not always managing. ++++ Denizens! Attention! how has its very own tumblr http://confessionsofawannabecomicartist.tumblr.com for updates, news and random comic making thoughts and sketches.", False, False)
add('DepthsOfMyEmptySoul', 'http://depthsofmyemptysoul.smackjeeves.com/comics/', u"Zadel, demon prince of Hell 7, struggles to prove himself to his mother and all who he's destined to rule over. The source of his struggles? His arch rival, yet best friend, Angel Abel. The truth is, Zadel rather spend his time enjoying Abel's company than act like the future ruler of Hell 7 and meanwhile other demons have their eyes on the throne. Zadel is being pressured to change his behavior and become a cold and respectable demon prince worthy of inheriting the throne, something that promises to put his friendship with Abel to the test. Will he finally make his final decision and chose his role as demon prince over his friendship with Abel? One night when Zadel's feeling bored and yearning for the company of Abel, he decides to pick on a down on his luck human. He tries and succeeds in persuading the human, Jacob, into making a bet with him wagering his own soul. Soon he realizes that picking on Jacob was not such a good idea. Bickering, jealousy and some romance ensues as Zadel and Abel both battle to doom or save Jacob's soul. But another more threatening battle approaches as well. BL, GL, HL Art improves over time.", True, True)
add('Descendant', 'http://descendant.smackjeeves.com/comics/', u'With the disappearance of her husband and her life dwindling to nothing, Celeste begins her quest to not only reclaim the fervor of her life but to also tangle with the now unfurling chaos that has consumed her being. This fledgling Descendant, with the most powerful relic on earth, finds herself violently hunted by those whose lives stretch back to antiquity. Can she come to terms with the revelation that the whole of humanity knows literally nothing about the nature of their existence and can she muster within herself the will to thwart the anger of an ancient god?', False, True)
add('DevilsCake', 'http://devilscake.smackjeeves.com/comics/', u"When Kea finds that her bad luck with boys isn't a 'what' but a 'who', will her sanity survive the IN-sanity that ensues? PG-13 Currently Updates Tuesdays and Fridays", False, False)
add('DevotoMusicinHell', 'http://devoto.smackjeeves.com/comics/', u"This is the story of how the now-fallen Principality of Music, formerly an angel of some repute, was given an opportunity to provide inspiration for one working man desperately in need of a muse. Other angels, fallen and not, are further compatriots, such as Devoto's surprisingly sympathetic boss and the armadillo aficionado commonly known as Sloth. Though the divines are great, and in some cases terrible, each is coming to appreciate the value of a uniquely human connection. (Gag, right? The important thing is that Guys Make Out. Guaranteed.) Warnings for: - Explicit gay content - Blood/Gore (but not in sexual contexts) Relevant tags: Yaoi , BL , gay , M/M , erotica , pornography , porn , F/F , yuri SJ Note: I understand SJ policy, and thus it's worth noting that this comic does not and will not portray sexual situations with minors or individuals who appear to be minors. Furthermore, this comic will not portray non-consensual (or dubiously consensual) sex.", True, True)
add('DigimonCorruption', 'http://digimoncorruption.smackjeeves.com/comics/', u'The world is in chaos. BlackWarGreymon and Omnimon continue to watch the Digital World collapse around them as Baihumon and Ebonwumon remain imprisoned. Meanwhile, the Daemon Corps is gathering more and more Fractal Code from innocent Digimon as they go about their search for the Code Crowns. But the DigiDestined is back to set things right.', False, True)
add('DigimonEclipsesShadow', 'http://digimones.smackjeeves.com/comics/', u'', False, True)
add('DigimonSaviors', 'http://digimonsaviors.smackjeeves.com/comics/', u'.:THE ALMOST ORIGINAL:. When 9 children are mysteriously transported to a new world, they come across strange monsters called Digimon. These digimon help them survive the digital world as they try to do anything possible to find an escape from this world... ------------------------------------------------------ After defeating the D-reaper in the Real World, a vision was shown to Neroe and Agumon that the digital world was in danger. Upon returning there, they learn how much trouble they set themselves up for exactly. How will the digidestined fight this ultimate threat? Find out on Arc 5 of Digimon Saviors! Neroe - Agumon Shard - Gaomon AnXjak - Crabmon Ankh - Gotsumon Marly - Impmon Beth - Hawkmon Neo - Guilmon CD - Wormmon Radd - Renamon Van - Veemon anime.... in... space', False, True)
add('DirtyFantasies', 'http://dirtyfantasies.smackjeeves.com/comics/', u"Shino Tanaka is the bad boy of Akai Bara High. Though he usually has himself together, lately some very perverted dreams he's been having about a fellow classmate has caused him to be a bit off his game. Confused by the sudden fantasies, Shino finally came up with a possible solution. His plan was simple, if he were to actually have sex with the boy, maybe the dreams would stop. But could it really be that easy?", True, True)
add('DoctorWhoSpamAndDiscussion', 'http://whovianpostingplace.smackjeeves.com/comics/', u'Where the few whovians of Smackjeeves unite to post doctor who stuff. alsospecialweaponsbestdalek', False, True)
add('DoodleBeans', 'http://beans.smackjeeves.com/comics/', u'No arms? No legs? No problem! Superheroes, Tentacle Monsters, Video Games, Violence, and PLOT!? If you like it, please comment and +favs Comic updates Monday-Friday at Midnight (PDT)', True, True)
add('DoodlingAround', 'http://doodlingcomic.smackjeeves.com/comics/', u'', False, True)
add('DoomsdayMyDear', 'http://www.doomsdaymydear.com/comics/', u'A turn-of-the-20th century webcomic drama about a modern day plague, the political turmoil that follows in its wake, and the lives of the people it touches.', False, True)
add('DougsMindDougshugs', 'http://dhstrips.smackjeeves.com/comics/', u'', True, True)
add('DragonKid', 'http://dragonkid.smackjeeves.com/comics/', u"Dragon Kid is the story of Keiko Shoda, a little girl from a land called Dragon Haven. Curious and strong-headed, she disobeys her brothers' warnings and ventures into the lair of the Dark Dragon, Kuronaga, accidentally freeing him. Now banished into the Mortal Realms because of her doing, she must become the heroine she is destined to be.", False, True)
add('DragonOrigin', 'http://dragonorigin.smackjeeves.com/comics/', u"On a island somewhere, hidden to the human eye, are shape shifting creatures called dragons. This island is the beginning of almost every dragon. This island is called 'Origin'. Dragons occasionally leave their nest at Origin and venture into the human domains. Some of them form relationships with humans as their guardians and the humans as their tamers. One particularly unlucky dragon decides to leave origin. He spends his life cautious of other living things and always alone. He vowed never to trust any one. That is, until a young girl comes along and earned his trust. Now he has a new vow. To protect this girl that has become his tamer, no matter what. Little does he know, there are more things in store for him then just protecting his new tamer. Contains: Romance, blood, violence.", False, True)
add('Dragonet', 'http://dragonet.smackjeeves.com/comics/', u'A wizard tries to raise an orphaned dragon in a world filled with fantasy, magic, war, and adventure. He soon finds out a dragon does what it wants...and he may make all the difference.', False, True)
add('DrawingParty', 'http://drawingparty.smackjeeves.com/comics/', u"** Congrats to our first prize winner of our Mascot contest, GunboyComics! In the banner is our new mascot, Sketchy! ** Are you stuck on ideas for things to draw? Are you just starting out and need practice and want to show the world? Well, no need to look any further! Comic artists gathered together to help eachother battle comic-artist's block! Every month there will be a new theme listed, you can either post a drawing or a comic strip based off of the theme. Since this is my first time putting a group together, the rules may be changed or added if things become out of control or to improve the group so that everyone has fun! :D * REQUIREMENTS * -- Some type of drawing instrument or any computer software! -- No experience necessary! :D * RULES * -- Must be drawn by hand or computer. -- Follow the theme topic for the month. -- The comic can be for anyone at any skill level! Which means any style, manga, american, realism, and anything in between! -- Be supportive! -- Be creative and have fun!", False, True)
add('DreamManga', 'http://dreammanga.smackjeeves.com/comics/', u"A monthly (mainly) shoujo online manga magazine featuring self-made original manga from non-professional artists all over the world. This site also serves as an online reader to our site at http://www.dream-manga.co.nr Current active mangas: ODD MONTHS * Contradiction (Ki Hiwatari) * Mascara (Arcadia) * WACOT (KO_Okami) * Machinataisen (Lwando) EVEN MONTHS * 2Kingdoms (SaiReba) * Dreamcatchers (Ayumi) * FireWire (SaiReba) * Kurokenshin (KO_Okami) * Saints' Calling (GuineaPiggy) MONTHLY * The World Stops (Marshmellow Muffin) * We Will Draw Near (Vervain) * Machinataisen *Lwando Lawrence Moshani) To learn more about us or join us, visit our forum at http://dreammanga.freeforums.org", False, True)
add('Dreamcatchers', 'http://dream-catchers.smackjeeves.com/comics/', u"Motsury Sohiru has been suffering from nightmares from long time, but one day fate drives her to a shop, where she finds a dreamcatcher. It would be all nice, but she hasn't got enough money to buy it, so she decides to steal it, but it get soon to an enemy of her, and when Sohiru get it back it is already broken. The next night she gets into a nightmare again, and the dreamcather brings it to the real world with a boy who saved her in the dream. But what can she do with this stranger? And what will happen after dreams and dreams? It will turn out from the manga...", False, False)
add('DressedForSuccessRetro', 'http://dressedforsuccess.smackjeeves.com/comics/', u"Alex Corbett and Walter Andrewkowski, two guys thrown together by chance, now making their way in a crazy universe one adventure at a time. All the while trying to stay one step ahead of the mafia and with the hopes of turning a profit. These are their original adventures, first published in the 1990's as black and white mini-comics.", False, True)
add('DungeonHordes', 'http://dungeonhordes.smackjeeves.com/comics/', u'In 1986 Dungeon Hordes was released on the Playtendo and moved 1 million units world wide which is way more successful than its previous release on the Batari 2200 in 1979. Now in 2011 Dungeon Hordes has returned bigger and better than ever with mind numbing graphics and all new enemies to fight. So how do the characters in game feel about this? Only time will tell. Enter the lives of Tiggz and Tomes, two level 5 bosses tired of being easily killed by player 1 and wanting the glory of finally becoming more than just petty bandits. Will they survive the new creatures that the mighty programmers have added to the game? Will they ever kill player 1 and move up the mob boss ladder? Will they ever get a raise from their uptight dungeon boss Kalakis and finally pay off their ale tabs at the Stinky Dragon Inn? Stay tuned and find out..... Will be updated Every Monday, Wednesday and Friday. Dungeon Hordes Facebook http://www.facebook.com/pages/Dungeon-Hordes#!/pages/Dungeon-Hordes/195568970460655', False, True)
add('EATATAU', 'http://eatatau.smackjeeves.com/comics/', u'', False, True)
add('EDIL', 'http://edil.smackjeeves.com/comics/', u'', False, True)
add('EDILfrench', 'http://edil-f.smackjeeves.com/comics/', u'', False, True)
add('ERAConvergence', 'http://convergence.smackjeeves.com/comics/', u"UPDATES MONDAY AND THURSDAY! The Darkwood corporation is in jeapordy if Velias doesn't manage to retrieve evidence stolen by a pesky rebel rat. He decides to hatch a plan to kidnap the rebel's clueless little sister, but finds that more difficult than he thought...", False, True)
add('ERAIbuki', 'http://eraibuki.smackjeeves.com/comics/', u"A short story about a girl with a kind heart who is faced against a world that's just too strong for her to fight. But it doesn't stop her from trying. Updates DAILY This comic is now a Premium Comic on Manga Magazine! :) If it isn't too much trouble, please give the comic one click over there too! :)", False, True)
add('ERRORERROR', 'http://errorerror.smackjeeves.com/comics/', u'A finnish teenage boy Tomi is a normal nerd. He plays videogames and gets average grades, but also is terribly bored with his life. But one day he accidentally gets inside of his computer and meets there a girl, who calls herself princess Jooda. And there is a profecy about Tomi, sword and Viruses. Warnings: If you are under 13 years old, I do not recommend this comic to you. Contains bad language, blood and somewhat sexual themes. ps. This started out as a test for new tablet, so the start looks like that too. Also, sorry about the style changes, I practice. Updates 2-4 pages a week.', False, False)
add('EVA303', 'http://eva303.smackjeeves.com/comics/', u'Evangelion 303 imagines an alternate-universe where the characters of "Neon Genesis Evangelion" are defending our modern world in a post-September 11th age.', True, True)
add('ElfenLiedDifferences', 'http://differences.smackjeeves.com/comics/', u"One of my favorite mangas is Lynn Okamoto's famous Elfen Lied (Which likewise I should clarify that I absolutely HATE the anime version) This comic is based on a trilogy story I wrote for FF.Net which I can't say was the best but it was fun nonetheless. --- Differences can be considered an alternate Universe Sequel to the manga. The story revolves around the actions of the second Queen Diclonius. --- It's all I can say, I'm not an artist, I just draw for fun. Enjoy Because it's based off of a Seinen Manga, there's going to be some adult content including Blood and Gore Language Nudity Sorry for inconsistent art as well. Read: Left to Right. When I started it, I didn't do as a traditional manga nor did I feel like changing it up either. Be nice, but feel free to criticize. --- Re-doing Volume I, updates will probably be weekly.", True, True)
add('EmeraldNuzlocke', 'http://giginuzlocke.smackjeeves.com/comics/', u"Yes, another Pokemon Nuzlocke to infest SmackJeeves. Done on Pokemon Emerald (since I haven't played the Hoenn games in forever D: ). I've been meaning to start a Nuzlocke that I'll stick to o3o This Nuzlocke follows the adventures of Gigi, a human who has lost her memory and wound up in Hoenn region. ********** COMPLETED! Part 2: http://giginuzlocke2.smackjeeves.com", False, False)
add('Entreeuxdeux', 'http://entreuxdeux.smackjeeves.com/comics/', u'"Entre eux deux" est une bande-dessin\xe9e amateur qui sent bon la poudre, les fusillades et la mafia, mais qui en fait se pr\xe9occupe plus des deux destins qui y ont difficilement trouv\xe9e leur place. Deux \xeatres que tout s\xe9pare, mais finalement pas tant que \xe7a... Je poste les pages par quatre (quand j\'y arrive) tous les 15 jour, le dimanche. Merci \xe0 tous ceux qui passent par ici. >w<', False, True)
add('Entuthrie', 'http://entuthrie.smackjeeves.com/comics/', u'A story about personages in turmoil, and the coincidences that follow. Taking steps forward, one (en), two (tu), three (thrie), is the way to reach to a conclusion. or, kitty-eared girls and gay librarians ride together with giant insects to chase a sadomasochistic lesbian pirate, the comic.', True, True)
add('EscuelaYamanaoki', 'http://yamanaoki.smackjeeves.com/comics/', u'Kouhei es un chico un poco rebelde y por esto ha sido cambiado constantemente de escuelas, entonces su padre decidio mandarlo a la escuela del Monte Naoki mas conocida como Yamanaoki, al parecer es una escuela normal... pero... si fuese asi... no habria nada que contar xDD muchos sucesos extra\xf1os haran que Kouhei vea la realidad con otros ojos... o una realidad completamente desconocida... chan chan chaaan English version: http://yamanaokihs.smackjeeves.com/ (paused) sitio en facebook: http://www.facebook.com/pages/Yamanaoki/167250876624086', False, True)
add('EternityConcepts', 'http://eternityconcepts.smackjeeves.com/comics/', u"WARNING: This is a yaoi manga. There is no sex--but there is some suggestion, and a large amount of adult humor. Julian--err, Father Julian--Father Skyy? Just call him Julian--is a priest at Sacred Heart Cathedral. . .and deeply depressed. After a long struggle with his depression, he concludes a deadly solution, convinced it's the only one he has; En route to take his own life, Julian discovers the body of another man who's beaten him to the same punch--and in the snap moment of a life or death situation, Julian forgoes his plans to save a life. Thus he meets Hollow, a depressed Atheist whom Julian now accredits his illumination to happiness to; Having now come to close to experiencing the damage he himself was about to cause, Julian feels transformed--and wants to return the favor to Hollow and do the same for him. If he can't--surely God can! While they agree to disagree, Hollow and Julian form an odd, close friendship--and soon, Julian forgets about converting Hollow and begins to realize his feelings. . .may mean something else. All the while, they're never aware of the danger lurking in the shadows. . .", True, True)
add('EvanYeti', 'http://evanyeti.smackjeeves.com/comics/', u"Follow Evan, a young abominable snow monster as he tracks down the strange creatures that took his parents. He'll find that life outside of his comfort zone is a dangerous place full of wild animals, new enemies, and maybe even a few friends.", False, True)
add('EvilPlan', 'http://evilplan.thewebcomic.com/comics/', u"Evil Plan takes the superhero world and flips it, viewing things from the supervillain's perspective. The story follows Dr. Kinesis' journey on the road to world conquest. On the way, he'll have to deal with a troublesome AI, his unwilling friendship with crazy black-market dealers, and the possibility of romance with his second-in-command. And the superhero. Can't forget that guy. With all this going on, Evil Plan is a comic for people who want to see the bad guy win. If he doesn't blow himself up first. Story and Line Art: Alexis Royce Color: Megan Johnston, Chelsea Capobianco Updates: Every Sunday", False, False)
add('ExperimentalMegaman', 'http://ex90081.smackjeeves.com/comics/', u"Distant in the future, a weapon of mass destruction is created to destroy all Megamen- A maverick more powerful than any of them. As the ninth prototype is created, it's creators take it for a test run. Aparently though, there are a few bugs in his system... .:Updates on Mondays and Friday:.", False, True)
add('Exploit', 'http://exploit.smackjeeves.com/comics/', u"[Don't worry guys - I'm pretty busy these days but updates are coming soon] Akitsu Yorukishi. Purple hair, glasses and headphones. He's not really interested in catching them all, being the best trainer or being famous. His life would be normal if he just didn't meet...her. Who cares about medals, when you have to SURVIVE. -- Extra tags: pokemon doujinshi manga anime", True, True)
add('EyesofaDigimon', 'http://eoad.smackjeeves.com/comics/', u'A fictional Digimon manga about a boy and a unique Digimon. Based off the series by Akiyoshi Hongo.', False, True)
add('FailureConfetti', 'http://failureconfetti.smackjeeves.com/comics/', u'Failure Confetti is a webcomic about life, words, science, games, and human observations. Updates weekly, on Wednesdays.', False, False)
add('FalconersDailyStrips', 'http://falcdaily.smackjeeves.com/comics/', u'Daily comic strips I throw together with little effort just for funzies.', False, True)
add('FallenAngelslove', 'http://fallen-angels-love.smackjeeves.com/comics/', u"A cute BL story No smex for awhile sorry! :D Hiro and Taisuke have known each other for many years, they have been friends for as long as they can remember. However, Hiro is a demon who is fated to be locked up for all his life and Taisuke is an angel who's a bit of a play boy. What will happen when Hiro begins to long for freedom so much he would do anything to obtain it? When Taisuke realizes that his feelings for Hiro are a bit more than friendship will he run away or embrace those feelings? When heaven and hell clash how could such a love be accepted? Sounds cliche but I promise it will be a enjoyable read XD", False, True)
add('FarOutMantic', 'http://meteorflo.smackjeeves.com/comics/', u'a kinda large comic this time. about love, creativity, music and discos!! just a fun comic really, nothing too perpelxing. have fun!!~', False, True)
add('FarOutThere', 'http://faroutthere.smackjeeves.com/comics/', u'A manga-esque Sci-Fi Comedy. Far Out There is the webcomic where things happen... IN SPACE!!! (currently being transfered over from DrunkDuck, so pardon the mess)', False, True)
add('FarewellFeeling', 'http://farewellfeeling.smackjeeves.com/comics/', u"new page posted every Saturday. reads R-to-L. ----------------- S Y N O P S I S Grief hates her job. She thought it would be romantic to be the human emotion for sadness -- instead it's nothing but heartbreaking. so she quits. and while she thinks she is giving her human, Ellison, a great gift by quitting, it is really just the opposite... ---------------- Farewell Feeling explores what would happen if our emotions....had emotions. the six basic human emotions of Grief, Joy, Anger, Surprise, Fear and Love are all personified, each with their own hopes, dreams and problems. -------------- note: I also take manga/comic sequential page & illustration commissions. Farewell Feeling is not entirely representative of the quality of such work, since it is done just for fun/for myself. please email me if you are interested, and I can provide you with other samples. lilyhanamail@gmail.com -------------- if you're interested in my other work, please visit: http://rain-and-sunshine.deviantart.com thanks for reading!", False, True)
add('FartherBeyondtheLookingGlass', 'http://fbtlg.smackjeeves.com/comics/', u"Remake of http://www.smackjeeves.com/comicprofile.php?id=108590 It has been years since Alistair's last arrival to Wonderland. Stuck within the walls of the mental hospital, Alistair had enough of life. When he had returned back to the world he once knew and loved, everything changed. Alistair's wonderful world is now his biggest nightmare.", False, True)
add('FierceConflict', 'http://fierceconflict.smackjeeves.com/comics/', u"For years, a war devastated the planet called Sapton. The conflict began with a group of rebels who were dissatisfied with the laws of this world attempted a world wide coup d'etat. They slowly gained power and eventually overwhelmed the majority of the opposition and are slowly but surely taking control of the world. Out of this group of rebels 5 have taken full authority and are now attempting to lead the world down the path of darkness.We follow the story of a koopa named Zuke who lost his family and homeland in the war. He travels the world in hopes of finding a way to bring peace. All sprites belong to their respective owners.", False, True)
add('FinalArcanum', 'http://finalarcanum.smackjeeves.com/comics/', u"Anyone can be a hero, even the unsuspecting, unwieldy sky pirate Acacitli. When he gets separated from his ship and crew, he quickly learn there's a little more to life than rum, thievery, and failing a little at life more than he'd care to admit.", False, True)
add('FireHeart', 'http://fireheart.smackjeeves.com/comics/', u'Fire Heart is "collaboration" comic which has been going on since November 2008. Its original idea was to be Sonic fancharacters adventure story but we have begun to change characters to more original form and these days it is more semi-fancharacteristic and we are trying to continue to change our comic even more original. (But we won\'t change older pages because this comic\'s idea is to continue all the time and tell the story and learn more about doing comics. So we are doing it for fun!) These days this project has about ten different artist working on it. (Notice that some older artists have left this project long time ago.) So please don\'t judge our work for its old (somehow horrible) pages. __________________________________________ Update on Monday, if there is new pages ready. Update also in Friday is possible if there is a lot of pages coming.', False, True)
add('FireWire', 'http://firewire.smackjeeves.com/comics/', u"When Kennedy H'naka's cell phone becomes the new home of the dragon FireWire Balisk, she finds herself sucked into a world of battles, secrets, and shadowy organizations. What's a girl to do when she has to save the world and still pass the tenth grade? Updates: Thursdays Reads: left to right. Comments greatly appreciated ^^", False, True)
add('FireredLisasReise', 'http://lisasreise.smackjeeves.com/comics/', u'This comic is a Firered Nuzlocke run. Lisa, a young girl from kanto starts her journey to become the Pok\xe9mon master. Updates Sundays! Also visit my tumblr account and ask Leaf questions! http://lisa-leaf.tumblr.com/ Laufente has helped me with the coloring until page 63, but I figured I should learn how to do backgrounds and attacks myself so I will do it alone from now on. Laufente has her own Nuzlocke as well so please look at Road to Glory as well :D', False, True)
add('Flashback', 'http://flashback.smackjeeves.com/comics/', u"Following the life of some unknown dutch dude in this journal comic. Through the true tales, the less true tales and the made up stories that simply don't make sense. UPDATED 5 DAYS A WEEK Welcome, to FLASHBACK.", False, True)
#add('FootLoose', 'http://footloose.smackjeeves.com/comics/', u'Beware, some strong language! Akio is sick of having fake friends who are only after his money and his looks, so what better to do then start at a new school, with a new personality... and gender, sort of. Some shoujo-ai and shounen-ai involved. PAIRINGS, psychotic bullies, and gender confused guys, what more could you ask for? Comic is completed, updates weekly with re-drawn pages-expect a sequel and an altered ending soon. Art: Alycia Cover art and story: Me read left to right', False, True)
add('ForcedSeduction', 'http://forced-seduction.smackjeeves.com/comics/', u'"Can you make the next person walking through this door fall in love with you within a month?" "Sounds easy." BL!!! I apologize for the lack of creativity and the super sketchy outlines. I\'m totally being forced XD (Just kidding) Oh, and English is not my first language. It\'d be lovely if you could help me to improve ;) (meaning correct me please XD) Better read from right to left ;)', False, True)
add('ForestHill', 'http://www.foresthillcomic.org/comics/', u'Life happens.', False, False)
add('ForgettheDistance', 'http://forgetthedistance.smackjeeves.com/comics/', u"(There's a little smidgen of nudity at the beginning but then it's smooth fluff sailing from there until...chapter 4? yeah, i think so.) Includes THEMES of BL/Yaoi/BoyXBoy: Logan's mother hasn't had a good eye for good men since his father went missing so when Brian comes along, he is automatically disliked. Any man who his mother brings home receives the same treatment: sarcasm,pranks and vile language. But unlike the others, Brian doesn't give up. He doesn't leave. Doing so earns him some respect from the teen and even though they begin to get along,the competition continues. They both love her dearly and neither will give up the game. Brian won't lose to a child such as Logan, and Logan won't lose to a man such as Brian. In the end are they really competing for his mother's love or for each others? Who will lose? Joint with my sister: Juli(AUTHOR/CO-ARTIST), Somi(ARTIST) UPDATES: We've gotten it down to about one every week...normally....if not within two. We're back on schedule cause we're free and hopefully drawing more.", True, True)
add('FoxpuffsSpriteandSpamStuff', 'http://spriteandspam.smackjeeves.com/comics/', u"Mostly random things go here. Sprite sheets aren't posted here, but any changes to any of my characters or new ones will still be posted.", False, True)
add('FreakyFresh', 'http://trololol.smackjeeves.com/comics/', u'Lulzy comic about parodies of famous works such as: -Black Butler/Kuroshitsuji. -Alice in Wonderland. Contains crack/lame jokes/profanity/Minty Fresh STORIES: Dat Butler (Ongoing) - A story about a cake addict and his butler. Alive in Wonderland (Ongoing) - A story about a kid who tries to find his way out of Wonderland. MFMMD (On Hold) - A beautiful love story with Minty as a love interest.', False, True)
add('Frenzy', 'http://theadventuresoffrenzy.smackjeeves.com/comics/', u'Neo Arcadia discovers an ancient reploid of immense power. Could he be their ultimate defense against the inevitable arrival of Zero?', False, True)
add('FrobertTheDemon', 'http://frobby.smackjeeves.com/comics/', u"A gag-a-day comic about one little demon's journey to cause mass chaos and wreak havoc upon the poorly-drawn folk known as stix.", False, False)
add('FromnowonImagirl', 'http://fromnowonimagirl.smackjeeves.com/comics/', u"One day out of nowhere Hikaru's girlfriend broke up with him because she found out she is lesbian. He decides he will never fall in love with women again so... he has to love men. with his big sister's help he is no longer hikaru the boy but a girl!(cross-dresser) Hikaru meet Natsu who made his life hell and decides to get his revange and... The rest is still unclear read from right to left Contains BL maybe yaoi, romance,GenderBender and comedy Hope you enjoy *improving drawing style", False, True)
add('FruitMachine', 'http://fruitmachine.smackjeeves.com/comics/', u"Jason Fellows is in love. Now the game is on to see how far Jason can string along his beloved Sheridan before his pennies run out. Just how long will Jason keep playing Sheri like a Fruit Machine before he tells him how he feels? -x-x-x-x-x-x-x-x-x-x- Ladies and gents, it'll be my pleasure to comic for you!", False, True)
add('FruitloopAndMrDownbeat', 'http://fruitbeat.smackjeeves.com/comics/', u"After hitting a bump in the road of life, Danny Lawson ended up moving back to the city where he attended college. His next door neighbor, Alan Taylor, is a senior in high school who falls in love with Danny almost immediately. AND THUS THEY BECAME FRUITLOOP & MR. DOWNBEAT. (bad intro, yes.) (contains boy/boy, girl/girl, foul language, cartoon violence, some sexual themes) Schedule is being removed for the time being. Updates whenever the author can get her crap together <xD'. (gonna aim for once a week?) (Note: A friend recently brought it up to me that she saw something on tv from the south where 'Fruitloop' was actually being actively used as a derogatory word. This comic means no offense, and the author wasn't aware that it was being used that way.)", False, True)
add('FurtherDowntheRabbitHole', 'http://fdtrh.smackjeeves.com/comics/', u"Wonderland has a dark edge to it. After so many years of being told that Wonderland was all made up in his twisted mind, Alex had about enoungh. He returned the very rabbit hole he first fell down in only to find it wasn't there. Was it true then? Was all his adventures and friends he made in Wonderland all made up? Was he really crazy like his family said? This is a Boy love collab. Don't like? Don't care, you don't have to read or join. Also this comic is gonna be a bit insanity/horror. Rules will be posted on first page. Any questions, pm me. Characters needed: Alice:(taken) Hatter:(taken) Tweedle twins:(taken) March Hare: (taken) White Rabbit:.( taken) Red Queen:(taken) White Queen:(taken) Chesire Cat:(taken) Knave:(taken) Catipiller:(taken) Dormouse:(taken) White Knight: (taken)", True, True)
add('Fusionsextras', 'http://fusions-extras.smackjeeves.com/comics/', u'A Showcase of Sprites. Now Accepting Fusions of Pokemon! 8 slots Total. Super Legend: Sprite Searching in Progress :open Slot: :open Slot: :open Slot: :open Slot: :open Slot: :open Slot: :open Slot:', False, True)
add('GRACE', 'http://grace-comic.smackjeeves.com/comics/', u"Welcome to Grace, a yaoi webcomic created by two girls, Majo and Miru, also known as M&M Studios! Adult content for sex and occassional violence. HOW WE WORK: Majo: sketching, shading, scriptwriting Miru: inking, flats, scriptwriting Updates: when the page is ready - our work keeps us very busy. We'll try to update as regularly as possible, though. Characters & artwork \xa9 M&M Studios. All rights reserved.", True, True)
add('GamesPeoplePlayUpdatedWeekly', 'http://gamespeopleplay.smackjeeves.com/comics/', u'A webcomic about the little nuances of table-top roleplaying games, and the people who play them. Updated weekly. Feedback and comments at azalin1@lycos.com', False, True)
add('GardenofHearts', 'http://gardenofhearts.smackjeeves.com/comics/', u"Alyn, royal guardsman to the elven Queen of the North leaves for a quest to the far south with his wise-cracking necromancer friend Skylar. They are seeking a long-lost magical talisman that could dispel the eternal winter of the northern lands--and just perhaps elevate Alyn to Queen's Consort after he returns a hero. To journey into the south Alyn will need the help of his childhood friend, Nirin. Only, Nirin is a lot more enchanting than he remembered and every step closer to the mythical Garden of Hearts is a step further from his goals. story specs: light-hearted fantasy romance BOY X GIRL. tech: hand-drawn, b & w, toned.", False, True)
add('GayBacon', 'http://gaybacon.smackjeeves.com/comics/', u'Here you can read strips about random things in my life or thoughts that may occur in this messed-up head. This is what the quiet, weird kid draws whenever he gets a chance. Updates at random times. [Contains a lot of cursing]', False, True)
add('GetUpandGo', 'http://getupandgo.smackjeeves.com/comics/', u'', True, True)
add('Gloomverse', 'http://gloomverse.smackjeeves.com/comics/', u'She was just a regular, unwanted kid, until she was lucky enough to get a job under the best magician in the world! Unfortunately for her, her new boss is a self absorbed sociopath. Updates are currently Monday, with some sporadic mid-week updates if I have time! Dark/Twisted Comedy!', False, True)
add('GoldenIrises', 'http://goldenirises.smackjeeves.com/comics/', u"Gay. Updates Tuesdays and Fridays. Will be 33 chapters long. I plan on publishing it eventually. The books will be really cool and have a lot of extra info. Sort of... intense. I guess. This comic project is honestly my baby. Those other projects, I dropped. Yeah. This though, I've been working on and tweaking for 2+ years already. So I will finish it. It is the most important to me and also I draw the two main characters constantly so if that doesn't say anything about how much I care for it, nothing does.", False, True)
add('GoldenSunGenerationsAftermathVolume1', 'http://gsgbtsyearone.smackjeeves.com/comics/', u"- BEFORE THE STORM SERIES EPISODE I: VOLUME ONE - A fantasy RPG story based from the underrated RPG game series Golden Sun. Three time traveled Adepts granted a second chance at life after living seventeen years in an alternate destroyed reality, must quickly get used to their new surroundings as they are thrown into the fray dealing with new friends, family, emerging enemies and a big sailing adventure they'll never forget. Part 1 of a 4 Year Webcomic Series BEFORE THE STORM, a Golden Sun doushinji. - Rated +13 for slapstick humor, mild language, and fantasy violence VOLUME ONE COMPLETED; VOLUME TWO AVAILABLE HERE: http://gsgaftermathv2.smackjeeves.com/", False, False)
add('GoldenSunGenerationsColossoVolume6', 'http://gsgbtsyearthree.smackjeeves.com/comics/', u'- BEFORE THE STORM: EPISODE III - A fantasy RPG story based from the underrated RPG game series Golden Sun. The main focus is on the character Ethan who has grown up the last two years in terms of height and skill, seeks to win the heart of the werewolf girl Tasha by competing in a tough fighting Tournament. The first round is over and now the festivities truly begin! Part 3 of a 4 Year Webcomic Series BEFORE THE STORM, a Golden Sun Fancomic. - Rated Web +14 for gutter humor, mild language, romantic situations (BxG love) and fantasy violence COMPLETE - SECOND HALF OF COLOSSO BEGINS FEBRUARY 2011: http://gsgcolossov7.smackjeeves.com/', False, False)
add('GoodGame', 'http://goodgame.smackjeeves.com/comics/', u'Three friends want to get some fun and play a computer game in their hi-tech fantasy world. But they got something wrong...', False, True)
add('GoodnightMrsGoose', 'http://goose.smackjeeves.com/comics/', u'Hard working lawyer mom Valerie Clark is letting her work life overcome her family life. However after a magical encounter, she gets the chance to rediscover her childhood and also help cleanse her world of odd creatures.', False, True)
add('GuardianGhost', 'http://guardianghost.smackjeeves.com/comics/', u"After being hit by a car a few months ago, things have been very strange for Max. Not only can he see ghosts, but one in particular claims to have saved him from death! But there are reasons why ghosts are not allowed to save humans. Updates Tuesdays and Thursdays (and Saturdays if there's time)with a massive quality shift from chapter to chapter", False, True)
add('GuardiansoftheGalaxialSpaceways', 'http://ggs.smackjeeves.com/comics/', u'Join Captain Taxxi Serbus and the crew of the Artful Dodger as they battle space pirates, giant comic book geeks, and intergalactic viruses in a star-spanning adventure!', False, False)
add('HDMTHCOMICS', 'http://hdmthcomics.smackjeeves.com/comics/', u'My sprite comic shows how me and my friends live in the world of Sonic the hedgehog!', False, False)
add('HIPS', 'http://hips.smackjeeves.com/comics/', u'An admittedly done before bl romance. Here is my attempt at a gripping back cover summary: In an effort to get away from his criminal family, Julius Green has turned witness for the city. He is secreted away and hidden in a posh private academy as...a girl?! Suffocated by the charade, will Julius be able to pull off school life as Penny Adams? And will he be able to save himself when the two rulers of the school, Max Lawson and Alex Watch, take particular interest in him?', True, True)
add('HappinessStartswithYou', 'http://happinessstartswithyou.smackjeeves.com/comics/', u"Looseing a best friend when you're young can hurt more than you think. Sasumi grows up with one memory of his friend, and day by day it fades. Will he ever find out who is friend was or will the memory be just disappear, just like his friend? This is YAOI so prepare yourselves peeps! :3 I hope you enjoy it! :3", False, True)
add('HaruSari', 'http://haru-sari.smackjeeves.com/comics/', u'June is a young woman dying from a terminal illness. A doctor by the name of Chi-Min Huang offers her free treatment, and the two of them become friends. Everything seems peaceful, if sad... on the surface. Unbeknown to June, the doctor is deeply entangled in a terrible conspiracy against his will. Not wanting to get her involved in the mess, he keeps a lot of things secret from her, but there may be another\u2014less noble\u2014reason behind his secrecy...', False, True)
add('HarvestMoonParadiseFound', 'http://paradisefound.smackjeeves.com/comics/', u'When a single phone call changes your destiny...do you find the strength to embrace it? A Harvest Moon Doujinshi (fan comic) Read RIGHT to LEFT. Updates Thursdays. (Harvest Moon title and concept are copyright of Marveslous Interactive)', False, True)
add('HatShop', 'http://hatshop.smackjeeves.com/comics/', u'You may be thinking this is a comic about hats. It\'s not. A strange comedy about a boy who is fired in the first panel and accidentally sells his soul to an eccentric hat maker. Shenanigans ensue. Note to new readers: The art gets better. Note on the format: I originally drew it vertically because I did it by hand and that\'s how it would fit on the page (It just seemed like a good idea at the time). Three years later, it\'s stuck. It sometimes changes to full pages if the story needs it, but the vertical format is the default and I\'m not planning on changing it. Updates every three days unless otherwise specified. Note: This is a "whatever the author feels like" comic. You have been warned.', False, False)
add('Hatecantlove', 'http://hate-cant-love.smackjeeves.com/comics/', u'Hate can\'t love Status: Ongoing Since: Summer 2009~ Language: English Genres: Romance Story&Art: Kiiroi Thousands and thousands years ago, God created the feelings "Love" and "Hate". They could live happily in the paradise as long as Love didn\'t hate and Hate didn\'t love. One of them broke that rule and they were separated forever. Nowadays, Ai Koizumi is a 15-year-old girl who is in love with a boy that everybody seems to hate. Although she confesses to him her feelings, he refuses her. Will she be able to change his mind? The last battle between Love&Hate! Who\'ll win? Updates every now and then. READ FROM LEFT TO RIGHT! >>>>>>>>>>>>>>>>>>>>>>> THANK YOU SO MUCH ^^', False, True)
add('HatethePlayer', 'http://hatetheplayer.thewebcomic.com/comics/', u"Hate the Player is a comic based on a number of concepts Tron, and Quantum Leap. The overall idea is the character M.C. (A play on words for Main Character). A horrible game magazine reviewer who gets transfer'd into the game world by Beans, who use to be a developer until M.C. ruined him, now an editor who came to get revenge on M.C., He forces M.C. to re-enact the various game worlds as the Hero of the world, until a freak glitch causes issues.", False, True)
add('HavingDifficulty', 'http://having-difficulty.smackjeeves.com/comics/', u"Robby is starting high school. In his mind, he's having difficulty fitting in. He barely knows anyone. Will the next four years change his attitude? Updates once a day.", False, True)
add('HealeronFeatheredWings', 'http://selsachronicles.smackjeeves.com/comics/', u"The world of Selsa is in danger of being conquered by an evil dragon lord- and they do not see it happening. Only a few heroes, who have crossed his path, know what he's up to and its up to them to stop him.", False, True)
add('HedgehogPieceANewEra', 'http://hedgehogpiece.smackjeeves.com/comics/', u'~This is a revival of the original Hedgehog Piece~ Take an adventure throughout a new world of One Piece, in a new Era of Pirates, following 5 major pirate crews of different species and personalities. We also accept cameos in the same format below (also include brief personality and background). PM to ReiKainaric. For ANY problems, PM to sonicmaster05.', False, True)
add('Helix', 'http://helix.smackjeeves.com/comics/', u"A street rat is given a second chance when he is dragged from the gutter and into a new life. Will he accept his position at the side of royalty, or fight every step of the way? *Rated M for sex (both hetero and homo), violence, nudity, language and dark themes.* If you can handle these subjects, I hope you'll enjoy the comic. :) Thanks for reading! ~Join Helix on tumblr at http://helix-comic.tumblr.com ! ~", True, False)
add('HeltonShelton', 'http://heltonshelton.smackjeeves.com/comics/', u'This is a goofy sketch at a party that grew into a two-book saga about a multi-generational battle against the darkness inside us. Shelton1 and Shelton2 set out to fight the Final Boss, but victory carries a cost for Shelton1. A party of heroes begin a quest of vengeance, but can they overcome their rivalries before facing their ultimate foe? A spellcasting musician learns to deal with death, but can she deal with life?', False, True)
add('Hephaestus', 'http://hephaestus.thewebcomic.com/comics/', u'(a retelling of Greek mythology, with more than likely deviation from the original myths) While other gods on Mt. Olympus are known to be beautiful and laid back, Hephaestus is more humble in appearance and works his hands to the bone. However, that is not to say that the god of crafting and fire doesn\'t have any interesting tales about himself... <<Current Chapter>> 6) Origins: Part 3: Our tale of tragedy comes full circle as we learn of the final fate of young Hephaestus, leading to a fateful encounter between him years later with a certain Queen of the Nereids... <<Previous Chapters>> 1)Road to Athens: 2)Origins: Part 1 3)Passive Affection 4) Origins Part 2 5) Hermes\' First Flight Hermes, the last of the Olympian twelve to join, starts his tale as a meek child with weak ankles, unable to live up to the "God of Messengers" name we know him for. It would take the guidance of a certain smith god to change all that soon enough...', False, False)
add('Herpdederp', 'http://herpdederp.smackjeeves.com/comics/', u'A collection of stories and jokes about myself and my boyfriend, an aggresive vegitarian, video-games and T.V. shows, and my life as an awkward klutz.', False, True)
add('HiddenStrengthAWhiteNuzlocke', 'http://hsnuzlocke.smackjeeves.com/comics/', u'Clover, Cheren, and Belle graduate from trainer school, looking forward to finally being able to go on a pokemon journey of their own. Things start out like any other adventure, however soon the trio becomes entangled in the mess that is Team Plasma, finding out secrets that have been hiding in plain sight all their lives. How will their adventure unfold? This is a Nuzlocke story comic. [THIS COMIC IS FINISHED]', False, True)
add('HighSchoolHeroes', 'http://highschoolheroes.smackjeeves.com/comics/', u'A group of teenagers desperately want to become superheroes, but high school keeps getting in the way.', False, True)
add('HitandMiss', 'http://hitandmiss.smackjeeves.com/comics/', u"It's a autobiographic comic about, well, me and my daily life! Doesn't that sound interesting? WARNING: This comic may contain the following; misspelling, weird situations, gaming, horrible puns, cats, depression, and the occasionally lovey dovey stuff. http://www.drunkduck.com/Hit_and_Miss/ ^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^^ The link to DrunkDuck Hit and Miss!", False, True)
add('Holocrash', 'http://holocrash.smackjeeves.com/comics/', u'Welcome to HoloCrash, the adventures of Commander Teelianna Santo ("Teela") and her Genetically Enhanced Nanotech Android trainer ("G.E.N.A"). Teela, a brilliant science officer and an exceptional athlete, volunteers for a year round trip aboard the cargo freighter Argenta-619 so that she, along with her trainer G.E.N.A, can train for the upcoming Pan System games in heavy gravity conditions. Soon, what seems like a normal freight run to the Cordas System, turns into an adventure like no other!', True, True)
add('HolyBlasphemy', 'http://holyblasphemy.smackjeeves.com/comics/', u'Making fun of religions since 2010. Better stay clear of this comic if you really cannot stand people making fun of Atheism, Buddhism, Christianity, Creationism, Germanic and Greek Polytheism, Hinduism, Islam or Judaism as well as of Abraham, Agni, Aliens, Angels, the Easter Bunny, Great Ctuluh, Isaac, Jahweh, Jesus, John the Baptist, Joseph, Mary, Mohammed, normal humans, Pascal, robots, Santa Claus, Satan, Tantalus, Thor, Vishnu, well-built catholic girls, Zao Jun or Zeus (more religious belief systems and persons may follow). Updates whenever I find the time (on average every 2.4 days or almost three times a week). Comments and voting highly welcome!', False, False)
add('HolyCrap', 'http://holycrap.smackjeeves.com/comics/', u"Hi there! Welcome to what-ma cha' call it? ... Oh that's right Crap Holy. No no... AH! WELCOME TO ME! I AM HOLY CRAP!", False, True)
add('HopeForABreeze', 'http://h4ab.smackjeeves.com/comics/', u'This is a story of a girl named Sophia and her journeys through life. webcomic, web comic, school life, slice of life, school, drama, anime, autobiography, memoirs, manga, cartoon, comic', False, False)
add('HotChocolate', 'http://hot-chocolate.smackjeeves.com/comics/', u"COMPLETE! Other art and doodads will be added, but as for the story, it's finished! Thanks to all the readers!", False, True)
add('Houseofsprite', 'http://sac22.smackjeeves.com/comics/', u'A hotel comic where anything can happen! Rules: no inappropriate updates keep it PG-10ish', False, True)
add('HurrocksFardel', 'http://hurrocksfardel.smackjeeves.com/comics/', u'', False, True)
add('INUSITADOONLINE', 'http://inusitado.smackjeeves.com/comics/', u'Uma simples comedia romantica ;D', False, False)
add('ImitationNightmare', 'http://imni.smackjeeves.com/comics/', u'The story of the relationship between a protagonist and an antagonist, both unknowingly wrapped up in the same conspiracy involving drug testing and the paranormal. Warning, contains: Violence/Gore Inconsistent art Updates at least once a week, sometimes more. Reads western style - left to right.', True, True)
add('ImminentMoose', 'http://www.imminentmoose.com/comics/', u'"EVERYTHING IS WONDERFUL" :~ UPDATES HAPPEN ON SUNDAYS~: NOW DOING COMMISSIONS!', False, True)
add('InaWorldwithWarcraft', 'http://worldwithwarcraft.smackjeeves.com/comics/', u'The world has been torn apart and only recently started coming back together again. As humans, we of course find an issue that divides the remaining population into two opposing sides. After having destroyed all knowledge of war, the only thing we can fight with is found to be a video game, the World of Warcraft. With more advanced technology, we are able to turn this video game into a virtual reality, battling quite realistically with each other. One woman finally is able to become a part of this new war, but how will others accept her?', False, True)
add('Inhuman', 'http://inhumancomic.smackjeeves.com/comics/', u"1000 years in the future, a schizophrenic has been kidnapped by a group of rebel soldiers. And it seems they've bitten off more than they can chew...", False, True)
add('InnerEdge', 'http://inneredge.smackjeeves.com/comics/', u'"Inner Edge: Old Wounds" is a prologue to the core Inner Edge story that I hope to put in a webcomic form sometime in the future. However, there are aspects of storytelling and art that I would like to experiment with before that and other sorts of stories that I want to tell in a short story form. So I decided to post some of those short stories here. Hope you will enjoy ^__^ More info/illustrations on my website: www.tacto.deviantart.com', False, True)
add('InsideOuTAYuriTale', 'http://insideout-a-yuri-tale.smackjeeves.com/comics/', u'A new Yuri series dealing with love, life and true friendship. The story follows new high school student Hitomi who decided to stop pretending to be someone else and start being herself. This decision leads to many odd encounters as she enters high school life and find her life is turned Inside OuT. Warning this manga is read Right to left. <<This way<<', False, False)
add('Insomanywords', 'http://insomanywords.smackjeeves.com/comics/', u'Sam Moore\'s 20 year old world is shifting on its axis, whether he\'s ready for it or not, and his relationship to his best friend Charlie is at the center of it all. But no friendly warnings, social boundaries, disabilities, self denial, Charlie\'s pretty girlfriend, nor the mayor of town can stop Sam\'s growing curiosity towards the quirky, blonde boy he\'s never had to live without. (art improves as you go on) Warnings: Adult content, Nudity, Profanity, Child Abuse/Neglect, and Alcoholism are all topics expected to be present in this comic. Slice of Life/Romance/"Dramedy" Uploads: Random days but frequently, 2 pages at a time', True, False)
add('InspiredByADream', 'http://inspiredbyadream.smackjeeves.com/comics/', u'in\xb7spire |in-spahyuhr| ~to fill or affect with a specified feeling, thought, etc ~to prompt or instigate (utterances, acts, etc.) by influence, without avowal of responsibility dream |dreem| ~a succession of images, thoughts, or emotions passing through the mind during sleep ~a vision voluntarily indulged in while awake; daydream; reverie ~a wild or vain fancy Updates: Saturdays 1-2 pages a week.', False, True)
add('Intoxicated', 'http://intoxicated.smackjeeves.com/comics/', u"This is the story of Robert, who tries to manage his relationships in his life of drug abuse, break up's and strong emotions. Contains drugs, sex and profanity. Approximately rated: 15", True, True)
add('IslandsofEzdora', 'http://ezdora.smackjeeves.com/comics/', u'Help Tara and friends adventure through the mystical Islands of Ezdora! Feel free to suggest! Updates daily.', False, True)
add('ItsCharacterDevelopment', 'http://characterdevelopment.smackjeeves.com/comics/', u"And now the tale of a party of adventurers who got lost in a dungeon ... and the one Paladin who had no choice but to try and save them. It's Character Development. Daily updated Playmobil toy photo-comic.", False, False)
add('Itsahardlife', 'http://itsahardlife.smackjeeves.com/comics/', u'Robin is ten years old and travels through Kanto with her pok\xe9mon to find a place to call home. This is a story about struggle, survival and friendship in a cruel world. -------------------------- This is a Nuzlocke comic. Contains some swearing and occasionally some gore. -------------------------- Updates are sadly quite irregular but I have no plans on giving up on it anytime soon!', False, True)
add('Itsan8BitWorldBlankWorld', 'http://8bitblankworld.smackjeeves.com/comics/', u'This comic\'s premise is simple. This is the White Space, or "Blank World" of my It\'s an 8-bit World Comicverse. Here all the characters, past, present, and future can interact and do crazy, random, and all-together odd things for your own entertainment. Of course, they have to be careful so as not to piss off the local Rulers of the Universe...', False, True)
add('JackiesStory', 'http://jackiestory.smackjeeves.com/comics/', u"Jackie's Story is an online flash webcomic adventure story about an alien named Jack (Better known as Jackie) who gets talked into participating in something that she hopes will bring back her dead brother. For the animated version: http://jackiestory.weebly.com/index.html", False, True)
add('JosPokemonJourney', 'http://jpj.smackjeeves.com/comics/', u"Just about a 17 year old twin with an afro who's going on a journey with a few surprises, friends, and foes. :D Updates when it can. :3", False, True)
add('JourneyMan', 'http://journeyman.smackjeeves.com/comics/', u'Life is a journey. Will finally seemed to be going places. But his plans take unexpected turns when cosmic forces intrude with occult plots and alien invasions. Can Will get a life as the galaxy burns? The first chapter includes old art from 2005 that will be fixed, later chapters have much better art.', False, True)
add('June', 'http://june.smackjeeves.com/comics/', u'SORRY! NO DOGS ALLOWED (A 100% true autobiographic horror story. @tumblr: http://junecomic.tumblr.com) (@ MangaMagazine: http://www.mangamagazine.net/manga-and-comics/JUNE/detail-page/403?lang=en)', False, True)
add('JustAnotherDay', 'http://ravenwing.smackjeeves.com/comics/', u'Shanku has left her home behind to explore the wide world around her. Out of her small forest home she finds more of her own kind and new friends. Love, loss, and adventure await her as she discovers the secrets her clan struggled to hide. But at what cost?', False, False)
add('Justmyluck', 'http://justmyluck.smackjeeves.com/comics/', u'Andreia is a normal girl, if you forget the fact that she\x92s the unluckiest girl in the world. Tired of her life, she leaves her home and goes to another town. But of course things don\x92t go as planned. Andreia meets Jason, who is a pain in the ass and very cold to her. She finds herself stuck in the biggest problem of her life, with nowhere to turn.', False, True)
add('KCNO', 'http://kcno.smackjeeves.com/comics/', u"A simple town in love with a simple radio station show. KCNO's Love Me Do, is the most popular show on the airwaves. Its success is owed to the host, Jason who has impeccable advice to give people struggling through love. But when a simple question moves the town to seek out Jason, his attempts at secrecy become the newest talk of the town.", False, True)
add('KaitoShuno', 'http://kaitoshuno.smackjeeves.com/comics/', u"a man named Kaito goes to commit suicide after living a boring, loveless, cubicle job. He meets a strange guy named Shuno...and Shuno immediatly takes a liking to him...almost too fast to be real XD Kaito quickly makes it clear that he isnt gay...but will Shuno's actions toward him make him alittle...'confused'? lol Kaito's been in such a need for love that maybe Shuno's affection doesnt look THAT bad...or does it?:P YAOI!!", False, True)
add('KasaKeira', 'http://kasakeira.smackjeeves.com/comics/', u'<b>The story of a girl, her magic umbrella and the hundreds of demons trying to kill her</b>', False, False)
add('Katran', 'http://katran.smackjeeves.com/comics/', u'This is the Story of Nirrod, an almost normal 14 year old boy. He is living with his Family and his clan in a big village in the north of Katran. Build on a giant cliff, it became one of the safest places in the land, and soon a very precious trading point. Nirrod is living his life well protected and without sorrows in the lap of his clan. he is playing with other kids, playing pranks....a normal life. but all of this is going to change....', False, True)
add('KeyFantasyAdventureWebcomic', 'http://keywebcomic.smackjeeves.com/comics/', u'Ex-knight Jerlorn wants to get the hell back to Feynia, after a year wasted in the human realm. But to his dismay, going home harder than it seems. Maybe all he needs is a magical Lock and the help of three other teens. Main site: key.shadilyn.com', False, True)
add('KingdomoftheDinosaurs', 'http://dinosaurkingdom.smackjeeves.com/comics/', u"Kingdom of the Dinosaurs is a theme park ride through the magical world of video game and pop-culture parody. If there's a bright center in the webcomic universe, you're on the comic that's farthest from. Updates sporadically.", False, True)
add('KingoftheWebComic', 'http://kingoftheweb.smackjeeves.com/comics/', u'Follow the random adventures of Don and his friends through a world of real life, internet, gaming, conventions and other strange events.', True, True)
add('Kirbandfriendsshowcase', 'http://kas.smackjeeves.com/comics/', u'a new kirb and friends!^^', False, True)
add('KirbyAdventure', 'http://kirbysadventure.smackjeeves.com/comics/', u'Meet the Kirby Adventure Squad: a group of Kirbies who take requests from random clients and attempt to complete them! And mostly fail miserably! Huzzah!', False, False)
add('KirbyDreamTeam', 'http://kirbysdreamteam.smackjeeves.com/comics/', u'Join Kirby and his Dream Team as they team up to take down evil!', False, True)
add('KirbyFunfestTheOriginals', 'http://kirbyfunfestold.smackjeeves.com/comics/', u'Kirby and his best friend Dee are minding their own business, when Dedede challenges Kirby to a duel! Since then, Kirby and Dee have to save the world from seemingly unstoppable forces of nature, and all the while they still have time to be funny... NOTE: I am restarting this comic, see it at http://kirbyfunfest.smackjeeves.com/', False, False)
add('KirbyandtheDarkKnight', 'http://kirby-darkknight.smackjeeves.com/comics/', u'This is a comic of a lot of nerdy pop-culture stuff such as internet memes, Naruto, RP characters, Pokemon, and.... Kirby. The whole story is LOOSELY based on Kirby and the Amazing Mirror. IMPORTANT: COMICS ARE READ RIGHT TO LEFT. THAT MEANS THAT "LATEST COMIC" IS ACTUALLY THE FIRST AND "FIRST COMIC" IS ACTUALLY THE LATEST. Kotaru, Kyousuke, and Riki were best friends since childhood and continued to be into high school, until one of their ordinary, normal days goes wrong and changes their life forever... They team up with Kirby and create the S.W.O.R.D to fight against the Dark Knight. Thanks for reading and please feel free to comment. Like our Facebook page! http://www.facebook.com/pages/Kirb-y-and-the-Dark-Knight/191342084279414 Also read Divided By Zero! Our team\'s newest detective story also on smackjeeves! divided-by-zero.smackjeeves.com AND Our new Deviant Art page holding our new manga "Winter Story." http://doomoxz.deviantart.com/', False, False)
add('KirbysDreamAdventure', 'http://kirbyda.smackjeeves.com/comics/', u"What's better than one Kirby? A whole mess of them, that's what! Follow them around their little adventures and daily lives, from the early randomness to the more story-built latter parts. It's a Kirby adventure worth watching, even if the main pink puffball doesn't get as much direct screen time as he should!", False, True)
add('KirbysDreamlandAdventures', 'http://kirbysdreamlandadventures.smackjeeves.com/comics/', u'A retelling of the many adventures Kirby has had over the years since 1992.', False, True)
add('KirbysSpritersResort', 'http://ksr.smackjeeves.com/comics/', u'A nother spriters showcase has come to town! what\'s the difference? IT"S KIRBY\'S ONLEH! If you want a place to post your kirby sprites and drawings, spost them here!', False, True)
add('KirbysofTHEVOID', 'http://kotv.smackjeeves.com/comics/', u'In the year 2032, Professor Wima Deerp created a vast expanse of space. A few random kirbies, and dees, were selected and transported into the new, infinitely diverse world. Later, a huge incident happened (it involved bunnies) one of the vict- I mean volunteers accidentally created his evil clone. When this clone threatens to destroy the world only a group of oddities can save it.', False, False)
add('KissParade', 'http://kissparade.smackjeeves.com/comics/', u'shitineedtostopmakingnewcomics A delinquent. 17 year old Isamu. A Playboy. 17 year old Taiki. They both hate eachother, so, so much. One day after winning a fight, Isamu is dragged away by Taiki and is asked a strange question: "Can I kiss you?" BL/Yaoi. I know right. AHA AHAHA. OTL', False, True)
add('KissoftheDevil', 'http://kissofthedevil.smackjeeves.com/comics/', u'Vist us at http://www.smackjeeves.com/comicprofile.php?id=110041 Thanks! Shadow Leafeon', False, True)
add('Knife', 'http://knife.smackjeeves.com/comics/', u'READ LEFT TO RIGHT ------------->', False, True)
add('Knightface', 'http://knightface.smackjeeves.com/comics/', u'A paladin who betrayed abusive people who used to be his friends seeks to rebuild faith in himself and his god.', True, True)
add('KnightsRequiem', 'http://knightsrequiem.smackjeeves.com/comics/', u'With weaponry called Emblems, the knights of NYX had always protected humanity from monsters of the night, the vampires. This is a story of a few new knights discovering just what it is like to become slayers', False, True)
add('KojiX5', 'http://kojix5.smackjeeves.com/comics/', u'\xbfQue de qu\xe9 va? Pues a grandes rasgos, es la historia de Hideyuki Hori, un chico muy t\xedmido y torpe, que en el d\xeda de su graduaci\xf3n se encuentra con un mago que le da un libro con un conjuro m\xe1gico que se supone que le ayudar\xe1 a enfrentarse a sus problemas diarios. Pero no todo es tan sencillo, pues parece que el libro le causa m\xe1s l\xedos de los que resuelve. Bueno, pues este es bastante antiguo, lo ide\xe9 en el 2003, y esta es la versi\xf3n que dibuj\xe9 durante 2006 y 2007. Es tan antiguo, tan antiguo, que no sab\xeda ni para qu\xe9 serv\xeda una regla. La dibuj\xe9 a una super velocidad mientras estaba en clase. Es una historia que sigo desarrollando actualmente. B\xe1sicamente, esta es una idea "deshechada" (vamos, que s\xf3lo queda de ella algunos personajes) pero hay algunas cosas que me gustan todav\xeda. Ah, s\xed, se lee de izquierda a derecha. Te gustar\xe1 si: -Sabes espa\xf1ol -No odias el shonen-ai -Te gusta ver al protagonista pasar verg\xfcenza', False, True)
add('Kranburn', 'http://kranburn.thewebcomic.com/comics/', u'An Australian Post Apocalypse Comic', False, True)
add('Kreetor', 'http://kreetor.smackjeeves.com/comics/', u'', False, True)
add('KuroiHitsuji', 'http://kuroi-hitsuji.smackjeeves.com/comics/', u'Title: \u9ed2\u3044\u7f8a Kuroi Hitsuji Author/Artist: Don G. (kuroi_hitsuji) Rated: [OT] Older Teens 16+ -contains sexual themes, occasional cussing, and sad stuff. Genre: Romance, Comedy, Drama, BL Gayness percentage: 80% (contains hetero) Update Schedule: Mondays 6AM-12PM PST This is the story of what happens when you put a straight man, his secretly gay brother and his secretly gay boyfriend, his wacky gay friends all in one apartment, as one organization: "Kuroi Hitsuji(Black Sheep)". A story of love, secrets and some downright gay humor. As a straight man in a gay world, who is the black sheep? NOTE: THIS IS NOT A COLLAB. kuroi_hitsuji is the author/artist. The other authors are the "characters" (they made them up). They also help compose their respective stories.', False, False)
add('Kurokenshin', 'http://kurokenshin.smackjeeves.com/comics/', u"Started in December 2005, so the first Volume's art is a bit rough. Volume 5 was finished in Spring 2011. The remaining two volumes will be available on my website: http://ko-mangaseries.com/kurokenshin.html After finding a book on the legendary ronin Kokushiryu, Kentaro finds himself on the adventure he's always dreamed of. He joins Rika, a mysterious red-haired demon, who is searching for Kokushiryu's sword - Kurokenshin. However, she isn't the only one pursuing Kokushiryu's legend for the book; a cruel demon from the past is desperate to attain the sword, and he will go through any means to do so. ~READS FROM RIGHT TO LEFT~", False, True)
add('KuronaFlutterandLylaSpamTime', 'http://icantflyaplane.smackjeeves.com/comics/', u'Self-explanatory. Credit to SEGA, CAPCOM and NINTENDO for most edited sprites in here. Alternate title: Aura and his girls~', False, True)
add('LOGOS', 'http://logoscomic.smackjeeves.com/comics/', u'In the far future, on a distant planet, a man made of plastics discovers what it truly means to be human.', True, False)
add('LandoftheSky', 'http://landofthesky.smackjeeves.com/comics/', u'While vacationing at the former port town Sin City, the young Fae princess Souri Ada Lodette discovers a mysterious heirloom in her possession. As she tries to understand what it is and where she has seen it before, she comes face to face with the notorious murderer known as Roo the Ripper, who just happens to be in search of the same object! Who exactly is this man... And why does he call her Solas?', False, False)
add('LastLivingSouls', 'http://lastlivingsouls.smackjeeves.com/comics/', u"It's probably safe to assume you know what a zombie is; A living corpse with an insatiable craving for human flesh that mindlessly acts on primal instincts. But, what would happen...if a zombie became able to think? Along side an empty road, a teenager named Eddie awakens, confused and fearful due to his inability to remember anything. He heads towards the nearest city in hopes of getting some help, but realizes it is nearly empty of residents and is instead being slowly consumed by a group of undead. It quickly becomes his purpose to survive and also to understand why these creatures are plaguing the city...and why he is one of them.", False, True)
add('LavenderLegend', 'http://lavenderlegend.smackjeeves.com/comics/', u'Epic Romantic Adventure! The men have gone to war. The princess is sealed away from their sight. Her favorite maid has a scandalous secret, and plans to overthrow the king.', False, True)
add('LeCirquedObscure', 'http://cirquedobscure.smackjeeves.com/comics/', u'A dark circus collaboration roleplay comic- open to everyone!', False, False)
add('LedbyaMadMan', 'http://ledbyamadman.smackjeeves.com/comics/', u'The country is devoid of life save for five people who try to stay alive the best that they can.', False, True)
add('LegendOfZeldaSwordOfWinds', 'http://swordofwinds.smackjeeves.com/comics/', u'A somewhat loose interpretation of Wind Waker, containing some of the scenes from the game. A pure adventure comic about Ganondorf threatening the World with a sword that can command the Winds. Link must use both the Wind Waker and the Master Sword to counter this Evil! Updates often', False, True)
add('LegendofZeldaAHerosStory', 'http://aherosstory.smackjeeves.com/comics/', u"The story of Ocarina of Time retold, will Link summon the courage to save his friends and the ones he cares about before it's too late? Find out and see!!", False, True)
add('LegendofZeldaStaffofPower', 'http://loz-sop.smackjeeves.com/comics/', u'An ancient weapon created for harmony brought civil war. Shattering it brought tentative peace, until the leader of the Gerudo attempts to slaughter an entire race of people, then turning his hatred upon the monarchy of Hyrule. Defeated by the Hero of Time and the Princess of Destiny, he was sealed away in the Sacred Realm. Years later, he has gained more power, and has broken free. Now it will take the very weapon he seeks to destroy him, and an unlikely wielder to complete the task. Who will win?', False, True)
add('LegendofZeldaTheEdgeandTheLight', 'http://legendofzelda.smackjeeves.com/comics/', u'After years of absence, Link finally returns to Hyrule from his travels abroard. Initially expecting to greet Princess Zelda, he instead finds the kingdom in decline, plagued by all kinds of trouble. Just what is causing these problems, and does it have anything to do with why Link left in the first place? NB: Thanks to its unusual format, this updates every FRIDAY.', False, True)
add('LegendofZeldaTheWindWaker', 'http://zeldawindwaker.smackjeeves.com/comics/', u'The Legend of Zelda: The Wind Waker turned into a webcomic. I hope you enjoy it. Written by Emily-Ann Coons and drawn by Kitty Lyre. Currently updates every Monday at Noon EST.', False, True)
add('LegendsofMobiusBookOne', 'http://legendsofmobius-bookone.smackjeeves.com/comics/', u'It\'s been two years after Sonic the Hedgehogs last adventures. A hedgehog named Crusade travels around planet Mobius and randomly or not, becomes friends with several other mobians. But on his journey dangerous things happen and concerning news spread. And so, Crusade and his comrads, later known as "Team Element", decide to search for the root of everything. Without knowing that they get involved into a war which will decide about the worlds future...', False, True)
add('LethalDose', 'http://lethaldosecomic.smackjeeves.com/comics/', u"WARNING: This comic contains heterosexual AND homosexual relationship, Drug abuse, sexual themes and violence. READ RIGHT TO LEFT - JAPANESE FORMAT Updates every Sun & Wed. ________________________________ Bobby and Raine were wannabe child hood sweet hearts that, due to unfortunate circumstance, had to be torn apart. Now, five years later Raine returns to find a Bobby very unlike the one she once new. Lonely and stuck with an undesirable life, he has turned to drugs and alcohol to mull the days away with. But after a strange encounter in an alleyway one night, Bobby finds himself trapped in a much more 'hardcore' underground world of drugs and abuse; one that's secrets are so dark it's not too easy to leave behind.", True, False)
add('Lethe', 'http://lethe.smackjeeves.com/comics/', u'On the distant world of Lethe, there lived the Queen of Nephele. Said to be desired by all men for her ethereal beauty. A beauty so divine even the Gods envied her, one particular Goddess decided to bless her favorite warrior with the beautiful woman as his gift, stealing the great Queen from her kingdom. The Queen\'s abduction led to a century long war, spreading throughout many, many lands. The King of Nephele created a rule, that for each city his army conquered, the Strategos would be gifted with the most beautiful maiden from that city. As a twisted take on what had happen to his wife. But one city was at a loss, for its most beautiful maiden, was far from beautiful. It was in fact, hard to find a fair beauty in this city at all. And thus the city panicked, not being able to find a sacrifice could lead to the massacre of their people. So in an act of desperation they gave the Strategos their most beautiful person. Now it is up to this -man- to survive the war in which he as been thrust head first into~ Welcome to the world of Lethe. Where everything beautiful, is possessed. A BL comic loosely inspired by the epic poem "The Iliad" by Homer', True, True)
add('LetsBreakitforReals', 'http://breaktehrecord.smackjeeves.com/comics/', u"LET'S DO THIS. I am Sexy~ - Sexy Rule 1: No explicit content. We can't have that, but you know what humans are like. Rule 2: No getting involved in big advertisements. Rule 3: No alternate accounts. That's just cheating. Rule 4: Spam. No spam. Spam is very, very bad. Rule 5: Link news posts. If you want to link to something, post a comic instead. Rule 6, very important, 6: Don't let me watch Digimon. I HATE Digimon! Aura's a character I made up, but he won't know that! I'll think I AM him and he might do something stupid like go and watch Digimon! I don't want to wake up in the morning with that in my head! - Kurona ---------------------- Rule 7: If you rap, i shall brutally murder you with the heavenly sound of the music known in this earthly plain as Metal. - Darkeh Goal:- 206.your face Current: 88", False, True)
add('LifeafterDeath', 'http://lifead.thewebcomic.com/comics/', u'Life after Death is about an out of work Grim Reaper navigating current events, new roommates and his new found mortality...', False, True)
add('Lifeonpaper', 'http://lifeonpaper.smackjeeves.com/comics/', u'"Life on Paper". Is a comic strip very loosely based on my life, originally it was titled, "Lil Bastard" It follows me and all my jobs, relationship, and even through marriage. With 2000+ strips. Which will eventually be uploaded here. Please Enjoy my life.', False, True)
add('LightRomantic', 'http://light-romantic.smackjeeves.com/comics/', u'Something like a romance between men.', True, True)
add('LiliBleu', 'http://lilibleu.smackjeeves.com/comics/', u'Webcomic en espa\xf1ol La humanidad ha quedado al borde de la extinci\xf3n por causa de un virus que los muta en superhumanos poderosos, dotados de una gran belleza y poder que han tomado control del planeta. De entre el nuevo orden se alza la \xfaltima esperanza de la humanidad: Espartaco Garc\xeda, armado s\xf3lo con una de las mentes m\xe1s brillantes del mundo en contra de seres que pueden derribar monta\xf1as con su mirada. S\xf3lo hay un problema: Quiere salvar el mundo... para gobernarlo \xe9l.', False, True)
add('LittleLink', 'http://littlelink.smackjeeves.com/comics/', u'A great Evil threatens the worlds of your favorite Nintendo characters and Link is the key to stopping it!', False, True)
add('LondonUnderworld', 'http://lunderworld.smackjeeves.com/comics/', u"Miss Ameliea Worton is sick of the rich, upper class, boring world she has been brought up in. She seeks entertainment from London's dark under belly, making friends with crooks and con artists and playing their games against the aristocracy she has grown bitter of. But, when Ameliea decides to join forces with the king of the London Underworld, she discovers how naive she has been, and how dangerous London can really be.", False, True)
add('LostLove', 'http://lostlove.smackjeeves.com/comics/', u'Matt has always been neglected by his parents, but he dosn\'t care anymore - he has found the one he love. The only problem is that that \'love\' is his best friend, Joshua - another guy. To make it even worse, Joshua already has a boyfriend, so Matt dosn\'t dare to confess his feelings. But the boyfriend, Daniel, acts like a total jerk towards Matt, who can\'t help but despise the guy - for more than one reason. Nonetheless he decides to hide his feelings, and support Joshua and Daniel as a couple, the best he can. Though one fatefull day, Daniel comes with a strange request, that Matt can\'t refuse; "Come to my house, or I\'ll break it off with your friend." What will Matt do from then on? Can he keep a secret from Joshua, a secret that\'s slowly breaking him apart? Why does Daniel do as he does and why the hell is the strangest thing starting to turn Matt\'s life upside-down?! WARNING!! Contains Yaoi/BL/shounen ai and soooo on - you know the rest ;)', True, False)
add('LoveDeaf', 'http://lovedeaf.smackjeeves.com/comics/', u"Boy love! That's right. Mika Lin, a famous rockstar, has run away. And where else would he hide out but in the apartment of an unfortunate youth, college student Alex Bentley?! Now Alex has to help Mika find inspiration again before he can return to the stage! Unfortunately for him, this includes being molested and tormented on a daily basis! Rockstars are quite the handful, after all.", False, True)
add('LoveHarbor', 'http://shipcentral.smackjeeves.com/comics/', u"This is a comic about shipping your characters. You can do as you please with your shippings, but please try to keep them to a T rating and below. Shipping: To support a relationship between two characters, be it canon or not. You will get a chapter here. All shipping of your design are to be posted in your own chapter. The point is to post pictures of shippings. (Sprites, Drawn, pixel art, etc.) These can be in the form of comics, author comments, etc. Your shippings can be gay, straight, lesbian and bi. So homophobes beware. You may post shipping of other authors. If you have any questions, contact 'aqua the hedgie' for more information. Author count because reasons: 34 ------ Don't ship real people. At least poke holes in the box.", False, True)
add('LoveMe', 'http://loveme.smackjeeves.com/comics/', u':::Comic reads top to botton left to right::: Follow Kajin in a modern dark twisted version of a love story. Kajin is in love with someone, but in this school that someone should not be another boy. Love is not something you can simply choose... it just is. "Love Me" THE OFFICIAL THEME SONG TO LOVE ME (SHOULD OF PUT THIS UP EARLIER...LIKE WHEN I STARTED DRAWING THE COMIC) http://www.youtube.com/watch?v=uzmmh9y0QPs \'Love Me\' Will update at random during the week, atleast 1 or two pages each week. [Gonna really try hard to stick to that] Comic story is written off the top of my head, it\'s a practice comic, nothing fancy or great so please don\'t rant about mistakes I make. this is for fun :D facebook \'Love Me\' page- http://www.facebook.com/pages/Love-Me/150627535019833 Please visit my personal site for cheap quality commissions <3 www.studio-adhd.com Art Tumblr is http://www.tumblr.com/tumblelog/studio-adhd [WARNING HARD CORE YAOI, NO ONE UNDER THE AGE OF 18 SHOULD VISIT THAT TUMBLR BLOG] Follow me on DA? > http://studio-adhd.deviantart.com/', True, True)
add('LoveTwister', 'http://lovetwister.smackjeeves.com/comics/', u"Love Twister! For Chiko,only working and studying is her priority in life,But when Warren came many things began to change until she knew that this person's face is not having two but three. His other twin is Harren her Math teacher,he is the complete opposite of Warren and the other is Darren, an aspiring celebrity who's known for being a playboy And its getting more complicated living with the three guys with the same face under one roof,What will she do when Love came like a twister? genre: shoujo manga read left to right", False, True)
add('LsEmpire', 'http://l-empire.smackjeeves.com/comics/', u"Luigi has left Mario, and gone out to prove he himself. With the help of Dimentio, Geminiman and Void; will his dreams of recognition come to fruition, or is he doomed to being second banana? Either way, we can be sure that it will be very silly. Updated 8:00am every day. Specials go up at 12:00am. Check out our TV Tropes page at http://tvtropes.org/pmwiki/pmwiki.php/Webcomic/LsEmpire Also Check out the offical L's Empire Youtube Channel at http://www.youtube.com/user/LsEmpireOfficial Or E-mail us at MrLandCo@hotmail.com", False, False)
add('LuffinpuffandEric', 'http://luffinpuff.smackjeeves.com/comics/', u'The magical adventures of a fat kid named Eric and his fanciful imaginary friend, Llewellyn Luffinpuff!', False, True)
add('LumasParadise', 'http://luma.smackjeeves.com/comics/', u"Welcome to Luma's Paradise, the one and only place in the galaxy where you can find sprite comics starring the Lumas!", False, True)
add('Lunargyros', 'http://lunargyros.smackjeeves.com/comics/', u'Moving to a new town with a new school is hard enough. For Kylie Larliath, it just got worse: her ex-boyfriend turns her into a werewolf just before she leaves. Now, faced with this new curse, Kylie struggles with keeping it a secret from her family, a judgmental school population, and only a few new friends to help. Worst of all, she soon finds herself at the center of a centuries-old plot for revenge... Previously featured on Wirepop.com, you can now read all of Lunargyros for free here on Smackjeeves! Print copies are also available for sale! If you\'re interested, be sure to send an email to lynxoftheg@gmail.com, with the phrase "Lunargyros Print Copy" in the subject line.', False, True)
add('MUTE', 'http://muterobot.smackjeeves.com/comics/', u'We fight for what we believe in and for those we care about. With terms and beliefs like these, who is to decide what is right and what is wrong? It is our emotions that fuel our actions, but is allowing them to take over really the right course of action in drastic situations...? Comic completed.', False, True)
add('MYth', 'http://myth.smackjeeves.com/comics/', u"MYth is a collection of original short stories inspired by the Greek mythology. Since it's MY version, the storyline differs from the classic mythology. .: MYth: My Seasons :. Demeter's sudden disappearance left Hades nothing but a daughter named Persephone... .: MYth: Eternal Gift :. The story of Poseidon and his true love... .: MYth: A PROMISE :. Before the time of the Olympians. Promises...made and broken... Between two brothers, only regrets remained. ***MATURE CONTENT APPLIES TO MYth: A PROMISE ONLY*** MYth (c) Zelda C. Wang http://zeldacw.idv.st http://zelda994612.deviantart.com", False, False)
add('MagicalGirlAlice', 'http://magicalgirlalice.smackjeeves.com/comics/', u'Behold the daily life of Alice Kamelot, a magical girl who is just looking to have fun and excitement.', False, True)
add('Magience', 'http://www.magience.co/comics/', u'------------------------------ Updates: M - W - F at Midnight PST ------------------------------ "Magience" was a new video game, one you could play while awake OR asleep thanks to an innovative headset. No one was quite sure the exact technology behind it, only that it was top-of-the-line and very mysterious. In a world of fantasy, players get one character to level and adventure with, exploring an infinitely growing and evolving world. However, it\'s not long before people start to notice certain oddities, and certain strange theories and rumors start popping up all over the place, both in game and in real life. Crazy as it sounded, what if "Magience" wasn\'t just a game after all?', False, True)
add('MarXistemTWC', 'http://marxistem.smackjeeves.com/comics/', u'The least funny system on the Internet.', False, True)
add('MarioandLuigiMisadventures', 'http://mandladventures.smackjeeves.com/comics/', u'Cackletta is up to no good and stuff', False, True)
add('MariovsSonicvsMegaMan', 'http://mvsvmm.smackjeeves.com/comics/', u"It's a battle of the three main video game mascots of the late 80's and the early 90's, Mario, Sonic, and Mega Man. Who will win this titanic battle worthy of Pay-Per-View?", False, False)
add('MarsMind', 'http://marsmind.smackjeeves.com/comics/', u'Attempting a comic journal. Lets see where it goes.', False, True)
add('Mascara', 'http://mascara.smackjeeves.com/comics/', u"As the smartest boy in school and a prodigy, everyone expects Ian to be a high achiever--\x97a future Nobel Prize winning genius. But he doesn't want to be the next Einstein. He just wants to be a makeup artist.", False, True)
add('Master', 'http://master-larayokoshima.smackjeeves.com/comics/', u'Shimazu Sho, a Japanese medicine student currently living in London, has an interesting secret: he is the owner of a zoomorphic creature, a boy with dog like features called Kin. How could this happen? In a world where magic is not fantasy, anything is possible. Magic, wizards, sexy villains, handsome guardians and mysterious creatures abound as Sho and Kin step into the adventure of their lives. Follow the official manga website here: http://yokoshima.com.mx/manga', True, True)
add('MaverickDaze', 'http://maverickdaze.smackjeeves.com/comics/', u'A Mega Man X based sprite comic. Set in the year 22XX as the Hunters must face their most challenging threat yet!', False, True)
add('MaytheRainCome', 'http://maytheraincome.smackjeeves.com/comics/', u'William Weasel returns home after seven years of war only to find his hometown deep in a drought, and his life eerily empty and devoid of meaning. ------------ This comic became finished on March 31st, 2013 - about a year and a half after I began it. May the Rain Come is rated PG-13 (for depictions of PTSD and scary moments). Inspirations: Black-and-white movies, cartoon animals, stories passed down through the family about the horrors of war.', False, True)
add('Mazscara', 'http://mazscara.smackjeeves.com/comics/', u'After her tragic suicide, Hollywood celebrity elite Victoria Starfield is ressurected and assigned by a secret supernatural organization called Crowd Control ,to protect five specific children (and her fans) from a slew of demons, serial killers, hellraisers and fallen angels. Her only weapon, 250 feet of razor sharp, flesh splitting barbed wire and an infinite trail of black tears. Call her, Mazscara. WARNING: Mazscara is rated +18 for Graphic Violence, Profanity and Mature Themes.', True, True)
add('MediocreAtBest', 'http://mediocre-at-best.smackjeeves.com/comics/', u'', False, True)
add('MegaMaidenandTheChopChopPrincess', 'http://mega-and-choppy.smackjeeves.com/comics/', u'Two girls who love punching crims become superheroes. Mega maiden is intended for OLDER Teens and adults for crude humor, language & adult situations.', False, True)
add('MegaManBattleNetwork7TheWorldTournament', 'http://mmbn7-twt.smackjeeves.com/comics/', u'The year is 20XX... People are very lazy because they have Net Navis that do everything for them since even desks are controlled through the internet. Some people use these Net Navis for fighting and are called "Net Battlers". But, who is the strongest Net Battler? This tournament will decide that.', False, True)
add('MegaManTales', 'http://megamantales.smackjeeves.com/comics/', u'Follow the Adventures of G.B.A, a boy who ended up the MegaMan world and must find a way back home. Status: FINISHED! FOR REALZ NOW!', False, True)
add('MegaManiacs', 'http://megamaniacscomics.smackjeeves.com/comics/', u'The adventures of the MM7 cast, plus the fun-loving Andante, in an attempt to stop the forces of evil.', False, True)
add('MegaPain', 'http://megapain.smackjeeves.com/comics/', u"Core and Daniel find an old Mega Man 5 cartridge at a yard sale. As they pop it in, there's more to this game then they realize. A lot more. Updates on Wednesdays and Sundays.", False, True)
add('MelodiesoftheHeart', 'http://melodiesoftheheart.smackjeeves.com/comics/', u"Rhi Grey is your average teenager, he loves music with a passion, he goes to school, hangs out with friends and works a job at his sisters local cafe, but he has a dangerous secret he's keeping from his friends and family, which is about to catch up to him very quickly. And When Lucy Turner, a young blonde writer and her family move back to the town of Chatsford, the two meet by chance, and an awkward start to a relationship begins. Though Love isn't always as simple as it seems, as many of the teens of Chatsford are about to find out. Also follow on facebook: http://www.facebook.com/Mothseries for updates and news on the series", False, True)
add('MelodyAndMacabre', 'http://melodyandmacabre.smackjeeves.com/comics/', u'A little girl befriends Death and encounters those who seek him. An odd little series about obsession and... you guessed it... death.', False, True)
add('MementoMori', 'http://mementomori.smackjeeves.com/comics/', u"Agus & Karina are a lovely couple of college students enjoying their everyday life, until the day Agus receives a shocking new that will change his life forever. This is a pilot comic I did for publishing in my country, but since local publications aren't successful in here, it got scrapped.", True, False)
add('Metabooandfriends', 'http://metabooandfriends.smackjeeves.com/comics/', u'This is a comic where spriters of all skills and types can post their creations for constructive critisism', False, True)
add('MetalPhoneMouse', 'http://mpm.smackjeeves.com/comics/', u"History Metal Phone Mouse (MPM) is the result of several years of roleplaying forum activity turned into a weekly updated webcomic. MPM deals with everything, Action, Comedy, Drama, Adventure, and Fantasy. Our webcomic slowly grew some popularity on Deviant art where most of our work is put up, but now we feel its time to expand into our own website with the help of Smack jeeves. Story An adventure story of a disbanded group of Mercenaries comprising of Demon hunters, Mythological creatures, and beings of mysterious powers set in the modern world. Although lost loves, betrayals and mistrusts separated their group, they gather again to create a new team including new members. Filled with mythology of all forms: Demons, Angels, Vampires, Gods and Tyrants of heaven and hell, and twisted creatures from nightmares challenge the MPM team with originally created Lore. MPM is a new up and coming webcomic that's well worth a spot on your bookmark menu!", False, True)
add('MetroJack', 'http://metro-jack.smackjeeves.com/comics/', u"A gay ex-lumberjack and a straight metro-sexual room together while attending Boston College. Humorous shounen-ai hijinks and confused sexual orientations abound. BL/Yaoi UPDATES EVERY SUNDAY! Also I just started a Tumblr Blog for the comic, so I can spam you guys on tumblr with sketches and fanart that my friends have done for me, as well as progress reports on the latest updates so you'll know about when to expect the next page! Feel free to check it out here: http://metro-jack.tumblr.com/", True, True)
add('Metsastajat', 'http://metsastajat.smackjeeves.com/comics/', u'Tarina kertoo kuudesta lukiolaisesta, joiden el\xe4m\xe4 muuttuu, kun he saavat teht\xe4v\xe4kseen mets\xe4st\xe4\xe4 hirvi\xf6it\xe4. Mist\xe4 ihmeest\xe4 hirvi\xf6t tulevat? Vain suomeksi (only in finnish)', False, True)
add('MidnightHunters', 'http://midnighthunters.smackjeeves.com/comics/', u'In the middle of the industrial revolution, magic and science collide. Strange machines, steam powered objects and mechanical devices are fuelled by dark magic. The Midnight Hunters chase and hunt Devils, spectres, vampires and other supernatural beings that lurk in the dark corners of the big cities. If you want to read more go to <b><a href="http://www.mangamagazine.net/manga/12">MangaMagazine.net! =D</a></b>', False, True)
add('MidnightPrince', 'http://midnightprince.smackjeeves.com/comics/', u'Jeremy Locke is just a normal high school student, but his best friend Erik has a secret. He\'s a vampire and not just any vampire, a prince! Alexei Drako is Erik\'s ex-fiance and he\'s the prince of Neutrals, a race mostly like the humans but with the power to use magic and known to live longer than five centuries. Two years after his painful break up with Erik, he\'s back to look for a new "wife" and has set his eyes on Jeremy! Will Erik let this happen and will Cleo Saint, Jeremy\'s stalker friend, allow it as well? *Not really planning to put mature things in it yet but it does contain strong language and sometime in the future partial nudity. It\'s not just Shounen Ai, there\'s hetero love too *UPDATES ON FRIDAY AND/OR SATURDAY*', False, True)
add('MineBlockTheOriginal', 'http://mineblock-comic.smackjeeves.com/comics/', u"It's like Minecraft, but it's two dimensional and the sprites are blocky! A story of hero go on their own adventure! Team work, boss battle, Pvp round and much more... NEW: Bridge Battle have open! challenge your friend and try to slay others on the bridge! Original creator/owner: BlueZero12/ EpicGames20 (I found him!) Co-Owner: Stone_Merten", False, True)
add('Minibot', 'http://minibot.smackjeeves.com/comics/', u'Created from the "Minibot Command" threads on the Smackjeeves forums. People gave suggestions of what Minibot should do next and I drew them! Special thanks to MINIBOT COMMANDERS (listed alphabetically) Afrohawkman, AFStaff, Antitime, avian-reader, Bagpipe, Bat McStar, Beany, Bowserknight, BreakCanyon, Eggie, Gibson Twist, granmastern, Hunterkirizaki, Jake48.2, johlin, MacSimon, neoblade42, Pyroman, The Radical, robybang, skystears, SonicBoom01, SuperBiasedMan, Supertoad, and wendy w. Original threads here: http://www.smackjeeves.com/forum/viewtopic.php?t=10155 http://www.smackjeeves.com/forum/viewtopic.php?f=20&t=2534', False, True)
add('MinorActsofHeroism', 'http://www.minoractsofheroism.com/comics/', u'The adventures of three young superhero sidekicks!', False, True)
add('MixupofallMixups', 'http://mixupofmixups.smackjeeves.com/comics/', u'Arcs sometimes happen here. Oh, and crossovers too but character wise. All characters and backgrounds used in this belong to their rightful owners, and credit goes to the people who ripped, edited and/or recoloured the sprites used.', False, True)
add('MobianChaos', 'http://mobianchaos.smackjeeves.com/comics/', u'Mobian Chaos: What year did rational thinking go out of style again?', False, True)
add('Mokepon', 'http://mokepon.smackjeeves.com/comics/', u"He wants to be the very best! That no one ever was... uh, no. Scratch that. Adventures and friendship were never something that appealed to Atticus... Shame that it's a pokemon world he lives in, and so teenage boys living in Pallet Town are not expected to sit idly by. But the life of a hero is not one he's about to consider; too much hard work for little reward, and so instead he embarks on his quest not to become the greatest... But at least, the richest. Although the biggest challenge may be ignoring the adventures and friendships which may attempt to ensnare him along the way... Updates Mondays and Thursdays.", False, False)
add('MonsterGirl', 'http://monstergirl.smackjeeves.com/comics/', u"An off and on comic first conceived during my elementary school years. The whole thing was pretty much a giant experiment for practice, though it's over now.Hope you like it if you're brave enough to read it! WARNING: This comic is EXTREMELY experimental, so try to ignore the ever changing artwork. Also it's pretty dramatized... Summary: A group of high school students have the ability to transform into animals, but what's the story behind their mysterious powers? Find out on their dangerous search for the answer.", False, True)
add('Mortifer', 'http://mortifer.smackjeeves.com/comics/', u"This comic has been completed! RATED WEB14 and up for gore and foul language! A mercenary team compiled of three men, Valentine, the asian prostitute obsessed with money, Mathew, a bloodlusting vampire with an anger problem, and Joey, an intellegent, but very odd, mercenary who always smiles. Things go well, until the presidency of the mercenary company is handed over to Joey, after mysterious death's of his competitors. Things slowly begin to get dangerous... and people's secrets begin to get exposed. Is Joey actually planning good things for the company... or something much more horrible?", False, True)
add('MrFactory', 'http://mrfactory.smackjeeves.com/comics/', u"Dee Bananahead is the coolest gangstah in da hood. Burglarizing 50 banks in 1 night? NO PROBLEM. But when she makes an outrageous promise to blow up the factory that everyone in the city hates, things start getting complicated. Updates, like, everyday. Unless it doesn't. But it typically does.", False, True)
add('MrGrimmsCircusofHorrors', 'http://grimms.smackjeeves.com/comics/', u'Lucia has a less than perfect life. One day she decides to run away. But there is one problem with her plan... She has absolutely no where to go. That is, until a strange flyer smacks her in the face. "A freak show huh? I\'ve never been to a circus before." Rated PG 13. Contains: Violence, some crude humor, blood, some romance.... Later.... This comic is boyXgirl. Reads right to left.', False, False)
add('MyFakeHeart', 'http://myfakeheart.smackjeeves.com/comics/', u"A tale of unending confusion, aggravation, adoration, and exclamation. Amanda's best friend just got dumped. How else to win her ex back than by pretending to date Amanda? Meanwhile, playboy of the school Zach has discovered he's rather bored toying with all the girls who fawn over him. After kissing Amanda's brother Leonard on a dare, he decides to do some follow up; he wants to know if he is so hot a guy would fall for him. Luckily for him, Leonard's already interested in his gender. Less work for Zach! In case you can't tell, it's full of gay kids. There's like, three straight kids total. If that doesn't float your boat, don't rock mine. Updates every Monday, Wednesday, and Friday. I'm also offering commissions to help keep myself alive.", False, False)
add('MyOasis', 'http://myoasis.smackjeeves.com/comics/', u"Includes YAOI(m/m,slash,boy love,shonen-ai) Hazu is the only son of Councilman Yuroba and is already set up to marry into another tribe.Bored of staying in the colony he ventures out one day only to come across a small expedition on their way to the mountain which protects their village.One of the young Archeologists,Johnathan,seems to catch Hazu's eye.A sandstorm blows in and everyone,expedition and Hazu,race to find shelter in a cave.At this close proximity Hazu seems to grow more attached to the young human and has the sudden urge to capture his interest in turn.Surza,his proposed,fights against their relationship entirely.Only more problems arise when Hazu chooses to protect him. Johnathan is merely a normal human.He doesn't talk much,he sticks to his books instead of with people,he has a love for everything made by nature,and is, apparently,Hazu's property.The human is abducted while he and his expedition protect themselves from a sandstorm inside a cave.There isn't anything special about him. But to Hazu he is every bit of everything. Updates: Hopefully Mondays AND/OR Thursdays. Do NOT hold me to it though! I'll try my best though!", True, True)
add('MySistertheDragon', 'http://sisterdragon.smackjeeves.com/comics/', u'A boy finds an egg in the woods, and he and the dragon that hatches from it are raised as brother and sister. Hijinks ensue, including but not limited to the wacky variety.', False, True)
add('MyTrollLife', 'http://mytrolllife.smackjeeves.com/comics/', u"This is a webcomic with rage comics surrounding real events in my life. NOTE: these comics are for jokes and laughs and should not be juged (but if you wanna still bitch then why are you here in the first place, you knew what you were gonna expect in the tittle's picture) UPDATES: *Summer Schedule: 1-2 A Week*", False, True)
add('MyTwoCentsPlusTax', 'http://mtcpt.smackjeeves.com/comics/', u'In the modern world there are many evils out there. Super villains who want to destroy the world, Evil masterminds with plans for revenge, and bad dudes who go around not paying their taxes. It is up to Sanders, Jock, and Payton, three tax collectors, to bring these evil fiends to justice! Contains: [Cartoon Violence.]', False, True)
add('MyUtopia', 'http://myutopia.smackjeeves.com/comics/', u'THIS COMIC IS OBSOLETE. Go read my latest project here: http://www.smackjeeves.com/comicprofile.php?id=121728', False, True)
add('MyZombieDays', 'http://zdays.smackjeeves.com/comics/', u"Gags about zombie movie's cliche.", False, True)
add('MysticanDreams', 'http://mysticandreams.smackjeeves.com/comics/', u'A story about a war torn country lead by the Golden Raced Echo and her insane father who happen to clash against the Silver Raced queen and her plot to take over the entire country of Mystica. (Yuri)', False, True)
add('MysttheBookofAtrusComic', 'http://mystcomic.smackjeeves.com/comics/', u'An unofficial, fan-made graphic adaptation of "Myst the Book of Atrus" by Rand and Robyn Miller with David Wingrove. Prequel to "Myst" (1993), the best-selling PC game created by Cyan, Inc (now Cyan Worlds, Inc). Characters and story used with permission. Story: Atrus and his grandmother live alone in the middle of the desert. His grandmother excites him with stories about the D\'ni, a race of people who lived long ago. Atrus\' father, Gehn, comes to claim Atrus and share with him the amazing power of the D\'ni. When Atrus starts to question what he\'s been taught, how can he find out the truth?', False, True)
add('MythsofUnovaAWhiteNuzlockeRunHardMode', 'http://mythsofunova.smackjeeves.com/comics/', u'Sort of a sequel of my Diamond Nuzlocke Run! You can read the previous nuzlocke comics here: http://ky-nim.deviantart.com/gallery/28245977 Different region, different characters...or are they so different from the first? See how Nina and her two best friends set out on an adventure that may be more life-changing then they initially had wanted...', False, True)
add('NERDALERT', 'http://nerd-alert.smackjeeves.com/comics/', u'The lives of a geek and a nerd - these things really happened. We hit nothing but books! Updates mostly on Sundays and Wednesdays nowadays.', False, True)
add('NIK', 'http://nik.smackjeeves.com/comics/', u"The Character: Nikolai is a young mage who shows great potential. He is able to wield magic without using his hands or chanting words by using the light magic he has webbed around him at all times. The Plot: The world has forever been balanced between good and evil. Each mortal lying somewhere between the two extremes. Now that a new mage has taken over the council, the light beings have a burst of power which breaks the balance they have with the dark beings of the world. And they aren't willing to keep the balance, no, the mage council decides to use this power for all they can and wipe out every ounce of dark-energy in their section of the world... This balance being broken can change many things. The mortals are directly influenced by the energies! But wouldn't a world of pure light magic be a good thing? ... (This is a BL comic.)", False, True)
add('Negligence', 'http://negligence.smackjeeves.com/comics/', u"Two kids, a bottle of mouthwash, and an almost non-existent parental figure. What could possibly go wrong, besides cult families, twisted public television shows, a baby's death, and a pseudo-incestuous relationship? Welcome to Negligence, a crazy journey.", False, True)
#add('NekotheKitty', 'http://www.nekothekitty.net/comics/', u"Comic about a cute little kitty cat who's really quite cheerful about how much he hates everything. Ireland's #1 webcomic, online since 2002!", False, True)
add('NemesisKatharsis', 'http://nemesiskatharsis.smackjeeves.com/comics/', u"Jove is the descendant of the most powerful magical clan in Nokt'ader - the Aerin. She is expected to be a magic user of legend by her parents and clan. Unfortunately, she cannot even learn how to... levitate. With almost no affinity for magic, and considered the black sheep of her family, Jove harbors the ridiculous notion of one day becoming the land's... Arch Mistress of Magic! Updating schedule: heavily variable! :s I'm also working on Sailor Moon: The Enemy Next Door, and that's my priority :) but as this here is MY baby, I'll do my best to post often Genre: fantasy/adventure/romance Edit 10.12.2012: Regarding updating, I've decided to get more regular and update at least ONCE per week. What day of the week that will be is literally dependent on the position of the stars. But at least I'm introducing some structure. Yay!", False, False)
add('NeoCrystalAdventures', 'http://neocrystaladventures.smackjeeves.com/comics/', u'My best, and longest lasting attempt at a sprite comic! Has a mix of things, ideas, and characters in it! All put into a dramatic/romantic/comedy setting! Currently numbering at 1200+ comics and still going strong, this comic is updated daily if at all possible! Enjoy your stay, and have fun reading!', False, True)
add('NeonGlow', 'http://neonglow.smackjeeves.com/comics/', u'Animals exposed to a special nuclear radiation and die become what is called a Neons. Neons are a phantom/zombie creatures that can be dangerous. Its up to Zedof and Jake to hunt them down to keep them from harming the public. May have some light boy love, but it is not the main focus of the comic.', False, True)
add('NiceKitty', 'http://nicekitty.smackjeeves.com/comics/', u"UPDATES TUESDAY, THURSDAY,and SATURDAY! About Nice Kitty: It is the touching coming of age story of a young boy and his cuddly feline companion, trying to find love and acceptance in a world fraught with peril and harsh realities. Will the mysterious new friend they meet one fateful day be able to answer the call of their lonely hearts, and bring some life and color to their otherwise blue and lonely world? You'll laugh, you'll cry, you'll pray for it to stop, but It won't because you can't stop the rock and why are you still reading this? You came to read the comic so READ already. This drivel certainly won't help you understand the story any better. Get going! And just remember: Be nice to your kitty, and he'll be NICE to you..........", False, False)
add('NighHeavenandHell', 'http://newnighheavenandhell.smackjeeves.com/comics/', u'A grudge as old as mankind. Three travelers entwined by fate. This road, once travelled, can never be undone. Between damnation & salvation, you find the truth hidden by God, Nigh Heaven & Hell. //Updates Every Friday//', False, True)
add('Nightmira', 'http://nightmira.smackjeeves.com/comics/', u"In a city where status rules everything, people will do anything to get to the top. It is Nightmira's job to protect the ones who are caught in the chaos. If the chaos doesn't catch her first.", False, True)
add('NihilWandasJourney', 'http://nihil.smackjeeves.com/comics/', u'I did this comic in coorperation with a friend of mine. Drawings, idea, characters and translation [The originalversion is in German] are all my fault. Wanda strongly believes she is a princess and wants to prove it, since most people just do not want to pay tribute to her. Together with Avis, a wood imp who accompanies her out of pity, Wanda embarks on a journey to the Garucian Mountains to see the mighty wizard Hon-ar, whom she expects to trace her [as she believes] lost, royal parents. Unfortunately it turns out that the world has other plans for the young woman.', False, True)
add('NormalcyisforWimps', 'http://normalcyisforwimps.smackjeeves.com/comics/', u"Sonic and Tails have gotten bored of living away from civilazation and have decided to move to Onette, at least that's what Sonic decided. Warning: Contains Demonic landlords, magic, insanity, and something else I can't think of right now.", False, True)
add('NotyoursamI', 'http://notyoursami.smackjeeves.com/comics/', u'Lyle harbors unrequited love for his twin sister\'s boyfriend, Kaden, ever since they were young. Years of suppressed feelings has made him very vulnerable and desperate that he\'ll grab any opportunity to be closer to him...even if it means losing his own identity? But is it really enough? "Not Yours, Am I?" is an original Yaoi / BL practice comic by Cinnamon Rub/Scottwm. It was first published online in September 2009. --READ FROM RIGHT TO LEFT--', True, True)
add('NuzlockeofErnie', 'http://nuzlockeofernie.smackjeeves.com/comics/', u'Yes, yet another Nuzlocke run-based Pokemon comic! A vast majority of this series will be an experiment, but I hope I can at least be entertaining in the meantime. Anyway, this is the story of the rookie Pokemon trainer Ernie, as he yearns to be the very best, like noone ever was.', False, True)
add('OffthePath', 'http://offthepath.smackjeeves.com/comics/', u'One step at a time', False, True)
add('Ofia', 'http://ofia.smackjeeves.com/comics/', u'Ofia is what has grown from a small group helping people hundreds of years ago to a huge organization that has taken over the whole valley. They do anything the people want them to do against money, which they need to keep their members alive and kicking. Ofia strives to be not a working place, but a home to its members. While Ofia is still recovering from a fight that took place five years ago, a stray cat full of hate towards the organization gets pulled in. What happens next?', False, True)
add('OldElastikid', 'http://oldelastikid.smackjeeves.com/comics/', u'These are all of the old Elastikid comics from prior to February, 2011. This was before Joe decided to become a superhero, and consists mostly of gag-a-day jokes with no real overall storyline. The tone of the series was rather different, so rather than continue on this comic, I decided to release all of the new strips as a "sequel" comic continuing in the same continuity. You can read the current Elastikid strips at http://elastikid.smackjeeves.com/ which is still being updated.', False, True)
add('Oli', 'http://oli.smackjeeves.com/comics/', u'', False, True)
add('OneFrameGags', 'http://oneframegags.smackjeeves.com/comics/', u'One panel (and occasionally two or more) gag cartoons featuring no main characters.', False, True)
add('OneRainyDay', 'http://one-rainy-day.smackjeeves.com/comics/', u'Basically a BL story like "the prince and the pauper" No sex scenes (at least not for a hundred pages or so) Mostly a cute story about a developing relationship Aki was abandoned when he was eight, for ten years he\'s lived on the streets with nothing but his wits and strength to support him. Needless to say he is unhappy. But one day he runs into some one who looks exactly like him! This mysterious boy named Ryuuta turns out to be the young master of a large corporation who just wants to be free and discover himself. Aki and this Ryuuta trade lives for the summer and Aki\'s doing fine in his new life until his identity is discovered by the Ryuuta\'s intimidating body guard named Kaidou. Can a love bloom between a stoic individual and a street rat?', True, True)
add('OnlyTwoPilot', 'http://onlytwopilot.smackjeeves.com/comics/', u"Discover the Only Two series' protagonists through two different periods (Middle-Age/Present). An intentionally progressive graphic and a screenplay style, from human stupidity to human folly, takes you through 12 chapters of 20 pages towards the main series. This pilot is presented as a color comics.", False, True)
add('Onlyonelovesong', 'http://onlyonelovesong.smackjeeves.com/comics/', u"[available as a paperback on Indyplanet with a few extra spicy pages, revamped dialogue and prettier speech bubble arrangement!] A spoiled, frustrated and capricious rock star accidentally meets a common girl seemingly imprevious to his charm. Hiding his true identity from her, he selfishly decides to make her fall in love with him. But as he gets to know her better he finds himself falling instead. Only, there's a secret in her past keeping her heart locked away... [story specs: BOY x GIRL romance, mostly comedy, some heavy drama, censored swearing, occasional gratuitous male fanservice] [tech: b&w pages, color covers,hand-drawn&inked then photoscreentoneshopped to death]", False, True)
add('OpenSpacesandClosedPlaces', 'http://oscp.smackjeeves.com/comics/', u'Open Spaces and Closed Places is a cute loverly comic about starry eyed youth with lots of flowers featuring gakuran, delinquents, glasses, scary things, fanciful thoughts, eroguro innocence, crack humour, weird characters, and paranormal stuff. Updated on Sunday and Wednesday. Website: http://www.saicoink.com', False, True)
add('OpteisenArcumShowcasium', 'http://opdiskshowcase.smackjeeves.com/comics/', u'My sprite dump because I need one...', False, True)
add('OptimalClutter', 'http://www.optimalclutter.com/comics/', u'Day to day, project to project lives of a group of developers/engineers, and the people that surround them. (Updated Tuesday, Thursday, Saturday, and 1st of the month) (Random once a month strips have moved to the Extra Pages site)', False, False)
add('OrangeJunk', 'http://orangejunk.smackjeeves.com/comics/', u'This is the story of Louise Barton, a former-rich girl that now has to attend a public high school filled with delinquents and weird people. Here, she meets Bruce, a rude and violent ruffian who\'s actually a top student, and Drew, a handsome and cool-looking guy who\'s actually a pretty calm and air-headed otaku. "Never judge a book by its cover", that\'s what she learnt once these 3 teenagers had to team up to save Louise from failing her exams... Genres: shoujo, comedy, school life Reads from left to right -->', False, True)
add('Oscurare', 'http://oscurare-comic.smackjeeves.com/comics/', u'Would you give your soul for a chance to search for a missing loved one? That is the price sixteen year old Yoru paid to the forest demon sending her on a journey to the sunless world of Oscurare. In an unfamiliar world does Yoru have what it takes to find her brother and stay alive? Updates Tuesdays and Fridays Rated-pg 13 now updating: chapter 4', False, True)
add('OtherSideoftheBlade', 'http://osotb.smackjeeves.com/comics/', u'All Sergius wants is to be left alone in the Vatican library with the hundreds of tomes he has acquired during his exile. All Garter wants to do is flirt with cute girls, eat great food, live his life, and kill whatever monster of the day the Vatican sends him. The last thing they want to do is deal with each other. Warnings: Blood & gore, some sexy stuff, a pinch of religion, and crabby librarians. Additional OSOTB Content at: http://sergijournal.smackjeeves.com/ OSOTB LJ Fansite: http://osotb-official.livejournal.com/ Currently Updating on FRIDAYS', False, True)
add('Outlawed', 'http://outlawed.smackjeeves.com/comics/', u"[Outlawed] is the story and events of DJ, who longs to be a webcomic artist(or an artist in anything for that matter). He lives in Waldorf, Maryland and it is not exactly the best place to try to get his talent showcased. So DJ has to enlist the help of his friends,who share common ideals but in truth they are only there for the video games and free gear. Even still, DJ has to face the drama and the crap that is thrown at him daily but with video games and heavy metal music there's no telling what will happen to DJ and his friends. Updates: Monday & Thursday For Mature Readers Copyright \xa9 2005-2013 Donnie Love All rights reserved.", False, True)
add('Outsiders', 'http://outsiders.smackjeeves.com/comics/', u"Made as a semi spinoff of Wildcards following their death at the hands of Caladbolg, Atma must team up with a new band of idiots to take on the weird and stupid things plaguing his world. It sucks to be a hero, but somebody's gotta do it. Hiatus is over. Back to work.", False, True)
add('OverlordofRavenfell', 'http://ravenfell.smackjeeves.com/comics/', u'Site Mirror: original comic can be found at ravenfell.com Razin wants to be an Evil Overlord and wreak havoc on the world. He just has one problem...his personality.', False, True)
add('PMDSkyNuzlocke', 'http://giginuzlocke2.smackjeeves.com/comics/', u"Part 2 of Gigi's Nuzlocke adventures~ This time Gigi loses her memory (again!) when she is mysteriously turned into an Eevee. Joining Kiara the Vulpix, can they solve the mystery of time and space? ~A Pokemon Mystery Dungeon: Sky Nuzlocke", False, True)
add('PMDTeamFireFox', 'http://pmdteamfirefox.smackjeeves.com/comics/', u"What happens when you turn into a pokemon, forget everything, and lay unconsciously on the beach? Go save the world from time freezing, obviously! Well that's just what Team FireFox is going to do! It's a gijinka comics :3 Oh yeah, art gradually gets better. Grammar? Not so much.", False, True)
add('PMDTheAdventuresOfHoundMaxandFang', 'http://pmdtheadventuresofhoundandfang.smackjeeves.com/comics/', u"A Pokemon Mystery Dungeon Based story. Max Hound Fang And Rose, A Umbreon,Houndoom,Mightyena and a Persian all together in a rescue team to protect the world from the evil lurking in every shadow. Years pass by as being a team leader and they find out that somethings changed and pokemon start going out of wack, and weird happenings are starting up for an odd reason. An Ex-Friend turns on them and plans his evil plot on killing them all includeing the world around them, getting ahold of black magic, Or should I say.. A long forgotten power souce of pure evil whipeing out all exsistence of life. Can this odd bunch figure out the whole mystery behind this? Or will the earth be lead into evil's hands... Updates Once a week if possible. (Pokemon (c) Go to Pokemon Compony Gamefreak and Nintendio.", False, True)
add('PMDVictoryFire', 'http://victoryfire.smackjeeves.com/comics/', u"Sometimes the most interesting stories come from the strangest places. Victory Fire starts off as most Mystery Dungeon comics do, a human comes to the pokemon world. But THAT'S where the similarities end.... New pages are posted on Tuesdays and Fridays, please check back :) **Broken images? SmackJeeves servers playing up? VF is mirrored on sulfurbunny.deviantart.com **", False, True)
add('PRAGUERACE', 'http://praguerace.smackjeeves.com/comics/', u'PRace is a story about friendship and adventure. Author is Petra Erika Nordlund, also known as LEPPU and her other artwork can be found from tumblr and deviantart with the same nickname. email for contact is petra.nordlund at gmail.com', False, True)
add('PSY', 'http://psywebcomic.smackjeeves.com/comics/', u"If you could have any power, what would it be? The ability to move things with your thoughts? The ability to read people's minds? Or maybe the power to control living things? In a world where psychics must hide their powers from the people around them, specialized psychics called Kinetics must learn to master their powers, while still keeping their powers a secret from the world around them. ------------------------ Volume 1 now on sale! http://psystore.bigcartel.com/", False, False)
add('PTO', 'http://pto.smackjeeves.com/comics/', u'"I just want to feel loved" The year is 2374 in the future. What is going to happen, when a gang of useless men adopt an adorable living doll? Well, a lot of drama and heartbreaks, that\'s for sure. ---- UPDATED EVERY DAY! Includes sex, nudity and a bit of violence. Check out also (http://ptobonus.smackjeeves.com/)', True, False)
add('Panacea', 'http://panacea.smackjeeves.com/comics/', u"Caelen is part shapeshifter but his dual heritage becomes a curse when he learns his unstable body is slowly deteriorating. Life seems pretty miserable and pointless. With no faith in himself and even less faith in others he\x92s very much sunken into pitiful state. After hitting his lowest point, landing in the streets with nowhere to be, he manages to catch the attention of a stranger. Will Sairys' compassion and cheerful attitude be enough to break through the barriers Caelen manage to erect around himself? *~*~*~*~*~*~*~*~*~*~*~*~*~*~ Boy Love Warning! Hopefully I'll manage to update once a week. You can expect new pages on Mondays and Thursdays... usually, unless something comes up and I can't make the deadline.", True, False)
add('PanzerDragonandEnigmaCompleteEdition', 'http://panzerdragonandenigma.smackjeeves.com/comics/', u"As a world reaches its peak of prosperity, instability begins to reveal itself as Dragonenix falls into a period of darkness. Three warriors will rise to the challenge to solve the mystery of their world's instability and set things right. The Complete Edition of Panzer Dragon and Enigma contains the full unabridged story of the entire First Arc series, including the first season of the PDE(+) Saga: Twilight Dawn. The last major update was November 16, 2011, with Twilight Dawn added to the archives as of March 20, 2012.", False, True)
add('PanzerDragonandEnigmaZwei', 'http://pdezwei.smackjeeves.com/comics/', u'Panzer Dragon and Enigma Zwei is the re-telling of the original story on SmackJeeves about protagonists Panzer Dragon, Enigma, and Niavana Avalon as they become involved in protecting their home from the move of a mysterious organization, spiraling into a battle that will decide the fate of so many worlds and reveal to this trio their destiny. Click on "PDE: Complete Edition" to check out the original story, but you do NOT have to read the Complete Edition to understand what\'s going on in PDE Zwei. Nevertheless, it\'s still an awesome read and you should check it out if you want an idea of my past works. Comics available every Monday, Thursday, and Saturday!!!', False, True)
add('Paradox', 'http://paradoxcomic.smackjeeves.com/comics/', u'Taken as prisoners of war, Dake and Tommy are sold as slaves, one to a wealthy but kind woman, the other to a man of unknown species who has a very bad habit of eating people. Forced to endure the horrors of war, racism, homophobia, and the occasional molestation, can these two opposites somehow attract? Contains sexual situations, violence, drug use and probably many other bad things.', True, True)
add('ParrishsWasteland', 'http://pbwasteland.smackjeeves.com/comics/', u"Just like epic mickey's wasteland, this shall be mine.", False, True)
add('PepSquad', 'http://pepsquad.smackjeeves.com/comics/', u'the day to day struggles and activities of a group of teenage cheerleaders.', False, True)
add('PerplexingMagnoliaDisruption', 'http://smgpmd.smackjeeves.com/comics/', u"Perplexing Magnolia Disruption is a serious comic filled with love, hate, drama, and... Who are we kidding, it's a Team SMG Pokemon Comic. Don't expect this to be serious at all. COMIC COMPLETED. The sequel can be found here: http://www.smackjeeves.com/comicprofile.php?id=118656", False, True)
add('PeterPan', 'http://peterpan.smackjeeves.com/comics/', u"A manga adaptation of the classic children's story Peter Pan. Closely following J.M. Barrie's original story, come follow the adventures of Peter and the Darling children in Neverland! If you've never read the book, here's your chance to experience the real story! If you have, and enjoyed it, then this is the comic for you! New reader? Start here! http://peterpan.smackjeeves.com/comics/1496616/peter-pan-cover/ Want more Peter Pan Posts? Find me on... Tumblr: http://triaelf9.tumblr.com/ Deviant art: http://triaelf9.deviantart.com/ And on Twitter: https://twitter.com/TriaElf9 This comic is also posted on Deviant Art, Manga Magazine and Crunchyroll, so if there's ever a smackjeeves outage, you can check any of those places! ^_^", False, True)
add('Phantomland', 'http://phantomland.smackjeeves.com/comics/', u"UPDATES ON THURSDAYS Santa Luison is a large city that employs it's strange minority of subhumans at a crime fighting organization. Introduce Chie: a fresh little rookie who receives her training from the baddest, meanest veteran officer around. Phantomland started as a self-published print comic back in 2009 and is now getting it's online debut at Smackjeeves. To know more about this comic, visit the homepage at: http://amph.nipponfever.net/phantomland", False, True)
add('PlanetChaser', 'http://planetchaser.smackjeeves.com/comics/', u'In the future when 18 year old Clarissa inherits a spaceship and a robot, little did she expect the trouble that goes with it. Being orphaned, she begins to learn about her parents and an alien who rules over humankind.', False, True)
add('PlasticKings', 'http://plastickings.smackjeeves.com/comics/', u"A young king and his rock n' roll queen must give up their party-animal ways and beg the gods for help when their newborn son falls ill. However, this is only the first of many problems facing the kingdom and the gods who watch over it.", False, True)
add('PlayProductions', 'http://playpros.smackjeeves.com/comics/', u'A curse consumes a whole school. To break the curse a group of unlikely friends set out together to go against the crazy school staff. This comic was rebooted with a whole different story and setting found here: http://prophetofficial.smackjeeves.com/comics/1743932/volume-1/', False, True)
add('PlayTime', 'http://dollysplaytime.smackjeeves.com/comics/', u'Megumi was just a timid high school girl trying to cope with life until the day a magic ribbon came into her life and a new hero was born!', False, True)
add('Pleasebemyboytoy', 'http://pleasebemyboytoy.smackjeeves.com/comics/', u'Takeshi likes Atsushi. Atsushi accidentally promises the creepy biology teacher a date with Takeshi... Right to left, please <3---', False, True)
add('Plume', 'http://plume.smackjeeves.com/comics/', u'"Revenge is like a plume of smoke. It seems tangible, but when you reach for it, you\'re grasping at nothing but air."', False, True)
add('PoKeMoNHEROES', 'http://pokemon-heroes.smackjeeves.com/comics/', u'A more mature PoK\xe9MoN sprite webcomic... Done completly in PhotoShop!', False, True)
add('PokefarmingRiseFromtheAshes', 'http://pokefarming.smackjeeves.com/comics/', u'http://pokefarm.org/ IF YOU HAVE A POKEFARM ACCOUNT YOU CAN JOIN. A second Pokefarming since the old one was deleted by some douchebag. >:I All about Pokefarm. Post your eggs and pokemon, etc. Anything Pokefarm related.', False, True)
add('PokemonBeta', 'http://pokemonbeta.smackjeeves.com/comics/', u'The Trygon facility was made to create better Pok\xe9mon that can survive in their world, as species over the years have been dying out. Rymadanas, the head of the Red tower, desire Pok\xe9mon to become equals, with no weaknesses or be disadvantaged. Pok\xe9mon are recruited into the facilities by force if they lack the necessary amount of specimen. The Trygon capture Pokemon and genetically experiment on them, and even themselves to achieve their goals. Those captured unwillingly are wiped of their memories, forcing them to obey without question. Some regions had seen the only way out is to urge their residents to undergo experimentation to keep families from being separated, and body counts low. Opposition to the Trygon Organization has reached an all time pitfall. Only few pieces of land are still free of the shadow cast from the buildings. Is risky science the way to salvation? What is the root cause of Pokemon to be dying out? Unbeknownst to a Totodile, he would find the answers to everything...', False, True)
add('PokemonBondofHearts', 'http://pokemonboh.smackjeeves.com/comics/', u'A certain trainer and her pokemon team go through an interesting transformation. Having been stripped of their usual power, how will they deal with the problems within and without? With a spoonful of humour, of course! This is a spin-off of "For The Wild" (http://archiveofourown.org/works/802980). Updates randomly (aiming for once a weekend). Quality increases unintentionally.', False, True)
add('PokemonBreak', 'http://pokemonbreak.smackjeeves.com/comics/', u'*Main plot starts at chapter three* There is only one Pokemon capable of learning any move, and that\u2019s Mew. Project HM 00 wants to change that. During the project\u2019s test run, a program error occurs and Missingno, an incomplete Pokemon is created. Missingno has no real form and needs oran berries to stay alive. It has no intentions of staying incomplete, though, and it\u2019ll stop at nothing to find what it\u2019s missing. -Pages are now in color (starting with Ch 5, pg15) -Updates: Fridays!', False, True)
add('PokemonCrystalDoubleNuzlockeChallenge', 'http://miinuzlocke.smackjeeves.com/comics/', u"Another Nuzlocke Challenge, Pokemon Crystal Version :D. Note: English is not my main language :B, so you're free to correct me anytime.", False, True)
add('PokemonMysteryDungeonStrikedownChronicles', 'http://pmdsc.smackjeeves.com/comics/', u'A party of Pokemon find themselves on an island and try to get back home. But there is more going on that what it seems. (Question marks will be replaced as actual party members surface)', False, True)
add('PokemonMysteryDungeonTales', 'http://pmdt.smackjeeves.com/comics/', u'Vexx and Mack of the Super Ranked Team, GreenFire, set out on a mission of their own, to explore the world outside their Island! However, things do not go according to plan when enemies of old appear with plans of their own. Along with their new team-mates, friends and allies, Vexx and Mack set a course to continue helping the Pok\xe9mon of the world while exploring the new world around them. This is their Tale... Based on the popular Pok\xe9mon Mystery Dungeon \xa9 series. Pok\xe9mon is copyrighted \xa9 to Nintendo/GameFreak Updates once a week, or whenever possible', False, True)
add('PokemonMysteryDungeonTeamCrystal', 'http://crystalmysterydungeon.smackjeeves.com/comics/', u"Just a little something I wanted to try as a result of playing pkmn mystery dungeon games a lot. Will have a bit of everything category wise :) Will up the rating to M if it calls for it..but hopefully it won't. It IS rated T for language though! Updated whenever I can!", False, True)
add('PokemonRandomKanto', 'http://randomkanto.smackjeeves.com/comics/', u"You know Pokemon FireRed and LeafGreen, right? Good. Now here's FR/LG a little different. I don't update. Yeah...", False, True)
add('PokemonSAKOHJU', 'http://sakohju.smackjeeves.com/comics/', u"Different adventures kick off with different characters in different parts of the Pokemon world! There's darkness in the Pokearth, and it's not just Team Plasma. A group by the name of Team Midnight is on the rise. However, their biggest obstacle appears when the protoganists come together to form SAKOHJU, an organization dedicated to ridding the Pokemon world of evil. As the fight rages, it's unclear how many will make it out alive, as it all comes down to SAKOHJU vs. Team Midnight... ____________________ I started this comic a couple years ago so some parts of it (beginning especially) aren't all that good. It's become more of a sketch comic and it's a learning experience for me, I improve and as my first project I'm seeing this thing to the end no matter what. I also have lots of characters based off real people. I will say that now. Also breaks the fourth wall. A LOT. Pokemon (c) Nintendo", False, True)
add('PokemonSoaringSoul', 'http://pkmnss.smackjeeves.com/comics/', u'Lyra is a young girl from New bark town. Eric is the same but a boy. Also there is Falkner. And a totodile. Also Gold is gay and Silver likes it up the ass probably. This is a pokemon comic. Read it or dont read it, this is what it is. KThx How long has there been a typo in this description jesus christ', False, True)
add('PokemonnoRakuen', 'http://pokemon-no-rakuen.smackjeeves.com/comics/', u"Summery- Gray has NEVER had a single girlfriend in his 17 years of life. His mother gets him a Totodile and then weird things happen... The Totodile becomes a human! What's going on?! Will going on a Pokemon journey give Gray the answers to his questions? Why did the Totodile become a human? What does Gray's father have to do with any of this? Will Gray EVER get a girlfriend? (Unlikely) Read to find out For ages 13 and up Warning- May contain death, blood and Implications", False, True)
add('PokemutatesRus', 'http://pokemutatesrus.smackjeeves.com/comics/', u"A showcase about pok\xef\xbf\xbdmon mutations by Flashwatch, Djoing, Digi300, Awesomeness189,Shift, Bowserknight, kitsune fire, himynameischris, Crusty_Kris, Weaver Tyialo, kh_fanatic1995, Snowy death,disturbed1, Chaodude, Jed192, Eddigardo, Rarhq2, naruto_numb,Celtic guardian, Ragethefox, Sparky The Fox, Bresong, Axel1000, Plazmaz, Xp_lulz and ridleykirb!! Also, not to forget, Flashwatch will show off some of his awesome Pokemon to Pokeball fusion art! Sparky Say HI! I'm New To This So Please Help Me- Sparky The Fox Ok seriously, Guys, save in PNG BEFORE you apply to join, thats the only rule now, PNG and you're in. The 189 wuz hir btw dont forget Blitzeh 'e3e' he makes aweseom stufz 2 ya no :[ (its true~Blitz) Plazmaz is probably the most epic one here. I love that guy. ~Anonymous Source Is anyone else active here? XD im determend to get this to 2k comics atlest ~Snowy<3", False, True)
add('Polly2sart', 'http://myart.smackjeeves.com/comics/', u'Yeah \u2665 This is where MY stuff goes <333 \u2665', False, True)
add('Ponzi', 'http://ponzi.smackjeeves.com/comics/', u"About: It's a new beginning, a new age and a new world where people enjoy advanced industrial games, technology and entertainment. At this moment, after a mysterious broadcast, the world media has launched a new tournament called N.E.O.SIN. The prize for this competition is unlike any other, the winners will receive an evolutionary enhancement of their body. This enhancement will improve their physical and mental capacity as a human being. Ever dream of super speed, super vision or any other kind of supernatural enhancement? Who will win the key to the evolution of the human race? (You can read more info on the official site: www.pigtailstudio.com )", False, True)
add('Predicaments', 'http://predicaments.smackjeeves.com/comics/', u"A story of a couple guys, living in the video game/sprite world, who are constantly thrust in random adventures in their surrounding world. This comic was once called 'Sprites!' but it got changed. Updates 2-3 times a week.", False, True)
add('PrincessChroma', 'http://princesschroma.smackjeeves.com/comics/', u"As darkness threatens to engulf all life, the universe cries out for a champion with a pure heart. But they'll have to settle for schoolgirl June Summer. With the help of her friends and her mentor, a winged bunny, June will battle monsters, struggle to maintain a normal school life, and occasionally watch television. Hey, even heroines need a little downtime. -A Magical Girl Parody. Updates Wednesdays!", False, True)
add('Puck', 'http://puck.smackjeeves.com/comics/', u'This site is the Smackjeeves mirror site for Puck where older comics are posted. The actual Puck website contains the latest content at... WWW.PUCKCOMICS.COM', False, True)
add('PulseandBolt', 'http://pulse-bolt.smackjeeves.com/comics/', u'Two female human batteries become armored superheroes.', False, True)
add('PumpkinFlower', 'http://pumpkinflower.smackjeeves.com/comics/', u"CONTAINS: BL When being stalked by an amnesiatic ghost is the best thing going for you there may be a problem. Now if only the ghost could understand the term 'personal space.' FINISHED", False, True)
add('QueerQueen', 'http://queerqueen.smackjeeves.com/comics/', u"Queer Queen is a comedy shounen ai manga centred around Helium, a transvestite male student attending a boys' school, who falls in love with his own form-teacher. For this love is unrequited, he decides to ask out a fellow student to make his teacher jealous. Updated every Thursday, should be read from right to left.", False, True)
add('Quickening', 'http://quickening.smackjeeves.com/comics/', u'Quickening: the ability to manifest your soul energy in the form of a weapon. --- Tony Lockhart is a senior student who attends one of the most prestigious schools in the country: Rowan Academy, which is known for its discerning methods of teaching the art of Quickening and combat. Every day he faces giant robots, giant reptiles, rabid fangirls (but not HIS fangirls), sadistic teachers, and anything that can put him in a life-or-death situation. All for the greater cause. Or so they say. But, really, he just wants to graduate with all his limbs intact. -- READ RIGHT TO LEFT', False, True)
add('QuiteNiceComics', 'http://quitenice.smackjeeves.com/comics/', u"Welcome to a world of mysticism, intrigue, and chaos. Where warring powers turn the tides of time itself to their bidding. Where deception is a virtue and the truth an executioner's axe. ... Actually, that's the comic next door. This is Quite Nice Comics.", False, True)
add('RAndAcomics', 'http://randacomics.smackjeeves.com/comics/', u'R&A comics author sketches A collection of Artwork and old comic pages from the authors and artists of R&A comics. (with added running commentry from yours truly) this comic also contains some sneak previews of upcoming comics and plans ;) This is mainly to show our fans what we do in our spare time when working away from our main projects. There are old comics in here (if anyone wants to continue them just drop us a message) Live comics: FootLoose (complete, old pages being redrawn) Scyth (on hold for re-scripting) Hidden comics: Paranormal S.P.P (goes live in September)', False, True)
add('RIDDICKQLOSSTALES', 'http://riddickqlosstales.smackjeeves.com/comics/', u"Crack detective Riddick Q. Loss' never-ending quest to catch the dastardly villain Sir Dimswitch.", True, True)
add('ROSIER', 'http://rosier.smackjeeves.com/comics/', u"[COMPLETED WORK] A Dark Fantasy Romance: Vanney is a ditzy acolyte at the Temple of the God of Wealth and spends her days daydreaming about adventures with her best friend Jaelia. When the Temple sends the two of them to escort a caravan to the mysterious, far-off border town of Shadow Charing Vanney's time for adventure has come. But her sunny imaginings have nothing to do with the shadowy world of witches, demons, magic and netherworlds her path takes her to...", False, True)
add('RainLGBT', 'http://rainlgbt.smackjeeves.com/comics/', u'Written by Jocelyn C.D. (aka LittleLynn84) "Rain" is a comedy/drama that follows the daily life of teenage transsexual (who is coincidentally named Rain) attempting to go through her senior year being only identified as a woman. I\u2019d like for it to be very funny and entertaining, but the story will also touch on many rather heavy subjects including acceptance from family and piers, blind hatred and many of the other difficulties faced by members of the LGBT community. This comic contains: - Occasionally strong language - Sexual themes and situations (but no nudity) - Gay, lesbian, bi and transgendered (and straight) characters - Lousy or non-existent backgrounds', False, False)
add('RaisonDetre', 'http://raison-detre.smackjeeves.com/comics/', u"When flamboyant Brit Alastair moved to America, he thought he'd accomplish a little more than setting up a failing pizza take away business after his Harvard education. After being deemed unable to have children, neither did be believe his pipe dream of starting a family would ever be possible. However following many odd twists of fate, he finds himself being the legal guardian of four children/adolescents each with their own unique quirks and of course, problems. But despite his best efforts, following a devastating accident, he finds it incredibly difficult to function within the busy New York lifestyle, let alone tackle four children alone. After being confronted with his first genuine Italian applicant for the new chefs job, could Luca Giovanni be the most complex new addition to this dysfunctional family? And what could be the reason behind Alastair's unhealthy attachment to him? Comedy / Drama / Slice of life / Romance >>>>>>>> Read this way >>>>>>>>>", False, True)
add('RareCandyTreatment', 'http://www.rarecandytreatment.com/comics/', u'A webcomic targetting the flaws and hypothetical situations in the Pok\xe9mon games. Ridiculing the trainers, mocking the various species, and overall making fun of a popular game we all hold very dear (author included).', False, True)
add('Rasputin', 'http://rasputin.smackjeeves.com/comics/', u'Rasputin is a grey haired kid who moves to the big city! Oh what horrors awaits him in this new town!? Angry redheads? Pedo teachers? Closet hookers!? yup. AND MUCH MORE! Hope you enjoy my comic >8D !', False, True)
add('RavenWolf', 'http://ravenwolf.smackjeeves.com/comics/', u"Due to human negligence the world as we know it has ended and been reborn. The animal spirits that guide man giving them the forms of animals so that they would be able to survive in this new wilderness. Though now carrying the form of beasts man has not forgotten the place they once had, as an existence greater then just what nature wanted of them, an existence above all. Those that worked to gain their humanity are known as domestics, while those who wished to follow the roles the spirits had given them were known as wilds. Both groups grew arrogant and hateful of one another because of how differently they thought. The raven and the wolf spirits grew tired of the destruction and fighting and sided with the wilds in their ideals, the domestics only capable of further destroying nature. In their anger they marked a tribe of wilds with a curse, they being removed from the sacred circle of life, the curse upon them only broken once the domestics are gone once and for all. The cursed tribe now known to all by the name of the spirits whom cursed them. 'Raven Wolf' Updates: Wed, Fri and Sun", False, True)
add('Regina', 'http://regina.smackjeeves.com/comics/', u"'Regina' is a sketch comic. It's a daily sketch challenge comic designed to get me to draw one comic page a day so I can stay in practice everyday. Also to practice page layouts and conversational writing. Regina is drawn using only a black ball-point pen and totally free-hand. The story of Regina is a slice of life about a girl named Regina and her random group of friends,where what ever happens, happens and I try to make it as interesting as possible. Updates: Daily", False, True)
add('Regnum', 'http://regnum.smackjeeves.com/comics/', u"The kingdom of Regnum is beautiful and ruled by the royal family. But the prince has been kidnapped by a demon! The king hastily throws together a team of elite fighters, soldiers, and weirdos to bring his son back. These 8 strangers are to work together to gather clues, fight, and bring the little shit back home. _______________________________ This collab will most likely contain violence, cursing, and sexual content so BE WARNED _______________________________ This is a BL collab! It is a BL collab but romance doesn't have to be a central theme! Spots Taken 8/8", False, True)
add('ReidyandFriendsShowcase', 'http://reidynfriends.smackjeeves.com/comics/', u"A general showcase where pretty much anyone can post anything they want, barring porn. Maybe. Probably. We also try to be civil whenever possible, so don't go out of your way to piss people off. Other than that just sit back, relax, and enjoy the showcase. Anyways, you should have at least SOME experience spriting before applying to join, should you want to. We don't accept recolors and are very much against sprite thieves. Send all applications to Reidy. Hah, no. He's dead. Just hit the apply button.", False, False)
add('Republicanattackmachine', 'http://www.republicanattackmachine.us/comics/', u'Life is about many things. But at this site it is mostly about discussion and observation. Here you can have a discussion with a Republican. Not the National Republican Party, nor a Republican office holder, staffer, or aide. Here you will see what one Republican thinks. An individual. And you will discover, hopefully, that we like to laugh as much as anyone. If its your first time talking to a Republican, welcome.', False, True)
add('RequiemShadowbornPariah', 'http://shadowbornpariah.smackjeeves.com/comics/', u"A bad job, a betrayed assassin. Now she's on the run from the very people with whom she once worked. Locked into the world of the Immortals, Anastasia V\xe3duva has lived in the shadows of Eastern Europe for over two centuries. Forced to flee to the New World with the promises of shelter - she finds no salvation. The New Kingdoms are possibly even more dangerous than anything existing within the Elder Illuminati demesnes. Armies march to the drums of the Requiem, nations rise and fall to the whim of the Illuminati - and they want her dead. Updated Sundays and Thursdays", False, True)
add('ReturntoEden', 'http://rte.smackjeeves.com/comics/', u"When you're the last angel remaining, being mistaken for Satan's lunch is *not* going to make things easier.... (may contain fun stuff like angels, demons, complete disregard for the bible, crazy people and bare butts, sometimes bare-butted crazy people. Add a hint of BL, and you've been warned)", False, True)
add('RockMyWorld', 'http://rockmyworld.smackjeeves.com/comics/', u"The upcoming J-rock band Battle-X balances on the brink of despair. And the cause of all this mess is the vocalist Rin Kawatake, who just can't seem to get a hold of his behaviour. When another bandmember leaves the band for the fifth time this year, the bandmanager puts his last hope into the new guitarist, named Teika Yoshida, the guy who just could be the solution to all of their problems! But not only that.. Because when they meet for the first time, Rin immediately seems to take a very special interest into this cute guy... YAOI/BL!! :3 updates a few times a week (I used to update everyday but... yeah, school's a bitch)", False, True)
add('RococosAtelier', 'http://rococo.smackjeeves.com/comics/', u'Vivian Lancebaker is a 17 year old girl who is having a hard time finding a part time job during her last summer in high school. With great reluctance, she went to a little bakery in which her mother have arranged for her to be an assistant/cashier. As it turn out, the owner of the store is a rather eccentric woman who happen to be a retired "magical girl". This leads to a series of strange and interesting encounter as Vivian work in the Rococo\'s Bakery and Catering.', False, True)
add('RoyalIcing', 'http://royalicing.smackjeeves.com/comics/', u'AVAILABLE IN PRINT AT AMAZON.COM! Look for "Royal Icing Graphic Novel". Synopsis: When little Emily bakes a cake, she gets more than she bargained for. Strange flora and fauna, a cold-hearted prince, and a mystery that must be solved before she can return home from the Sucre Isles. What adventures await her in the land of curious candies?', False, True)
add('RozeFighter', 'http://rozefighter.smackjeeves.com/comics/', u'The year\'s 2310A.D and mutants have taken over the planet. One human, Aurora Lockluster ( Bara for short) teams up with Apollo "Mitsu" Kurosu (a lovable Casanova) to collect 9 magical crystals and incredible powers that come with them! Join us on Wednesdays and Saturdays! Warning: Strong language and booty! Follow us on tumblr: http://roze-fighter.tumblr.com/ Find us on Facebook: https://www.facebook.com/RozeFighter?ref=hl LGBTQ comic~', False, True)
add('RubyNation', 'http://www.therubynation.com/comics/', u"This is the story of Ruby Harrison, former middle-upper-class American high schooler turned nine-foot-tall post-human person of mass destruction. Dragged into a worldwide conspiracy that treats human beings as mere test subjects, Ruby's goal is to create a safe haven for her fellow post-human victims. But their powers are too valuable for the world to let be, and Ruby and her comrades will have to make hard decisions to preserve her new home.", False, True)
add('RubyRed', 'http://rubyred.smackjeeves.com/comics/', u'', False, True)
add('RuderiQuest', 'http://ruderi.smackjeeves.com/comics/', u'Four kids confront a school full of demonic teachers!', False, True)
add('RyakLo', 'http://ryak-lo.smackjeeves.com/comics/', u'', False, True)
add('RydalsStory', 'http://rydal.smackjeeves.com/comics/', u"A story loosely based off of Carlo Collodi's Pinocchio. -------------------------------------------- Robert Rydal, an optimistic and semi-incompetent, fake-it-till-you-make-it conman recruits an unsuspecting (and partially unwilling) crew of people to aid his quest of finding the Blue Fairy to lift the Donkey Curse he had received as a child. What price would you pay to get your life back? ----------------------- Updates normally over the weekend...Unless it doesn't...But mostly it does. :) Check the Twitter Feed for live page updates!", False, True)
add('SAKANA', 'http://sakana.smackjeeves.com/comics/', u'A thrilling tale of two socially dysfunctional brothers working at the largest fish market in the world, and the things they must do to get paid, make friends and date ladies. Also, this comic updates a few days ahead of time on Mangamagazine.net! http://www.mangamagazine.net/manga-and-comics/SAKANA/detail-page/125', False, True)
add('SChIzO', 'http://schizophrenic.smackjeeves.com/comics/', u"Hector never seems to want to leave Ruby alone. He's always there, bugging her and tracking her every move and she can't stand him much longer. Of course...she has to learn to live with it seeing as he isn't going anywhere. Afterall, he IS just that little voice in her head. Join the schizophrenic Ruby, her mute best friend and roommate Kenneth, their eccentric neighbor Lynn and a whole cast of oddball characters as they try to live through the everyday trials of moving out and living on your own...despite being a little messed up in the head.", False, True)
add('SFCForestofDreams', 'http://sfcforestofdreams.smackjeeves.com/comics/', u'A strict, megalomaniacal lioness. A egocentric, muscular vampire. A sarcastic, antisocial eraser. A surprisingly sane blob. A small, mute pikmin. An optimistic, friendly green thing. A stubborn, determined mouse. A curious woman from the future. A meek, brilliant scientist. A calm, fatherly fighter. A serious, taciturn war veteran. A crazy, hyper girl. A confident, eager architect. A savvy, sly chimpanzee. A frustrated, busty teenager. A sad, lonely emo. A fangirlish, lovestruck fairy. A dominant, genius octopus. A loud, grumpy senior citizen. And a sadistic, creepy alien. Who will win the $1,000,000 grand prize?', False, True)
add('SLightlyabOVeavErage', 'http://slightlyaboveaverage.smackjeeves.com/comics/', u'Keiko Tachibana is an average High school girl. Scratch that. She\'s a self proclaimed "Slighty above average" High school girl who has dedicated herself to being only moderately better than the social norm. However one day she gets a visit from someone Way over the top. An inter dimensional cutie whom goes by the name Llla-Elac Ngtholi Cllegogg, also known as "Laila" to humans. She has come to destroy the sanity, and lives of everyone at Daisuke Ryuzaki high school. However, poor Keiko seems to be the only one at school whom has noticed this terrifying beast, and to make matters worse, she\'s staying at her house!! Will Keiko be driven insane by the ramblings of this terrible alien and her Slightly above average lifestyle tossed to the wind? Or will she succeed in defeating this strange alien menace!? Find out in this incredibly odd web comic inspired by the works of H.P. Lovecraft!', True, True)
add('SOSRadio', 'http://sosradio.smackjeeves.com/comics/', u'WORKERS WARNING, CONTAINS MUSIC PLAYER "Set at very low volume, Lyrics warning" 50.5 The Sounds Of Survival Apocalyptic Radio "Because it\'s never to late to liberate!" A web-comic of sound, music, and a quest for creative freedom from an entertainment starved tyrannical monarchy where anyone with the gift of art and self expression are not only hunted but enslaved. Chainsaw Adam\'s, a lone pirate radio dj travels a post apocalyptic wasteland broadcasting a message of rebellion. Calling to the abstract souls and the free spirits, he inspires those in hiding from the powers that be to rise up and fight back to create a new society built on the stuff that dreams are made of. "CLIFF-NOTES FOR NEW VIEWERS" After breaching the city walls of Tulsa, Chainsaw finds Rockette, the sister of the woman he seeks "The Girl with Green Eyes" AKA (Quill). Ready to venture to the prison to rescue her, the two find themselves confronted by re-animated robots bent on destruction. Can Chainsaw\'s abilities as a \'Natural\' save them!? WHY READ? Read BEFORE we become popular. THEN when your friends start reading too, you can say "Hey I\'ve been reading for years, suck it!', False, True)
add('SPOON', 'http://spoon.smackjeeves.com/comics/', u'A evil wizard turned Charles\' whole town turned into a kitchen (that\'s right). Cursed with the body of a SPOON, he has embarked on a journey to find the wizard and along the way, he will meet other "cursed" ones. UPDATED MONDAY THROUGH FRIDAY.', False, False)
add('SailorMoontheEnemyNextDoor', 'http://sailormoontheenemynextdoor.smackjeeves.com/comics/', u'A manga version of my Fan Fiction of the same title, art work by Karolina Romanska. The past comes to the present yet again, and the Sailor Scouts shall be called upon once again to put down the latest threat to the safety of Earth, with a new member to the team to help them along! To find the threat, they will not have to look far.', False, True)
add('SaintsCalling', 'http://saintscalling.smackjeeves.com/comics/', u'*Please go to the "About" page for a full description. Thanks :)* An ill-tempered girl gets her life flipped up-side-down when her best friend abducts her in an attempt to straighten her out a bit. Little does she know...her friend is an alien king from another planet?! A Scifi Shoujo! (Rated T for Teen. Read from left-to-right. Currently in sketch comic mode until further notice)', False, True)
add('SakuraMishzo', 'http://sakurazo.smackjeeves.com/comics/', u'An original gekiga set in Sengoku Period and featuring the strange relationship between the warlord Nobunaga, his valet Ranmaru and the ninja Mitsubachi.', True, True)
add('SalemUncommons', 'http://salemuncommons.smackjeeves.com/comics/', u"In a hidden corner of Salem MA stands the Salem Uncommon boarding house...It was purchased years ago by Karl (formerly Dr. Frankenstein's nameless monster), and has since attracted every manner of ghoul, ghost, goblin, and monster (as well as a few odd humans)...If you like your humor a little dark but good natured, like the Addams and Munsters of old, stop by. Salem always has room for more Uncommons...", False, True)
add('Saywhatyoumean', 'http://saywhatyoumean.smackjeeves.com/comics/', u"A comic pulled out of the freaked up author's subconscious. humor and pain, philosophy and non-sense,love and violence and sexy things, based on real events or completely fake, who knows what the next update will bring", False, True)
add('SchoolofRejectsSoRe', 'http://sore.smackjeeves.com/comics/', u"Have you ever wondered what happens to the characters that DON'T make it into the stories? There is a place where rejected, unfinished, and imperfect characters can go to study, play, and talk to each other. A place that an ordinary girl has stumbled upon... This is the School of Rejects.", False, True)
add('ScrappedProject', 'http://scrappedproject.smackjeeves.com/comics/', u'This is a simple tale of what happens when ideas get discarded and go looking for their purpose in life. Told through the eyes of a robot. ~Journey Completed~ (thanks for reading ^.^)', False, True)
add('SecondGeneration', 'http://keepersofthepeace.smackjeeves.com/comics/', u"Two powerful magicians are at war. One's empire is torn apart by internal turmoil. The other has a 19-year old grudge that is about to reach a new generation. Updates Sundays", False, True)
add('SecretPowerbk1', 'http://secretpower1.smackjeeves.com/comics/', u"Since the begining of time... There's been a power to control all... It's been locked away, and kept a secret... Until now. Jump threw time, control magic, and learn from a new world known as Spartelia. -Author's note- I created this book, about three-four years ago. i was younger and my art style isn't the best, but i have more that are better. But i'm sure the story will be better than the artwork. ~ Enjoy", False, True)
add('SecretPowerbk2', 'http://secretpower2.smackjeeves.com/comics/', u"book 2, please enjoy book 1 and 2, and if your reading this for your every first time, I wouldn't if I were you, because nothing would make sence, read book 1 first before reading this book.", False, True)
add('Seed', 'http://seedcomic.smackjeeves.com/comics/', u'A fantasy story about three individuals in a time of war against magic. Written and illustrated by Julia Philip http://www.seed-comic.com/', False, True)
add('SenoireDelirium', 'http://senoiredelirium.smackjeeves.com/comics/', u"Omnibus of Senoire Delirium 1: Conquer (2007) and Senoire Delirium 2: Rivalry (2009). Updating almost daily. The Senoires were a team of legendary heroes who saved the world and created the magical Madness Pizza Slices. Generations later, a race of candy people took over the world and humans were moved to the artificial internal planet known as the Bernoulli 2. A woman raised four boys to become the next generation of the Senoires and her timing couldn't be better.", False, True)
add('Seppen', 'http://seppen.smackjeeves.com/comics/', u"Yaoi/BL(boy's love) comic first started January 2006 completed April 2011. A Simple love story between a snow spirit servant named Yuki(snow) affectionately nicknamed Seppen (snowflake) by his master/lover Taki. Their simple story of how they met, fall in love and transcend time.", True, True)
add('SeriousTimes', 'http://serioustimes.smackjeeves.com/comics/', u"Let's get serious...", False, True)
add('ShacklesInstallment02', 'http://shackles02.smackjeeves.com/comics/', u'After escaping badly wounded with her target captured, Kas loses conciousness and crashlands on an alien planet. Captured by a tribe of the native aliens, Kas is forced to work together with Otakaog Phimosh, her own prisoner, and she starts to suspect he knows a lot more about her than he should...', False, True)
add('ShamelessAdvertisements', 'http://advertiseat.smackjeeves.com/comics/', u"Ever made a comic that none notice? But do you think the comic would be very successful? Well, you just gotta advertise somewhere, maybe a multi-author comic, but that'll annoy other authors. NOT ANYMORE! In this comic, you can post as many advertisements as you like! Show others your comics, and watch comics from others! That way, everyone will be able to read the latest comics! Please only place advertisements for comics here. So no fillers, no bios, no spritesheets. Don't forget to add a link towards your comic profile in the comments section below the ad! We request that you read the rules & guidelines section if you haven't done so already. Please don't be negative about comics in the comments, no one wants their ad to look bad. For those interested: Last author count: 469 authors (May 23rd 2013)", False, True)
add('ShotoutofCanon', 'http://akumathfs.smackjeeves.com/comics/', u"Shot out of Canon is the new direction for the former Fallout Shelter Comics. Like the Fallout Shelter Comics, it'll be about the forums (and sometimes comics) I go to. Unlike the former Fallout Shelter Comics, this will deal with things besides there. And unlike that, it won't be Canon with my Main Comics. Formerly: My Fallout Shelter Comics I do for the Fallout Shelter: http://z1.invisionfree.com/forums/The_Fallout_Shelter/index.php?act=idx", False, True)
add('ShowcasimusMaximus', 'http://allaboardthesteamtrain.smackjeeves.com/comics/', u"KURONA, FLUTTER AND LYLA SPAM TIME, FOXPUFF SPRITE AND SPAM, LE SPRITE DUMP, PROBLEM WITH STARLO, DUB'S STUFF BIN, AQUA'S SPRITE HOSTING PLACE...THINGY, ZERO'S SPRITE TEST GROUND, THE REALM OF PUNCHY, AND TTLY NOT A RIPOFF MERGE TO FORM SHOWCASIMUS MAXIMUSSSSSSSSSSSS Scar's here too say hi scar yeah this is basically reidy's for lower tiers WHY. ARE. THERE. CHAPTERS. FOR. US. THEN. wut", False, True)
add('SidekBrosOrigins', 'http://sidekbrosorigins.smackjeeves.com/comics/', u'A Sidek Bros (Anak-Anak Sidek) doujin (a manga from my hometown) of incestual proportion Contains rape, incest, brotherhood, yaoi, super sex scenes and the like. Read at your own risk. Updates once a week', True, True)
add('Signifikat', 'http://signifikat.smackjeeves.com/comics/', u"Life's but a walking shadow, a poor player That struts and frets his hour upon the stage And then is heard no more: it is a tale Told by an idiot, full of sound and fury, Signifying nothing.", True, True)
add('SilverVein', 'http://silvervein.smackjeeves.com/comics/', u'Blinder Foxes are widely feared as ferocious beasts, an evil that parallels man. Yet as the not-so-young fox called Whisper finds out, every life has its limits. Beaten down and broken, he is saved by a equally damaged young woman who calls herself "Howl". The two unite under the common goal of revenge but do two broken souls truly make one whole? Meanwhile, a millennia long storm called "The Silver" is tearing the world apart - the answer to a question that no one seems to know.', True, True)
add('SimonSues', 'http://simonsues.smackjeeves.com/comics/', u'Simon, a former law student at the prestigious Haversford campus, has made it his mission to defend the students against demon-like Fiends. Helping him is a mysterious boy named Isaac who has the ability to destroy Fiends that breach their own contracts. But his relationship with Simon is more sinister than it seems... ************************************************* WARNING! Main Comic contains horror, some graphic violence. Bonus Comics contain sexual content/Yaoi. Updates Monday, Wednesday, and Friday! ************************************************* * Check out my tumblr to see process pages and random sketches! http://simonsues.tumblr.com/ You can now read Simon Sues on MangaMagazine.net The comic there will always be a few pages ahead of the updates on SJ. (http://www.mangamagazine.net/manga-and-comics/Simon-Sues/detail-page/221) and on Manga Fox! (http://mangafox.me/manga/simon_sues/)', False, False)
add('SimpleBear', 'http://simplebear.smackjeeves.com/comics/', u'Bear Copenhagen is just a simple bear and nothing else. Spoiler: Not for long. Simple Bear is an action packed, supernatural thrill ride that uses words like this in the summary to make people want to read it. Also this comic features cartoon animals, not "furries." Just thought I\'d throw that out there. Updates about 3 times a week', False, False)
add('SinPararse', 'http://sinpararse.smackjeeves.com/comics/', u'This is a mirror of http://sinpararse.skyscrapersoup.com It updates every friday. This site is updated in a batch every few weeks. Sin Pararse is a prequel to my other comic, but you can read either of them independently. It follows Gabry and Liam, two popular side characters and details how they met and got together. The comic updates every Monday.', False, True)
add('Skate', 'http://skate.smackjeeves.com/comics/', u"'You think you can do anything... how about your rival is better? Outstanding skills, cheatting or maybe something else? Go find out in the confrontation of two strong personalities. Remember: curiosity is the first step to hell...' --- Manga: real life, school life, comedy, action, sports", False, True)
add('Skeptical', 'http://skeptical.smackjeeves.com/comics/', u'A regular slice of life/death romantic comedy about an unusual family and their relations to a group of creatures that call themselves "skull people". Said human family(and half the comic itself) was created by and belongs to TyrannicalShipper! Warning- there\'s an abundance of foul language, and blood. Lots of blood, including the first page. Also, constructive critiques are always appreciated! (Updates sporadically due to the fact that we are both now in college)', False, True)
add('Skooland', 'http://skooland.smackjeeves.com/comics/', u'Skooland is a fictional city in New York. The story focuses on the lives of three brothers: Jet, Kasey, and Tim Jackson; who are apparently talking pencils. The comic is a sitcom focusing on topics such as school, relationships, and family.', False, True)
add('SlashMaximum', 'http://slashmanga.smackjeeves.com/comics/', u"SLASH (SOUL LINKED AEGIS SUPPORTING HEGEMEMONY), is a mysterious power that prevents a person from being harmed or killed, an enhancement for combat and is used to enforce authority among the weak. It can determine one's social superiority to one who possesses it. Not all may have it. Alizeti ekilore, a rich innocent girl from Trifang mansion, suddenly discovered she has it since she survived a strong explosion that killed all her family. Now that she had survived and obtained such power, Alizeti decided to pursue the murderer of her family using her SLASH. Clash, a veteran slasher(SLASH user), will help Alizeti use and strengthen her SLASH in order to find the culprits. Will they succeed in getting justice for Alizeti's family if the killers are the government's strongest Slashers? Will Alizeti and Clash be able to fully understand and utilize their SLASH to counteract their pursuers? In a society where SLASH enhancement and slashers are made, Alizeti and Clash will experience the inevitable. latest chapters here>> http://www.mangamagazine.net/manga-and-comics/SLASH/detail-page/75", False, True)
add('SlipstreamSingularity', 'http://slipstreamsingularity.smackjeeves.com/comics/', u'350 years have passed since the first and only mission beyond Human Occupied Space was launched. In search of the alien intelligence that sent such wondrous knowledge back to Earth, the Odyssey mission was lost. Now, denied their own home world by the rebellion of their own children creations, the Synthetics, humanity has become a race of despots and wanderers that meander through the stars, eking out an existence. Updated Tuesdays and Saturdays.', False, True)
add('Smashandfriendsshowcase', 'http://smashshowcase.smackjeeves.com/comics/', u'This a a showcase in which any spriter can join. Here you can post: Sprites Pixel art Character bios Cool effects Short comics Memes Ads And More! Rules: No flaming, trolling or any of the sort No Porn So Join!!!! And be sure to post often! (If you do not post in like a month or something without reason, you will be taken off) And now, for some quotes from the authors: Smash: sprite! Pocket_Ninja : ......WHO ARE YOU PEOPLE?!?!?!?!?! Luxbot: EFFECTS IS A NECESSITY FOR ME. :< CamTro: No effects for me to sprite and speak as in same time! ~\xe0\xb2\xa0_\xe0\xb2\xa0~ Sspeedo th: I try to sprite but effects and comics work betta under the microscope. Drago: Spritin epic style. A-A-A-A-A-A-AAAAA- *shot*', False, True)
add('SoManyProblems', 'http://somanyproblems.thewebcomic.com/comics/', u"'If Toothpaste For Dinner was less funny' Single panel comics about life, booze, love and... swans(?). Updates 5 times a week.", False, True)
add('SomebodyShootMe', 'http://somebodyshootme.smackjeeves.com/comics/', u"An autobiographical comic chronicling the negative aspects of Kita's life in a light and often humorous manner. P.S. Kita sometimes has a potty mouth. It can only get worse. UPDATES DAILY!", False, True)
add('SomethingLikeaPhenomenon', 'http://somethinglikeaphenomenon.smackjeeves.com/comics/', u'All kinds of love in mid 90s fictional NYC like city. Vampires and other supernatural things included. Updates Wednesdays, unless otherwise specified.', True, True)
add('SongoftheButterfly', 'http://songofthebutterfly.smackjeeves.com/comics/', u'- Little Rim Marie is drawn into another world hidden just under the surface of reality and discovers her self-worth. She is caught in the middle of the eternal struggle between Light and Shadow.', False, True)
add('SonicAuthorAdventII', 'http://saa2.smackjeeves.com/comics/', u'TEH CHAT IS BACK. Dont forget to space between your sentences.- Mr. Jack If you\'ve come to SAAII thinking "Oh my god- another author comic!"- Never fear. this one is the ORIGINAL AND FIRST author comic. Well, it\'s prequel, SAA, run by mostly the the same people, was.-Rikco the Robot Random post of death and doom. ~ Ryan We demand cookies! ~ Shin Guess who\'s back and fluffier than ever! ~ Shard Oh Praise the mightly Lords of the Laziness ~Jayh TEAM JINJO PWNZ YOUR SOULS! AND IM BACK! -2021 Run around for all I care! I have me my flying ceiling! HA! ~Slash Beware the newness! ~3000', False, True)
add('SonicBoom', 'http://sonic-boom.smackjeeves.com/comics/', u"Rules: 1. No random images that have nothing to do with the comic. 2. No content over PG-13. 3. Excessive trolling is prohibited. Some minor jokes are fine, but don't take it too far please. 4. If you're gonna give criticism, be constructive! No blatant insults! 5. Homophobia is also undesired.", False, True)
add('SonicClub', 'http://sonicclub.smackjeeves.com/comics/', u"****RETIRED/DEAD/COMPLETED**** The Characters: Sonic Shadow Amy Tails Knuckles Rouge Capuchino(me) Nikomy(Capuchino's girlfriend) Lola(Capuchino's little sister) Lanz(Capuchino's older brother) Andry(I made him up... he's just a Shadow android) Xavier (Xevious) Degreenfreak Miles-XD(Just Miles) Stochi The Vampire Chao Crackuchino The Hedgehog Crazy China Crappuchino Ghost the Echidna(inlove with Knuckles.. XD) Green Darkness Flame the demon hedgehog Glandor the hedgehog and his brother cendar the fox", False, True)
add('SonicDASH', 'http://sonicdash.smackjeeves.com/comics/', u"Updates Tuesdays and Thursdays. ------- Eight months have passed since the fight against Knuckles beneath South Island. Merlin and Charles, funded by Robotnik Enterprises, are now beginning their expedition to Angel Island. During the middle of a news conference, the Egg Carrier is attacked by a mysterious foe, but a familiar face. It's a race against time as Sonic and Tails must find a way up to Angel Island before the Egg Carrier is destroyed... and Charles and Merlin along with it! In a world covered by endless water, this is the Digger's Adventure Story in Halcyon days.", False, True)
add('SonicSchoolRedo', 'http://sonicschoolredo.smackjeeves.com/comics/', u'THIS COMIC HAS BEEN MOVED TO CRAZY R US.', False, True)
add('SonicUniverseAsk', 'http://sonicuniverseask.smackjeeves.com/comics/', u'HI THERE! Do you read Sonic: Universe, or Sonic Universe- Sides?... No? WELL! Would you like to learn about it? n...no?... AH WELL! Here you can ask the characters anything you wish! And they will answer as they please! Probable Spoilers for the Main Comic', False, True)
add('SonicWorldAdventures', 'http://sonicworldadventures.smackjeeves.com/comics/', u'Sequel/Spin-Off to Metroid Prime: Altina Through a series of unforunate events, Sonic the Hedgehog has found himself in the past with diminished intelligence and memory, and must complete all his previous adventures to create a Synch Nexus, and fix a space-time rip threatening to destroy... STUFF. Previously called: Sonic World Adventure Created by S of Team Dark Nexus! PG Content!! Daily updates!!!', False, True)
add('SonoftheNothing', 'http://sotn.smackjeeves.com/comics/', u'Son of the Nothing is the epic adventure of Seth Rothida, a young soldier who soon will be immersed in the devastating world of the war, but Seth is confident in his ideals, values \u200b\u200band friends who will support it in finding his sister Beth who has disappeared. Update monday & friday night.', False, True)
add('SonoftheNothingspanish', 'http://sotns.smackjeeves.com/comics/', u'Son of the Nothing es la epica aventura de Seth Rothida, un joven soldado que muy pronto se vera inmerso en el devastador mundo de la guerra, sin embargo Seth confia en sus ideales, valores y amigos que lo apoyaran en la busqueda de su hermana Beth que ha desaparecido. Subo lunes y viernes por la noche.', False, True)
add('SoulEye', 'http://souleye.smackjeeves.com/comics/', u"In the pitch black dead of the night, Make sure that you're tucked in tight. If you aren't, you'll surely be A victim to the demon's teeth... The Reaper swoops down in the dark, Hungry for a child's heart. If you see him, don't you scream, Or he'll rip you from your seams... Most of all, though you are scared, Don't once glance upon his face, For if you see his eye of death, Darcia will devour your soul's breath. ----- UPDATES EVERY SATURDAY. *WARNING: Contains BL. For Mature viewers ;A;", True, True)
add('SoulGuardian', 'http://soulguardian.smackjeeves.com/comics/', u'How far would you go...to get home alive? Ren has been kidnapped, and sent to the future. Upon her arrival, a strange cloaked young man finds her. On hearing her circumstances...he offers to help her, for a price. READ: Right to left UPDATES: Wednesday', False, False)
add('SparElricsextras', 'http://sparextras.smackjeeves.com/comics/', u"Just a bunch of random shit that I wanna put up. :P Such as sprite-sheets, W.I.P.s, drawings and more! :D BTW, if you have a problem with that, just click the BACK button and leave. I do NOT tolerate trolls/assholes. Thank you! <33 Also, you're welcome to join in on the fun if you so choose! Just PM me!", False, True)
add('SparkStory', 'http://sparkstory.smackjeeves.com/comics/', u"INSPIRED BY ABBIMAYS RANDOMNESS! Characters w/ quotes: Sniveh: Spark, WHY DID YOU DRAG ME FROM THE FOREST ALL THE WAY OUT HERE?! Brokor: DON'T YOU DARE PRESS THE PURPLE BUTT-*explodes* Dameon: *messing with doofus' radio* Doofus: If you don't stop trying to change the radio station on my tank, I swear to Black Mesa I will come over there with an army of pies! Dameon: *Does a faceplant on the side of the Lor Starcutter* Magolor: SERIOUSLY?! Plazy: Ok now who's ready for SCIENCE! .... anyone Dave: I heard Science. Dub: Dave, get out. You haven't made an appearance yet. T_T Galacta: Galacta is my name, teleporting is my game! Thunderbolt: I met someone named Galacta KNIGHT but never galacta... RJ: NEEDA DISPENSER HERE Deuce:F@!# GRAVITY!", False, True)
add('Spellcross', 'http://spellcross.smackjeeves.com/comics/', u'In the City of Aria, the last great capital of the world, life revolves around mysterious dungeons and the monsters that crawl from them. Adventurers gather from the world over to battle in these dangerous labyrinths, seeking the fame and fortune that comes from exploring them. Follow Caldwell the Alchemist as he strives to raise himself up the ranks of adventurers, to gather a party of friends, and to overcome his fears. Updates three times a week on Monday, Wednesday, and Friday!', False, True)
add('SpiderWings', 'http://spiderwings.smackjeeves.com/comics/', u'This is a story about a girl named Momo, who has a brush with death and is thrown into the world of Limbo...Now she must find away back home but that is easier said than done. Updated: Thursdays Rated-pg-13 Now updating chapter 5', False, True)
add('Spidersilk', 'http://spidersilk.smackjeeves.com/comics/', u"Our story begins in Kalviva, after Prentice and Orestes have made their way south from a distant land. They get stuck doing senseless mercenary work and - feeling unfulfilled - find themselves following other possibly questionable paths. Prentice becomes a thief (admittedly on accident, much to the embarrassment of his new guild mates) and Orestes is forced to follow up with an unsavory, uptight fighter's guild. Well, it's better than the alternative --- looking for lucky slippers never was all that exciting anyway. Updates twice a week, Monday and Friday! Fantasy/ Comedy/ Drama/ Action/ Adventure/ Romance", False, True)
add('SplitScreen', 'http://splitscreencomic.smackjeeves.com/comics/', u"Jan Lumeneski and Jeremy Tanner were inseparable best friends from childhood through high school, but Jan wanted more. When things didn't go her way Jan vowed never to speak to Jeremy again. More than a decade later a chance meeting puts the pair together again, but a lot has happened. Jan is a successful fashion designer while Jeremy is now fat and depressed. Still Jan can't help but feel that old flame burning, but is she just going to end up back where she started?", True, True)
add('Spriterschaos', 'http://spriterschaos.smackjeeves.com/comics/', u'random things happen everyday', False, True)
add('Sprytts', 'http://sprytts.smackjeeves.com/comics/', u'---COMPLETE COMIC--- For the past few hundred years, the two great countrys, Carvia and Gloomland, have been enemies. While Carvia, land of the Sprytts, is full of wonder, delight, and magic, Gloomland, land of the Gools is full of demons, nightmares and violence. Blado, a royal guard to Queen Mellaba, is in search of the mysteries behind his past. Not long after he and three other royal guards encounter the princess, they get caught up in the middle of this international conflict.', False, True)
add('StampedeJessicasStory', 'http://stampedegirl.thewebcomic.com/comics/', u'Youth crime is on the rise in England as the gap between social classes increases. Resulting in an increase in street "gangs." To tackle this problem the government made a plan to reform these unruly teenagers by giving these youths an incentive. Which was providing them with their own housing and "pocket" money but only if they study a course of the government\'s choice, stay out of trouble and attend classes as often as necessary. A quick fix to a very complicated problem. {Stampede:~} Jessica\'s story is about a troubled angry girl stuck under one of the government\'s incentives and her empathetic classmate named Ryam who befriends her. But as Jessica slowly falls back into street gang culture, Ryam also finds himself falling in with her as he tries to help her to stop. Deep into a downward spiral of fight clubs, hatred and gang rivalry. Will both of them get out of it alive or will it end tragically? Is there any hope for a hurt and struggling youth? Has some mature themes and swearing. Based 100% on real life, in my hometown in South London. Its an urban street comic. Updates: Depends. 3-4 pages every week/couple/few weeks max.', False, True)
add('StarTrip', 'http://startrip.smackjeeves.com/comics/', u'Chronicles the travels of a human girl and her alien companion as they visit every habitable planet in the galaxy. Updates a new chapter every two months!', False, True)
add('Stay', 'http://stay-comic.smackjeeves.com/comics/', u"Stay is a comic I started in 2008 and I'm just now uploading it in 2012 >_>; It is a Yaoi comic Description: Lee is just an ordinary dude, he's very studious, studies on the weekends and does well in school, but then he meets Jude - a punk guy with streaks in his hair, piercings and tattoos -- his total opposite! Jude is a mysterious guy with a mysterious past that for some reason wants to be all over Lee the nerd, and as he makes his moves hy-jinks ensue!", True, False)
add('StellaInChrome', 'http://stellainchrome.smackjeeves.com/comics/', u'Lost in the rubble at a condominium development lies a key that unlocks more than doors. Can Stella unlock the mystery that surrounds the key itself? Updated 8:00 PM CST each Wednesday, every Wednesday.', False, False)
add('Stitchpunkchronicles', 'http://stitchpunk.smackjeeves.com/comics/', u'a world were man kind is almost gone and a small band of living rag dolls must continue life', False, True)
add('StrangeBedfellows', 'http://stranfellows.smackjeeves.com/comics/', u'"Strange Bedfellows" is a romantic comedy set in 18th century France. It follows the (mis)adventures of spunky courtesan M\xe1urine, after a chance meeting with a reserved writer, \xc9douard.', False, True)
add('StrangersandFriends', 'http://hemu.smackjeeves.com/comics/', u'The small English town of Wootton Bassett begins to be haunted by a series of mysterious and horrific murders! Hemu, a new-comer to the town, becomes an obvious and easy target to the local community- he does have his fair share of secrets! But what secrets are the other locals hiding? A comic about the peculiar prejudices and customs of small communities, with a hint of social commentary on modern Britain, and a sinister splash of horror ;)', False, False)
add('Striped', 'http://striped.smackjeeves.com/comics/', u"'Altan Silvan is a new transfer student at this highschool. And he's already this popular! But there is something weird about him- he always wears a scarf! Hey, wait, maybe he has a flu... WEll, what's more, since he became one of our students, strange things started to happen at this school! Hey... What's with this blood?! Where's everybody?! Hello?!!' Updated irregularly. Edit: This is my first comic ever, so art is changing and improving (at least I think so xD) with each chapter. WARNING: This comic contains nudity, violence, gore, swearing, because that's how life is.", True, True)
add('SuburbanFreeflow', 'http://suburban-freeflow.smackjeeves.com/comics/', u'That Comic!', False, True)
add('SunmeetsMoon', 'http://sunmeetsmoon.smackjeeves.com/comics/', u"This is a story about a boy and a girl who met in the summer and fell in love. But the end of the summer parted them for a long time. The meeting again wasn't as happy as they expected... Between them stand a lot of differences.She being a loner, attracted by witchcraft and some serious supernatural stuff. He being a sociable fellow with a childish behaviour. But most of all he having a new girlfriend ;) The story has four parts, each one made in a different year: 1. The Riddle ('07) 2. Marg's revenge ('06) 3. Who's that girl? ('07/'08) 4. Passing by Midnight ('08/'09)", False, False)
add('SupaKawaiiSparkleNekoDesuChan', 'http://nekodesuchan.smackjeeves.com/comics/', u"I-it's not like I want to show you my sprites or anything... B-baka...", False, True)
add('SuperDimensionAfterTheHero', 'http://afterthehero.smackjeeves.com/comics/', u"Updates once every weekend. (Mondays count as weekend.) Super-Dimension comics are just the name I give all my superhero comics. This has no relation to any other Super-Dimension comics. Dennis Lockham was Paladin. A guardian superhero of L.A. But now his powers are gone. He's just a man. And that is the one thing he can't take on. Rated 12+ for *&%$'ed cussing, and violence. Neither of much, though.", False, True)
add('SuperMarioBros3', 'http://smb3.smackjeeves.com/comics/', u'The story of the Super Mario Bros. 3 game.', False, True)
add('SupermassiveBlackHoleA', 'http://smbhax.smackjeeves.com/comics/', u'Stories of a human civilization at the center of the Milky Way galaxy: an area of space dominated by a gigantic black hole, where energy is abundant and life is cheap. Updates M-F, usually multiple times per day.', False, True)
add('SurvivorFanCharacters', 'http://sfc.smackjeeves.com/comics/', u'Fan Characters will be competing for $1,000,000.', False, True)
add('SweetandSourCitrus', 'http://lemonscented.smackjeeves.com/comics/', u"The everyday life of brothers Lemon and Lime, as well as their friends, and enemies...and strangers! There is a huge cast of characters and heaps of cameo's and alternate dimensions! So sit back and relax as the duo take you on an adventure of the sooooooouuuuullll! Accepting both new and experienced spriters!", False, True)
add('SwitchMechanism', 'http://switchmechanism.smackjeeves.com/comics/', u'There once was a boy who was not a boy. Who carried stones in his heart. And an astronaut who tried to carry the boy and the stones both. Switch Mechanism- A genetic or environmental trigger which decides which of several possible forms an individual of a species may take. This is a stand-alone sequel to Black and Blue. Updates FRI and SAT', False, True)
add('SwordEnd', 'http://swordend.smackjeeves.com/comics/', u"Kumoshi, is cursed. Ousted from his throne. Magic is illegal. The continent of Meniscus is in utter chaos. What can a mage do when everything you do is against the law, and you have a bounty on your head?! WARNING: This comic has blood, mild gore, nudity and language. Please read with caution. CHAPTER ONE-FOUR: Complete CHAPTER FIVE: Updates until 7/12 CHAPTER SIX: storyboarding Monthly-Bi weekly means: depending on my projects each month, if I'am able to upload in one batch or two separate batches. Updates Faster on Mangamagazine! Though, please don't forget to rate if you enjoy it!", False, True)
add('Symbios', 'http://symbios.smackjeeves.com/comics/', u"Almost every nation in existence has a tale of terrors and hauntings to pass on to their posterity... Xedondria is no different. Their tale was to keep children from doing wrong, and if they behaved, their reward was to sleep with a clear conscience. But if they didn't behave, not only would they suffer the consequences from man, they would also be visited by the Night Horror: a monstrosity only nightmares could bring, only living in one's sleep... Now one must ask: who is it that sleeps, yet suffers the torture of this very real Horror? ***Comic will be marked mature due to any violence or themes, Thank you!***", True, True)
add('TCWFireRedNuzlockeedition', 'http://tcwfirered.smackjeeves.com/comics/', u'Mewtwo completly destroyed the hidden village of the angels in Kanto. One angel survived the disaster. A girl, Sarachan (or sara). Mewtwo let her alive and challenge her to battle him at Cerulean Cave. But first of doing that, Sara should challenge the Gym and the Elite 4. She accepted, but will she make it until the end?', False, True)
add('TEN', 'http://ten.smackjeeves.com/comics/', u'Two years ago our two main characters jumped from a cliff to escape from a life of confinement and torture. The life of a human guineapig They jumped into a unknown future, a unknown destiny... and maybe death. But both of them survived and now, two years later, they meet again...', False, False)
add('TH3D3AD5H0WCA53', 'http://thedeadshowcase.smackjeeves.com/comics/', u"In this show case it is our goal to have every kind of comic shown manga, anime, sprite etc for critique. So here you can advertise and show your comic pages for critiquing the art, layout, special effects, and style of the comic. There will be 5 sections to this comic. The Art section. A place to review, critique, to get help, and show off art work. The Comic section. A place to review, critique, show off comic pages, and to get help. (not the whole comic just individual pages for review on layout and such) The Advertisement section. That one is self explanatory. The Special effects section. A place to get help, tips, and critiques on custom special effects. And The sprite section. A place to review, critique, show off and get help on sprite work. Anyone and everyone is welcome to join. And sadly there are a few rules (TALKING TO YOU TROLLS LOL) Inappropriate content in either comments or other posts will be deleted. Swearing is allowed as long is it isn't offensive, and remember. Critique and help, not troll. Anyways that is all so enjoy!", False, True)
add('TLAAOK', 'http://tlaaok.smackjeeves.com/comics/', u"Percival Livingston may not entirely look the part, but he is one of the world's leading experts when it comes to authenticating rare artifacts. Thus, he is invited by a private collector to take a look at a rather strange find. However, before Percy is able to get a good look at the object, it is stolen by a thief! Oh hell no! Percy chases the man down, but is sucked into another world when he collides with said thief as he happens to be opening an inter dimensional gate! Now Percy has to deal with the thief, get the artifact, and find a way back home! Of course, knowing Percy, he may just want to do a little exploring in between... Warnings: -It's bl. SilverHyena may have an addiction problem... hmmm... -It's rated mature, because I plan on being a bit... tasteless. Yeeees. -It's on crack. Don't expect anything too serious. XP", True, True)
add('TPTruePower', 'http://truepower.smackjeeves.com/comics/', u'A fun comic about friendship, aliens, and flashlights! Updates: Saturdays', False, False)
add('TRIPP', 'http://tripp.smackjeeves.com/comics/', u"The story of an ordinary guy stuck in a never-ending acid trip. Tripp must learn to cope with his new psychotropically enhanced existence with the aid of his spirit guide, Edgar Allan Poe. This comic is not an endorsement of drug use, merely one guy's effort to deal with an accidental, perpetual hallucinatory life change. Updates on Mondays (really Sunday night at 11:45) and Thursdays See the official site at http://trippcomic.com", False, True)
add('TaikiTheWebcomic', 'http://taiki.smackjeeves.com/comics/', u"FINISHED! Taiki is a typical shy 16 year old high school student who is starting the 10th grade with her best friend Nikki. Going into the 2nd half of high school, Taiki thinks it\u2019s strange that she has never liked someone or fallen in love. One day she unexpectedly meets someone who changes all of this. However this person turns out to be a girl! Taiki has always wanted to know what it was like to fall in love, but what she didn\u2019t expect was that finding out would also be a journey of self discovery, realizing her sexuality, and maybe even heartbreak. -IMPORTANT!!- This is a mirror of my own website, check it out if you want to see more artwork --> http://www.taikiwebcomic.com/ This comic was started in 2006, so the art in the beginning isn't very good compared to what it is now. This story contains GL and HL, it is MOSTLY GIRL LOVE THOUGH.", False, False)
add('TailsAdventureThroughTimeandOtherWorlds', 'http://tailsadventure.smackjeeves.com/comics/', u'Tails unexpectedly goes on an adventure through different worlds and even through different times! It all started from falling through a purple portal. How will his adventures go? Credit goes to those who ripped/edited the sprites used for this. None of the characters used belong to me except for my own.', False, True)
add('TakingPicturesofStrangers', 'http://darrenandkale.smackjeeves.com/comics/', u"Darren lived the charmed life of barhopping before he met Kale. It was a new guy every night, lots of drinking, lots of sex, etc. But when he snagged big, quiet Kale, Darren uncovered Kale's secret and set into motion a series of events that lead them both down a path no one expected. Warnings: first and foremost, very gay. Gay romance, gay sex, gay gay gay. If this isn't your cup of tea, you probably shouldn't bother continuing reading. Second, the occasional bad word. Third, booze. (Does booze require a warning? It's not underage drinking or anything.) Fourth; drama and cheeze out the wazoo. Fifth and final warning; very badly drawn. (And probably badly spelled, too.)", True, True)
add('TeamShapes', 'http://teamshapes.smackjeeves.com/comics/', u"There's a team of MS paint creatures that do random events that include fighting Paint.net, rescuing a monster, getting eaten by it, running from a guy who they owe $500 to, doing missions, stopping a time stopping machine, and simply fooling around. Current chapter: Pizzanonoalofisicadoimmahatanio has created something and is probably trying to get his money back.", False, True)
add('TechnicolorLondon', 'http://technicolorlondon.smackjeeves.com/comics/', u"Toby Landon's love life is a bloody mess.His on and off girlfriend has once again tossed him aside. His mate Mark gives him some advice: Try something different. With a kiss, the lives of these two friends go from being black and white to being full of vivid color. No longer a checkerboard, This is Technicolor London. //Yaoi/Boylove Plus a little bit of everything else// //Updates are Every Tuesday & Friday//", False, False)
add('Tenwaysbendystrawssavedmylife', 'http://bendystraws.smackjeeves.com/comics/', u'an informal window into the way i saw/see life as a teenager and young adult told though the adventures of two rather ordinary kids', False, True)
add('ThatWasntThereYesterday', 'http://twty.smackjeeves.com/comics/', u'A mysterious stranger meets a mysterious road.', False, False)
add('ThatsMyBoh', 'http://tmb.smackjeeves.com/comics/', u'Updates whenever the hell I feel like updating it.', False, True)
add('The13thWorld', 'http://the13thworld.smackjeeves.com/comics/', u"In the galaxy known as Andromeda ruled by the Goddess Palutena; creatures known as O'phans rule the thirteen worlds and it is up to her chosen followers to save and bring peace to the thirteen planets. This is a mashup of several anime and video game worlds.", False, True)
add('The3rd', 'http://the3rd.smackjeeves.com/comics/', u'The 3rd is a tale of war and strife set in a fictional world filled with magic and mystery. The story follows Max a young soldier that finds himself thrust into a world much bigger than he is. In his journey Max will discover who he really is.', False, True)
add('TheAlliance', 'http://alliance.smackjeeves.com/comics/', u'The year is 3010... The earth has become a poisoned shadow of what it once was. The sky has stained red, a symbol of the endless wars that had emerged below. Animals mutated from the toxic atmosphere that own the lands. Mankind itself has even been mutated. For some, their DNA being matched with various animals. And others gaining different attributes from their darkening hearts. Human kind has now fled to giant toxin purified domes. But even this is beginning to become less then what they need to survive. Their minds have been polluted with evil. Darkness surrounds their hearts. Now there is only one hope........ The Alliance. Contains Violence, blood, romance... Eventually... My comic is BOYXGIRL.', False, True)
add('TheAntihero', 'http://antihero.smackjeeves.com/comics/', u"Most stories have good guys and bad. Some have only good guys, but with antagonists. Then some have only dastardly villains trying to do villainous things to decent people while all along screaming at the top of their lungs into the rain. This is one of those comics This is also a very depressing comic. Seriously. Every chapter is 'death' in a different language, and each title page is the Protagonist about to die. ... I told you it was depressing. Anyways, don't let that stop you! It takes place 20 years in the future. The U.S. has deteriorated into a kind of middle-ages scenario, where the government is corrupt, inflation rules, and the Mafia basically control the country. It doesn't get any better than that. But Isaac, the commander of the NY Mafia, notices there's a new gang in town. The Redblades. And there's something familiar about the commander... I'd rate it about 12+. There's mild gore, blood, and violence. Also comic cussing (!@#$%^& it!). And it's basically aimed at an older audiance, but if you're okay with the above, go ahead.", False, False)
add('TheAttackoftheRecoloursSeason1', 'http://mysticalvalley.smackjeeves.com/comics/', u'The Recolours are attacking and the edits will have to eliminate them. Flash, Leeroy and Kedar500 are creating the recolors and sending them out to fight but Sonic, Josephk and others who are preventing them from succeeding. Will they save the world from whatever Flash and Kedar500 are planning? Read the Seasons and find out! Warning: Mild Language may be used *Completed*', False, True)
add('TheAvianStories', 'http://theavianstories.smackjeeves.com/comics/', u'Sybil and Zakk are a pair of mythical humanoid avian monsters called avians with spirits of birds. When they meet each other they are spewed into a quest to stop genocidal acts on humans from a rouge group of avians.', False, True)
add('TheBookofNosferatu', 'http://www.thebookofnosferatu.com/comics/', u'Two unusual sisters strive to survive a post apocalyptic world where supernatural creatures reign supreme.', False, True)
add('TheBrideoftheShark', 'http://sameyome.smackjeeves.com/comics/', u"Toshio is a pearl diver, dealing with his love problems in Onjuku. 'Ehukai is a shark, instantly falling in love with the boy and claiming him his wife in front of his family...", True, False)
add('TheBrightmoonChronicles', 'http://brightmoonchronicles.smackjeeves.com/comics/', u'Heimr. A world ruled by Monarchies, Academies and the Guilds. In a bid to gain supremacy in the world, Caelum Academy sends two brothers to find two ancient artifacts. These artifacts were said to be forged by the Gods of old who once ruled Heimr and said to contain the ancient powers and knowledge of these Gods. And with the sudden disappearance of their father, Maximilian and Lucas Gabriel are in way over their heads. Updates on Fridays. (Normally colour. Black and white for the moment though)', False, True)
add('TheBucket', 'http://thebucket.smackjeeves.com/comics/', u'An art/comic journal as well as a collection of memes, scraps, and deep artwork and stuff. Also includes a psychological side story, "ENS Special". Updates daily (if not, extra updates).', False, True)
add('TheCafedAlizee', 'http://alizee.smackjeeves.com/comics/', u"Eliza Jones always had a dream of opening a cafe, but met a tragic fate before she ever could. Thus, the Caf\xe9 d'Alizee was opened in her honor. This story really isn't about her, though. Instead, this story follows the interesting, strange, and in some cases eccentric staff of the Cafe d'Alizee as they wander through the trials and tribulations of life. They may not know where they are going, but they have the four most important things in the world: love, life, coffee, and cake. *Updates every Monday and Thursday.* P.S. I should also mention that because this comic deals with the lives of various people, there may be situations that include relationships of any gender combination as well as violence or sexual situations, but there will be nothing graphic. So because they are (mostly) all adults, expect adult situations to occur. :)", False, False)
add('TheClass', 'http://www.theclasscomic.com/comics/', u'The Class is a story about high school students learning to deal with growing up while being confronted with the ability to use powers and fight a growing evil. Written by Jaysen Headley and Illustrated by Jessi Jordan. For more news and info, check out our blog at www.theclasscomic.com', False, True)
add('TheColony', 'http://thecolony.smackjeeves.com/comics/', u"In the secluded hills of upstate New York, there is a place known only to few. It is a haven for all things macabre; werewolves, vampires, zombies. If you fear it, chances are it resides there. Every 300 years, a new regent is crowned, and this time you're invited to the ceremony. The Colony is updated every Tuesday, so come on back!", True, True)
add('TheContract', 'http://the-contract.smackjeeves.com/comics/', u'After a series of dreams, Starken wakes up in another world. There he meets Phalarin, a demon who seems harmless.', False, True)
add('TheCrimsonVirusAPokemonEmeraldNuzlockeComic', 'http://thecrimsonvirus.smackjeeves.com/comics/', u"Jumping on the bandwagon with my first nuzlocke and my first webcomic. For those who are unfamiliar with what a Nuzlocke is, here are the rules: 1.) Pokemon that are KO'd are considered dead and must be permanently placed in a box or released. If all your Pokemon in your party die (aka you whiteout) you lose. 2.) You are only allowed to catch the first Pokemon you find in each route. If you kill it or run away, you are not allowed to catch anymore Pokemon in that route. This includes fishing. (Shiny Pokemon are exempted from this rule because they're cool) 3.) You must nickname every Pokemon you catch. 4.) No legendaries. 5.)No Day Care Center", False, True)
add('TheDarkAgeofMobius', 'http://thedarkageofmobius.smackjeeves.com/comics/', u'It was 20 years ago that the Emerald war began. Many died. Sonic, and Eggman are but a few. There were, however, survivers. A mysterious overlord has taken over much of the world. There are those who oppose him. This is the story of one.', False, True)
add('TheDemonicAdventuresofAngelWitchPita', 'http://angelwitchpita.smackjeeves.com/comics/', u"Reading a book is innocent enough, right? Except when you're Pita, and reading the book releases hundreds of demons and their leader, and all of them are craving for a bit of...action. Enter a (pig) cherub-in-training named Buhi, who then puts Pita in a contract to take care of each and every one of the demons, add a little bit of Magical Girl bibbity boo, and now you have the start of the story.", True, True)
add('TheDestroyer', 'http://heartless-destroyer.smackjeeves.com/comics/', u"A Shadow-cat demon named Kairo Ventaiga finds his solitude interrupted when he finds out his family isn't dead. However, he's gotten used to his deadly lifestyle and doesn't want to change... In a neighboring kingdom, Princess Nicole, a daughter of Light, doesn't want her father's crown. She is strangely sympathetic toward Shadow demons, her kind's mortal enemy. She's determined to befriend the Destroyer; perhaps she knows something Kairo doesn't... Reilyn Ventaiga only wants to find out what happened to his parents the night Kairo disappeared, but getting any answers out of his brother is looking more and more impossible... TakJak, a former thief, starts to notice that the Heartless Destroyer isn't as heartless as he seems... Updates: every Saturday with one or two pages Warning for minors: contains prevalent cursing, blood and gore, violence, and maaaybe farther down the line, partial nudity or hints at it. Also gay people. If you don't like any of the above, I'd advise against reading my comic.", True, True)
add('TheDragonandtheLemur', 'http://dal.smackjeeves.com/comics/', u'The Dragon and the Lemur is a web manga drawn by Vilani Vil\xe1 and scripted by the same and CherryVincent. In few words, a RP between the artist and CherryVincent, which Vilani decided to transform into a Manga. D.a.L (for short) tells us the story of two characters, Hakakku (a humanoid, hybrid between Cat and a Lemur) and Chain (a humanoid, dragon). They both met, probably not under the best circumstances and ended up falling in love. The script is currently finished. This comic contains explicit content and homosexual relationships. Bestiality/shota/incest may be often mentioned. May have blood and gore. NC-17 YAOI/HENTAI/YURI Update schedule: MONDAY Started: Sept 2005 Status: On going', True, True)
add('TheDump', 'http://the1dump.smackjeeves.com/comics/', u"A dumb of random pics and comics, i'll try to upload at least once a week, hopefully more.", False, True)
add('TheElectricRose', 'http://electricrosecomic.smackjeeves.com/comics/', u'What happens when three normal girls in high school are ripped straight out of their beds and brought to a completely different planet? Why, they\u2019re asked to save it, of course! Agreeing to become a Barrier Guardian could mean the lives of Elysia and her friends, but choosing not to could mean the end of their world. So what do they do? And will these three girls even survive long enough to decide?', False, True)
add('TheEssyaneWarriors', 'http://essyane.smackjeeves.com/comics/', u"EDIT: the site will reverse back to its former address http://essyane.smackjeeves.com from April 13th. Don't forget to update your bookmark! A heroic fantasy manga, where revenge and lies are the main allies for a resentful queen. And only the Essyane Warriors can provide a proper revenge to her master plan... The trick is to find them and wake them from a very powerful spell. Updates every Wednesday.", False, False)
add('TheGlassisBroken', 'http://glassisbroken.smackjeeves.com/comics/', u'The glass is not just half empty, it is broken.', False, True)
add('TheGoldRiderofPern', 'http://goldrider.smackjeeves.com/comics/', u"I started this comic a little over a year ago, and it's been going strong ever since. Taking place in the 3rd pass of Pernese history, K'mlar, a young genius Masterweaver was placed at Ista Weyr as his first appointment after being given the station of Master. There he impresses a young Gold hatchling, an event completely unheard of in Pernese history. Despite being aggressively anti-social, he manages to make a place for himself at the Weyr that he never would have dreamed possible.", False, True)
add('TheGrayZone', 'http://thegrayzone.smackjeeves.com/comics/', u'A daily cartoon featuring the lives of extraterrestrial "grays"', False, True)
add('TheHeadhunters', 'http://headhunters.smackjeeves.com/comics/', u"It's about people trying to capture a floating head. Every Mondays, Wednesdays and Saturdays.", False, True)
add('TheHorribles', 'http://thehorribles.smackjeeves.com/comics/', u'Things that go bump in the night! Monkeys that dance and a Creature that rants. Monsters that snap and bite! A comic for kids of all ages. Updates every Tuesday!', False, True)
add('TheJosephComics', 'http://josephcomics.smackjeeves.com/comics/', u'What started out as "Joseph and His Comics" in 2003 became the first minimal comic strip series by amateur cartoonist Joseph Scarbrough. The comic centered around fifteen-year-old Joseph Armstrong - just you\'re typical, average, American teenager who just so happens to get himself in and out of random situations that give way to continuing storylines with serial cliffhangers much like the old "Rocky and Bullwinkle" show (which adopted said format from old movies and westerns of the 50s). In 2004, Scarbrough "revamped" the comic strips, renamed it to simply "Joseph Comics" which carried on until Scarbrough announced his retiring from comic strips, thus making Joseph and his friends find their place in the Old Cartoon Stars Retirement Home permanently come 2008.', False, True)
add('TheKeyHotelEnding', 'http://tekeyhotel.smackjeeves.com/comics/', u'Alright, the Key was fun while it lasted, but due to a lack of updates and interaction, I must shut down the Key Hotel. It now belongs to SteamingBullets Uboa. See ya!', False, True)
add('TheKwiddexProtocol', 'http://kwiddexprotocol.smackjeeves.com/comics/', u'Welcome to Satellite Falls. Starstorm has returned after a 15-year absence. So has the White Rose. Plus there\'s a monster tearing up the city. Now, it\'s up to disgraced cop Jerry Binder to find out just what the hell is going on in his city and just what the hell "The Kwiddex Protocol" means. The Kwiddex Protocol is updated every Monday, so come on back!', False, False)
add('TheLegendaryQueen', 'http://legendaryqueen.smackjeeves.com/comics/', u"Being drawn, then written out, this comic is about my character Crystal, a normal 15-year old hedgehog who soon finds out she's worth much more than she ever believed she could be. There will be love, fighting, death..friendship..and above all else, family and self importance. Journey along with her, as she becomes what everyone has been waiting for...and stays true to herself! Updates: Whenever I get pages drawn XD", True, True)
add('TheLegendofMushroomKingdom', 'http://lomk.smackjeeves.com/comics/', u"To put it simply, this is a crossover fan-fictional graphic novel featuring the Super Mario Brothers and Legend of Zelda franchise. Mario and Zelda are the two of the most well-known franchises in Nintendo, not to mention my two favorite video game franchises. It's pretty long, so get the popcorn and drinks ready :D Characters in this story are properties of (c) Nintendo", False, True)
add('TheLifeofMagFlamequill', 'http://lifeofmag.smackjeeves.com/comics/', u"The coming of age ceremony is tomorrow. Participants will take their birth-feathers and soar gracefully into the sky, cheered on by their proud friends and relatives. But what if you're Mag Flamequill, the bird-woman with a fear of heights?", False, True)
add('TheLoneSwordsman', 'http://theloneswordsman.smackjeeves.com/comics/', u"Heaven has fallen, including its Leader, Aven, thanks to the Demon King Shutendoji's new Elite Demons. Now Shutendoji has his eyes set on Earth. Can a Lone Swordsman wielding Aven's sword stand a chance against such hopeless odds? Or will the madness of the souls he must absorb destroy him from the inside? Rated PG-13 due to cartoon violence, blood and mild language. The Lone Swordsman and all related subsidiaries are property of Sol's Dawning Creations. The use of such without permission for the purpose of monetary gain is illegal and will be met with legal action.", False, True)
add('TheMegaManandSonicSpriteShowcase', 'http://megamanshowcase.smackjeeves.com/comics/', u"Credit to all the authors listed for the sprites. We do 8 bit, 16, bit and 32 bit sprites (mostly 8 bit) and Sonic sprites. WE TAKE REQUESTS. no trolling, flaming, cussing (some allowed) and ABSOLUTELY NO STEALING SPRITES AND DON'T CLAIM ANY AS YOUR OWN, unless you actually made them and your part of this showcase. *One new rule: I would like to address the fact that THIS IS NO LONGER A SHOWCASE WHERE WE POST RESOURCE SPRITES OR SPRITES WE DIDN'T MAKE! I'm gonna remove the sheets that aren't ours soon. any body else that posts anything that isn't theirs will be punished, if caught, with the following: 1st offense: a warning. 2nd offense: comment privilege taken away. 3rd offense: uploading privilege taken away Anything past the third offense will result in removal from this comic.", False, True)
add('TheMewExperiment', 'http://themewexperiment.smackjeeves.com/comics/', u'A Tokyo Mew Mew spinoff about a genetically engineered mew and her fight for freedom against the aliens hired for the sole purpose of her capture. However, an accident robbed her of her memories and she must relearn her forgotten powers in order to survive. The comic is for practice, so please ignore the bad art! (Especially in the first two chapters.) Also, you do not need to be familiar with the series Tokyo Mew Mew whatsoever to read! Read from right to left! Updates about every 4 or 5 days (usually hopefully)!', False, True)
add('TheMitchellEffect', 'http://themitchelleffect.smackjeeves.com/comics/', u'A typical tale of an ordinary teenager who accidentally summons a demon that eats all his snacks and smokes all his good weed. You know.....a classic :) If you like what you see here come friend me on Facebook for more goodies and funny content: Cornelius Goodfellar', False, True)
add('TheMurderofMe', 'http://themurderofme.smackjeeves.com/comics/', u'Every new beginning, Must have an end. Sonic the hedgehog is a hero who never gives in, Shadow the Hedgehog is a creature with a dark past, and Silver the hedgehog is a kid who just wants justice. Together, these three characters will have to play the most dangerous game of all: The Survial game.', False, True)
add('TheNightSurfers', 'http://thenightsurfers.smackjeeves.com/comics/', u'When the coastal city of Costa Nueva is threatened by sand creatures sent by a mysterious evil, four teenagers rise from tragedy to become heroes. They are The Night Surfers. Read it here at Smack Jeeves, or get even more content and the most recent updates at thenightsurfers.com!', False, True)
add('ThePirateBalthasar', 'http://thepiratebalthasar.smackjeeves.com/comics/', u'Wilson Kane wins a fortune and his future bride at a game of dice from the former pirate Balthasar. When he decides to go and get the girl, the pirate way, by kidnapping her, not only he finds out that she is more than a pirate could ever want from a wife... but that she has 4 identical sisters as well. This discovery hits him when his men, who were supposed to help him out, each kidnaps a different girl... and none of them gets the right one! But Wilson Kane wants the girl he had met and no one else! Luckily for him it will be the girl herself to solve his problem and put an end to his dilemma... a solution that will eventually fling her into a new way of life, aboard the Alidivento, across the Mediterranea sea!', False, False)
add('ThePrincessandtheGiant', 'http://princess.smackjeeves.com/comics/', u'A silent fairytale about a young princess and another, rather larger individual. Updates Sundays.', False, True)
add('TheProtector', 'http://protectorcomic.smackjeeves.com/comics/', u"A story about a boy and his protector. Set in the country of Senobia, a young boy is set on the path of destiny. His companion is one of the country's most celebrated heroes. What adventures awaits the two of them? Started in 2008 and continued in 2010. This is not a BL, it contains little to no sexual scenes at all, this is an adventure story. If you want porn linked to this story (only between adults of course), then please feel free to read my companion story, Sacrifices. Updates Sundays http://sacrificescomic.smackjeeves.com/", False, True)
add('TheRandomObscureFairyTaleNoOnesEverReallyHeardOf', 'http://tro.smackjeeves.com/comics/', u"Yeah, so I ran out of characters for the title. Trust the banner. 12-year-old girl Wolfgang Rock manages to convince her mom to let her stay with her ex-uncle-in-law-in-law instead of having to move. Soon enough, however, the said uncle, Dieter Jung, starts to have an innocent crush on the girl... This was the first full-length comic I ever did. Don't mind the amateur art and the fact that its unrealistic story could only be written by a child (indeed it was) and the JPEG fuzziness and and and... *COMPLETED! *Reads left to right *Not suitable for impressionable young girls/adult men with developing complexes *Nothing inherently inappropriate, either *The original comic before He Who Has Partners, which apparently takes place in an alternate universe", False, False)
add('TheReborn', 'http://reborn.smackjeeves.com/comics/', u'Every teenage girl looks forward to her sixteenth birthday, and Angela is no exception. But on that day her life turns upside. Angela learns a stunning secret about herself, and finds herself caught up in war between two demon clans. Updated Mondays and Fridays. This comic may not be suitable for younger readers. It may contain violence, gore, occasional bad language and other stuff that may not be appropiate for readers under 13.', False, False)
add('TheSilverLeague', 'http://thesilverleague.smackjeeves.com/comics/', u'The Silver League is a comic based around the members of the site of the same name and placing them in our own interpretation of the Pokemon World. Silver August of Harvestone Town is a teen that never really knew life outside his hometown; however after rescuing his Sister from the hands of Team Reaction, Silver becomes motivated to explore the world as a Pok\xc3\xa9mon Trainer! However on his journey, Silver discovers that behind the battles he\'d watch on TV lies corruption because of devices known as "Modifiers" that allow a Trainer to alter a Pokemon\'s stats by force without having to earn them through training. This leads Silver and the friends he makes along the way to form "The Silver League Movement" which vows to travel the region, collecting badges but also recruiting Gym Leaders and convincing them to join their cause so that they can form a league of their own, take down the Team Reaction organization and bring honour, fun and hard work back to Pokemon Battles! http://www.thesilverleague.com/', False, True)
add('TheSixthBar', 'http://thesixthbar.smackjeeves.com/comics/', u'The war between Del-Naaj and Saam-Sara has ended, but Nero knows otherwise. A false peace has been created by the Del-Naajan fear of the Saam-Saran psychics. Torn by the death of his close companion Lynn, Nero has trained for the past six years, sharpening his skills so that he may better protect his city. But a plot is brewing: a plot that will rekindle hostilities between the two cities.', False, True)
add('TheSomewhereOther', 'http://somewhere-other.smackjeeves.com/comics/', u"You don't exist after you've fallen into the Somewhere-Other.", False, True)
add('TheSpritersShowcase30', 'http://thespritersshowcase3.smackjeeves.com/comics/', u"Welcome to the third installment of the spriter's showcase! RULES 1.Give credit for any and all sprite sheets. 2.Treat all other authors with respect. Critique is fine. Flaming isn\u2019t. 3.Stick to a posting schedule. (Whatever works for you. Just don\u2019t post one thing and go missing for a month.) 4.No adult content. 5. No recolors or very easy edits are to be posted, this rule is only in place to keep you from getting flamed/trolled. Recolors are looked down upon in this comic. 6. Spriters must have at least some experience with sprites before applying to join. If they do not, their application will be denied. 7. Flaming, spam, and arguing in the comments will not be tolerated, and will be deleted. If you have any questions, concerns, or suggestions, drop a PM my way. -Noland", False, True)
add('TheSummerofBlakeSinclair', 'http://blake-sinclair.smackjeeves.com/comics/', u"A slice of life comic set in the summer of a student's university life. about hipsters, Punks, and ultimately self reflection and 'honesty'. This comic is Apparently what you would call a 'social comedy' and a sattire on generation Y. loosely based on my recently passed student experiences =) Hopefuly this comic will remind you of summer when you read it; enjoy!", False, True)
add('TheTalesofSerendipity', 'http://talesofserendipity.smackjeeves.com/comics/', u'Serendipity is the phenomenon of finding wonderful things you were never searching for. With that said, join the herd into the land of Equestria and beyond, seeing the intertwining lives of the ponies who live there.', False, True)
add('TheTimeDog', 'http://timedog.smackjeeves.com/comics/', u'Ayaka travels through time with "the time-dog". A strange and weird story :)', False, True)
add('TheTytonNuzlockeChallengeEmeraldEdition', 'http://tytonnuzlockeemerald.smackjeeves.com/comics/', u"[Working on: Page 552] Kids, I'm going to tell you a story. The story of how I... no, wait. Sorry. Welcome to the Tyton Nuzlocke Challenge, a character-driven graphic novel created entirely in Microsoft Paint. It updates daily, including weekends, holidays, and apocalypses (apocalypsi?). In a world overrun with eager trainers, the Pokemon Administration has taken desperate measures to ensure the remaining wild Pokemon survive, while allowing trainers to continue their paths. This has resulted in the limiting of catching wild Pokemon, the banning of certain items, and finally--the closing of Pokemon Resurrection Stations in all Pokemon Centers. Enter Tyton. He's thirteen and has less than a year to get all the way to the Pokemon League. Join him and his team as they follow the road to the Elite Four, get wrapped up in the schemes of Teams Aqua and Magma, and (possibly) uncover the mystery of Scott the poofy-haired stalker. There's also a Latin ladies' man Lombre, a swagalicious Gloom, a Numel that hates everyone he's ever met, a firecracker of a Whismur, and the most lovable Dustox you've ever seen. But we'll get to that.", False, False)
add('TheWastelands', 'http://wastelands.smackjeeves.com/comics/', u'A world abandoned by its Gods and the people who find out why. Did they really abandon their people? Updated Sundays. Updated more frequently at Manga Magazine http://www.mangamagazine.net/manga-and-comics/The-Wastelands/detail-page/2864?lang=en', False, True)
add('TheWhiteTower', 'http://thewhitetower.smackjeeves.com/comics/', u'Cotton has no memory of who he is. He just woke up from a seven month coma. His hair is completely gone. And no one is telling him anything. A sci-fi/mystery/drama comic. Warning: partial nudity, some violence and cursing.', False, True)
add('TheWinterCampaign', 'http://winterc.smackjeeves.com/comics/', u'Japan, 1919. 16-year-old Akio and his mother move into a new home with the mysterious Kikugawa family: A secretive father, a fragile and reclusive son, and the shadow of a mother whose death years ago may be more than it appears. The lines between truth and fantasy, and friend and enemy begin to blur as winter sets in... Drama/Historical/Coming-Of-Age/Romance? Contains angsty teenagers, Taishou-era geekery on the part of the author, and some BL. Updates once or twice a week.', False, True)
add('TheYoshiHerd', 'http://theyoshiherd.smackjeeves.com/comics/', u"A comic about a young Yoshi, and his efforts to become a hero. To evolve, become something more than he was meant to be; little does he know, more people than he alone depend on this. I swear, it's better than it sounds. Not by a LOT but it IS. The Yoshi Herd. Wish I could say it's updated weekly - so I decided to start updating weekly! Every Wednesday, usually late at night - Australian time anyway - point is, there's roughly a six hour window every Wednesday where you might see it pop up. But, uh, keep it on the down-low. People might start EXPECTING it to update. As if it was MAKING A COMEBACK or something. So this? This is between you, and me. If you tell anyone - look, just don't tell anyone. You don't wanna know, capiche?", False, True)
add('Theatrics', 'http://theatrics.smackjeeves.com/comics/', u'A weekly movie review comic, starring two ruthless critics who will bash a different cinematic release, both new blockbusters and obscure classics, every week. By Itamar Katz', False, True)
add('ThehumanBEing', 'http://thehumanbeing.smackjeeves.com/comics/', u'"A story about friends and enemies; love and hate; forgiving and forgetting; holding on and letting go. A story about being human, and being MORE..." Follow the story of ten friends as they survive college, friendship, love, and life in general. No matter who we are, what we know, or what we believe, we are all HUMAN. Updates: Fridays (sometimes Saturdays) Reads left to right', False, False)
add('TheiaMania', 'http://theia-mania.smackjeeves.com/comics/', u"My own take on Greek mythology. It's like the gods would have been ordinary people, i.e. no superheroes, no big action. Rather, it's everyday relation life and philosophical, although sometimes emotionally charged (like real life). Occasionally though, the gods have a magical trick or two up their sleeve. :) Join Hermes, Hades, Persephone, Athena and the others as they try to deal with themselves, their complicated family and those strange humans. NEKYIA: A journey down to the Underworld. A philosopher and a necromantic priestess enter Hades' realm to find the answer to the question what a good life really is. At the same time, the messenger god Hermes arrives with a message to Hades... DADDY'S GIRL: Athena is miraculously born from her father's head. She's stronger and more intelligent than most people, but deep down she is just a confused child who tries to understand herself, her family and the world around her. This story takes place long before the events in NEKYIA. HERO BONES: A short story about Hermes, love and fossils. Has some mature content, but nothing too explicit. Takes place after NEKYIA Updates usually once a week.", False, True)
add('Themadman', 'http://themadman.smackjeeves.com/comics/', u'everyday insanity, taking what life throws at you just a notch further to show what could happen^^ updates once a week', False, True)
add('ThiefCatcherRingTail', 'http://tcringtail.smackjeeves.com/comics/', u"RingTail is the hero name of the main character, Lynia, who is actually formally a thief! After her family is arrested she is hired by her rich, genius classmate Rose to test out her superhero inventions. Together, they stop thieves and uncover the sinister plot of Arcadio, Lynia's former employer. This comic reads Left to Right.", False, True)
add('ThinkBeforeYouThink', 'http://thinkbeforeyouthink.smackjeeves.com/comics/', u'A funny, awkward, and spontaneous comic about a guy who can read minds. Updates Fridays.', False, True)
add('ThisistheWorstIdeaYouveEverHad', 'http://twiyeh.smackjeeves.com/comics/', u'TWIYEH! is a an urban fantasy comic about idiots with magic powers and also there are monsters and stuff. This is a mirror of the main site located at http://worstidea.skyscrapersoup.com The comic updates there a couple days earlier than I post it here. I batch update over here every 10 pages or so.', False, True)
add('ThornTopia', 'http://tnt100.smackjeeves.com/comics/', u"Thorn is reknown for her alts. This a showcase of all the ones she's got! This series is now completed! Many thanks to all the contributors and followers for sticking around!", False, True)
add('TimeWastingStuff', 'http://timewastingstuff.smackjeeves.com/comics/', u'Aha just a place to put stuff? Sketches and such, sometimes memories, exaggerated things, whatever I feel like putting. Nothing special, read if you wanna see half assed and random inconsistent art XD', False, True)
add('TinyPinkRobots', 'http://tinypinkrobots.smackjeeves.com/comics/', u'Featuring me, my beatnik lumberjack husband, mild cat torture, dancing and the occasional tiny robot. Updates Monday & Wednesday!', False, True)
add('TitleUnrelated', 'http://www.titleunrelated.com/comics/', u'The Newest Iteration.', False, True)
add('TotalDramaSurvivor', 'http://totaldramasurvivor.smackjeeves.com/comics/', u"We're bringing back some of your favorite Total Drama contestants for a chance at another million dollars! Who will win? Who will lose? Find out here... on Total Drama Survivor!", False, True)
add('TotallyCrossover', 'http://totallycrossover.smackjeeves.com/comics/', u'There are a lot of typical generic gaming webcomics out there. This one, however, is not one of them. Where most comics are fully happy to parody the gaming world one game at a time, Totally Crossover will parody them all. At the same time. The gaming stars of 2010 unite to face an unknown enemy which could destroy all of time and space itself. This should be fun.', False, True)
add('TransUMan', 'http://transuman.smackjeeves.com/comics/', u'Mutants. Aliens and Zombies, Oh My! It starts simply enough: another day of survival. But then...', True, True)
add('Transfusions', 'http://transfusions.smackjeeves.com/comics/', u"Boy meets a vampire. What happens when they get to know each other? This comic will have lotsa boylove stuff in it, so if you have a problem with that, get rid of that problem and then come back here and enjoy the comic. If you don't have a problem with BL then... enjoy the comic anyways!<3 Updates every Sunday.", False, True)
add('TrillyAndSilly', 'http://trillysilly.smackjeeves.com/comics/', u"This usefull story written by Cynthia and Debby alias Silerna(Silly) and Trilly for those who could use a little edge. Follow their daily shabbies and meet lots of new strange creatures. Give their furry companion and Cynthia's best friend Kitty a big hug and she shall teach you the important things in life as well! Each chapter includes a few short-comic stories that you will enjoy! Seriously... don't try this at home alright ? ~ This comic reads from left to right.", False, True)
add('TroubledWatersAnEmeraldNuzlocke', 'http://troubledwaters.smackjeeves.com/comics/', u"Thrown into the midst of a terrible disaster in the Pok\xe9mon world, KK must get to the bottom of the mystery - before it's too late. Lives are at stake, the world of Pok\xe9mon is falling into ruin, and the team has to try and find out where the Nuzlocke disease came from. Only danger lies down that road, but that's where destiny leads. Of course, because Professor Birch asked him to do it, he's got to take a Pok\xe9dex with him too. Go figure. _______________ Updates every Monday at 00:00 GMT.", False, True)
add('Troublenextdoor', 'http://troublenextdoor.smackjeeves.com/comics/', u"Ilona hates her new neighbor! Sure he might be a tall, athletic, motorcycle-riding hot model kind of a guy but he's snarky and rude. Just like the jocks in school that used to make fun of Ilona because she was a nerdy tomboy girl. And did he say something about Ilona's panties?! This means war! Ilona wants him gone, right now! Because he's a horrible person...but wait, he actually has a kind side? ...and how come he's always helping her out when she's in a pinch? this is...(you guessed it!) a BOYxGIRL romance sprinkled with a lot of humor and a few tearjerking moments. Hand-drawn, scanned and screentoned.", False, True)
add('UTENSIL', 'http://utensil.smackjeeves.com/comics/', u"U,T.E:N.S.I.L. is an experimental comic with light romance, random humor, and gag action. And the story...? Well... Ninja-wannabes are out to steal cakes. Love Triangle. Maybe drama. Warning: Do NOT take this story too seriously... if there is one. It's an experiment, a learning tool for me. Critique is welcomed.", False, True)
add('UglyBoysLove', 'http://shounenai.smackjeeves.com/comics/', u'', False, True)
add('Uglygame', 'http://uglygame.smackjeeves.com/comics/', u'so takumis had a crush on his teacher mr. asakura (who he lovingly call sensei) for a long time now, but there are these dumb games that the girls play to see who can get a specific teacher to fall in love with them first, then dump them afterwards. and asakura\u2019s next in the game. not only that, but this kid satoru, whos always bullying takumi, is getting in on the game too and according to everyone hes in the lead. takumi knows what a little shit satoru is and doesn\u2019t want sensei to get hurt, and basically gets tricked into playing the game too. now hes gotta get sensei to fall in love with him before its too late. plots based off scramble game (it made me so mad I thought I could do it better HA) reads from left to right bl/yaoi will have nasty stuff later on~~', False, True)
add('Ugnis', 'http://ugnis.smackjeeves.com/comics/', u"Elizabeth is cursed by flames that disrupt her personality and shorten her lifespan when she uses them. She decided to abandon the ruins of Eldur in a quest to seek for the sorceress who resurrected the god of fire that cursed her. However, she'll need help...", False, True)
add('Unity', 'http://unity.smackjeeves.com/comics/', u'The Master Painter, Drawcia of Kirby Canvas Curse, has recovered from her defeat from Kirby and is much more powerful than before. She seeks revenge on Popstar itself and everyone is threatened by her wrath. Drawcia begins her revenge at Ripple star, and soon after, Kirby and Drawcia have a battle. Kirby is defeated easily, and now, he will have to unite both friend and foe to fight Drawcia and defeat her once more. The return of the old and new.... It gets "Shockingly Violent" and "Confusing"(Luigi_96) at some points.But please sit tight...I\'ll get better! Updates: Whenever Accepting criticism as long as you don\'t pester me every.single.page.', False, True)
add('UniversityofSpeed', 'http://u-speed.smackjeeves.com/comics/', u"13-year old Mapherry Wilson goes to school after being home-schooled his entire life. But it's not just any ordinary school... It's a University built by a giant automobile company! There will be racing, rivalries, crashes, and a little bit of everything else! Welcome to the DynaFaux University of Speed! Part 5: The Turbulent Times (eng. ver- ongoing) Part 6: Mappy's First Date (TBA) Part7-PartXX- TBA", False, True)
add('VACANT', 'http://vacant.smackjeeves.com/comics/', u'VACANT is a science fiction web comic following Commander Hayze, an agent of "The Eye" a powerful alien government/ corporate agency. Sent on a seemingly simple rescue mission, Hayze stumbles upon a possible explanation for the near extermination of the human race that had taken place over 100 years prior. His only lead is a virus and, along with his crew, Hayze tries to find the cure. Look at official site here: http://www.imaginetheending.net/Vacant.html VACANT also has a Etsy: http://www.etsy.com/shop/ImagineTheEnding?ref=si_shop tumblr: http://vacantcomic.tumblr.com/ twitter: https://twitter.com/VacantComic or Facebook: http://www.facebook.com/pages/Vacant/161911700538775', False, True)
add('Vacan7', 'http://vacan7.smackjeeves.com/comics/', u"Django is living with his younger brother in the heart of the big city named Los Perdidos. He's been stuck in a limbo between being a policeman and being a detective for a while now, and he finds himself falling for his new trainer and partner. On top of that Django starts to see and hear things others can't, and hopes his odd behaviour won't get him in trouble. Six voices seek the seventh, Django. Are they here to help or harm him? Updates Thursdays. Contains m/m. Mature: Occasional swearing and half naked dudes.", True, True)
add('VampireFetish', 'http://vampire-fetish.smackjeeves.com/comics/', u'A crossdressing vampire hunter takes on OCD vampires in modern London, all the while trying to break into the writing business using the name of the girl he was accused of murdering years ago. YA Graphic Novel: Urban Fantasy (Other Genres: Action, Comedy, Drama, Fantasy, Horror, Supernatural) ----------------------- Read full chapters online monthly @ Manga Magazine Online! http://www.mangamagazine.net loomcomics.com', False, True)
add('VerloreGeleentheid', 'http://verlore.thewebcomic.com/comics/', u'"Verlore Geleentheid" is \'n wetenskapfiksie strokiesprent wat hom deur van die ouer wetenskapfiksie soos "All the Way Back" (Michael Shaara) en "Die Oorlewendes" en "Ruimteskip Celeste" (albei deur Johan Bredell) laat inspireer. "Lost Opportunity" is a sci-fi webcomic which is inspired by older SF like "All the Way Back" (Michael Shaara) and "The Survivors" and "Spaceship Celeste" (both by Johan Bredell). It is in Afrikaans. At the moment no English version is planned, although a translation will be provided on the website.', False, True)
add('Villain', 'http://villain.smackjeeves.com/comics/', u'In popular culture, the line between hero and villain has always been well defined, but what if you got to chance to see what goes on for the other team? This is the story of three \'villains\' as they struggle make sense of why they are where they are today, while dealing with the same problems we do, and some much worse. As Villains and Heroes clash, they have to ask themselves, "Who\'s the true hero and who\'s the true villain?"', False, True)
add('Virus000', 'http://virus000.smackjeeves.com/comics/', u'Rei, a 15 year old student, has to switch to a new school because of an accident he caused at his previous one. Rei knows there is something wrong with him because everytime he\'s angry, any living thing he touches gets mysteriously ill. On Rei\'s first day at his new school, his bad luck lands him a detention and he ends up injuring himself on some misplaced equipment. Harumi, a girl in Rei\'s class, attempts to help him but backs off after seeing his wound heal itself before her eyes. Rei, not wanting to have this discovery spread, and not wanting to move schools again, decides that his only option is to make a deal and keep a sharp eye on Harumi, even if stalking is necessary. But, even with Rei\'s efforts to keep his ability secret, somehow people find out about it... These people call themselves "viruses" that have the intention to harm Rei for being the "one of immortal blood". Due to the constant attacks, Rei and the friends he meets along the way search to find answers about Rei\'s past and why these "viruses" are after him. *** FB: https://www.facebook.com/virus000manga {READ RIGHT TO LEFT} >Shounen >Updates every Wednesday and Saturday :D', False, True)
add('VoidMisadventures', 'http://voidmisadventures.smackjeeves.com/comics/', u"Quotes ------------------------------------------------------- Alexini: FEAR THE BUCKET!!!!!!! \\_/ Burey: By the name of Daucaus, I shall EAT those cookies! Carbon: I'M THE ALMIGHTY (and uber smexy) EATIRALATOR! I am the scroll Dry: Death by MONKEYS! Firekitty: Meow. *coughs up burning hairball onto something flammable* Gigi: You've gotta tell me when you turn on the mic, ok? Wait, it's already on?! HOW COUL- Jason: cavestorycavestorycavestorycavestorycavestorycaoeocirvgiarbvrsvoefssr Lucas: gotta speed keed Spark: Hi, guys, I'm back, did I miss anyth-- OH MY GOD WHAT DID YOU DO Tater: Unfunny umbrella.", False, True)
add('WHATaboutSHADOWS', 'http://was.smackjeeves.com/comics/', u'Charlie is a relatively normal teenage boy, who enjoys hunting supernatural creatures with his homemade "ghost-tracking-device" in his spare time. One day he meets a strange man, who has lost his cane. Charlie then decides to help the man find it, which was probably the worst decision he ever made. Updates Mondays (or Tuesday sometimes whoops).', False, True)
add('WantedDeadorDead', 'http://wanteddeadordead.smackjeeves.com/comics/', u'Two greedy undead bandits cause havoc in the wild west until one day a misterious little girl in a weird outfit hires them in order to help her father. Demons, monsters and wild west action! Beware of violence and foul language. Read L-->R Updates: Wednesday and Friday. Comment plz! :3', False, True)
add('WeAreGolden', 'http://wearegolden.smackjeeves.com/comics/', u'"We are not what you think we are, we are golden" (Mika, We are Golden 2009) A story of self-discovery, sexuality and relationships. When Olivia Barclay was forced to move from her high class private school to a scummy comprehensive it felt like the end of the world. But it was only the beginning... (God, anyone want some wine with that cheese? I\'m really no good at taglines!) Warning: contains examples of British humour. If there\'s any slang you don\'t understand, just ask :) Also, yaoi, yuri, het and any other kind of relationships you can think of. Updated Wednesday and Sunday. Mostly.', True, True)
add('WelcomeBackToTheLandOfForgottenMemories', 'http://wbttlofm.smackjeeves.com/comics/', u'A surreal comic that takes place in New York city and the dream world of CommonFictura, a world created by a boy named Jacob White.', False, True)
add('WelcometoAlcaturyBok2', 'http://alcaturybok2.smackjeeves.com/comics/', u"Fairies wear boots and you gotta believe me Yeah I saw it, I saw it, I tell you no lies Yeah fairies wear boots and you gotta believe me I saw it, I saw it with my own two eyes. An action packed sci-fi thrill ride, that takes you from our world and beyond, through dimensions. Enter the space the final frontier and witness the battle against the Krill'him. Hosting a cast of unforgettable characters, such as Jennyfer the fairy with boots, Zaceron an elf with and addiction, the stunning and beautiful Hannah and many more. Welcome to Alcatury", False, True)
add('WelcometoFreakshow', 'http://welcometofreakshow.smackjeeves.com/comics/', u'The audience roars, the acrobats and performers provide them with a spectacle unrivaled in all of Europe. The lights die, and the audience is now the entertainment for the apathetic circus. As blood and bone rush to the surface, one man leads the troupe downward to the darkest ring of all. Welcome to the Freakshow. //Updates Every Friday//', False, False)
add('WelcometothePCA', 'http://welcometothepca.smackjeeves.com/comics/', u'Pokemon Combat Academy - where fighting is your schoolwork! Timid little Cyndaquil Hirohiko Rangoku has to square off against a monster of a delinquent for his Combat mid-terms! Not only must he conquer his fears, he must also contend with a little battlefield drama, too! Loosely based off the FurAffinity/DeviantArt art-and-RP community of the same name.', False, True)
add('WestburyDetectives', 'http://westbury.smackjeeves.com/comics/', u"After his ex-girlfriend's accident, young Manhattan investigator Jack Arthur is transferred to an independent detective agency in Nassau County. At the same time, up-and-coming mob boss Pinhead Miyamoto is determined to avenge the murder of his adopted father. As the violent attacks on detectives and civilians increase, Jack is thrown into a violent rivalry with Miyamoto, finding he may be the only man able to keep the village from falling apart... Updated unevenly. Warnings for violence and mild sexual situations.", False, True)
add('WhatAboutLove', 'http://whataboutlove.smackjeeves.com/comics/', u"Takao has had a secret crush on his classmate, Hisoka, since he first entered high school. Now it's Takao's last year and he figures it's now or never so he does the crazy thing and confesses. Much to his surprise, Hisoka agrees to be his boyfriend. Takao is in pure bliss... until he realizes Hisoka has different aims. While Takao wants an actual relationship all Hisoka seems to be interested in is, well, physical stuff. So now Takao has to figure out a way to make Hisoka see him in a different way, but that's not easy since other men (realizing Hisoka goes that way) have taken an interest. Can Takao fend off potential rivals and get the guy he loves to love him back while facing all the other drama that comes with high school? Probably not, but that won't stop him from trying! Warning: - This is a Yaoi comic. I think that should be self-explanatory, but that means man on man action.", True, True)
add('WhatHappensinCarpediem', 'http://whic.smackjeeves.com/comics/', u'a comic by Piggy Ho Ho Welcome to Carpediem, the world of the massively popular MMORPG. When Naoto and Chris set out to find a strong attacker for their party, Kurogawa is not quite what they expected... *This is a BL story*', True, True)
add('WhenSheWasBad', 'http://whenshewasbad.smackjeeves.com/comics/', u'For every story about a hero, there is a "bad guy". Only, this story isn\'t about the hero. It\'s about the smart-alec, tough-as-nails villain. About her fights, her triumphs, her losses, her lackeys... And maybe her love life. If she can ever get the guts to ask the girl of her dreams out. (contains mostly yuri/GL and a bit of background het...Beware of foul language. It\'s mostly rated "mature" for violence and cursing. Sort of like an extremely f-d up reverse version of a magical girl story.) Read L->R, western style. For now, due to my work schedule, updates will be on either Sunday or Monday, sometimes both. This is subject to change, since my schedule/days off changes every few months. A lot of the shading from Interlude 1 and #13 done by Jovat. <3 Sidenote... This comic is not for horny guys hoping to see "HOTT LESBO ACTION ZOMG!!!11ONE" Yes, the main character happens to be a lesbian. But this story is about the plot, not "porn".', False, True)
add('Whenweweresilent', 'http://silence.smackjeeves.com/comics/', u'Two girls with different pasts, problems and ambitions - one future and one friendship.', False, False)
add('WhiteHeart', 'http://whiteheart.smackjeeves.com/comics/', u'"Lady Love received a magical book of the dark powers to her hands, and summoned a great, divine spirit. The spirit promises that Lady can make one wish, if she catches all the eight special albino souls and brings them to the spirit. Greedy Lady accepts the mission, and so the bloody collecting of albino humans begin... White is a tough and intense young man from the streets. He has been running away from Lady ever since when Love killed his gang and beloved. White is thirsty for revenge, but can do nothing but run away from Love and her henchmen... However, White finally meets Black, a friendly musician, who takes White with him and wants to help him in any way he possibly can. Both of them become good friends, but living in the same apartment makes both of them feel something stronger than just friendship..." WARNING: This comic contains gay relationships, sex, blood, swearing, crying and angsting, confusing scenes, drama and possible grammar mistakes. NOTICE! I started the comic in 2008, so the first four chapters are pretty awful to read... but please bear it, \'cause I\'m saving all the re-drawn pages for the possible-author\'s edition.', True, False)
#add('WhiteNoise', 'http://white-noise.smackjeeves.com/comics/', u'Warning: Shoujo/Shojo Story about the lives of 4 individuals. ~ Romance/Humour ~ Read from left to right >>>>>', False, True)
add('WildWingBoys', 'http://wwb.smackjeeves.com/comics/', u"It's the original Wild Wing Boys, never before seen in its entirety on the Internet! Follow the wacky hijinks of the Gundam Wing characters with sandwich obsessions, meat collecting, and cameos a-plenty! Updates when I can get around to it because school is killer.", False, True)
add('WildWingBoysKoathArc', 'http://wwbka.smackjeeves.com/comics/', u'When a freak dimensional portal sends the five main characters of Gundam Wing into a fantasy world and puts Heero in a coma, the four remaining pilots, accompanied by a young catboy named Toko, must conquer various obstacles in finding a cure...and a way home.', False, True)
add('Wildflowers', 'http://wildflowers.smackjeeves.com/comics/', u'A web comic about love, life, and trying to comes to terms with being transgendered. Sometimes dark, sometimes light, and always an attempt at a honest look at transexual life. Updating every day, including weekends!', False, True)
add('Willem', 'http://willemcomic.smackjeeves.com/comics/', u"Willem the robot wants desperately to become a super hero, but the Hero Academy doesn't allow robots! While searching for a loophole he finds a long lost hero named Moonshadow and makes some new friends in the process.", True, True)
add('WingsOverEthereal', 'http://wings-over-ethereal.smackjeeves.com/comics/', u'[On Hiatus for remaking. Thank you for your patience.] The age-old fantasy story of a boy and a princess, yet a tale unlike any other... ********************************************* Set in the fictonal world of Chrona, "Wings Over Ethereal" is a twisting tale of Love and Hate... Two Kingdoms, inches away from erupting in war... A Knight who\'s inner demon seeks to destroy what he holds dear... A sibling rivalry the likes of which the world has never seen... Yet they are all blind to the true darkness that awaits them all... The fate of these two Kingdoms rests in the forbidden Love between a Human... And an Angel... *********************************************', False, True)
add('WintersinLavelle', 'http://wintersinlavelle.smackjeeves.com/comics/', u'Winters in Lavelle follows siblings Kari and Aiden as they discover an old family heirloom is more than it seems. Lost in a strange world, they must find a way to stay together and alive amid strange cloaked men, human/deer hybrids, dragon kings, and magic amber that will change the course of their lives.', False, True)
add('WitchsQuarry', 'http://witchsquarry.smackjeeves.com/comics/', u"For most current pages see Witch's Quarry at Mangamagazine.net. http://www.mangamagazine.net/manga-and-comics/Witchs-Quarry/detail-page/357?lang=en Currently Updating Here Tuesdays and Thursdays 3:00am EST! This is the tale of Sir Veolynn Moreshire's greatest and strangest achievement. Fate would have her/him led by the whims of a powerful witch. This is what really happened in the Second Great War for Oladuan; when heroes and villains were neither righteous or evil. There were other hidden creatures that placed high stakes in the outcome of the human's conflict. And there were a great many funny things that just didn't go as planned. All's fair game in love, war and species propagation! Rated PG-13 *warning* some adult situations/humor/GLBT themes Rogue X Knight Intermission short story of Wesyng Reedle meets a man who shares the same face, Sir Deshad Bright. Suggested age +16 for mature themes.", False, True)
add('WithACherryOnTop', 'http://wacot.smackjeeves.com/comics/', u"Started in 2006, currently in Issue 6 Kira Morishita is just your everyday high school student: average grades, many friends and plays on Sakio Highs Boys soccer team. His secret? He\x92s actually a she! After finding out that Sakio High no longer has a girls\x92 team, Kira disguises herself as a boy to play. As the saying goes, \x93Whatever can go wrong, will. Her new best friend fell in love with her at first sight, she likes the boy that sits next to her in class, but he hates her, and on top of that she\x92s a benchwarmer until further notice: is this what she traded her skirt in for? Will Kira be able to become a star on the boys\x92 soccer team, and keep the others from finding out she's a girl? ~READS RIGHT to LEFT~ ^_^ Should update regularly, but we don't really know :/", False, True)
add('Wootlabs', 'http://wootlabs.thewebcomic.com/comics/', u'"Square Woot is the worst supervillain I ever fought. She held her death ray backwards and vaporized half of her robot army." - Riot Girl, superhero "An uplifting story for anyone that loves cute things in hats." - Penguin Parade Weekly "THIS IS THE STORY OF CATBOT 9000. EVERYONE ELSE IN IT IS STUPID AND NOT CATBOT 9000." - Catbot 9000 Square Woot is a genius with robots, weapons, and that funky little thing called science. Joined by her penguin sidekick and her family of creations, all she wants to do is rule the world. At least, that\'s all she used to want. A chance encounter has the group thinking that it might be more fun to be heroes from now on. Is the city ready to be saved through mad science?', False, True)
add('XYZ', 'http://xyz.smackjeeves.com/comics/', u'[COMPLETE] ~~~READS LEFT-TO-RIGHT~~~ Two twin sisters, Tomi and Tori, grew up with the average twin sister life- sharing everything: their faces, their clothes, their grades... And then they hit puberty. Tomi went through the expected changes- filling out in places, and going all out "girly". As for Tori...not so much. What her sister got in chest she got in height, and that was basically it. This unexplainable change makes everyone think Tori is a guy, and more particularly, Tomi\'s brother (which helps Tomi out alot). However, crossing the line can be painful and dangerous, and above all, lonely. {ZOMG, It\'s actually a romance/shoujo *_*} UPDATES Tues, Thurs Saturday and/or Sunday', False, True)
add('YamanaokiHighSchool', 'http://yamanaokihs.smackjeeves.com/comics/', u"there're a lot of dimensions on this world and Honjitsu is where 8 students will live the adventure of their lives... Facebook page: http://www.facebook.com/#!/pages/Yamanaoki/167250876624086 version espa\xf1ol: http://yamanaoki.smackjeeves.com be nice 8D", False, True)
add('Yaoishereforareason', 'http://yaoishereforareason.smackjeeves.com/comics/', u"A Yaoi collab. Rules. No furries. (Sorry furry fans) You can have up to four characters. Characters can be anything. (Vampire, demon, fairy. etc.) Pro or Beginners are welcomed. NO trashing on other's work, be nice! Mature or mild things are welcomed and loved. So, if your interested, we are still accepting about.. Five or four more.. Hope to hear from you! <3 Yoai.", True, False)
add('YoungCannibals', 'http://youngcannibals.smackjeeves.com/comics/', u"The story of one girl's battle NOT to kill her friends. Updates every Monday & Friday.", False, True)
add('YuGiOh09', 'http://ygo-09.smackjeeves.com/comics/', u"--Updates Mondays and Fridays-- Sakima Hirose's tragic past leads him down the path of justice as a part of the Duel Agents--a CIA-style team of ten Duelists made to take on the high crime of Neo Domino City! With the threat of the terror gang Aurora looming over the horizon, can Sakima work with his fellow Duel Agents Azuki Haneaoi and Taisuke Yatsuda to take Aurora down? Follow the story of Sakima and the Duel Agents as Yu-Gi-Oh! 09 presents all new cards, characters, and challenges in the biggest Yu-Gi-Oh! fan comic the internet has to offer!", False, True)
add('ZaenWell', 'http://zaenwell.smackjeeves.com/comics/', u'Thrown into the well of the Gods as part of an initiation, Renee Nathans has fourteen days to find a suitable God to bring back into the world of humanity. Danger lurks behind every corner, however, and when a rogue God decides humanity is no longer necessary, an already difficult task becomes even harder...', False, True)
add('ZirrasReturn', 'http://tloszirrasreturn.smackjeeves.com/comics/', u"Based on the Legend of Spyro trilogy. This story explains all about the mysteries of Cynder's evil side. (in my own veiws, of course)", False, True)
add('Zodiac', 'http://zodiac.smackjeeves.com/comics/', u"A curse has fallen on the ten students along with their two teachers, and they must work together to find the source and break it, so they can spent their lives like it was before. The story will be, most of the time, stupid. You've been warned :D Updates: !!! When a page is out/I'll try to update at least twice/three times a week c:", False, False)
add('ZonowTheHedgehog', 'http://zonow.smackjeeves.com/comics/', u"As an Alien creature from a far away planet lands on Earth he soon calls it home and decides to do anything to keep it safe. This story will not tell the life of one but, The lives of many and will show how each of them intertwine with one another. This is Zonow Story. It's recommended that you read Season 2's section. Not reading season 1 will not make a difference. CAMEO'S ARE WELCOME! PLEASE SEND TO PARRISH_BROADNAX ~thankyou.", False, True)
add('ZosKias', 'http://zoskias.smackjeeves.com/comics/', u"Being a part of the gatekeeper's sepcial clean-up crew is never easy! From vampires to new magick users, there is never any time for breaks! But, the fighting is the easiest part about it... Mizuno Umishin has been a member for a couple years, but he has yet to do any real fieldwork as he's lacking a partner. When he goes to find his...it's not what he bargained for! But now, the real question isn't whethe Light is up to the task...it's whether Umishin and Light can ever get along and become true partners!", False, True)
