#include <config.h>
#include <glade/glade.h>

#include "drgenius_mdi.h"
#include "drgenius_menus.h"
#include "drgeo_menu.h"
#include "drgeo_view.h"
#include "gobobjs/drgenius-mdi-child.h"
#include "gobobjs/drgeo-mdi-child.h"
#include "gobobjs/editor-mdi-child.h"

static void mdi_destroy_handler (GnomeMDI * mdi);
static void app_created_handler (GnomeMDI * mdi, GnomeApp * app);
static void child_changed_handler (GnomeMDI * mdi, GnomeMDIChild * child);
static gint remove_child_handler (GnomeMDI * mdi, GnomeMDIChild * child);
static void app_deleted_handler (GnomeApp * widget, gpointer data);
static gint remove_view_handler (GnomeMDI * mdi, GtkWidget * view);

GnomeMDI *
drgenius_mdi_new ()
{
	GnomeMDI *mdi;

	mdi = GNOME_MDI (gnome_mdi_new (PACKAGE, _ ("Dr Genius")));
	gnome_mdi_set_mode (mdi, GNOME_MDI_NOTEBOOK);

	/* connect signals */
	gtk_signal_connect (GTK_OBJECT (mdi), "destroy",
			    GTK_SIGNAL_FUNC (mdi_destroy_handler), NULL);
	gtk_signal_connect (GTK_OBJECT (mdi), "remove_view",
			    GTK_SIGNAL_FUNC (remove_view_handler), NULL);
	gtk_signal_connect (GTK_OBJECT (mdi), "app_created",
			    GTK_SIGNAL_FUNC (app_created_handler), NULL);
	gtk_signal_connect (GTK_OBJECT (mdi), "child_changed",
			    GTK_SIGNAL_FUNC (child_changed_handler), NULL);
	gtk_signal_connect (GTK_OBJECT (mdi), "remove_child",
			    GTK_SIGNAL_FUNC (remove_child_handler), NULL);
	return (mdi);
}

void 
drgenius_mdi_close (GnomeMDI * mdi)
{
	/* This function can be invoked to explicitly close the application.  */
	if (!gnome_mdi_remove_all (mdi, FALSE)) {
		/* Warn the user if there are unsaved files.  */
		/* XXX */
	}
}

static void
tieToolWidgetName (GtkWidget *tie, GladeXML *xml, gchar *name)
{
	GtkWidget *w;

	w = glade_xml_get_widget (xml, name);
	gtk_object_set_data (GTK_OBJECT (tie), name, w); 
}

static void 
mdi_destroy_handler (GnomeMDI * mdi)
{
	/* on destruction of GnomeMDI we call gtk_main_quit(), since we have 
	   opened no windows on our own and therefore our GUI is gone.  */

	gtk_main_quit ();
}

static gint 
remove_view_handler (GnomeMDI * mdi, GtkWidget * view)
{
	/* This signal handler is invoked each time an MDI view is removed.  */
	/* FIXME call some checks from here to verify that the file is saved.  */
	DrGeniusMDIChild * child;
	
	child = (DrGeniusMDIChild *) gnome_mdi_get_active_child (mdi);

	return (TRUE);		/* It's OK to remove this view.  */
}

static void 
app_created_handler (GnomeMDI * mdi, GnomeApp * app)
{
	GtkWidget *widget;
	GnomeDockItem *dockItem;

	/* Setup the application correctly. */
	gtk_window_set_policy (GTK_WINDOW (app), FALSE, TRUE, FALSE);
	gtk_window_set_default_size (GTK_WINDOW (app), 640, 480);
	gtk_window_set_wmclass (GTK_WINDOW (app), "drgenius", "DrGenius");

	widget = gnome_appbar_new (FALSE, TRUE, GNOME_PREFERENCES_NEVER);

	gnome_app_set_statusbar (app, widget);
	
	/* Set default menu and toolbar */
	drgeo_install_menus_and_toolbar (GTK_WIDGET (app));
 
	/* prepare the dock item for the per child toolbar */
	dockItem = GNOME_DOCK_ITEM (gnome_dock_item_new ("DockItem", 
							 GNOME_DOCK_ITEM_BEH_NEVER_FLOATING));
	gnome_app_add_dock_item (app, dockItem, GNOME_DOCK_TOP,
				 2, 0, 0); 

	/* Keep the reference of the dockItem of this Gnome App */
	gtk_object_set_data (GTK_OBJECT (app), "childDockItem", dockItem);

	gnome_mdi_set_child_list_path (mdi, _ ("Windows/"));

	gtk_signal_connect (GTK_OBJECT (app),
			    "delete_event",
			    GTK_SIGNAL_FUNC (app_deleted_handler),
			    NULL);
}
static void 
child_changed_handler (GnomeMDI * mdi, GnomeMDIChild * child)
{
	DrGeniusMDIChild *newChild;
	GnomeDockItem *dockItem;
	GtkWidget *bar;
	GnomeApp *app;

	newChild = (DrGeniusMDIChild *) gnome_mdi_get_active_child (mdi);
	app = gnome_mdi_get_active_window (mdi);
	dockItem = GNOME_DOCK_ITEM ( gtk_object_get_data 
				     (GTK_OBJECT (app), "childDockItem"));
	reconcile_grayout_widget ();
	if (child)
	{
		/* Different kind of child, change the child toolbar */
		/* First, eventualy remove an actual child toolbar */
		bar = gnome_dock_item_get_child (dockItem);
		if (bar)
			gtk_container_remove (GTK_CONTAINER (dockItem), bar);		

	}
	/* Add the toolbar specific to the active child */
	switch (newChild->child_type) 
	{
	case FIGURE_CHILD:
		bar = drgenius_mdi_child_get_toolbar (newChild);
		gtk_container_add (GTK_CONTAINER (dockItem), bar);
		reconcile_popup_menu (newChild);
		break;
	case EDITOR_CHILD:
		break;
	}
}
static gint 
remove_child_handler (GnomeMDI * mdi, GnomeMDIChild * child)
{
	GnomeDockItem *dockItem;
	GtkWidget *bar;
	GnomeApp *app;

	app = gnome_mdi_get_active_window (mdi);
	dockItem = GNOME_DOCK_ITEM (gtk_object_get_data 
				    (GTK_OBJECT (app), "childDockItem"));
	/* Is is the last child? */
	if (g_list_length (mdi->children) == 1)
	{
		/* Remove any toolbar specific to the active child */
		switch (((DrGeniusMDIChild *)child)->child_type) 
		{
		case FIGURE_CHILD:
			bar = drgenius_mdi_child_get_toolbar (DRGENIUS_MDI_CHILD (child));
			gtk_container_remove (GTK_CONTAINER (dockItem), bar);
			break;
		case EDITOR_CHILD:
			break;
		}
	}
	return TRUE;
}
static void 
app_deleted_handler (GnomeApp * app, gpointer data)
{
	/* XXX invoked for each app removed. 
	   remove ref of the child toolbar 
	*/
  printf("What to remove here ?\n");
}
/* Create a figure toolbar instance */
static GtkWidget* createFigureToolbar ()
{
	GtkWidget *widget, *bar, *button, *toolbar;
	GladeXML *xml, *xml1;
 
       	/* Load specific toolbars */
	xml = glade_xml_new (DRGENIUS_GLADEDIR"/drgeo.glade", "menuBar");
	glade_xml_signal_autoconnect (xml);
	bar = glade_xml_get_widget (xml, "menuBar");

	/* keep track of the button in the top bar */
	tieToolWidgetName (bar, xml, "pointMenu");
	tieToolWidgetName (bar, xml, "curveMenu");
	tieToolWidgetName (bar, xml, "transformationMenu");
	tieToolWidgetName (bar, xml, "numericMenu");
	tieToolWidgetName (bar, xml, "macroMenu");
	tieToolWidgetName (bar, xml, "otherMenu");
	tieToolWidgetName (bar, xml, "moveItem");	
	
	// To prevent the widget from been deleted
	gtk_widget_ref (bar);
	gtk_toolbar_set_style (GTK_TOOLBAR (bar), GTK_TOOLBAR_ICONS);

	/* Prepare the sub-toolbar for the drgeoToolbar */

	/* The point Bar */
	xml1 = glade_xml_new (DRGENIUS_GLADEDIR"/drgeo.glade", "pointBar");
	glade_xml_signal_autoconnect (xml1);
	widget = glade_xml_get_widget (xml1, "pointBar");
	toolbar = glade_xml_get_widget (xml1, "toolbar");
	gtk_toolbar_set_style (GTK_TOOLBAR (toolbar), GTK_TOOLBAR_ICONS);
	gtk_toolbar_set_button_relief (GTK_TOOLBAR (toolbar), GTK_RELIEF_HALF);
	button = glade_xml_get_widget (xml, "pointMenu");
	gtk_object_set_data (GTK_OBJECT (button), "subBar", widget);
	/* Attach the sub bar reference to the main toolbar so we can change 
	   their orientation */
	gtk_object_set_data (GTK_OBJECT (bar), "pointBar", toolbar);

	/* keep track of the tools in the point bar */
	tieToolWidgetName (bar, xml1, "freePoint");
	tieToolWidgetName (bar, xml1, "middle");
	tieToolWidgetName (bar, xml1, "intersection");
	tieToolWidgetName (bar, xml1, "coordinatesPoint");

	gtk_object_destroy (GTK_OBJECT (xml1));


	/* The curve Bar */
	xml1 = glade_xml_new (DRGENIUS_GLADEDIR"/drgeo.glade", "curveBar");
	glade_xml_signal_autoconnect (xml1);
	widget = glade_xml_get_widget (xml1, "curveBar");
	toolbar = glade_xml_get_widget (xml1, "toolbar");
	gtk_toolbar_set_style (GTK_TOOLBAR (toolbar), GTK_TOOLBAR_ICONS);
	gtk_toolbar_set_button_relief (GTK_TOOLBAR (toolbar), GTK_RELIEF_HALF);
	button = glade_xml_get_widget (xml, "curveMenu");
	gtk_object_set_data (GTK_OBJECT (button), "subBar", widget);
	gtk_object_set_data (GTK_OBJECT (bar), "curveBar", toolbar);
	/* keep track of the tools in the curve bar */
	tieToolWidgetName (bar, xml1, "line");
	tieToolWidgetName (bar, xml1, "halfLine");
	tieToolWidgetName (bar, xml1, "segment");
	tieToolWidgetName (bar, xml1, "vector");
	tieToolWidgetName (bar, xml1, "circle");
	tieToolWidgetName (bar, xml1, "arcCircle");
	tieToolWidgetName (bar, xml1, "locus");
	tieToolWidgetName (bar, xml1, "polygon");

	gtk_object_destroy (GTK_OBJECT (xml1));

	/* The transformation Bar */
	xml1 = glade_xml_new (DRGENIUS_GLADEDIR"/drgeo.glade", "transformationBar");
	glade_xml_signal_autoconnect (xml1);
	widget = glade_xml_get_widget (xml1, "transformationBar");
	toolbar = glade_xml_get_widget (xml1, "toolbar");
	gtk_toolbar_set_style (GTK_TOOLBAR (toolbar), GTK_TOOLBAR_ICONS);
	gtk_toolbar_set_button_relief (GTK_TOOLBAR (toolbar), GTK_RELIEF_HALF);
	button = glade_xml_get_widget (xml, "transformationMenu");
	gtk_object_set_data (GTK_OBJECT (button), "subBar", widget);
	gtk_object_set_data (GTK_OBJECT (bar), "transformationBar", toolbar);
	/* keep track of the tools in the transformation bar */
	tieToolWidgetName (bar, xml1, "parallel");
	tieToolWidgetName (bar, xml1, "perpendicular");
	tieToolWidgetName (bar, xml1, "reflexion");
	tieToolWidgetName (bar, xml1, "symmetry");
	tieToolWidgetName (bar, xml1, "translation");
	tieToolWidgetName (bar, xml1, "rotation");
	tieToolWidgetName (bar, xml1, "scale");

	gtk_object_destroy (GTK_OBJECT (xml1));

	/* The numeric Bar */
	xml1 = glade_xml_new (DRGENIUS_GLADEDIR"/drgeo.glade", "numericBar");
	glade_xml_signal_autoconnect (xml1);
	widget = glade_xml_get_widget (xml1, "numericBar");
	toolbar = glade_xml_get_widget (xml1, "toolbar");
	gtk_toolbar_set_style (GTK_TOOLBAR (toolbar), GTK_TOOLBAR_ICONS);
	gtk_toolbar_set_button_relief (GTK_TOOLBAR (toolbar), GTK_RELIEF_HALF);
	button = glade_xml_get_widget (xml, "numericMenu");
	gtk_object_set_data (GTK_OBJECT (button), "subBar", widget);
	gtk_object_set_data (GTK_OBJECT (bar), "numericBar", toolbar);
	/* keep track of the tools in the numeric bar */
 	tieToolWidgetName (bar, xml1, "distance");
	tieToolWidgetName (bar, xml1, "angle");
	tieToolWidgetName (bar, xml1, "equation");
	tieToolWidgetName (bar, xml1, "script");

	gtk_object_destroy (GTK_OBJECT (xml1));

	/* The macro Bar */
	xml1 = glade_xml_new (DRGENIUS_GLADEDIR"/drgeo.glade", "macroBar");
	glade_xml_signal_autoconnect (xml1);
	widget = glade_xml_get_widget (xml1, "macroBar");
	toolbar = glade_xml_get_widget (xml1, "toolbar");
	gtk_toolbar_set_style (GTK_TOOLBAR (toolbar), GTK_TOOLBAR_ICONS);
	gtk_toolbar_set_button_relief (GTK_TOOLBAR (toolbar), GTK_RELIEF_HALF);
	button = glade_xml_get_widget (xml, "macroMenu");
	gtk_object_set_data (GTK_OBJECT (button), "subBar", widget);
	gtk_object_set_data (GTK_OBJECT (bar), "macroBar", toolbar);
	/* keep track of the tools in the macro bar */
	tieToolWidgetName (bar, xml1, "buildMacro");
	tieToolWidgetName (bar, xml1, "runMacro");
	tieToolWidgetName (bar, xml1, "widgetScript");

	gtk_object_destroy (GTK_OBJECT (xml1));

	/* The other Bar */
	xml1 = glade_xml_new (DRGENIUS_GLADEDIR"/drgeo.glade", "otherBar");
	glade_xml_signal_autoconnect (xml1);
	widget = glade_xml_get_widget (xml1, "otherBar");
	toolbar = glade_xml_get_widget (xml1, "toolbar");
	gtk_toolbar_set_style (GTK_TOOLBAR (toolbar), GTK_TOOLBAR_ICONS);
	gtk_toolbar_set_button_relief (GTK_TOOLBAR (toolbar), GTK_RELIEF_HALF);
	button = glade_xml_get_widget (xml, "otherMenu");
	gtk_object_set_data (GTK_OBJECT (button), "subBar", widget);
	gtk_object_set_data (GTK_OBJECT (bar), "otherBar", toolbar);
	/* keep track of the tools in the other bar */
	tieToolWidgetName (bar, xml1, "deleteItem");
	tieToolWidgetName (bar, xml1, "styleItem");
	tieToolWidgetName (bar, xml1, "propertyItem");
	
	gtk_object_destroy (GTK_OBJECT (xml1));

	gtk_object_destroy (GTK_OBJECT (xml));

	return bar;
}


/* Open XML file with multiple date */
void 
drgenius_mdi_session_open (GnomeMDI * mdi, char *filename)
{
	xmlDocPtr drgeniusXml;
	xmlNodePtr tree;

	if ((drgeniusXml = xmlParseFile (filename)) == NULL) 
	{
		char *s = g_strdup_printf ("drgenius_mdi_session_open: can't parse file %s\n", filename);
		gnome_error_dialog (s);
		free (s);
		return;
	}
	tree = drgeniusXml->root;
	if (strcasecmp (tree->name, "drgenius") != 0) 
	{
	        char *s = g_strdup_printf (_("%s is not a Dr Genius XML file\n"), filename);
		gnome_error_dialog (s);
		free (s);
		return;
	}
	tree = tree->childs;
	/* vistit the top child */
	while (tree != NULL) 
	{
		if (strcasecmp (tree->name, "drgeo") == 0) 
			/* we get a Dr Geo figure */
			drgenius_mdi_new_child (mdi, FIGURE_CHILD, tree);
		else if (strcasecmp (tree->name, "text") == 0) 
			/* we get a text buffer */
			drgenius_mdi_new_child (mdi, EDITOR_CHILD, tree);
		else if (strcasecmp (tree->name, "macro") == 0) 
			/* we get a Dr Geo macro-construction, not a mdi child ! */
			loadMacro (tree);

		tree = tree->next;
	}
	xmlFreeDoc (drgeniusXml);
}

/* create a new mdi child and record it */
void
drgenius_mdi_new_child (GnomeMDI * mdi, int childType, xmlNodePtr tree)
{
	DrGeniusMDIChild *child;
	GtkWidget * toolbar = NULL;;
	switch (childType)
	{
	case FIGURE_CHILD:
		child = drgeo_mdi_child_new (tree);
		/* declare the figure toolbar here:*/
		toolbar = createFigureToolbar ();
		break;
	case EDITOR_CHILD:
		child = editor_mdi_child_new (tree);
		break;
	default:
		child = NULL;
	}
	if (child != NULL) 
	{
		drgenius_mdi_child_set_toolbar(child, toolbar);
		/* update the toolbar */
		drgenius_mdi_child_update_user_interface (child);

		/* add the child to MDI */
		gnome_mdi_add_child (mdi, GNOME_MDI_CHILD (child));			    
		/* and add a new view of the child */
		gnome_mdi_add_view (mdi, GNOME_MDI_CHILD (child));		
	}
}

/* close the current child of the mdi */
void 
drgenius_mdi_close_view (GnomeMDI * mdi)
{
	GnomeMDIChild *child;
	GtkWidget *active_view;

	active_view = gnome_mdi_get_active_view (mdi);
	/* We remove the current view, and the child containing it.  */
	if (active_view) {
		child = gnome_mdi_get_child_from_view (active_view);
		//if (gnome_mdi_remove_view (mdi, active_view, FALSE)) {
			/* Remove the child after the view it was holding.  The
			   view is only removed if the user agreed to it (see
			   remove_view_handler callback).  */
			gnome_mdi_remove_child (mdi, child, FALSE);
			//}
	}
}
