#	Programmer:	Daniel Pozmanter
#	E-mail:		drpython@bluebottle.com
#	Note:		You must reply to the verification e-mail to get through.
#
#	Copyright 2003-2004 Daniel Pozmanter
#
#	Distributed under the terms of the GPL (GNU Public Lisense)
#
#    DrPython is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
from drBoolean import *
from wxPython.wx import *
from wxPython.html import *

class drAboutDialog(wxDialog):

	def __init__(self, parent, title):
		wxDialog.__init__(self, parent, -1, title, wxPoint(50, 50), wxSize(425, 300))
		
		self.theSizer = wxBoxSizer(wxVERTICAL)

		htmlwin = wxHtmlWindow(self, -1, wxPoint(0, 0), wxSize(400, 200))
		self.theSizer.Add(htmlwin, 1, wxEXPAND)		
		
		htmlwin.LoadPage(parent.programdirectory + "/documentation/about.html")
		
		self.btnClose = wxButton(self, 101, "&Close")
		self.theSizer.Add(wxStaticText(self, -1, ""), 0, wxALIGN_CENTER | wxSHAPED)
		self.theSizer.Add(self.btnClose, 0, wxALIGN_CENTER | wxSHAPED)
		self.btnClose.SetDefault()

		self.SetAutoLayout(True)
		self.SetSizer(self.theSizer)
	
		EVT_BUTTON(self, 101, self.OnbtnClose)
		
	def OnbtnClose(self, event):
		self.EndModal(0)
