#	Programmer:	Daniel Pozmanter
#	E-mail:		drpython@bluebottle.com
#	Note:		You must reply to the verification e-mail to get through.
#
#	Copyright 2003-2004 Daniel Pozmanter
#
#	Distributed under the terms of the GPL (GNU Public License)
#
#    DrPython is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
	
#FindReplace Dialog

from wxPython.wx import *
from wxPython.stc import *
from wxPython.lib.dialogs import wxScrolledMessageDialog
import re

class drFinder:
	#copy old finder limodou 2004/04/19
	#def __init__(self, parent):
	def __init__(self, parent, oldfinder=None):
	#end limodou
		self.parent = parent
		self.reset()
		#copy old finder limodou 2004/04/19
		self.Copy(oldfinder)
		#end limodou

	#copy old finder limodou 2004/04/19
	def Copy(self, finder):
		if finder:
			self.findtext = finder.findtext
			self.findflags = finder.findflags
			self.backwards = finder.backwards
	#end limodou
		
	def DoFind(self, findtext, findflags, backwards):
		doclength = self.parent.txtDocument.GetLength()	
		
		self.findtext = findtext
		self.findflags = findflags
		self.backwards = backwards
		
		prev = self.lastpos	
		
		if (backwards):
			endpos = self.targetStart
			if (self.lastpos >= doclength) or (self.lastpos < 0):
				self.lastpos = doclength
		else:
			endpos = self.targetEnd
			if (self.lastpos >= doclength) or (self.lastpos < 0):
				self.lastpos = 0
				
		self.lastpos = self.parent.txtDocument.FindText(self.lastpos, endpos, findtext, findflags)
		
		if (self.lastpos == -1):
			if (prev > self.targetStart):
				self.lastpos = self.targetStart
				d = wxScrolledMessageDialog(self.parent, ("End of document reached."), "DrPython Find")
				d.ShowModal()
				d.Destroy()	
				return
			d = wxScrolledMessageDialog(self.parent, ("Search string \"" + findtext + "\" not found"), "DrPython Find")
			d.ShowModal()
			d.Destroy()
			return

		self.parent.txtDocument.GotoPos(self.lastpos)
		self.parent.txtDocument.EnsureCaretVisible()
		self.parent.txtDocument.SetSelectionStart(self.lastpos)
		self.parent.txtDocument.SetSelectionEnd(self.lastpos + len(findtext))
								
		if (backwards):
			self.lastpos = self.lastpos - 1
		else:
			self.lastpos = self.lastpos + 1
				
	def DoREFind(self, findtext, matchcase):
		self.RE = 1
		doclength = self.parent.txtDocument.GetLength()	
		
		self.findtext = findtext
		self.findflags = matchcase
		
		prev = self.lastpos	
		
		case = 0
		if (not matchcase):
			case = re.IGNORECASE
		
		regularexpression = re.compile(findtext, case | re.MULTILINE)
				
		endpos = self.targetEnd
		if (self.lastpos >= doclength) or (self.lastpos < 0):
			self.lastpos = 0
						
		matchedtext = regularexpression.search(self.parent.txtDocument.GetText()[self.lastpos:endpos])
				
		if matchedtext is None:
			if (prev > self.targetStart):
				self.lastpos = self.targetStart
				d = wxScrolledMessageDialog(self.parent, ("End of document reached."), "DrPython Find")
				d.ShowModal()
				d.Destroy()	
				return
			d = wxScrolledMessageDialog(self.parent, ("Regular expression \"" + findtext + "\" not found"), "DrPython Find")
			d.ShowModal()
			d.Destroy()
			return

		oldpos = self.lastpos
		self.lastpos = oldpos + matchedtext.start()
		endpos = oldpos + matchedtext.end()
				
		
		self.parent.txtDocument.GotoPos(self.lastpos)
		self.parent.txtDocument.EnsureCaretVisible()
		self.parent.txtDocument.SetSelectionStart(self.lastpos)
		self.parent.txtDocument.SetSelectionEnd(endpos)		
		
		self.lastpos = endpos
	
	def DoFindNext(self):
		if (not self.RE):
			self.DoFind(self.findtext, self.findflags, self.backwards)
			return
		self.DoREFind(self.findtext, self.findflags)
		
	def DoFindPrevious(self):
		if (not self.RE):
			pback = self.backwards
			self.DoFind(self.findtext, self.findflags, not self.backwards)
			self.DoFindNext()
			self.backwards = pback
		
	def GetFindPos(self):
		return self.lastpos
	
	def GetFindText(self):
		return self.findtext

	def ReplaceAll(self, findtext, replacetext, flags, prompt = 0):
		p = self.parent.txtDocument.FindText(self.targetStart, self.targetEnd, findtext, flags)
		diff = len(replacetext) - len(findtext)
		x = 0	
		notfirst = 0
		favpos = wxPoint(5, 5)
		while (p is not -1):
			self.parent.txtDocument.GotoPos(p)
			self.parent.txtDocument.EnsureCaretVisible()
			self.parent.txtDocument.SetTargetStart(p)
			self.parent.txtDocument.SetTargetEnd(p + len(findtext))
			if prompt:
				self.parent.txtDocument.SetSelection(p, (p + len(findtext)))
				d = wxSingleChoiceDialog(self.parent, ("Found \"" + findtext + "\" at Line: " \
				+ str(self.parent.txtDocument.LineFromPosition(p)+1) + \
				" Col: " + str(self.parent.txtDocument.GetColumn(p))
				 + "\n(Hit Cancel to Stop)"), "Replace", ["Replace", "Skip"], wxOK|wxCANCEL)
				if notfirst:
					d.Move(favpos)
				else:
					notfirst = 1
				answer = d.ShowModal()
				favpos = d.GetPosition()
				d.Destroy()
				if (answer == wxID_OK):					
					if (d.GetStringSelection() == "Replace"):
						self.parent.txtDocument.ReplaceTarget(replacetext)
						self.targetEnd = self.targetEnd + diff
					else:
						x = x - 1
					p = self.parent.txtDocument.FindText((p + len(replacetext)), self.targetEnd, findtext, flags)						
				else:
					p = -1
					x = x - 1
			else:
				self.parent.txtDocument.ReplaceTarget(replacetext)
				self.targetEnd = self.targetEnd + diff
				p = self.parent.txtDocument.FindText((p + len(replacetext)), self.targetEnd, findtext, flags)
			x = x + 1						
		return x
	
	def REReplaceAll(self, findtext, replacetext, matchcase, prompt = 0):
		case = 0
		if (not matchcase):
			case = re.IGNORECASE
		
		regularexpression = re.compile(findtext, case | re.MULTILINE)
		
		oldtext = self.parent.txtDocument.GetText()
		if not prompt:
			newtext, x = regularexpression.subn(replacetext, oldtext[self.targetStart:self.targetEnd])
		
			self.parent.txtDocument.SetText(oldtext[0:self.targetStart] + newtext + oldtext[self.targetEnd:])
		else:
			matchedtext = regularexpression.search(self.parent.txtDocument.GetText()[self.lastpos:self.targetEnd])
			
			diff = len(replacetext) - len(findtext)
			
			x = 0
			notfirst = 0
			
			favpos = wxPoint(5, 5)
			while matchedtext is not None:		
			
				oldpos = self.lastpos
				self.lastpos = oldpos + matchedtext.start()
				endpos = oldpos + matchedtext.end()
				
				self.parent.txtDocument.GotoPos(self.lastpos)
				self.parent.txtDocument.EnsureCaretVisible()
				self.parent.txtDocument.SetSelectionStart(self.lastpos)
				self.parent.txtDocument.SetSelectionEnd(endpos)
				self.parent.txtDocument.SetTargetStart(self.lastpos)
				self.parent.txtDocument.SetTargetEnd(endpos)
				
				d = wxSingleChoiceDialog(self.parent, ("Found \"" + findtext + "\" at Line: " \
				+ str(self.parent.txtDocument.LineFromPosition(self.lastpos)+1) + \
				" Col: " + str(self.parent.txtDocument.GetColumn(self.lastpos)) + \
				"\n(Hit Cancel to Stop)"), "Replace", ["Replace", "Skip"], wxOK|wxCANCEL)
				
				if notfirst:
					d.Move(favpos)
				else:
					notfirst = 1
				answer = d.ShowModal()
				favpos = d.GetPosition()
				d.Destroy()
				if (answer == wxID_OK):					
					if (d.GetStringSelection() == "Replace"):
						self.parent.txtDocument.ReplaceTarget(replacetext)
						self.lastpos = self.lastpos + len(replacetext)
						self.targetEnd = self.targetEnd + diff
					else:
						self.lastpos = endpos
						x = x - 1
					x = x + 1
				
					matchedtext = regularexpression.search(self.parent.txtDocument.GetText()[self.lastpos:self.targetEnd])
				else:
					matchedtext = None					
					
		return x
	
	def reset(self):
		self.findflags = 0
		self.lastpos = 0
		self.backwards = 0
		self.findtext = ""
		self.targetStart = 0
		self.targetEnd = 0
		self.RE = 0
		#copy old finder limodou 2004/04/19
		self.SetTargetRange(self.parent.txtDocument.GetCurrentPos(), self.parent.txtDocument.GetTextLength())
		#end limodou
			
	def SetFindPos(self, findpos):
		self.lastpos = findpos	
		
	def SetTargetRange(self, start, end, backwards = 0):
		self.lastpos = start
		if (backwards):
			self.lastpos = end
		self.targetStart = start
		self.targetEnd = end
		

class drFindTextCtrl(wxTextCtrl):
	def __init__(self, parent, id, value, pos, size):
		wxTextCtrl.__init__(self, parent, id, value, pos, size)		
		
		EVT_CHAR(self, self.OnChar)
		
	def OnChar(self, event):
		if (event.GetKeyCode() == WXK_ESCAPE):
			self.GetParent().OnbtnCancel(event)
		elif (event.GetKeyCode() == WXK_RETURN):
			self.GetParent().OnbtnFind(event)
		else:
			event.Skip()
		

class drFindReplaceDialog(wxDialog):
	def __init__(self, parent, id, title, IsReplace = 0):
		wxDialog.__init__(self, parent, id, title, wxPoint(50, 50), wxSize(350, 300), wxDEFAULT_DIALOG_STYLE | wxMAXIMIZE_BOX | wxTHICK_FRAME | wxRESIZE_BORDER)		
		
		self.ID_FIND = 1001
		self.ID_CANCEL = 1002
		
		self.ID_CHK_REGEX = 1010
		self.ID_CREATERE = 1011
		
		self.ID_CLEAR_FIND = 1020
		self.ID_CLEAR_REPLACE = 1021
		
		self.theSizer = wxFlexGridSizer(8, 3, 5, 10)

		self.IsReplace = IsReplace

		#Size Buffer
		self.theSizer.Add(wxStaticText(self, -1, "    "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "    "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "    "), 1, wxSHAPED)

		self.theSizer.Add(wxStaticText(self, -1, "    "), 1, wxSHAPED)						
		self.theSizer.Add(wxStaticText(self, -1, "Search For: "), 1, wxSHAPED)		
		self.theSizer.Add(wxStaticText(self, -1, "    "), 1, wxSHAPED)
				
		self.txtSearchFor = drFindTextCtrl(self, -1, "", wxDefaultPosition, wxSize(175, -1))		
		self.btnClearFind = wxButton(self, self.ID_CLEAR_FIND, "Clear")
		self.theSizer.Add(wxStaticText(self, -1, "    "), 1, wxSHAPED)
		self.theSizer.Add(self.txtSearchFor, 1 ,wxSHAPED)
		self.theSizer.Add(self.btnClearFind, 1, wxSHAPED)
				
		if (IsReplace):
			self.SetSize(wxSize(375, 345))
			self.txtReplaceWith = drFindTextCtrl(self, -1, "", wxDefaultPosition, wxSize(175, -1))		
			self.btnClearReplace = wxButton(self, self.ID_CLEAR_REPLACE, "Clear")
		
		self.chkRegularExpression = wxCheckBox(self, self.ID_CHK_REGEX, "RegularExpression")
		self.btnCreateRE = wxButton(self, self.ID_CREATERE, " &Create ")
		self.chkMatchCase = wxCheckBox(self, -1, "Match Case")
		self.chkFindBackwards = wxCheckBox(self, -1, "Find Backwards")
		self.chkWholeWord = wxCheckBox(self, -1, "Whole Word")
		self.chkInSelection = wxCheckBox(self, -1, "In Selection")
		self.chkFromCursor = wxCheckBox(self, -1, "From Cursor")
		
		#Prefs
		self.chkRegularExpression.SetValue(parent.prefs.findreplaceregularexpression)
		self.btnCreateRE.Enable(parent.prefs.findreplaceregularexpression)
		self.chkMatchCase.SetValue(parent.prefs.findreplacematchcase)
		self.chkFindBackwards.SetValue(parent.prefs.findreplacefindbackwards)
		self.chkWholeWord.SetValue(parent.prefs.findreplacewholeword)
		self.chkInSelection.SetValue(parent.prefs.findreplaceinselection)
		self.chkFromCursor.SetValue(parent.prefs.findreplacefromcursor)
		
		self.chkInSelection.Enable(len(parent.txtDocument.GetSelectedText()) > 0)
		
		if (IsReplace):
			self.chkPromptOnReplace  = wxCheckBox(self, -1, "Prompt on Replace")
			self.theSizer.Add(wxStaticText(self, -1, "    "), 1, wxSHAPED)						
			self.theSizer.Add(wxStaticText(self, -1, "Replace With: "), 1, wxSHAPED)		
			self.theSizer.Add(wxStaticText(self, -1, "    "), 1, wxSHAPED)			
			
			self.theSizer.Add(wxStaticText(self, -1, "    "), 1, wxSHAPED)
			self.theSizer.Add(self.txtReplaceWith, 1 ,wxSHAPED)
			self.theSizer.Add(self.btnClearReplace, 1, wxSHAPED)
						
			self.chkFindBackwards.Disable()
						
			#Prefs
			self.chkPromptOnReplace.SetValue(parent.prefs.findreplacepromptonreplace)
		
		#Size Buffer
		self.theSizer.Add(wxStaticText(self, -1, "    "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "    "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "    "), 1, wxSHAPED)
				
		self.theSizer.Add(wxStaticText(self, -1, "    "), 1, wxSHAPED)
		self.theSizer.Add(self.chkRegularExpression, 1, wxSHAPED)
		self.theSizer.Add(self.btnCreateRE, 1, wxSHAPED)
		
		self.theSizer.Add(wxStaticText(self, -1, "    "), 1, wxSHAPED)
		self.theSizer.Add(self.chkMatchCase, 1, wxSHAPED)
		self.theSizer.Add(self.chkFindBackwards, 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "    "), 1, wxSHAPED)
		self.theSizer.Add(self.chkWholeWord, 1, wxSHAPED)
		self.theSizer.Add(self.chkInSelection, 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "    "), 1, wxSHAPED)
		self.theSizer.Add(self.chkFromCursor, 1, wxSHAPED)
		if (IsReplace):
			self.theSizer.Add(self.chkPromptOnReplace, 1, wxSHAPED)
		else:	
			self.theSizer.Add(wxStaticText(self, -1, "    "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "    "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "    "), 1, wxSHAPED)
		self.theSizer.Add(wxStaticText(self, -1, "    "), 1, wxSHAPED)		
		
		self.btnFind = wxButton(self, self.ID_FIND, "&Ok")
		self.btnCancel = wxButton(self, self.ID_CANCEL, "&Cancel")
		
		self.theSizer.Add(wxStaticText(self, -1, "    "), 1, wxSHAPED)
		self.theSizer.Add(self.btnFind, 1, wxSHAPED)
		self.theSizer.Add(self.btnCancel, 1, wxSHAPED)
				
		self.SetAutoLayout(True)
		self.SetSizer(self.theSizer)				
				
		self.btnFind.SetDefault()
		self.txtSearchFor.SetFocus()
				
		EVT_BUTTON(self, self.ID_CANCEL, self.OnbtnCancel)	
		EVT_BUTTON(self, self.ID_FIND, self.OnbtnFind)
		EVT_BUTTON(self, self.ID_CREATERE, self.OnbtnCreateRE)
	
		EVT_CHECKBOX(self, self.ID_CHK_REGEX, self.OnCheckRegularExpression)
		
		EVT_BUTTON(self, self.ID_CLEAR_FIND, self.OnbtnClearFind)
		if (IsReplace):
			EVT_BUTTON(self, self.ID_CLEAR_REPLACE, self.OnbtnClearReplace)
	
	def OnbtnCancel(self, event):
		self.Close(1)
	
	def OnbtnClearFind(self, event):
		self.txtSearchFor.SetValue("")
		self.txtSearchFor.SetFocus()
		
	def OnbtnClearReplace(self, event):
		self.txtReplaceWith.SetValue("")
		self.txtReplaceWith.SetFocus()
	
	def OnbtnCreateRE(self, event):
		from drRegularExpressionDialog import drRegularExpressionDialog
		d = drRegularExpressionDialog(self, -1, "Create Regular Expression")
		d.Show()
						
	def OnbtnFind(self, event):
		self.Show(0)
		findflags = 0
		findbackwards = self.chkFindBackwards.GetValue()
				
		#Set Target Range
		if (self.chkInSelection.GetValue()):
			selstart = self.GetParent().txtDocument.GetSelectionStart()
			selend = self.GetParent().txtDocument.GetSelectionEnd()
			if (selend - selstart) < 1:
				selstart = 0
				selend = self.GetParent().txtDocument.GetTextLength()
			self.GetParent().Finder.SetTargetRange(selstart, selend, findbackwards)
		elif (self.chkFromCursor.GetValue()):
			if (findbackwards):
				self.GetParent().Finder.SetTargetRange(0, self.GetParent().txtDocument.GetCurrentPos(), findbackwards)
			else:
				self.GetParent().Finder.SetTargetRange(self.GetParent().txtDocument.GetCurrentPos(), self.GetParent().txtDocument.GetTextLength(), findbackwards)
		else:
			self.GetParent().Finder.SetTargetRange(0, self.GetParent().txtDocument.GetTextLength(), findbackwards)
		
		#Do Search
		if (self.chkRegularExpression.GetValue()):
			if (self.IsReplace):
				x = self.GetParent().Finder.REReplaceAll(self.txtSearchFor.GetValue(), self.txtReplaceWith.GetValue(), self.chkMatchCase.GetValue(), self.chkPromptOnReplace.GetValue())
				if self.GetParent().prefs.enablefeedback:
					d = wxScrolledMessageDialog(self, (str(x) + " occurances of \"" + self.txtSearchFor.GetValue() + "\" replaced with \"" + self.txtReplaceWith.GetValue() + "\""), "Replace")
					d.ShowModal()
					d.Destroy()
			else:		
				self.GetParent().Finder.DoREFind(self.txtSearchFor.GetValue(), self.chkMatchCase.GetValue())
		else:
			#Set Flags
			if (self.chkWholeWord.GetValue()):
				findflags = findflags | wxSTC_FIND_WHOLEWORD
			if (self.chkMatchCase.GetValue()):
				findflags = findflags | wxSTC_FIND_MATCHCASE
				
			if (self.IsReplace):
				x = self.GetParent().Finder.ReplaceAll(self.txtSearchFor.GetValue(), self.txtReplaceWith.GetValue(), findflags, self.chkPromptOnReplace.GetValue())
				if self.GetParent().prefs.enablefeedback:
					d = wxScrolledMessageDialog(self, (str(x) + " occurances of \"" + self.txtSearchFor.GetValue() + "\" replaced with \"" + self.txtReplaceWith.GetValue() + "\""), "Replace")
					d.ShowModal()
					d.Destroy()
			else:
				self.GetParent().Finder.DoFind(self.txtSearchFor.GetValue(), findflags, findbackwards)
		
		self.Close(1)							
	
	def OnCheckRegularExpression(self, event):
		usingRegularExpressions = self.chkRegularExpression.GetValue()
		self.btnCreateRE.Enable(usingRegularExpressions)
		self.chkWholeWord.Enable(not usingRegularExpressions)
		if not self.IsReplace:
			self.chkFindBackwards.Enable(not usingRegularExpressions)
				
	def SetFindString(self, findstring):
		self.txtSearchFor.SetValue(findstring)
		self.txtSearchFor.SetSelection(0, len(findstring))		
