#	Programmer:	Daniel Pozmanter
#	E-mail:		drpython@bluebottle.com
#	Note:		You must reply to the verification e-mail to get through.
#
#	Copyright 2003-2004 Daniel Pozmanter
#
#	Distributed under the terms of the GPL (GNU Public License)
#
#    DrPython is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
	
#Regular Expression Dialog

from wxPython.wx import *
from wxPython.lib.dialogs import wxScrolledMessageDialog

wildcard = "Text File (*.txt)|*.txt|All files (*)|*"

class drRETextCtrl(wxTextCtrl):
	def __init__(self, parent, id, value, pos, size):
		wxTextCtrl.__init__(self, parent, id, value, pos, size)		
		
		EVT_CHAR(self, self.OnChar)
		
	def OnChar(self, event):
		if (event.GetKeyCode() == WXK_ESCAPE):
			self.GetParent().OnbtnCancel(event)
		elif (event.GetKeyCode() == WXK_RETURN):
			self.GetParent().OnbtnOk(event)
		else:
			event.Skip()
		

class drRegularExpressionDialog(wxFrame):
	def __init__(self, parent, id, title, prompthasfocus = 0, infiles = 0):
		if (wxPlatform == '__WXMSW__'):
			size = wxSize(500, 160)
		else:
			size = wxSize(500, 110)
		
		wxFrame.__init__(self, parent, id, title, wxPoint(50, 50), size, wxDEFAULT_DIALOG_STYLE | wxMAXIMIZE_BOX | wxTHICK_FRAME | wxRESIZE_BORDER)		

		self.ID_OK = 1001
		self.ID_CANCEL = 1002
		
		self.ID_LOAD = 1003
		self.ID_SAVE = 1004
		
		self.ID_ANYCHARACTER = 1010
		self.ID_ANYCHARACTERD = 10101
		self.ID_ANYCHARACTERND = 10102
		self.ID_ANYCHARACTERW = 10103
		self.ID_ANYCHARACTERNW = 10104
		self.ID_ANYCHARACTERA = 10105
		self.ID_ANYCHARACTERNA = 10106
		self.ID_SETOFCHARACTERS = 10107
		self.ID_START = 1011
		self.ID_END = 1012
		self.ID_STARTD = 1111
		self.ID_ENDD = 1112
		self.ID_EDGEW = 1211
		self.ID_EDGENW = 1212
		self.ID_REPSZEROPLUS = 1013
		self.ID_REPSONEPLUS = 1014
		self.ID_REPSZEROORONE = 1015
		self.ID_REPSN = 1016
		self.ID_GROUP = 1017
		self.ID_OR = 10171
		self.ID_POSITIVE_LOOKAHEAD = 1018
		self.ID_NEGATIVE_LOOKAHEAD = 1019
		self.ID_POSITIVE_LOOKBEHIND = 1118
		self.ID_NEGATIVE_LOOKBEHIND = 1119
		
		self.ID_INSERT_NORMAL_TEXT = 1050
				
		self.insert = (title == "Insert Regular Expression")
		
		self.theSizer = wxFlexGridSizer(4, 1, 5, 10)
				
		okcancelSizer = wxBoxSizer(wxHORIZONTAL)
						
		self.parent = parent
		self.prompthasfocus = prompthasfocus
		
		if self.insert:
			self.defaultdirectory = self.parent.prefs.defaultdirectory
			self.enablefeedback = self.parent.prefs.enablefeedback
		elif not infiles:
			self.defaultdirectory = self.parent.GetParent().prefs.defaultdirectory
			self.enablefeedback = self.parent.GetParent().prefs.enablefeedback
		else:
			self.defaultdirectory = self.parent.GetGrandParent().prefs.defaultdirectory
			self.enablefeedback = self.parent.GetGrandParent().prefs.enablefeedback

		FileMenu = wxMenu()
		FileMenu.Append(self.ID_LOAD, "&Load", " Load Regular Expression")
		FileMenu.Append(self.ID_SAVE, "&Save", " Save Regular Expression")
		
		TextMenu = wxMenu()
		TextMenu.Append(self.ID_INSERT_NORMAL_TEXT, "Normal Text")
		TextMenu.Append(self.ID_ANYCHARACTER, "Any Character  \".\"")
		TextMenu.Append(self.ID_ANYCHARACTERD, "Any Decimal Digit  \"\\d\"")
		TextMenu.Append(self.ID_ANYCHARACTERND, "Any Non Digit  \"\\D\"")
		TextMenu.Append(self.ID_ANYCHARACTERW, "Any Whitespace Character  \"\\s\"")
		TextMenu.Append(self.ID_ANYCHARACTERNW, "Any Non Whitespace Character  \"\\S\"")
		TextMenu.Append(self.ID_ANYCHARACTERA, "Any AlphaNumeric Character  \"\\w\"")
		TextMenu.Append(self.ID_ANYCHARACTERNA, "Any Non AlphaNumeric Character  \"\\W\"")
		TextMenu.Append(self.ID_SETOFCHARACTERS, "A Set of Characters  \"[ ]\"")
		
		RepetitionsMenu = wxMenu()
		RepetitionsMenu.Append(self.ID_REPSZEROPLUS, "0 Or More  \"*\"")
		RepetitionsMenu.Append(self.ID_REPSONEPLUS, "1 Or More  \"+\"")
		RepetitionsMenu.Append(self.ID_REPSZEROORONE, "0 Or 1  \"?\"")
		RepetitionsMenu.Append(self.ID_REPSN, "n  \"{n}\"")
		
		LimitMenu = wxMenu()
		LimitMenu.Append(self.ID_START, "The Start Of Each Line  \"^\"")
		LimitMenu.Append(self.ID_END, "The End Of Each Line  \"$\"")
		LimitMenu.Append(self.ID_STARTD, "The Start of the Document  \"\\A\"")
		LimitMenu.Append(self.ID_ENDD, "The End of the Document  \"\\Z\"")
		LimitMenu.Append(self.ID_EDGEW, "The Start or End of a Word  \"\\b\"")
		LimitMenu.Append(self.ID_EDGENW, "Text That is Not at Either End of a Word  \"\\B\"")
				
		lookMenu = wxMenu()
		lookMenu.Append(self.ID_POSITIVE_LOOKAHEAD, "Lookahead: Positive  \"(?=)\"")
		lookMenu.Append(self.ID_NEGATIVE_LOOKAHEAD, "Lookahead: Negative  \"(?!)\"")
		lookMenu.Append(self.ID_POSITIVE_LOOKBEHIND, "Lookbehind: Positive  \"(?<=)\"")
		lookMenu.Append(self.ID_NEGATIVE_LOOKBEHIND, "Lookbehind: Negative  \"(?<!)\"")
		
		InsertMenu = wxMenu()
		InsertMenu.AppendMenu(3001, "&Text", TextMenu)
		InsertMenu.AppendMenu(3002, "&Repetitions", RepetitionsMenu)
		InsertMenu.AppendMenu(3003, "&Match", LimitMenu)
		InsertMenu.AppendMenu(3004, "&Assertions", lookMenu)
		InsertMenu.Append(self.ID_OR, "&Or  \"|\"")
		InsertMenu.Append(self.ID_GROUP, "&Group  \"( )\"")
		
		menuBar = wxMenuBar()
		menuBar.Append(FileMenu,"&File")
		menuBar.Append(InsertMenu,"&Insert")
		
		self.SetMenuBar(menuBar)
				
		self.txtRE = drRETextCtrl(self, -1, "", wxDefaultPosition, wxSize(500, -1))	
				
		self.btnOk = wxButton(self, self.ID_OK, "&Ok")
		self.btnCancel = wxButton(self, self.ID_CANCEL, "&Cancel")
		
		okcancelSizer.Add(self.btnOk, 1, wxSHAPED)
		okcancelSizer.Add(self.btnCancel, 1, wxSHAPED)
		
		self.theSizer.Add(self.txtRE, 1, wxSHAPED | wxALIGN_CENTER)
		self.theSizer.Add(wxStaticText(self, -1, "   "), 1, wxSHAPED | wxALIGN_CENTER)		
		self.theSizer.Add(okcancelSizer, 1, wxSHAPED | wxALIGN_CENTER)
				
		self.SetAutoLayout(True)
		self.SetSizer(self.theSizer)				
				
		self.btnOk.SetDefault()
		self.txtRE.SetFocus()
						
		EVT_BUTTON(self, self.ID_CANCEL, self.OnbtnCancel)	
		EVT_BUTTON(self, self.ID_OK, self.OnbtnOk)		
		
		EVT_MENU(self, self.ID_LOAD, self.OnLoad)
		EVT_MENU(self, self.ID_SAVE, self.OnSave)
		EVT_MENU(self, self.ID_ANYCHARACTER, self.OnbtnAnyCharacter)
		EVT_MENU(self, self.ID_ANYCHARACTERD, self.OnbtnAnyCharacterD)
		EVT_MENU(self, self.ID_ANYCHARACTERND, self.OnbtnAnyCharacterND)
		EVT_MENU(self, self.ID_ANYCHARACTERW, self.OnbtnAnyCharacterW)
		EVT_MENU(self, self.ID_ANYCHARACTERNW, self.OnbtnAnyCharacterNW)
		EVT_MENU(self, self.ID_ANYCHARACTERA, self.OnbtnAnyCharacterA)
		EVT_MENU(self, self.ID_ANYCHARACTERNA, self.OnbtnAnyCharacterNA)
		EVT_MENU(self, self.ID_SETOFCHARACTERS, self.OnbtnSetOfCharacters)
		EVT_MENU(self, self.ID_START, self.OnbtnStart)
		EVT_MENU(self, self.ID_END, self.OnbtnEnd)
		EVT_MENU(self, self.ID_STARTD, self.OnbtnStartD)
		EVT_MENU(self, self.ID_ENDD, self.OnbtnEndD)
		EVT_MENU(self, self.ID_EDGEW, self.OnbtnEdgeW)
		EVT_MENU(self, self.ID_EDGENW, self.OnbtnEdgeNW)
		EVT_MENU(self, self.ID_REPSZEROPLUS, self.OnbtnRepsZeroPlus)
		EVT_MENU(self, self.ID_REPSONEPLUS, self.OnbtnRepsOnePlus)
		EVT_MENU(self, self.ID_REPSZEROORONE, self.OnbtnRepsZeroOrOne)
		EVT_MENU(self, self.ID_REPSN, self.OnbtnRepsN)
		EVT_MENU(self, self.ID_OR, self.OnbtnOr)
		EVT_MENU(self, self.ID_GROUP, self.OnbtnGroup)
		EVT_MENU(self, self.ID_POSITIVE_LOOKAHEAD, self.OnbtnLookPositiveA)
		EVT_MENU(self, self.ID_NEGATIVE_LOOKAHEAD, self.OnbtnLookNegativeA)
		EVT_MENU(self, self.ID_POSITIVE_LOOKBEHIND, self.OnbtnLookPositiveB)
		EVT_MENU(self, self.ID_NEGATIVE_LOOKBEHIND, self.OnbtnLookNegativeB)
		
		EVT_MENU(self, self.ID_INSERT_NORMAL_TEXT, self.OnbtnInsertNormalText)
		
	def insertText(self, text):
		pos = self.txtRE.GetInsertionPoint()
		textRE = self.txtRE.GetValue()
		self.txtRE.SetValue(textRE[0:pos] + text + textRE[pos:])
		self.txtRE.SetInsertionPoint(pos + len(text))
	
	def OnbtnAnyCharacter(self, event):
		self.insertText('.')
	
	def OnbtnAnyCharacterA(self, event):
		self.insertText('\\w')
	
	def OnbtnAnyCharacterD(self, event):
		self.insertText('\\d')
	
	def OnbtnAnyCharacterNA(self, event):
		self.insertText('\\W')
	
	def OnbtnAnyCharacterND(self, event):
		self.insertText('\\D')
	
	def OnbtnAnyCharacterNW(self, event):
		self.insertText('\\S')
	
	def OnbtnAnyCharacterW(self, event):
		self.insertText('\\s')
	
	def OnbtnAnyCharacter(self, event):
		self.insertText('.')
		
	def OnbtnCancel(self, event):
		self.txtRE.SetValue("")
		self.Close(1)
	
	def OnbtnEdgeNW(self, event):
		self.insertText('\\B')
		
	def OnbtnEdgeW(self, event):
		self.insertText('\\b')	
			
	def OnbtnEnd(self, event):
		self.insertText('$')
			
	def OnbtnEndD(self, event):
		self.insertText('\\Z')
	
	def OnbtnGroup(self, event):
		self.insertText('()')
		pos = self.txtRE.GetInsertionPoint()
		self.txtRE.SetInsertionPoint(pos - 1)
	
	def OnbtnInsertNormalText(self, event):
		d = wxTextEntryDialog(self, "Enter Normal Text", "Insert Normal Text", "")
		answer = d.ShowModal()
		v = d.GetValue()
		d.Destroy()
    		if (answer == wxID_OK):
			v = v.replace('\\', "\\\\").replace('^', "\\^").replace('*', "\\*").replace('$', "\\$")
			v = v.replace('+', "\\+").replace('?', "\\?").replace('{', "\\{").replace('}', "\\}")
			v = v.replace('[', "\\[").replace(']', "\\]").replace('(', "\\(").replace(')', "\\)")
			v = v.replace('.', "\\.").replace('|', "\\|")
			
			self.insertText(v)			

	def OnbtnLookNegativeA(self, event):
		self.insertText('(?!)')
		pos = self.txtRE.GetInsertionPoint()
		self.txtRE.SetInsertionPoint(pos - 1)

	def OnbtnLookPositiveA(self, event):
		self.insertText('(?=)')
		pos = self.txtRE.GetInsertionPoint()
		self.txtRE.SetInsertionPoint(pos - 1)	
		
	def OnbtnLookNegativeB(self, event):
		self.insertText('(?<!)')
		pos = self.txtRE.GetInsertionPoint()
		self.txtRE.SetInsertionPoint(pos - 1)

	def OnbtnLookPositiveB(self, event):
		self.insertText('(?<=)')
		pos = self.txtRE.GetInsertionPoint()
		self.txtRE.SetInsertionPoint(pos - 1)	
			
	def OnbtnOk(self, event):
		self.Show(0)

		result = self.txtRE.GetValue()
		l = len(result)
		if (l > 0):
			if self.insert:		
				if (self.prompthasfocus):
					pos = self.parent.txtPrompt.GetCurrentPos()
					self.parent.txtPrompt.InsertText(pos, result)
					self.parent.txtPrompt.GotoPos(pos + l)
				else:
					pos = self.parent.txtDocument.GetCurrentPos()
					self.parent.txtDocument.InsertText(pos, result)
					self.parent.txtDocument.GotoPos(pos + l)
			else:
				self.parent.txtSearchFor.SetValue(result)
			
		self.Close(1)							
	
	def OnbtnOr(self, event):		
		self.insertText('|')
	
	def OnbtnRepsN(self, event):
		d = wxTextEntryDialog(self, "Enter The Desired Number of Repetitions:", "Insert N Repetitions", "")
		answer = d.ShowModal()
		v = d.GetValue()
		d.Destroy()
    		if (answer == wxID_OK):				
			self.insertText('{' + v + '}')		
	
	def OnbtnRepsOnePlus(self, event):
		self.insertText('+')			
	
	def OnbtnRepsZeroOrOne(self, event):
		self.insertText('?')	
		
	def OnbtnRepsZeroPlus(self, event):
		self.insertText('*')		
	
	def OnbtnSetOfCharacters(self, event):
		self.insertText('[]')
		pos = self.txtRE.GetInsertionPoint()
		self.txtRE.SetInsertionPoint(pos - 1)
	
	def OnbtnStart(self, event):
		self.insertText('^')
		
	def OnbtnStartD(self, event):
		self.insertText('\\A')
	
	def OnLoad(self, event):
		dlg = wxFileDialog(self.parent, "Load Regular Expression From", "", "", wildcard, wxOPEN|wxHIDE_READONLY)
		if (len(self.defaultdirectory) > 0):
			try:
				dlg.SetDirectory(self.defaultdirectory)			
			except:
				d = wxScrolledMessageDialog(self, ("Error Setting Default Directory To: " + self.defaultdirectory), "DrPython Error")
				d.ShowModal()
				d.Destroy()
		if (dlg.ShowModal() == wxID_OK):
			refile = dlg.GetPath().replace("\\", "/")
			try:
				f = file(refile, 'r')
				text = f.read()
				f.close()
			except:
				d = wxScrolledMessageDialog(self, ("Error Reading From: " +  refile), "DrPython Error")
				d.ShowModal()
				d.Destroy()
				text = ""
			if (text.find('\n') > -1) or (text.find('\r') > -1):
				d = wxScrolledMessageDialog(self, ("Error Reading From: " +  refile), "DrPython Error")
				d.ShowModal()
				d.Destroy()
				text = ""
			self.txtRE.SetValue(text)
			
		dlg.Destroy()
		self.Raise()
		
	def OnSave(self, event):		
		dlg = wxFileDialog(self.parent, "Save Regular Expression As", "", "", wildcard, wxSAVE|wxOVERWRITE_PROMPT)
		if (len(self.defaultdirectory) > 0):
			try:
				dlg.SetDirectory(self.defaultdirectory)			
			except:
				d = wxScrolledMessageDialog(self, ("Error Setting Default Directory To: " + self.defaultdirectory), "DrPython Error")
				d.ShowModal()
				d.Destroy()
		if (dlg.ShowModal() == wxID_OK):
			refile = dlg.GetPath().replace("\\", "/")
			try:
				f = file(refile, 'w')
				f.write(self.txtRE.GetValue())
				f.close()
			except:
				d = wxScrolledMessageDialog(self, ("Error Writing To: " +  refile), "DrPython Error")
				d.ShowModal()
				d.Destroy()
				return
			if self.enablefeedback:
				d = wxScrolledMessageDialog(self, ("Successfully Saved: " + refile), "Save Success")
				d.ShowModal()
				d.Destroy()
    		dlg.Destroy()
		self.Raise()
