#	Programmer:	Daniel Pozmanter
#	E-mail:		drpython@bluebottle.com
#	Note:		You must reply to the verification e-mail to get through.
#
#	Copyright 2003-2004 Daniel Pozmanter
#
#	Distributed under the terms of the GPL (GNU Public License)
#
#    DrPython is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
	
#drScript Menu

import os.path, traceback, sys
from wxPython.wx import *
from wxPython.lib.dialogs import wxScrolledMessageDialog
from drPrefsFile import ExtractPreferenceFromText
import drShortcutsFile
import drShortcuts

def getTraceBackString():
	slist = traceback.format_tb(sys.exc_info()[2])
	l = len(slist)
	x = 0
	rstring = ""
	while x < l:
		rstring = rstring + slist[x]
		x = x + 1
	return str(sys.exc_info()[0]) + ":\n\n" + str(sys.exc_info()[1]) + "\n\n" + rstring

def updatescripts(scriptfile, paths, titles):
	l = len(paths)
	x = 0
	f = open(scriptfile, 'w')
	while (x < l):
		f.write("<path>" + paths[x] + "</path><title>" + titles[x] + "</title>\n")
		x = x + 1
	f.close()

class drScriptMenu(wxMenu):
	def __init__(self, parent):
		wxMenu.__init__(self)
		
		self.ID_ADD_SCRIPT = 3001
		self.ID_NEW_SCRIPT = 3002
		self.ID_EDIT_SCRIPT = 3003
		self.ID_MOVE_SCRIPTS = 3004
		self.ID_REMOVE_SCRIPT = 3005
		self.ID_DYNAMIC_SCRIPT = 3006
		
		self.ID_EXAMPLE_SCRIPTS = 3010
		
		self.ID_SCRIPT_BASE = parent.ID_SCRIPT_BASE
						
		self.parent = parent
		self.homedirectory = parent.homedirectory
		self.programdirectory = parent.programdirectory
		self.wildcard = parent.wildcard
				
		self.scriptcount = 0
		self.scripts = []
		self.titles = []
		
		self.setupMenu()
		
		self.ExampleScriptCount = 0
		
		self.loadscripts()
		
	def loadscripts(self, SyncShortcuts = 1):
		self.scriptcount = 0
		if self.parent.prefs.drscriptloadexamples:
			self.examplemenu = wxMenu()
			self.loadscriptsfromfile(self.programdirectory + "/examples/DrScript/drscript.dat", self.examplemenu, 1)
			self.AppendMenu(self.ID_EXAMPLE_SCRIPTS, "Examples", self.examplemenu)
			self.AppendSeparator()
			self.ExampleScriptCount = self.scriptcount
			
		self.loadscriptsfromfile(self.homedirectory + "/drscript.dat", self)
				
		#Either there is no shortcuts file, or it is out of sync.
		if SyncShortcuts:
			l = len(self.titles)
			if not (l == len(self.parent.DrScriptShortcuts)):
				self.parent.DrScriptShortcuts = []
				self.parent.DrScriptKeycodeArray = []
						
				x = 0
				while (x < l):
					self.parent.DrScriptShortcuts.append(drShortcuts.drShortcut())
					self.parent.DrScriptShortcuts[x].Name = self.titles[x]
					self.parent.DrScriptKeycodeArray.append("")
					x = x + 1		
	
	def loadscriptsfromfile(self, scriptfile, target, appendprogpath = 0):
		if (os.path.exists(scriptfile)):
			try:
				#Read from the file
				f = open(scriptfile, 'r')
				#Initialize
				line = f.readline()
				while (len(line) > 0):
					line_path = ExtractPreferenceFromText(line, "path")
					if appendprogpath:
						line_path = self.programdirectory + "/" + line_path.replace('\\', '/')
					line_title = ExtractPreferenceFromText(line, "title")
					if (os.path.exists(line_path)):
						target.Append((self.ID_SCRIPT_BASE + self.scriptcount), line_title, line_title)
						EVT_MENU(self.parent, (self.ID_SCRIPT_BASE + self.scriptcount), self.OnScript)
						self.scripts.append(line_path)
						self.titles.append(line_title)
						self.scriptcount = self.scriptcount + 1
					line = f.readline()
				f.close()
			except:
				d = wxScrolledMessageDialog(self.parent, ("Your drscript file is a tad messed up.\n"), "Error")
				d.ShowModal()
				d.Destroy()
		
	def OnAddScript(self, event):
		scriptfile = self.homedirectory + "/drscript.dat"
		dlg = wxFileDialog(self.parent, "Select Script File", "", "", self.wildcard, wxOPEN|wxHIDE_READONLY)
		if (len(self.parent.prefs.drscriptdefaultdirectory) > 0):
			try:
				dlg.SetDirectory(self.parent.prefs.drscriptdefaultdirectory)			
			except:
				d = wxScrolledMessageDialog(self.parent, ("Error Setting Default Directory To: " + self.parent.prefs.drscriptdefaultdirectory), "DrPython Error")
				d.ShowModal()
				d.Destroy()
		if (dlg.ShowModal() == wxID_OK):
			filen = dlg.GetPath().replace("\\", "/")
			d = wxTextEntryDialog(self.parent, 'Enter Script Title:', 'Add DrScript: Title', '')
			title = ""
			if (d.ShowModal() == wxID_OK):
				title = d.GetValue()
			d.Destroy()
			if (len(title) < 1):
				d = wxScrolledMessageDialog(self.parent, ("Bad script title.\nDrPython will politely ignore your request to add this script."), "Error")
				d.ShowModal()
				d.Destroy()
				return				
			self.Append((self.ID_SCRIPT_BASE + self.scriptcount), title, title)
			EVT_MENU(self.parent, (self.ID_SCRIPT_BASE + self.scriptcount), self.OnScript)
			self.scripts.append(filen)
			self.titles.append(title)
			
			x = len(self.parent.DrScriptShortcuts)
			self.parent.DrScriptShortcuts.append(drShortcuts.drShortcut())
			self.parent.DrScriptShortcuts[x].Name = title
			self.parent.DrScriptKeycodeArray.append("")
			
			self.scriptcount = self.scriptcount + 1
			try:
				f = open(scriptfile, 'a')
				f.write("<path>" + filen + "</path><title>" + title + "</title>\n")
				f.close()
				
				#Update the shortcuts Too.
				shortcutsfile = self.homedirectory + "/drscript.shortcuts.dat"
				drShortcutsFile.WriteShortcutsFromText(shortcutsfile, self.parent.DrScriptShortcuts, self.parent.ShortcutsIgnoreString)
			except:
				d = wxScrolledMessageDialog(self.parent, ("Problem saving script.\n"), "Error")
				d.ShowModal()
				d.Destroy()
		dlg.Destroy()
	
	def OnDynamicScript(self, event):
		from drDynamicDrScriptDialog import drDynamicDrScriptDialog
		d = drDynamicDrScriptDialog(self.parent)
		d.ShowModal()
		d.Destroy()
			
	def OnEditScript(self, event):
		if (len(self.scripts) > 0):
			d = wxSingleChoiceDialog(self.parent, "Select the Script to Edit:", "Edit Script", self.titles, wxOK|wxCANCEL)
			d.SetSize(wxSize(250, 250))
			answer = d.ShowModal()
			d.Destroy()
			if (answer == wxID_OK):
				i = d.GetSelection()
				old = self.parent.filename
				self.parent.filename = self.scripts[i].replace("\\", "/")
				if (len(old) > 0) or (self.parent.txtDocument.GetModify()):
					self.parent.OpenFile(True, False)
				else:
					self.parent.OpenFile(False, False)
		else:	
			d = wxScrolledMessageDialog(self.parent, ("There aren't any scripts to edit.\nTry \"New Script\" or \"Add Script\" Instead."), "Error")
			d.ShowModal()
			d.Destroy()		
	
	def OnMoveScripts(self, event):
		from drScriptDialog import drScriptDialog
		d = drScriptDialog(self.parent)
		d.ShowModal()
		d.Destroy()
		self.reloadscripts()
	
	def OnNewScript(self, event):
		scriptfile = self.homedirectory + "/drscript.dat"
		dlg = wxFileDialog(self.parent, "Save New Script File As", "", "", self.wildcard, wxSAVE|wxOVERWRITE_PROMPT)
		if (len(self.parent.prefs.drscriptdefaultdirectory) > 0):
			try:
				dlg.SetDirectory(self.parent.prefs.drscriptdefaultdirectory)			
			except:
				d = wxScrolledMessageDialog(self.parent, ("Error Setting Default Directory To: " + self.parent.prefs.drscriptdefaultdirectory), "DrPython Error")
				d.ShowModal()
				d.Destroy()
		if (dlg.ShowModal() == wxID_OK):
			filen = dlg.GetPath().replace("\\", "/")
			d = wxTextEntryDialog(self.parent, "Enter Script Title:", "Add DrScript: Title", "")
			title = ""
			if (d.ShowModal() == wxID_OK):
				title = d.GetValue()
			d.Destroy()
			if (len(title) < 1):
				d = wxScrolledMessageDialog(self.parent, ("Bad script title.\nDrPython will politely ignore your request to add this script."), "Error")
				d.ShowModal()
				d.Destroy()
				return		
						
			cfile = file(filen, 'wb')
			cfile.write("#drscript\n\n")
			cfile.close()
							
			self.Append((self.ID_SCRIPT_BASE + self.scriptcount), title, title)
			EVT_MENU(self.parent, (self.ID_SCRIPT_BASE + self.scriptcount), self.OnScript)
			self.scripts.append(filen)
			self.titles.append(title)
						
			x = len(self.parent.DrScriptShortcuts)
			self.parent.DrScriptShortcuts.append(drShortcuts.drShortcut())
			self.parent.DrScriptShortcuts[x].Name = title
			self.parent.DrScriptKeycodeArray.append("")
						
			self.scriptcount = self.scriptcount + 1
			try:
				f = open(scriptfile, 'a')
				f.write("<path>" + filen + "</path><title>" + title + "</title>\n")
				f.close()
				
				shortcutsfile = self.homedirectory + "/drscript.shortcuts.dat"
				drShortcutsFile.WriteShortcutsFromText(shortcutsfile, self.parent.DrScriptShortcuts, self.parent.ShortcutsIgnoreString)				
			except:
				d = wxScrolledMessageDialog(self.parent, ("Problem saving script.\n"), "Error")
				d.ShowModal()
				d.Destroy()				
			
			old = self.parent.filename
			self.parent.filename = filen
			if (len(old) > 0) or (self.parent.txtDocument.GetModify()):
				self.parent.OpenFile(True, False)
			else:
				self.parent.OpenFile(False, False)	
		dlg.Destroy()
		
		
	def OnRemoveScript(self, event):
		oldlength = len(self.scripts[self.ExampleScriptCount:])
		if (oldlength > 0):
			d = wxSingleChoiceDialog(self.parent, "Select the Script to Remove:", "Remove Script", self.titles[self.ExampleScriptCount:], wxOK|wxCANCEL)
			d.SetSize(wxSize(250, 250))
			answer = d.ShowModal()
			d.Destroy()
			if (answer == wxID_OK):
				i = self.ExampleScriptCount + d.GetSelection()
				self.parent.DrScriptShortcuts.pop(i)
				self.parent.DrScriptKeycodeArray.pop(i)
				self.scripts.pop(i)
				self.titles.pop(i)
				self.scriptcount = self.scriptcount - 1
				try:
					updatescripts((self.homedirectory + "/drscript.dat"), self.scripts[self.ExampleScriptCount:], self.titles[self.ExampleScriptCount:])			
					self.reloadscripts(oldlength)
					#Update the shortcuts Too.
					shortcutsfile = self.homedirectory + "/drscript.shortcuts.dat"
					drShortcutsFile.WriteShortcutsFromText(shortcutsfile, self.parent.DrScriptShortcuts, self.parent.ShortcutsIgnoreString)
				except:
					d = wxScrolledMessageDialog(self.parent, ("Error Saving Changes to DrScript.\n"), "Error")
					d.ShowModal()
					d.Destroy()				
		else:			
			d = wxScrolledMessageDialog(self.parent, ("There aren't any scripts to remove.\n"), "Error")
			d.ShowModal()
			d.Destroy()		

	def OnScript(self, event):
		scriptindex = event.GetId() - self.ID_SCRIPT_BASE
		f = open(self.scripts[scriptindex], 'r')
		scripttext = f.read()
		f.close()
		
		if (scripttext.find("DrFilename") > -1):
			scripttext = scripttext.replace("DrFilename", "self.parent.filename")
		if (scripttext.find("DrScript") > -1):
			scripttext = scripttext.replace("DrScript", "self.parent.DrScript")
		if (scripttext.find("DrDocument") > -1):
			scripttext = scripttext.replace("DrDocument", "self.parent.txtDocument")
		if (scripttext.find("DrPrompt") > -1):
			scripttext = scripttext.replace("DrPrompt", "self.parent.txtPrompt")
		if (scripttext.find("DrFrame") > -1):
			scripttext = scripttext.replace("DrFrame", "self.parent")	
		
		try:
			code = compile((scripttext + '\n'), self.scripts[scriptindex], 'exec')
		except:
			d = wxScrolledMessageDialog(self.parent, ("Error compiling script.\n\nTraceback:\n\n" + getTraceBackString()), "Error", wxDefaultPosition, wxSize(550,300))
			d.ShowModal()
			d.Destroy() 
			return
		
		try:
			exec(code)
		except:
			d = wxScrolledMessageDialog(self.parent, ("Error running script.\n\nTraceback:\n\n" + getTraceBackString()), "Error", wxDefaultPosition, wxSize(550,300))
			d.ShowModal()
			d.Destroy()
			return
	
	def setupMenu(self):		
		self.Append(self.ID_ADD_SCRIPT, "&Add Script...", " Add Script")
		self.Append(self.ID_NEW_SCRIPT, "&New Script...", " Create New Script")
		self.Append(self.ID_EDIT_SCRIPT, "&Edit Script...", "  Edit Script")
		self.Append(self.ID_MOVE_SCRIPTS, "&Rename | Move Scripts...", "  Rename or Move Scripts")
		self.Append(self.ID_REMOVE_SCRIPT, "&Remove Script...", " Remove Script")
		self.AppendSeparator()
		self.Append(self.ID_DYNAMIC_SCRIPT, "&Dynamic DrScript...", " Dynamic DrScript")
		self.AppendSeparator()
		
		
		EVT_MENU(self.parent, self.ID_ADD_SCRIPT, self.OnAddScript)
		EVT_MENU(self.parent, self.ID_NEW_SCRIPT, self.OnNewScript)
		EVT_MENU(self.parent, self.ID_EDIT_SCRIPT, self.OnEditScript)
		EVT_MENU(self.parent, self.ID_MOVE_SCRIPTS, self.OnMoveScripts)
		EVT_MENU(self.parent, self.ID_REMOVE_SCRIPT, self.OnRemoveScript)
		EVT_MENU(self.parent, self.ID_DYNAMIC_SCRIPT, self.OnDynamicScript)
				
	def reloadscripts(self, oldlength = -1, SyncShortcuts = 1):
		if oldlength < 0:
			oldlength = len(self.scripts)
		mnuitems = self.GetMenuItems()
		num = len(mnuitems)
		x = 0
		while (x < num):
			self.Remove(mnuitems[x].GetId())
			mnuitems[x].Destroy()
			x = x + 1
		self.scripts = []
		self.titles = []
		self.setupMenu()
		self.loadscripts(SyncShortcuts)