#	Programmer:	Daniel Pozmanter
#	E-mail:		drpython@bluebottle.com
#	Note:		You must reply to the verification e-mail to get through.
#
#	Copyright 2003-2004 Daniel Pozmanter
#
#	Distributed under the terms of the GPL (GNU Public License)
#
#    DrPython is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
	
#drShell Menu

import os, os.path, traceback, sys
from wxPython.wx import *
from wxPython.lib.dialogs import wxScrolledMessageDialog
from drPrefsFile import ExtractPreferenceFromText, GetPrefFromText
import drShortcutsFile
import drShortcuts

def getTraceBackString():
	slist = traceback.format_tb(sys.exc_info()[2])
	l = len(slist)
	x = 0
	rstring = ""
	while x < l:
		rstring = rstring + slist[x]
		x = x + 1
	return str(sys.exc_info()[0]) + ":\n\n" + str(sys.exc_info()[1]) + "\n\n" + rstring

def updateshells(shellfile, titles, commands, directories, arguments, runinprompt):
	l = len(titles)
	x = 0
	f = open(shellfile, 'w')
	while (x < l):
		f.write("<title>" + titles[x] + "</title><command>" + commands[x] + "</command><directory>" + directories[x] \
		+ "</directory><arguments>" + arguments[x] + "</arguments>" + "<run.in.prompt>" + str(runinprompt[x]) + "</run.in.prompt>\n")
		x = x + 1
	f.close()

class drShellMenu(wxMenu):
	def __init__(self, parent):
		wxMenu.__init__(self)
		
		self.ID_NEW_SHELL = 33001
		self.ID_EDIT_SHELL = 33002
		self.ID_MOVE_SHELLS = 33003
		self.ID_REMOVE_SHELL = 33004
		self.ID_RUN_SHELL = 33005
		self.ID_RUN_SHELL_IN_PROMPT = 33006
		
		self.ID_SHELL_BASE = parent.ID_SHELL_BASE
						
		self.parent = parent
		self.homedirectory = parent.homedirectory
		self.programdirectory = parent.programdirectory
		self.wildcard = parent.wildcard
				
		self.shellcount = 0
		self.directories = []
		self.arguments = []
		self.commands = []
		self.titles = []
		self.runinprompt = []
		
		self.setupMenu()
				
		self.loadshells()
		
	def loadshells(self, SyncShortcuts = 1):
		self.shellcount = 0
			
		self.loadshellsfromfile(self.homedirectory + "/drshell.dat", self)
				
		#Either there is no shortcuts file, or it is out of sync.
		if SyncShortcuts:
			l = len(self.titles)
			if not (l == len(self.parent.DrShellShortcuts)):
				self.parent.DrShellShortcuts = []
				self.parent.DrShellKeycodeArray = []
						
				x = 0
				while (x < l):
					self.parent.DrShellShortcuts.append(drShortcuts.drShortcut())
					self.parent.DrShellShortcuts[x].Name = self.titles[x]
					self.parent.DrShellKeycodeArray.append("")
					x = x + 1		
	
	def loadshellsfromfile(self, shellfile, target):
		if (os.path.exists(shellfile)):
			try:
				#Read from the file
				f = open(shellfile, 'r')
				#Initialize
				line = f.readline()
				while (len(line) > 0):
					command = ExtractPreferenceFromText(line, "command")
					args = ExtractPreferenceFromText(line, "arguments")
					dir = ExtractPreferenceFromText(line, "directory")
					line_title = ExtractPreferenceFromText(line, "title")
					inprompt = GetPrefFromText(self.parent.prefs.drshellruninpromptbydefault, line, "run.in.prompt", True)
					target.Append((self.ID_SHELL_BASE + self.shellcount), line_title, line_title)
					EVT_MENU(self.parent, (self.ID_SHELL_BASE + self.shellcount), self.OnShell)
					self.commands.append(command)
					self.arguments.append(args)
					self.directories.append(dir)
					self.titles.append(line_title)
					self.runinprompt.append(inprompt)
					self.shellcount = self.shellcount + 1
					line = f.readline()
				f.close()
			except:
				import sys, traceback
				slist = traceback.format_tb(sys.exc_info()[2])
				l = len(slist)
				x = 0
				rstring = ""
				while x < l:
					rstring = rstring + slist[x]
					x = x + 1
				print "Traceback (most recent call last):\n" + rstring \
				+ str(sys.exc_info()[0]).lstrip("exceptions.") + ": " + str(sys.exc_info()[1])

				d = wxScrolledMessageDialog(self.parent, ("Your drshell file is a tad messed up.\n"), "Error")
				d.ShowModal()
				d.Destroy()
			
	def OnEditShell(self, event):
		if (len(self.commands) > 0):
			d = wxSingleChoiceDialog(self.parent, "Select the Shell to Edit:", "Edit Shell", self.titles, wxOK|wxCANCEL)
			d.SetSize(wxSize(250, 250))
			answer = d.ShowModal()
			d.Destroy()
			if (answer == wxID_OK):
				i = d.GetSelection()
								
				shellfile = self.homedirectory + "/drshell.dat"			
				from drShellDialog import drNewShellDialog
				d = drNewShellDialog(self.parent, "Edit Shell Command")		
				if self.parent.prefs.platform_is_windows:
					d.SetSize(wxSize(425, 300))
				d.SetShellTuple(self.titles[i], self.commands[i], self.arguments[i], self.directories[i], self.runinprompt[i])
				d.ShowModal()
				if d.GetExitStatus():
					title, cmd, args, dir, inprompt = d.GetShellTuple()
					d.Destroy()
				else:
					d.Destroy()
					return
				if (len(title) < 1):
					d = wxScrolledMessageDialog(self.parent, ("Bad shell title.\nDrPython will politely ignore your request to add this shell command."), "Error")
					d.ShowModal()
					d.Destroy()
					return
											
				self.directories[i] = dir
				self.commands[i] = cmd
				self.arguments[i] = args
				self.titles[i] = title
				self.runinprompt[i] = inprompt
														
				try:
					updateshells((self.homedirectory + "/drshell.dat"), self.titles, self.commands, self.directories, self.arguments, self.runinprompt)
					self.reloadshells(len(self.titles))
				except:
					d = wxScrolledMessageDialog(self.parent, ("Problem saving shell.\n"), "Error")
					d.ShowModal()
					d.Destroy()	
		else:	
			d = wxScrolledMessageDialog(self.parent, ("There aren't any shells to edit.\nTry \"New Shell\" or \"Add Shell\" Instead."), "Error")
			d.ShowModal()
			d.Destroy()		
	
	def OnMoveShells(self, event):
		from drShellDialog import drMoveShellDialog
		d = drMoveShellDialog(self.parent)
		d.ShowModal()
		d.Destroy()
		self.reloadshells()
	
	def OnNewShell(self, event):
		shellfile = self.homedirectory + "/drshell.dat"			
		from drShellDialog import drNewShellDialog
		d = drNewShellDialog(self.parent, "New Shell Command")		
		if self.parent.prefs.platform_is_windows:
			d.SetSize(wxSize(425, 350))
		d.ShowModal()
		if d.GetExitStatus():
			title, cmd, args, dir, inprompt = d.GetShellTuple()
			d.Destroy()
		else:
			d.Destroy()
			return
		if (len(title) < 1):
			d = wxScrolledMessageDialog(self.parent, ("Bad shell title.\nDrPython will politely ignore your request to add this shell command."), "Error")
			d.ShowModal()
			d.Destroy()
			return
									
		self.Append((self.ID_SHELL_BASE + self.shellcount), title, title)
		EVT_MENU(self.parent, (self.ID_SHELL_BASE + self.shellcount), self.OnShell)
		self.directories.append(dir)
		self.commands.append(cmd)
		self.arguments.append(args)
		self.titles.append(title)
		self.runinprompt.append(inprompt)
					
		x = len(self.parent.DrShellShortcuts)
		self.parent.DrShellShortcuts.append(drShortcuts.drShortcut())
		self.parent.DrShellShortcuts[x].Name = title
		self.parent.DrShellKeycodeArray.append("")
					
		self.shellcount = self.shellcount + 1
		try:
			f = open(shellfile, 'a')
			f.write("<title>" + title + "</title><command>" + cmd + "</command><arguments>" + args + \
			"</arguments><directory>" + dir + "</directory>" + "<run.in.prompt>" + str(inprompt) + "</run.in.prompt>\n")
			f.close()
			
			shortcutsfile = self.homedirectory + "/drshell.shortcuts.dat"
			drShortcutsFile.WriteShortcutsFromText(shortcutsfile, self.parent.DrShellShortcuts, self.parent.ShortcutsIgnoreString)				
		except:
			import sys, traceback
			slist = traceback.format_tb(sys.exc_info()[2])
			l = len(slist)
			x = 0
			rstring = ""
			while x < l:
				rstring = rstring + slist[x]
				x = x + 1
			print "Traceback (most recent call last):\n" + rstring \
			+ str(sys.exc_info()[0]).lstrip("exceptions.") + ": " + str(sys.exc_info()[1])

			d = wxScrolledMessageDialog(self.parent, ("Problem saving shell.\n"), "Error")
			d.ShowModal()
			d.Destroy()		
		
	def OnRemoveShell(self, event):
		oldlength = len(self.commands)
		if (oldlength > 0):
			d = wxSingleChoiceDialog(self.parent, "Select the Shell to Remove:", "Remove Shell", self.titles, wxOK|wxCANCEL)
			d.SetSize(wxSize(250, 250))
			answer = d.ShowModal()
			d.Destroy()
			if (answer == wxID_OK):
				i = d.GetSelection()
				self.parent.DrShellShortcuts.pop(i)
				self.parent.DrShellKeycodeArray.pop(i)
				self.commands.pop(i)
				self.arguments.pop(i)
				self.directories.pop(i)
				self.titles.pop(i)
				self.runinprompt.pop(i)
				self.shellcount = self.shellcount - 1
				try:
					updateshells((self.homedirectory + "/drshell.dat"), self.titles, self.commands, self.directories, self.arguments, self.runinprompt)			
					self.reloadshells(oldlength)
					#Update the shortcuts Too.
					shortcutsfile = self.homedirectory + "/drshell.shortcuts.dat"
					drShortcutsFile.WriteShortcutsFromText(shortcutsfile, self.parent.DrShellShortcuts, self.parent.ShortcutsIgnoreString)
				except:
					d = wxScrolledMessageDialog(self.parent, ("Error Saving Changes to DrShell.\n"), "Error")
					d.ShowModal()
					d.Destroy()				
		else:			
			d = wxScrolledMessageDialog(self.parent, ("There aren't any shells to remove.\n"), "Error")
			d.ShowModal()
			d.Destroy()		

	def OnRunShell(self, event):
		d = wxTextEntryDialog(self.parent, "Enter Shell Command:", "Run Shell Command", "")
		answer = d.ShowModal()
		v = d.GetValue()
		d.Destroy()
		if (answer == wxID_OK):
			wxShell(v)
			
	def OnRunShellInPrompt(self, event):
		if self.parent.txtPrompt.pid is not -1:
			d = wxScrolledMessageDialog(self.parent, ("Close the current program first.\n"), "Error")
			d.ShowModal()
			d.Destroy()
			return
		d = wxTextEntryDialog(self.parent, "Enter Shell Command:", "Run Shell Command In Prompt", "")
		answer = d.ShowModal()
		v = d.GetValue()
		d.Destroy()
		if (answer == wxID_OK):
			self.parent.runcommand(v, event, 1)
			
	def OnShell(self, event):
		shellindex = event.GetId() - self.ID_SHELL_BASE
		args = self.arguments[shellindex]
		if args.find("<Current File>") > -1:
			args = args.replace("<Current File>", self.parent.filename)
		if args.find("<Current Directory>") > -1:
			args = args.replace("<Current Directory>", os.path.split(self.parent.filename)[0])
		command = self.commands[shellindex] + " " + args
		dir = self.directories[shellindex]
		if dir.find("<Current Directory>") > -1:
			dir = dir.replace("<Current Directory>", os.path.split(self.parent.filename)[0])
		inprompt = self.runinprompt[shellindex]
		if inprompt and (self.parent.txtPrompt.pid is not -1):
			d = wxScrolledMessageDialog(self.parent, ("Close the current program first.\n"), "Error")
			d.ShowModal()
			d.Destroy()
			return
		cdir = os.getcwd()
		try:
			if len(dir) > 0:
				os.chdir(dir)
			if inprompt:
				self.parent.runcommand(command, event, 1)
			else:
				wxShell(command)
			if len(dir) > 0:
				os.chdir(cdir)
		except:
			d = wxScrolledMessageDialog(self.parent, ("Error running shell.\n\nTraceback:\n\n" + getTraceBackString()), "Error", wxDefaultPosition, wxSize(550,300))
			d.ShowModal()
			d.Destroy()
			return
	
	def setupMenu(self):		
		self.Append(self.ID_NEW_SHELL, "&New Shell Command...", " Create New Shell Command")
		self.Append(self.ID_EDIT_SHELL, "&Edit Shell Command...", "  Edit Shell Command")
		self.Append(self.ID_MOVE_SHELLS, "Rename | Move Shells...", "  Rename or Move Shell Commands")
		self.Append(self.ID_REMOVE_SHELL, "Remove Shell Command...", " Remove Shell Command")
		self.AppendSeparator()
		self.Append(self.ID_RUN_SHELL, "&Run Shell Command...", " Run Shell Command")
		self.Append(self.ID_RUN_SHELL_IN_PROMPT, "Run Shell Command In Prompt", " Run Shell Command In Prompt")
		self.AppendSeparator()		
		
		EVT_MENU(self.parent, self.ID_NEW_SHELL, self.OnNewShell)
		EVT_MENU(self.parent, self.ID_EDIT_SHELL, self.OnEditShell)
		EVT_MENU(self.parent, self.ID_MOVE_SHELLS, self.OnMoveShells)
		EVT_MENU(self.parent, self.ID_REMOVE_SHELL, self.OnRemoveShell)
		EVT_MENU(self.parent, self.ID_RUN_SHELL, self.OnRunShell)
		EVT_MENU(self.parent, self.ID_RUN_SHELL_IN_PROMPT, self.OnRunShellInPrompt)
				
	def reloadshells(self, oldlength = -1, SyncShortcuts = 1):
		if oldlength < 0:
			oldlength = len(self.titles)
		mnuitems = self.GetMenuItems()
		num = len(mnuitems)
		x = 0
		while (x < num):
			self.Remove(mnuitems[x].GetId())
			mnuitems[x].Destroy()
			x = x + 1
		self.commands = []
		self.arguments = []
		self.directories = []
		self.titles = []
		self.runinprompt = []
		self.setupMenu()
		self.loadshells(SyncShortcuts)