#	Programmer:	Daniel Pozmanter
#	E-mail:		drpython@bluebottle.com
#	Note:		You must reply to the verification e-mail to get through.
#
#	Copyright 2003-2004 Daniel Pozmanter
#
#	Distributed under the terms of the GPL (GNU Public License)
#
#	DrPython is free software; you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation; either version 2 of the License, or
#	(at your option) any later version.
#
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#
#	You should have received a copy of the GNU General Public License
#	along with this program; if not, write to the Free Software
#	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#Some Folding Code From demo.py by Robin Dunn
#Some more from pype by Josiah Carlson
	
#The StyledTextControl

from wxPython.wx import *
from wxPython.stc import *
from drProperty import *
from drPopUp import SetUpPopUpActions
import drKeywords

class DrText(wxStyledTextCtrl):
	def __init__(self, parent, id, grandparent, DynamicScript = 0):
		wxStyledTextCtrl.__init__(self, parent, id)
		
		self.needtoindent = 0
		self.grandparent = grandparent
		
		self.ID_POPUP_BASE = 33000
		
		self.lineendingsaremixed = 0
		
		self.locale = 3
		
		self.currentlanguage = 0
		
		self.SetControlCharSymbol(254)
		
		#Right Click Menu
		self.UsePopUp(0)
								
		self.SetMarginType(0, wxSTC_MARGIN_SYMBOL)
		self.SetMarginType(1, wxSTC_MARGIN_NUMBER)
		
		self.SetMarginWidth(0, 0)
		self.SetMarginWidth(1, 0)
		self.SetMarginWidth(2, 0)
		
		self.SetMarginType(2, wxSTC_MARGIN_SYMBOL)
		self.SetMarginMask(2, wxSTC_MASK_FOLDERS)
		
		self.MarkerDefine(0, wxSTC_MARK_ARROW)
		self.SetScrollWidth(1)
		
		self.SetupTabs()
		
		self.usestyles = (self.grandparent.prefs.docusestyles == 1)			
		
		if not DynamicScript:
			EVT_STC_MODIFIED(self, id, self.OnModified)
			EVT_KEY_UP(self, self.OnPositionChanged)
			EVT_LEFT_UP(self, self.OnPositionChanged)
		EVT_UPDATE_UI(self, id, self.OnUpdateUI)
		EVT_KEY_DOWN(self, self.OnKeyDown)
		EVT_STC_CHARADDED(self, id, self.OnCharAdded)
		EVT_STC_MARGINCLICK(self, id, self.OnMarginClick)
		EVT_RIGHT_DOWN(self, self.OnPopUp)

	def GetEndOfLineCharacter(self):
		emode = self.GetEOLMode()
		if emode == wxSTC_EOL_CR:
			return '\r'
		elif emode == wxSTC_EOL_CRLF:
			return '\r\n'
		return '\n'

	def OnModified(self, event):
		if (self.GetModify()):
			if (len(self.grandparent.filename) <= 0):
				self.grandparent.SetTitle("DrPython - Untitled*")
			elif (self.grandparent.GetTitle().find('*') == -1):
				self.grandparent.SetTitle("DrPython - " + self.grandparent.filename + "*")
		else:
			self.SetSavePoint()
			if (len(self.grandparent.filename) <= 0):
				self.grandparent.SetTitle("DrPython - Untitled")
			else:
				self.grandparent.SetTitle("DrPython - " + self.grandparent.filename)
		if not (self.grandparent.prefs.docwordwrap):
			ll = self.TextWidth(wxSTC_STYLE_DEFAULT, "OOO")
			x = 0
			current_width = self.GetScrollWidth()
			line = self.GetCurLine()[0].expandtabs(self.tabwidth)
			actual_width = self.TextWidth(wxSTC_STYLE_DEFAULT, line)
			if (current_width < actual_width):
				self.SetScrollWidth(actual_width + ll)

	def OnPositionChanged(self, event):
		if self.lineendingsaremixed:
			eolmodestr = "MIX"
		else:
			emode = self.GetEOLMode()
			if emode == wxSTC_EOL_CR:
				eolmodestr = "MAC"
			elif emode == wxSTC_EOL_CRLF:
				eolmodestr = "WIN"
			else:
				eolmodestr = "UNIX"
			
		self.grandparent.SetStatusText(("Line: %(line)s, Col: %(col)s %(mode)s" % {"line": self.GetCurrentLine()+1, "col": self.GetColumn(self.GetCurrentPos()), "mode": eolmodestr}), 1)
		event.Skip()

	def OnUpdateUI(self, event):
		if (self.usestyles):
			#check for matching braces
			braceAtCaret = -1
			braceOpposite = -1
			caretPos = self.GetCurrentPos()
			charBefore = self.GetCharAt(caretPos - 1)
	
			# check before
			if charBefore and chr(charBefore) in "[]{}()" and self.GetStyleAt(caretPos - 1) == wxSTC_P_OPERATOR:
				braceAtCaret = caretPos - 1
				
			if braceAtCaret < 0:
				# check after
				charAfter = self.GetCharAt(caretPos)
				if charAfter and chr(charAfter) in "[]{}()" and self.GetStyleAt(caretPos) == wxSTC_P_OPERATOR:
					braceAtCaret = caretPos
	
			if braceAtCaret >= 0:
				braceOpposite = self.BraceMatch(braceAtCaret)
	
			if braceAtCaret != -1  and braceOpposite == -1:
				self.BraceBadLight(braceAtCaret)
			else:
				self.BraceHighlight(braceAtCaret, braceOpposite)
			
	def OnKeyDown(self, event):		
		if (not self.grandparent.RunShortcuts(event, self)):
			keycode = event.GetKeyCode()
			if (keycode == WXK_RETURN) and (self.grandparent.prefs.docautoindent):
				self.needtoindent = 1
			event.Skip()

	def OnCharAdded(self, event):
		pos = self.GetCurrentPos()
		if (self.needtoindent == 1):
			self.needtoindent = 0
			#Look at last line
			pos = pos - 1
			self.GotoPos(pos)
			linenumber = self.GetCurrentLine()
			self.GotoLine(self.LineFromPosition(pos))
			numtabs = self.GetLineIndentation(linenumber) / self.tabwidth
			#Go to current line to add tabs
			pos = pos + 1
			self.GotoPos(pos)
			x = 0
			while (x < numtabs):
				self.AddText(self.addchar)
				x = x + 1
		event.Skip()
		
	def OnMarginClick(self, event):
		# fold and unfold as needed
		if event.GetMargin() == 2:
			lineClicked = self.LineFromPosition(event.GetPosition())
			if self.GetFoldLevel(lineClicked) & wxSTC_FOLDLEVELHEADERFLAG:
				self.ToggleFold(lineClicked)

	def OnPopUp(self, event):
		self.actiondict, self.builtindict = SetUpPopUpActions(self.grandparent)
		
		if len(self.grandparent.popupmenulist) < 1:
			self.grandparent.popupmenulist = ["Undo", "Redo", "<Separator>", "Cut", "Copy", "Paste", "Delete", "<Separator>", "Select All"]
		
		self.PopUpMenu = wxMenu()
		
		x = 0
		l = len(self.grandparent.popupmenulist)
		while x < l:
			if self.grandparent.popupmenulist[x] == "<Separator>":
				self.PopUpMenu.AppendSeparator()
			else:
				self.PopUpMenu.Append(self.ID_POPUP_BASE+x, self.grandparent.popupmenulist[x])
				EVT_MENU(self, self.ID_POPUP_BASE+x, self.OnPopUpMenu)
			x = x + 1
		self.PopupMenu(self.PopUpMenu, event.GetPosition())
		
		self.PopUpMenu.Destroy()

	def OnPopUpMenu(self, event):
		eid = event.GetId()
		label = self.PopUpMenu.GetLabel(eid)
		
		if label in self.actiondict:
			self.actiondict[label](event)
		elif label in self.builtindict:
			self.CmdKeyExecute(self.builtindict[label])
		elif label.find("Tab") > -1:
			if label == "Next Tab":
				self.grandparent.OnSelectTab(1)
			elif label == "Previous Tab":
				self.grandparent.OnSelectTab(-1)
			elif label == "First Tab":
				self.grandparent.OnSelectTab(0)
			elif label == "Last Tab":
				self.grandparent.OnSelectTab(2)		

	def SetupPrefsDocument(self, notmdiupdate = 1):
		if self.grandparent.prefs.doconlyusedefaultsyntaxhighlighting:
			self.currentlanguage = self.grandparent.prefs.docdefaultsyntaxhighlighting
		#comment limodou 2004/04/16
		#self.locale = self.grandparent.prefs.encoding
		#end limodou
		self.SetEndAtLastLine(not self.grandparent.prefs.docscrollextrapage)
		self.SetIndentationGuides(self.grandparent.prefs.docuseindentationguides)
		self.SetupTabs()
		self.SetUseTabs(self.grandparent.prefs.docusetabs)
		if (self.grandparent.prefs.docfolding):
			self.grandparent.viewmenu.Enable(self.grandparent.ID_FOLDING, True)
			self.SetMarginWidth(2, 12)
			self.SetMarginSensitive(2, True)
			#WIERD!
			self.SetProperty("fold", "1")
			self.SetProperty("tab.timmy.whinge.level", "1")	
		else:
			self.grandparent.viewmenu.Enable(self.grandparent.ID_FOLDING, False)
			self.SetMarginWidth(2, 0)
			self.SetMarginSensitive(2, False)
			#WIERD!
			self.SetProperty("fold", "0")
			self.SetProperty("tab.timmy.whinge.level", "0")	
		
		#LongLineCol from Chris McDonough
		
		#Adding if statement, else section myself, also added code to use line and/or background method:
		#I put the set edge color section in under styles.
		
		if self.grandparent.prefs.doclonglinecol > 0:
			self.SetEdgeColumn(self.grandparent.prefs.doclonglinecol)
			self.SetEdgeMode(wxSTC_EDGE_LINE)
		elif self.grandparent.prefs.doclonglinecol < 0:
			self.SetEdgeColumn(abs(self.grandparent.prefs.doclonglinecol))
			self.SetEdgeMode(wxSTC_EDGE_BACKGROUND)
		else:
			self.SetEdgeMode(wxSTC_EDGE_NONE)			
				
		#/LongLineCol from Chris McDonough
				
		self.SetMarginWidth(1, self.grandparent.prefs.docmarginwidth)
		
		if (self.grandparent.prefs.eolmode == 1):
			self.SetEOLMode(wxSTC_EOL_CRLF)
		elif (self.grandparent.prefs.eolmode == 2):
			self.SetEOLMode(wxSTC_EOL_CR)
		else:
			self.SetEOLMode(wxSTC_EOL_LF)
			
		if notmdiupdate:
			self.SetViewWhiteSpace(self.grandparent.prefs.docwhitespaceisvisible)
			
		self.SetTabWidth(self.grandparent.prefs.tabwidth)
		
		if (self.grandparent.prefs.docwordwrap):
			self.SetWrapMode(wxSTC_WRAP_WORD)
		else:
			self.SetWrapMode(wxSTC_WRAP_NONE)
						
		self.SetKeyWords(0, drKeywords.GetKeyWords(self.currentlanguage))
					
		self.SetLexer(drKeywords.GetLexer(self.currentlanguage))
	
		if (self.currentlanguage == 0) or (self.currentlanguage == 3):
			self.grandparent.prefs.txtDocumentStyleArray = self.grandparent.prefs.PythonStyleArray
			cursorstyle = self.grandparent.prefs.txtDocumentStyleArray[13]
			foldingstyle = self.grandparent.prefs.txtDocumentStyleArray[15]
			self.SetEdgeColour(self.grandparent.prefs.txtDocumentStyleArray[16])
		elif self.currentlanguage == 1:
			self.grandparent.prefs.txtDocumentStyleArray = self.grandparent.prefs.CPPStyleArray
			cursorstyle = self.grandparent.prefs.txtDocumentStyleArray[14]
			foldingstyle = self.grandparent.prefs.txtDocumentStyleArray[16]
			self.SetEdgeColour(self.grandparent.prefs.txtDocumentStyleArray[16])
		elif self.currentlanguage == 2:
			self.grandparent.prefs.txtDocumentStyleArray = self.grandparent.prefs.HTMLStyleArray
			cursorstyle = self.grandparent.prefs.txtDocumentStyleArray[18]
			foldingstyle = self.grandparent.prefs.txtDocumentStyleArray[20]
			self.SetEdgeColour(self.grandparent.prefs.txtDocumentStyleArray[16])

		#Folding:
		foldback = getStyleProperty("back", foldingstyle)
		foldfore = getStyleProperty("fore", foldingstyle)
		self.MarkerDefine(wxSTC_MARKNUM_FOLDEREND, wxSTC_MARK_BOXPLUSCONNECTED, foldback, foldfore)
		self.MarkerDefine(wxSTC_MARKNUM_FOLDEROPENMID, wxSTC_MARK_BOXMINUSCONNECTED, foldback, foldfore)
		self.MarkerDefine(wxSTC_MARKNUM_FOLDERMIDTAIL, wxSTC_MARK_TCORNER, foldback, foldfore)
		self.MarkerDefine(wxSTC_MARKNUM_FOLDERTAIL,wxSTC_MARK_LCORNER, foldback, foldfore)
		self.MarkerDefine(wxSTC_MARKNUM_FOLDERSUB, wxSTC_MARK_VLINE, foldback, foldfore)
		self.MarkerDefine(wxSTC_MARKNUM_FOLDER,wxSTC_MARK_BOXPLUS, foldback, foldfore)
		self.MarkerDefine(wxSTC_MARKNUM_FOLDEROPEN,wxSTC_MARK_BOXMINUS, foldback, foldfore)
				
		if self.grandparent.prefs.docusestyles:
		
			self.StyleSetSpec(wxSTC_STYLE_DEFAULT, self.grandparent.prefs.txtDocumentStyleArray[0])
			self.StyleSetSpec(wxSTC_STYLE_INDENTGUIDE, self.grandparent.prefs.txtDocumentStyleArray[0])

			self.StyleClearAll()

			self.StartStyling(0, 0xff)	
			self.SetCaretForeground(cursorstyle)							
			
			if (self.grandparent.prefs.docusestyles < 2) or (not self.currentlanguage == 4):
				self.StyleSetSpec(wxSTC_STYLE_LINENUMBER, self.grandparent.prefs.txtDocumentStyleArray[1])
				self.StyleSetSpec(wxSTC_STYLE_BRACELIGHT, self.grandparent.prefs.txtDocumentStyleArray[2])
				self.StyleSetSpec(wxSTC_STYLE_BRACEBAD, self.grandparent.prefs.txtDocumentStyleArray[3])
				drKeywords.SetSTCStyles(self.grandparent, self, self.currentlanguage)

	def SetupTabs(self):
		self.tabwidth = self.grandparent.prefs.tabwidth
		self.addchar = '\t'
		if (not self.grandparent.prefs.docusetabs) and (self.grandparent.prefs.docautoindent):
			x = 0
			self.addchar = "\t".expandtabs(self.tabwidth)		

	def SetSelectedText(self, text):
		self.SetTargetStart(self.GetSelectionStart())
		self.SetTargetEnd(self.GetSelectionEnd())
		self.ReplaceTarget(text)

	def FoldAll(self, expanding):
		lineCount = self.GetLineCount()

		#Yup, this is different from the  demo.py stuff.
		#This is a really messed up hack of the pype.py and demo.py stuff to act
		#the way I want it to...
		#Folding is just ugly.
				
		#Set stuff up first...
		lines = []
		lineNum = 0
		for line in xrange(lineCount):
			lines.append(line)		
		lines.reverse()
		
		if (not expanding):
			#Code Inspired by pype.py...Wake wxSTC Up Before we fold!
			self.HideLines(0, lineCount-1)
			wxYield()
			self.ShowLines(0, lineCount-1)
		
			for line in xrange(lineCount):
				if self.GetFoldLevel(line) & wxSTC_FOLDLEVELHEADERFLAG:
					self.SetFoldExpanded(line, 1)
				
		#Back to demo.py...mmmm, open source...Modified ever so slightly
		
		if (expanding):
			#Modify the demo.py stuff to act like pype.py:
			for line in lines:
				a = self.GetLastChild(line, -1)
				self.ShowLines(line+1,a)
				self.SetFoldExpanded(line, True)
		else:
			#Get pype.py funky(Ever so slightly modified old bean)!
			for line in lines:
				a = self.GetLastChild(line, -1)
				self.HideLines(line+1,a)
				self.SetFoldExpanded(line, False)

	def Expand(self, line, doExpand, force=False, visLevels=0, level=-1):
		#From demo.py (pype.py 1.1.8 uses it too!)
		lastChild = self.GetLastChild(line, level)
		line = line + 1
		while line <= lastChild:
			if force:
				if visLevels > 0:
					self.ShowLines(line, line)
				else:
					self.HideLines(line, line)
			else:
				if doExpand:
					self.ShowLines(line, line)
			if level == -1:
				level = self.GetFoldLevel(line)
			if level & wxSTC_FOLDLEVELHEADERFLAG:
				if force:
					if visLevels > 1:
						self.SetFoldExpanded(line, True)
					else:
						self.SetFoldExpanded(line, False)
					line = self.Expand(line, doExpand, force, visLevels-1)
				else:
					if doExpand and self.GetFoldExpanded(line):
						line = self.Expand(line, True, force, visLevels-1)
					else:
						line = self.Expand(line, False, force, visLevels-1)
			else:
				line = line + 1
		return line