#	Programmer:	Daniel Pozmanter
#	E-mail:		drpython@bluebottle.com
#	Note:		You must reply to the verification e-mail to get through.
#
#	Copyright 2003-2004 Daniel Pozmanter
#
#	Distributed under the terms of the GPL (GNU Public License)
#
#	DrPython is free software; you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation; either version 2 of the License, or
#	(at your option) any later version.
#
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#
#	You should have received a copy of the GNU General Public License
#	along with this program; if not, write to the Free Software
#	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
	
#Open Imported Module Dialog

import os, os.path, sys
import wx

class drOpenImportedModuleDialog(wx.Dialog):
	def __init__(self, parent, modulelist, point=(0, 0), size=(250, 300)):
		wx.Dialog.__init__(self, parent, -1, "Open Imported Module", point, size, wx.DEFAULT_DIALOG_STYLE | wx.MAXIMIZE_BOX | wx.THICK_FRAME | wx.RESIZE_BORDER)
		
		self.parent = parent
		
		self.filepath = os.path.split(parent.txtDocument.filename)[0]
	
		self.ID_MODULES = 101
		self.ID_TXT_MODULE = 102
		
		self.ID_OK = 111
		self.ID_CANCEL = 112
		
		#/Constants
		
		#Components:

		self.txtModule = wx.TextCtrl(self, self.ID_TXT_MODULE, '', (0, 0), (250, -1))

		self.modules = modulelist

		self.listModules = wx.ListBox(self, self.ID_MODULES, (0, 0), (250, 250), modulelist)
	
		self.btnOk = wx.Button(self, self.ID_OK, "  &Ok  ")
		
		self.btnOk.SetDefault()
		self.txtModule.SetFocus()
								
		self.btnCancel = wx.Button(self, self.ID_CANCEL, "  &Cancel  ")
		
		#/Components
		
		#Sizer:
						
		self.theSizer = wx.BoxSizer(wx.VERTICAL)
	
		self.textSizer = wx.BoxSizer(wx.HORIZONTAL)
		
		self.textSizer.Add(wx.StaticText(self, -1, '  '), 0, wx.SHAPED | wx.ALIGN_RIGHT)
		self.textSizer.Add(self.txtModule, 1, wx.EXPAND)
		self.textSizer.Add(wx.StaticText(self, -1, '  '), 0, wx.SHAPED)
		
		self.listSizer = wx.BoxSizer(wx.HORIZONTAL)
		
		self.listSizer.Add(wx.StaticText(self, -1, '  '), 0, wx.SHAPED | wx.ALIGN_RIGHT)
		self.listSizer.Add(self.listModules, 1, wx.EXPAND)
		self.listSizer.Add(wx.StaticText(self, -1, '  '), 0, wx.SHAPED)
		
		self.commandSizer = wx.BoxSizer(wx.HORIZONTAL)
		
		self.commandSizer.Add(wx.StaticText(self, -1, '  '), 0, wx.SHAPED | wx.ALIGN_RIGHT)
		self.commandSizer.Add(self.btnCancel, 0, wx.SHAPED | wx.ALIGN_LEFT)
		self.commandSizer.Add(wx.StaticText(self, -1, '  '), 1, wx.EXPAND)
		self.commandSizer.Add(self.btnOk, 0, wx.SHAPED | wx.ALIGN_RIGHT)
		self.commandSizer.Add(wx.StaticText(self, -1, '  '), 0, wx.SHAPED | wx.ALIGN_RIGHT)
		
		self.theSizer.Add(wx.StaticText(self, -1, '  '), 0, wx.SHAPED)
		self.theSizer.Add(self.textSizer, 0, wx.EXPAND)
		self.theSizer.Add(wx.StaticText(self, -1, '  '), 0, wx.SHAPED)
		self.theSizer.Add(self.listSizer, 9, wx.EXPAND)
		self.theSizer.Add(wx.StaticText(self, -1, '  '), 0, wx.SHAPED)		
		self.theSizer.Add(self.commandSizer, 0, wx.EXPAND)
		self.theSizer.Add(wx.StaticText(self, -1, '  '), 0, wx.SHAPED)
		
		self.SetAutoLayout(True)
		self.SetSizerAndFit(self.theSizer)
		
		#/Sizer
		
		#Events:
		
		self.Bind(wx.EVT_BUTTON, self.OnbtnCancel, id=self.ID_CANCEL)
		self.Bind(wx.EVT_BUTTON, self.OnbtnOk, id=self.ID_OK)
		
		self.Bind(wx.EVT_TEXT, self.OnTextChanged, id=self.ID_TXT_MODULE)
				
		self.txtModule.Bind(wx.EVT_CHAR, self.OnTextChar)
		
		self.listModules.Bind(wx.EVT_LISTBOX_DCLICK, self.OnbtnOk)
		self.listModules.Bind(wx.EVT_CHAR, self.OnChar)
		self.Bind(wx.EVT_CHAR, self.OnChar)
						
		#/Events
		
		self.listModules.SetSelection(0)
				
		self.parent.LoadDialogSizeAndPosition(self, 'openimportedmoduledialog.sizeandposition.dat')
	
	def GetSelectedModule(self):
		selmodule = self.listModules.GetStringSelection()
		moduletext = selmodule
		#Special Cases:
		if selmodule == 'os.path':
			if self.parent.PLATFORM_IS_WIN:
				selmodule = 'ntpath'
			elif os.name == 'mac':
				selmoudle = 'macpath'
			else:
				selmodule = 'posixpath'
				
		selectedmodule = '/' + selmodule.replace('.', '/') + '.py'
		#Handle cases like 'import wx' == import 'wx.__init__'
		selectedinitmodule = '/' + selmodule.replace('.', '/') + '/__init__.py'
		
		if os.path.exists(self.filepath + selectedmodule):
			return moduletext, (self.filepath + selectedmodule)
		if os.path.exists(self.filepath + selectedinitmodule):
			return moduletext, (self.filepath + selectedinitmodule)
		
		#Search for the file:
		for somepath in sys.path:				
			modulefile = somepath.replace('\\', '/') + selectedmodule
			initfile = somepath.replace('\\', '/') + selectedinitmodule
			if os.path.exists(modulefile):
				return moduletext, modulefile
			elif os.path.exists(initfile):
				return moduletext, initfile
							
		return moduletext, None
	
	def OnCloseW(self, event):
		self.parent.SaveDialogSizeAndPosition(self, 'openimportedmodule.sizeandposition.dat')
		if event is not None:
			event.Skip()	
				
	def OnbtnCancel(self, event):
		self.EndModal(wx.ID_CANCEL)
	
	def OnbtnOk(self, event):
		l = self.listModules.GetCount()
		if l > 0:
			self.EndModal(wx.ID_OK)
		else:
			self.EndModal(wx.ID_CANCEL)			

	def OnTextChar(self, event):
		ekc = event.GetKeyCode()
		i = self.listModules.GetSelection()
		l = self.listModules.GetCount()
		
		if ekc == wx.WXK_UP:
			i -= 1
			if i < 0:
				i = l - 1
			self.listModules.SetSelection(i)					
		elif ekc == wx.WXK_DOWN:
			i += 1
			if i >= l:
				i = 0
			self.listModules.SetSelection(i)		
		self.OnChar(event)
	
	def OnChar(self, event):
		if (event.GetKeyCode() == wx.WXK_ESCAPE):
			self.OnbtnCancel(None)
		elif (event.GetKeyCode() == wx.WXK_RETURN):
			self.OnbtnOk(None)
		else:
			event.Skip()
		
	def OnTextChanged(self, event):
		text = self.txtModule.GetValue()
		stringselection = self.listModules.GetStringSelection()
		l = len(text)
		
		newlist = []
		for mod in self.modules:
			if mod[:l] == text:
				newlist.append(mod)

		self.listModules.Set(newlist)
		
		if stringselection in newlist:
			self.listModules.SetStringSelection(stringselection)
		else:
			if len(newlist) > 0:
				self.listModules.SetSelection(0)
	
		event.Skip()