#	Programmer:	Daniel Pozmanter
#	E-mail:		drpython@bluebottle.com
#	Note:		You must reply to the verification e-mail to get through.
#
#	Copyright 2003-2004 Daniel Pozmanter
#
#	Distributed under the terms of the GPL (GNU Public License)
#
#    DrPython is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
	
#Preferences

#LongLineCol from Chris McDonough
#Changed name from longlinecol to doclonglinecol

#The idea for using a dictionary for reading/writing preferences
#ame from submitted code by limodou that was never incorporated
#into DrPython.  (It used an array of preferences,
#and called modified versions of drPrefsFile functions using
#setattr and getattr to read and write preferences).

import os.path

def GetPreferencesDictionary():
	#Each item in the Dictionary:
	#(Key, Array)
	#Each item in the Array:
	#(Preference, Preferences File String, Function)
	#Function: 0: (GetPref, Not an Integer,), 1: (GetPref, Integer), 2: (ExtractPref, Not an Integer).
	return {'General': [('rememberwindowsizeandposition', 'remember.window.size.and.position', 1), \
('rememberdialogsizesandpositions', 'remember.dialog.sizes.and.positions', 1), \
('autodetectencoding', 'auto.detect.encoding', 1), \
('saveonrun', 'save.on.run', 1), \
('promptonsaveall', 'prompt.on.save.all', 1), \
('iconsize', 'icon.size', 1), \
('iconfile', 'icon.file', 2), \
('recentfileslimit', 'max.recent.files', 1), \
('tabwidth', 'tab.width', 1), \
('pythonargs', 'python.arguments', 2), \
('defaultdirectory', 'default.directory', 2), \
('enablefeedback', 'enable.feedback', 1), \
('alwayspromptonexit', 'always.prompt.on.exit', 1), \
('backupfileonsave', 'backup.file.on.save', 1)], \
'Line Endings': [('checkeol', 'check.line.ending.type', 1), \
('eolmode', 'line.ending.type', 1)], \
'File Dialog': [('constantwildcard', 'constant.wildcard', 0), \
('wildcard', 'wildcard', 0), \
('windowsshortcutreplacetable', 'windows.shortcut.replace.table', 0), \
('usewxfiledialog', 'use.wx.filedialog', 1)], \
'Drag and Drop': [('draganddropmode', 'drag.and.drop.mode', 1), \
('draganddroptextmode', 'drag.and.drop.text.mode', 1)], \
'Document': [('docmarginwidth', 'doc.margin.width', 1), \
('docwordwrap', 'doc.wordwrap', 1), \
('docautoindent', 'doc.autoindent', 1), \
('docautoreload', 'doc.autoreload', 1), \
('docupdateindentation', 'doc.update.indentation', 1), \
('docparenthesismatching', 'doc.parenthesis.matching', 1), \
('docusefileindentation', 'doc.use.file.indentation', 1), \
('docusetabs', 'doc.use.tabs', 1), \
('docwhitespaceisvisible', 'doc.whitespace.is.visible.on.startup', 1), \
('docfolding', 'doc.folding', 1), \
('dochighlightcurrentline', 'doc.highlight.current.line', 1), \
('doccaretwidth', 'doc.caret.width', 1), \
('doccommentstring', 'doc.comment.string', 0), \
('doccommentmode', 'doc.comment.mode', 1), \
('docusestyles', 'doc.use.styles', 1), \
('docuseindentationguides', 'doc.use.indentation.guides', 1), \
('doclonglinecol', 'doc.long.line.col', 1), \
('docscrollextrapage', 'doc.scroll.extra.page', 1), \
('docdefaultsyntaxhighlighting', 'doc.default.syntax.highlighting', 1), \
('doconlyusedefaultsyntaxhighlighting', 'doc.only.use.default.syntax.highlighting', 1), \
('PythonStyleArray[0]', 'doc.style.normal', 0), \
('PythonStyleArray[1]', 'doc.style.linenumber', 0), \
('PythonStyleArray[2]', 'doc.style.brace.match', 0), \
('PythonStyleArray[3]', 'doc.style.brace.nomatch', 0), \
('PythonStyleArray[4]', 'doc.style.character', 0), \
('PythonStyleArray[5]', 'doc.style.class', 0), \
('PythonStyleArray[6]', 'doc.style.comment', 0), \
('PythonStyleArray[7]', 'doc.style.definition', 0), \
('PythonStyleArray[8]', 'doc.style.keyword', 0), \
('PythonStyleArray[9]', 'doc.style.number', 0), \
('PythonStyleArray[10]', 'doc.style.operator', 0), \
('PythonStyleArray[11]', 'doc.style.string', 0), \
('PythonStyleArray[12]', 'doc.style.triple.string', 0), \
('PythonStyleArray[13]', 'doc.style.caret', 0), \
('PythonStyleArray[14]', 'doc.style.selection', 0), \
('PythonStyleArray[15]', 'doc.style.folding', 0), \
('PythonStyleArray[16]', 'doc.style.longlinecol', 0), \
('PythonStyleArray[17]', 'doc.style.current.line', 0), \
('CPPStyleArray[0]', 'doc.cstyle.normal', 0), \
('CPPStyleArray[1]', 'doc.cstyle.linenumber', 0), \
('CPPStyleArray[2]', 'doc.cstyle.brace.match', 0), \
('CPPStyleArray[3]', 'doc.cstyle.brace.nomatch', 0), \
('CPPStyleArray[4]', 'doc.cstyle.character', 0), \
('CPPStyleArray[5]', 'doc.cstyle.preprocessor', 0), \
('CPPStyleArray[6]', 'doc.cstyle.comment', 0), \
('CPPStyleArray[7]', 'doc.cstyle.verbatim', 0), \
('CPPStyleArray[8]', 'doc.cstyle.keyword', 0), \
('CPPStyleArray[9]', 'doc.cstyle.number', 0), \
('CPPStyleArray[10]', 'doc.cstyle.operator', 0), \
('CPPStyleArray[11]', 'doc.cstyle.string', 0), \
('CPPStyleArray[12]', 'doc.cstyle.regex', 0), \
('CPPStyleArray[13]', 'doc.cstyle.uuid', 0), \
('CPPStyleArray[14]', 'doc.cstyle.caret', 0), \
('CPPStyleArray[15]', 'doc.cstyle.selection', 0), \
('CPPStyleArray[16]', 'doc.cstyle.folding', 0), \
('CPPStyleArray[17]', 'doc.cstyle.longlinecol', 0), \
('CPPStyleArray[18]', 'doc.cstyle.current.line', 0), \
('HTMLStyleArray[0]', 'doc.htmlstyle.normal', 0), \
('HTMLStyleArray[1]', 'doc.htmlstyle.linenumber', 0), \
('HTMLStyleArray[2]', 'doc.htmlstyle.brace.match', 0), \
('HTMLStyleArray[3]', 'doc.htmlstyle.brace.nomatch', 0), \
('HTMLStyleArray[4]', 'doc.htmlstyle.tag', 0), \
('HTMLStyleArray[5]', 'doc.htmlstyle.unknown.tag', 0), \
('HTMLStyleArray[6]', 'doc.htmlstyle.attribute', 0), \
('HTMLStyleArray[7]', 'doc.htmlstyle.unknown.attribute', 0), \
('HTMLStyleArray[8]', 'doc.htmlstyle.number', 0), \
('HTMLStyleArray[9]', 'doc.htmlstyle.string', 0), \
('HTMLStyleArray[10]', 'doc.htmlstyle.character', 0), \
('HTMLStyleArray[11]', 'doc.htmlstyle.comment', 0), \
('HTMLStyleArray[12]', 'doc.htmlstyle.entity', 0), \
('HTMLStyleArray[13]', 'doc.htmlstyle.tag.end', 0), \
('HTMLStyleArray[14]', 'doc.htmlstyle.xml.start', 0), \
('HTMLStyleArray[15]', 'doc.htmlstyle.xml.end', 0), \
('HTMLStyleArray[16]', 'doc.htmlstyle.script', 0), \
('HTMLStyleArray[17]', 'doc.htmlstyle.value', 0), \
('HTMLStyleArray[18]', 'doc.htmlstyle.caret', 0), \
('HTMLStyleArray[19]', 'doc.htmlstyle.selection', 0), \
('HTMLStyleArray[20]', 'doc.htmlstyle.folding', 0), \
('HTMLStyleArray[21]', 'doc.htmlstyle.longlinecol', 0), \
('HTMLStyleArray[22]', 'doc.htmlstyle.current.line', 0)], \
'Prompt': [('promptisvisible', 'prompt.is.visible.on.startup', 1), \
('promptmarginwidth', 'prompt.margin.width', 1), \
('promptsize', 'prompt.size', 1), \
('promptusetabs', 'prompt.use.tabs', 1), \
('promptwordwrap', 'prompt.wordwrap', 1), \
('promptwhitespaceisvisible', 'prompt.whitespace.is.visible.on.startup', 1), \
('promptcaretwidth', 'prompt.caret.width', 1), \
('promptusestyles', 'prompt.use.styles', 1), \
('promptscrollextrapage', 'prompt.scroll.extra.page', 1), \
('txtPromptStyleArray[0]', 'prompt.style.normal', 0), \
('txtPromptStyleArray[1]', 'prompt.style.linenumber', 0), \
('txtPromptStyleArray[2]', 'prompt.style.brace.match', 0), \
('txtPromptStyleArray[3]', 'prompt.style.brace.nomatch', 0), \
('txtPromptStyleArray[4]', 'prompt.style.character', 0), \
('txtPromptStyleArray[5]', 'prompt.style.class', 0), \
('txtPromptStyleArray[6]', 'prompt.style.comment', 0), \
('txtPromptStyleArray[7]', 'prompt.style.definition', 0), \
('txtPromptStyleArray[8]', 'prompt.style.keyword', 0), \
('txtPromptStyleArray[9]', 'prompt.style.number', 0), \
('txtPromptStyleArray[10]', 'prompt.style.operator', 0), \
('txtPromptStyleArray[11]', 'prompt.style.string', 0), \
('txtPromptStyleArray[12]', 'prompt.style.triple.string', 0), \
('txtPromptStyleArray[13]', 'prompt.style.caret', 0), \
('txtPromptStyleArray[14]', 'prompt.style.selection', 0)], \
'Side Panels': [('sidepanelleftsize', 'side.panel.left.size', 1), \
('sidepanelrightsize', 'side.panel.right.size', 1), \
('sidepaneltopsize', 'side.panel.top.size', 1), \
('sidepanelbottomsize', 'side.panel.bottom.size', 1)], \
'Find/Replace': [('findreplaceregularexpression', 'find.replace.regular.expression', 1), \
('findreplacematchcase', 'find.replace.match.case', 1), \
('findreplacefindbackwards', 'find.replace.find.backwards', 1), \
('findreplacewholeword', 'find.replace.whole.word', 1), \
('findreplaceinselection', 'find.replace.in.selection', 1), \
('findreplacefromcursor', 'find.replace.from.cursor', 1), \
('findreplacepromptonreplace', 'find.replace.prompt.on.replace', 1), \
('findreplaceautowrap', 'find.replace.auto.wrap', 1), \
('findreplaceundercursor', 'find.replace.prompt.under.cursor', 1)], \
'Source Browser': [('sourcebrowserpanel', 'sourcebrowser.pane', 1), \
('sourcebrowserisvisible', 'sourcebrowser.is.visible', 1), \
('sourcebrowsercloseonactivate', 'sourcebrowser.close.on.activate', 1), \
('sourcebrowserissorted', 'sourcebrowser.is.sorted', 1), \
('sourcebrowserautorefreshonsave', 'sourcebrowser.auto.refresh.on.save', 1), \
('sourcebrowserstyle', 'sourcebrowser.style', 0)], \
'Bookmarks': [('bookmarksstyle', 'bookmarks.style', 0)], \
'Plugins': [('pluginsdefaultdirectory', 'plugins.default.directory', 2)], \
'DrScript': [('drscriptdefaultdirectory', 'drscript.default.directory', 2), \
('drscriptstyle', 'drscript.style', 0), \
('drscriptloadexamples', 'drscript.load.examples', 1)], \
'Printing': [('printdoclinenumbers', 'print.doc.linenumbers', 1), \
('printpromptlinenumbers', 'print.prompt.linenumbers', 1), \
('printtabwidth', 'print.tab.width', 1)], \
'Documentation': [('documentationbrowser', 'documentation.browser', 0), \
('documentationpythonlocation', 'documentation.python.location', 0), \
('documentationwxwidgetslocation', 'documentation.wx.widgets.location', 0), \
('documentationrehowtolocation', 'documentation.rehowto.location', 0)]}

class drPreferences:

	def __init__(self, platform_is_windows, programdirectory = ""):
		self.platform_is_windows = platform_is_windows
		self.programdirectory = programdirectory
		
		#General Settings
		self.rememberwindowsizeandposition = 1
		self.rememberdialogsizesandpositions = 0
		self.autodetectencoding = 1
		self.saveonrun = 0
		self.promptonsaveall = 1
		self.iconsize = 24
		self.iconfile = ""
		self.recentfileslimit = 10
		self.tabwidth = 4
		self.checkeol = 1
		self.eolmode = 0
		self.pythonargs = ""
		self.defaultdirectory = os.path.expanduser("~")
		self.enablefeedback = 1
		self.alwayspromptonexit = 0
		self.backupfileonsave = 1
		
		#File Dialog
		self.usewxfiledialog = 0
		self.constantwildcard = '*.lnk'
		#self.windowsshortcutreplacetable = 'C:,/mnt/win_c#'
		#@ = replace with lowercase match & = replace with exact match
		self.windowsshortcutreplacetable = '[A-Z],/mnt/win_@#'
		if (self.platform_is_windows):
			self.wildcard = "Python Source (*.pyw *.py)|*.pyw;*.py|C/C++ Source (*.c *.cc *.cpp *.cxx *.h *.hh *.hpp *.hxx)|*.c;*.cc;*.cpp;*.cxx;*.h;*.hh;*.hpp;*.hxx|HTML Files (*.htm *.html *.shtm *.shtml *.xml)|*.htm;*.html;*.shtm;*.shtml;*.xml|Backup Files (*.bak)|*.bak|Plain Text (*.txt *.dat *.log)|*.txt;*.dat;*.log|All Files (*)|*"
		else:
			self.wildcard = "Python Source (*.py *.pyw)|*.py;*.pyw|C/C++ Source (*.c *.cc *.cpp *.cxx *.h *.hh *.hpp *.hxx)|*.c;*.cc;*.cpp;*.cxx;*.h;*.hh;*.hpp;*.hxx|HTML Files (*.htm *.html *.shtm *.shtml *.xml)|*.htm;*.html;*.shtm;*.shtml;*.xml|Backup Files (*.bak)|*.bak|Plain Text (*.txt *.dat *.log)|*.txt;*.dat;*.log|All Files (*)|*"
		
		#Drag and Drop
		self.draganddropmode = 0
		self.draganddroptextmode = 0
		
		#Document Settings
		self.docmarginwidth = 41
		self.docwordwrap = 0
		self.docautoindent = 2
		self.docautoreload = 1
		self.docupdateindentation = 1
		self.docparenthesismatching = 1
		self.docusefileindentation = 1
		self.docusetabs = 1
		self.docwhitespaceisvisible = 0
		self.docfolding = 0
		self.dochighlightcurrentline = 1
		self.doccaretwidth = 1
		self.doccommentstring = '#'
		self.doccommentmode = 0
		self.docusestyles = 1
		self.docuseindentationguides = 0
		self.doclonglinecol = 0
		self.docscrollextrapage = 0
		self.docdefaultsyntaxhighlighting = 0
		self.doconlyusedefaultsyntaxhighlighting = 0
		
		self.PythonStyleArray = ["", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""]
		self.CPPStyleArray = ["", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""]
		self.HTMLStyleArray = ["", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", ""]
		
		self.PythonStyleArray[0] = "fore:#000000,back:#FFFFFF,size:12,face:lucida"
		self.PythonStyleArray[1] = "fore:#000000,back:#82AEE3,size:12,face:lucida"
		if (self.platform_is_windows):
			self.PythonStyleArray[0] = "fore:#000000,back:#FFFFFF,size:8,face:Courier New"
			self.PythonStyleArray[1] = "fore:#000000,back:#82AEE3,size:8,face:Courier New"
		self.PythonStyleArray[2] = "fore:#FF6400,back:#98D3FF,bold"
		self.PythonStyleArray[3] = "fore:#FF0000,back:#FFFF00,bold"
		self.PythonStyleArray[4] = "fore:#007f08,back:#ffffff"
		self.PythonStyleArray[5] = "fore:#b200ac,back:#ffffff"
		self.PythonStyleArray[6] = "fore:#2D3D9E,back:#DFDFEB,bold"
		self.PythonStyleArray[7] = "fore:#e80300,back:#ffffff"
		self.PythonStyleArray[8] = "fore:#000000,back:#ffffff,bold"
		self.PythonStyleArray[9] = "fore:#0027c4,back:#ffffff"
		self.PythonStyleArray[10] = "fore:#204D71,back:#ffffff,bold"
		self.PythonStyleArray[11] = "fore:#007f08,back:#ffffff"
		self.PythonStyleArray[12] = "fore:#7B8184,back:#FFFFFF,bold"
		self.PythonStyleArray[13] = "#000000"
		self.PythonStyleArray[14] = "fore:#000000,back:#FF7900"
		self.PythonStyleArray[15] = "fore:#000000,back:#82AEE3"
		self.PythonStyleArray[16] = "#82AEE3"
		self.PythonStyleArray[17] = "#98D3FF"
		
		self.CPPStyleArray[0] = "fore:#000000,back:#FFFFFF,size:12,face:lucida"
		self.CPPStyleArray[1] = "fore:#000000,back:#82AEE3,size:12,face:lucida"
		if (self.platform_is_windows):
			self.CPPStyleArray[0] = "fore:#000000,back:#FFFFFF,size:8,face:Courier New"
			self.CPPStyleArray[1] = "fore:#000000,back:#82AEE3,size:8,face:Courier New"
		self.CPPStyleArray[2] = "fore:#FF6400,back:#98D3FF,bold"
		self.CPPStyleArray[3] = "fore:#FF0000,back:#FFFF00,bold"
		self.CPPStyleArray[4] = "fore:#007f08,back:#ffffff"
		self.CPPStyleArray[5] = "fore:#b200ac,back:#ffffff"
		self.CPPStyleArray[6] = "fore:#2D3D9E,back:#DFDFEB,bold"
		self.CPPStyleArray[7] = "fore:#e80300,back:#ffffff"
		self.CPPStyleArray[8] = "fore:#000000,back:#ffffff,bold"
		self.CPPStyleArray[9] = "fore:#2050C6,back:#ffffff,"
		self.CPPStyleArray[10] = "fore:#003D22,back:#ffffff"
		self.CPPStyleArray[11] = "fore:#008500,back:#FFFFFF"
		self.CPPStyleArray[12] = "fore:#338144,back:#5FFFFF,bold"
		self.CPPStyleArray[13] = "fore:#330044,back:#5FFFFF"
		self.CPPStyleArray[14] = "#000000"
		self.CPPStyleArray[15] = "fore:#000000,back:#FF7900"
		self.CPPStyleArray[16] = "fore:#000000,back:#82AEE3"
		self.CPPStyleArray[17] = "#82AEE3"
		self.CPPStyleArray[18] = "#98D3FF"
		
		self.HTMLStyleArray[0] = "fore:#000000,back:#FFFFFF,size:12,face:lucida"
		self.HTMLStyleArray[1] = "fore:#000000,back:#82AEE3,size:12,face:lucida"
		if (self.platform_is_windows):
			self.HTMLStyleArray[0] = "fore:#000000,back:#FFFFFF,size:8,face:Courier New"
			self.HTMLStyleArray[1] = "fore:#000000,back:#82AEE3,size:8,face:Courier New"
		self.HTMLStyleArray[2] = "fore:#FF6400,back:#98D3FF,bold"
		self.HTMLStyleArray[3] = "fore:#FF0000,back:#FFFF00,bold"
		self.HTMLStyleArray[4] = "fore:#000000,back:#ffffff,bold"
		self.HTMLStyleArray[5] = "fore:#0000FF,back:#FFFFFF,bold"
		self.HTMLStyleArray[6] = "fore:#2D3D9E,back:#DFDFEB,bold"
		self.HTMLStyleArray[7] = "fore:#FF0000,back:#ffff00,bold"
		self.HTMLStyleArray[8] = "fore:#0000FF,back:#ffffff"
		self.HTMLStyleArray[9] = "fore:#003100,back:#ffffff"
		self.HTMLStyleArray[10] = "fore:#204D71,back:#ffffff,bold"
		self.HTMLStyleArray[11] = "fore:#2D3D9E,back:#DFDFEB,bold"
		self.HTMLStyleArray[12] = "fore:#7B8184,back:#FFFFFF,bold"
		self.HTMLStyleArray[13] = "fore:#000000,back:#FFF7C2,bold"
		self.HTMLStyleArray[14] = "fore:#000081,back:#FFE48D,bold"
		self.HTMLStyleArray[15] = "fore:#006E00,back:#FFE48D,bold"
		self.HTMLStyleArray[16] = "fore:#00812A,back:#CEF0FF,bold"
		self.HTMLStyleArray[17] = "fore:#000000,back:#C2FFE8,bold"
		self.HTMLStyleArray[18] = "#000000"
		self.HTMLStyleArray[19] = "fore:#000000,back:#FF7900"
		self.HTMLStyleArray[20] = "fore:#000000,back:#82AEE3"
		self.HTMLStyleArray[21] = "#82AEE3"
		self.HTMLStyleArray[22] = "#98D3FF"
		
		self.txtDocumentStyleArray = self.PythonStyleArray
		
		#Prompt Settings
		self.promptisvisible = 0
		self.promptmarginwidth = 0
		self.promptsize = 50		
		self.promptusetabs = 1
		self.promptwordwrap = 1
		self.promptwhitespaceisvisible = 0
		self.promptcaretwidth = 1	
		self.promptusestyles = 1
		self.promptscrollextrapage = 0
		self.txtPromptStyleArray = ["", "", "", "", "", "", "", "", "", "", "", "", "", "", ""]
		self.txtPromptStyleArray[0] = "fore:#FFFFFF,back:#000000,size:12,face:fixed"
		if (self.platform_is_windows):
			self.txtPromptStyleArray[0] = "fore:#FFFFFF,back:#000000,size:8,face:Courier New"
		self.txtPromptStyleArray[1] = "fore:#FFFFFF,back:#710000"
		self.txtPromptStyleArray[2] = "fore:#FFFFFF,back:#000000"
		self.txtPromptStyleArray[3] = "fore:#FFFFFF,back:#000000"
		self.txtPromptStyleArray[4] = "fore:#FFFFFF,back:#000000"
		self.txtPromptStyleArray[5] = "fore:#FFFFFF,back:#000000"
		self.txtPromptStyleArray[6] = "fore:#FFFFFF,back:#000000"
		self.txtPromptStyleArray[7] = "fore:#FFFFFF,back:#000000"
		self.txtPromptStyleArray[8] = "fore:#FFFFFF,back:#000000"
		self.txtPromptStyleArray[9] = "fore:#FFFFFF,back:#000000"
		self.txtPromptStyleArray[10] = "fore:#FFFFFF,back:#000000"
		self.txtPromptStyleArray[11] = "fore:#FFFFFF,back:#000000"
		self.txtPromptStyleArray[12] = "fore:#FFFFFF,back:#000000"
		self.txtPromptStyleArray[13] = "#FFFFFF"
		self.txtPromptStyleArray[14] = "fore:#000000,back:#FF7900"
		
		#Side Pane Settings
		self.sidepanelleftsize = 30
		self.sidepanelrightsize = 30
		self.sidepaneltopsize = 30
		self.sidepanelbottomsize = 30
		
		#Find/Replace Settings
		self.findreplaceregularexpression = 0
		self.findreplacematchcase = 0
		self.findreplacefindbackwards = 0
		self.findreplacewholeword = 0
		self.findreplaceinselection = 0
		self.findreplacefromcursor = 0
		self.findreplacepromptonreplace = 1
		self.findreplaceautowrap = 0
		self.findreplaceundercursor = 1						
				
		#Source Browser Settings
		self.sourcebrowserpanel = 0
		self.sourcebrowserisvisible = 0
		self.sourcebrowsercloseonactivate = 0
		self.sourcebrowserissorted = 0
		self.sourcebrowserautorefreshonsave = 1
		self.sourcebrowserstyle = "fore:#000000,back:#FFFFFF,size:12,face:fixed,bold"
		if (self.platform_is_windows):
			self.sourcebrowserstyle = "fore:#000000,back:#FFFFFF,size:8,face:Arial,bold"				
		
		#Bookmarks Settings
		self.bookmarksstyle = "fore:#000000,back:#FFFFFF,size:12,face:fixed,bold"
		if (self.platform_is_windows):
			self.bookmarksstyle = "fore:#000000,back:#FFFFFF,size:8,face:Arial,bold"
		
		#Plugins Settings
		self.pluginsdefaultdirectory = os.path.expanduser("~")
		
		#DrScript Settings
		self.drscriptdefaultdirectory = os.path.expanduser("~")
		self.drscriptstyle = "fore:#000000,back:#FFFFFF,size:12,face:fixed,bold"
		if (self.platform_is_windows):
			self.drscriptstyle = "fore:#000000,back:#FFFFFF,size:8,face:Arial,bold"
		self.drscriptloadexamples = 1
		
		#Printing Settings
		self.printdoclinenumbers = 1
		self.printpromptlinenumbers = 0
		self.printtabwidth = 4
		
		#Documentation Settings
		self.documentationbrowser = "mozilla"
		if (self.platform_is_windows):
			self.documentationbrowser = "c:/Program Files/Internet Explorer/iexplore.exe"
		self.documentationpythonlocation = "http://www.python.org/doc/current/"
		self.documentationwxwidgetslocation = "http://www.wxwidgets.org/docs.htm"
		self.documentationrehowtolocation = "http://www.amk.ca/python/howto/regex/"
		
	def reset(self):
		self.__init__(self.platform_is_windows, self.programdirectory)
		
	def resetjust(self, target):
		defaults = drPreferences(self.platform_is_windows, self.programdirectory)
		
		prefsdictionary = GetPreferencesDictionary()
		if prefsdictionary.has_key(target):
			for Preference in prefsdictionary[target]:
				evaltext = 'self.' + Preference[0] + ' = defaults.' + Preference[0]
				e = compile(evaltext, '<string>', 'exec')
				exec(e)
		
	def Copy(self, target):
		self.platform_is_windows = target.platform_is_windows
		self.programdirectory = target.programdirectory
		
		prefsdictionary = GetPreferencesDictionary()
		for Entry in prefsdictionary:
			for Preference in prefsdictionary[Entry]:
				evaltext = 'self.' + Preference[0] + ' = target.' + Preference[0]
				e = compile(evaltext, '<string>', 'exec')
				exec(e)
