#	Programmer:	Daniel Pozmanter
#	E-mail:		drpython@bluebottle.com
#	Note:		You must reply to the verification e-mail to get through.
#
#	Copyright 2003-2004 Daniel Pozmanter
#
#	Distributed under the terms of the GPL (GNU Public License)
#
#    DrPython is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with this program; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#Shortcuts

import wx.stc
import wx

class drShortcut:
	def __init__(self):
		self.Name = ""
		self.Control = 0
		self.Shift = 0
		self.Meta = 0
		self.Alt = 0
		self.Keycode = ""

	def Compare(self, target):
		return ((self.Control == target.Control) and \
		(self.Shift == target.Shift) and \
		(self.Meta == target.Meta) and \
		(self.Alt == target.Alt) and \
		(self.Keycode == target.Keycode))

	def Copy(self, target):
		self.Name = target.Name
		self.Control = target.Control
		self.Shift = target.Shift
		self.Meta = target.Meta
		self.Alt = target.Alt
		self.Keycode = target.Keycode

	def GetShortcutString(self):
		if len(self.Keycode) > 0:
			keystr = ""
			if self.Control:
				keystr = "Control,"
			if self.Shift:
				keystr = keystr + "Shift,"
			if self.Meta:
				keystr = keystr + "Meta,"
			if self.Alt:
				keystr = keystr + "Alt,"
			keystr = keystr + " #" + self.Keycode
			return keystr
		else:
			return ""

	def Set(self, name, intkeycode, modifiers):
		self.Name = name
		if intkeycode == -1:
			self.Keycode = ""
		else:
			self.Keycode = str(intkeycode)
		self.Control = (modifiers.find("Control") > -1)
		self.Shift = (modifiers.find("Shift") > -1)
		self.Meta = (modifiers.find("Meta") > -1)
		self.Alt = (modifiers.find("Alt") > -1)

	def SetShortcutFromString(self, value):
		self.Control = (value.find("Control") > -1)
		self.Shift = (value.find("Shift") > -1)
		self.Meta = (value.find("Meta") > -1)
		self.Alt = (value.find("Alt") > -1)
		target = value.find("#")
		if target > -1:
			self.Keycode = value[(target + 1):]
		else:
			self.Keycode = ""

def CompareShortcuts(shortcut1, shortcut2):
	if (shortcut1.Name == shortcut2.Name):
		return 0
	elif (shortcut1.Name < shortcut2.Name):
		return -1
	return 1

def GetDefaultSTCShortcut(stcindex):
	d = drShortcut()
	shortcut = [["Back Tab", wx.WXK_TAB, "Control"], ["Cancel", wx.WXK_ESCAPE, ""], \
	["Char Left", wx.WXK_LEFT, ""], ["Char Left Extend", wx.WXK_LEFT, "Shift"], ["Char Left Rect Extend", wx.WXK_LEFT, "Shift, Alt"], \
	["Char Right", wx.WXK_RIGHT, ""], ["Char Right Extend", wx.WXK_RIGHT, "Shift"], ["Char Right Rect Extend", wx.WXK_RIGHT, "Shift, Alt"], \
	["Copy", ord('C'), "Control"], ["Cut", ord('X'), "Control"], \
	["Delete", wx.WXK_DELETE, ""], \
	["Delete Back", wx.WXK_BACK, ""], ["Delete Back Not Line", wx.WXK_BACK, "Shift"], \
	["Delete Line Left", -1, ""], ["Delete Line Right", wx.WXK_DELETE, "Control, Shift"], \
	["Delete Word Left", -1, ""], ["Delete Word Right", wx.WXK_DELETE, "Control"], \
	["Document End", wx.WXK_END, "Control"], ["Document End Extend", wx.WXK_END, "Control, Shift"], \
	["Document Start", wx.WXK_HOME, "Control"], ["Document Start Extend", wx.WXK_HOME, "Control, Shift"], \
	["Form Feed", -1, ""], ["Home", wx.WXK_HOME, ""], \
	["Home Display", wx.WXK_HOME, "Alt"], ["Home Display Extend", -1, ""], \
	["Home Extend", wx.WXK_HOME, "Shift"], ["Home Rect Extend", wx.WXK_HOME, "Shift, Alt"], ["Line Cut", -1, ""], ["Line Delete", -1, ""], \
	["Line Down", wx.WXK_DOWN, ""], ["Line Down Extend", wx.WXK_DOWN, "Shift"], ["Line Down Rect Extend", wx.WXK_DOWN, "Shift, Alt"], \
	["Line Duplicate", -1, ""], ["Line End", wx.WXK_END, ""], \
	["Line End Display", wx.WXK_END, "Alt"], ["Line End Display Extend", -1, ""], \
	["Line End Extend", wx.WXK_END, "Shift"], ["Line End Rect Extend", wx.WXK_END, "Shift, Alt"], ["Line Scroll Down", wx.WXK_DOWN, "Control"], \
	["Line Scroll Up", wx.WXK_UP, "Control"], ["Line Transpose", -1, ""], ["Line Up", wx.WXK_UP, ""], \
	["Line Up Extend", wx.WXK_UP, "Shift"], ["Line Up Rect Extend", wx.WXK_UP, "Shift, Alt"], ["Lowercase", ord('U'), "Control"], ["New Line", wx.WXK_RETURN, ""], \
	["Page Down", wx.WXK_NEXT, ""], ["Page Down Extend", wx.WXK_NEXT, "Shift"],["Page Down Rect Extend", wx.WXK_NEXT, "Shift, Alt"],  ["Page Up", wx.WXK_PRIOR, ""], \
	["Page Up Extend", wx.WXK_PRIOR, "Shift"], ["Page Up Rect Extend", wx.WXK_PRIOR, "Shift, Alt"], ["Paste", ord('V'), "Control"], \
	["Redo", ord('Y'), "Control"], \
	["Select All", ord('A'), "Control"], \
	["Tab", wx.WXK_TAB, ""], ["Toggle Overtype", wx.WXK_INSERT, ""], ["Undo", ord('Z'), "Control"], \
	["Uppercase", ord('U'), "Control, Shift"], \
	["Visible Character Home", -1, ""], ["Visible Character Home Extend", -1, ""], \
	["World Left", wx.WXK_LEFT, "Control"], \
	["Word Left Extend", wx.WXK_LEFT, "Control, Shift"], ["Word Part Left", wx.WXK_LEFT, "Alt"], \
	["Word Part Left Extend", -1, ""], \
	["Word Part Right", wx.WXK_RIGHT, "Alt"], ["Word Part Right Extend", -1, ""], \
	["Word Right", wx.WXK_RIGHT, "Control"], ["Word Right Extend", wx.WXK_RIGHT, "Control, Shift"], \
	["Zoom In", 392, "Control"], ["Zoom Out", 394, "Control"]][stcindex]

	d.Set(shortcut[0], shortcut[1], shortcut[2])

	return d

def GetKeycodeText(keycode):
	wxkeycodes = [wx.WXK_BACK, wx.WXK_TAB, wx.WXK_RETURN, wx.WXK_ESCAPE, wx.WXK_SPACE, wx.WXK_DELETE, wx.WXK_START, wx.WXK_LBUTTON, wx.WXK_RBUTTON, wx.WXK_CANCEL, wx.WXK_MBUTTON, wx.WXK_CLEAR, wx.WXK_SHIFT, wx.WXK_CONTROL, wx.WXK_MENU, wx.WXK_PAUSE, wx.WXK_CAPITAL, wx.WXK_PRIOR, wx.WXK_NEXT, wx.WXK_END, wx.WXK_HOME, wx.WXK_LEFT, wx.WXK_UP, wx.WXK_RIGHT, wx.WXK_DOWN, wx.WXK_SELECT, wx.WXK_PRINT, wx.WXK_EXECUTE, wx.WXK_SNAPSHOT, wx.WXK_INSERT, wx.WXK_HELP, wx.WXK_NUMPAD0, wx.WXK_NUMPAD1, wx.WXK_NUMPAD2, wx.WXK_NUMPAD3, wx.WXK_NUMPAD4, wx.WXK_NUMPAD5, wx.WXK_NUMPAD6, wx.WXK_NUMPAD7, wx.WXK_NUMPAD8, wx.WXK_NUMPAD9, wx.WXK_MULTIPLY, wx.WXK_ADD, wx.WXK_SEPARATOR, wx.WXK_SUBTRACT, wx.WXK_DECIMAL, wx.WXK_DIVIDE, wx.WXK_F1, wx.WXK_F2, wx.WXK_F3, wx.WXK_F4, wx.WXK_F5, wx.WXK_F6, wx.WXK_F7, wx.WXK_F8, wx.WXK_F9, wx.WXK_F10, wx.WXK_F11, wx.WXK_F12, wx.WXK_F13, wx.WXK_F14, wx.WXK_F15, wx.WXK_F16, wx.WXK_F17, wx.WXK_F18, wx.WXK_F19, wx.WXK_F20, wx.WXK_F21, wx.WXK_F22, wx.WXK_F23, wx.WXK_F24, wx.WXK_NUMLOCK, wx.WXK_SCROLL]
	wxkeynames = ["BACK", "TAB", "RETURN", "ESCAPE", "SPACE", "DELETE", "START", "LBUTTON", "RBUTTON", "CANCEL", "MBUTTON", "CLEAR", "SHIFT", "CONTROL", "MENU", "PAUSE", "CAPITAL", "PRIOR", "NEXT", "END", "HOME", "LEFT", "UP", "RIGHT", "DOWN", "SELECT", "PRINT", "EXECUTE", "SNAPSHOT", "INSERT", "HELP", "NUMPAD0", "NUMPAD1", "NUMPAD2", "NUMPAD3", "NUMPAD4", "NUMPAD5", "NUMPAD6", "NUMPAD7", "NUMPAD8", "NUMPAD9", "MULTIPLY", "ADD", "SEPARATOR", "SUBTRACT", "DECIMAL", "DIVIDE", "F1", "F2", "F3", "F4", "F5", "F6", "F7", "F8", "F9", "F10", "F11", "F12", "F13", "F14", "F15", "F16", "F17", "F18", "F19", "F20", "F21", "F22", "F23", "F24", "NUMLOCK", "SCROLL"]

	try:
		i = wxkeycodes.index(keycode)
		return True, wxkeynames[i]
	except:
		pass

	return False, ""

def GetShortcutFromDialogString(dialogstring):
	shortcut = drShortcut()
	shortcut.Name = "Meh"
	target = dialogstring.find("#")
	if target > -1:
		shortcut.Keycode = dialogstring[(target + 1):]
	else:
		shortcut.Keycode = ""

	shortcut.Control = (dialogstring.find("Control") > -1)
	shortcut.Shift = (dialogstring.find("Shift") > -1)
	shortcut.Meta = (dialogstring.find("Meta") > -1)
	shortcut.Alt = (dialogstring.find("Alt") > -1)

	return shortcut

def GetSTCCommandList():
	return [wx.stc.STC_CMD_BACKTAB, wx.stc.STC_CMD_CANCEL, \
	wx.stc.STC_CMD_CHARLEFT, wx.stc.STC_CMD_CHARLEFTEXTEND, wx.stc.STC_CMD_CHARLEFTRECTEXTEND, \
	wx.stc.STC_CMD_CHARRIGHT, wx.stc.STC_CMD_CHARRIGHTEXTEND, wx.stc.STC_CMD_CHARRIGHTRECTEXTEND, \
	wx.stc.STC_CMD_COPY, wx.stc.STC_CMD_CUT, \
	wx.stc.STC_CMD_CLEAR, \
	wx.stc.STC_CMD_DELETEBACK, wx.stc.STC_CMD_DELETEBACKNOTLINE, \
	wx.stc.STC_CMD_DELLINELEFT, wx.stc.STC_CMD_DELLINERIGHT, \
	wx.stc.STC_CMD_DELWORDLEFT, wx.stc.STC_CMD_DELWORDRIGHT, \
	wx.stc.STC_CMD_DOCUMENTEND, wx.stc.STC_CMD_DOCUMENTENDEXTEND, \
	wx.stc.STC_CMD_DOCUMENTSTART, wx.stc.STC_CMD_DOCUMENTSTARTEXTEND, \
	wx.stc.STC_CMD_FORMFEED, wx.stc.STC_CMD_HOME, \
	wx.stc.STC_CMD_HOMEDISPLAY, wx.stc.STC_CMD_HOMEDISPLAYEXTEND, \
	wx.stc.STC_CMD_HOMEEXTEND, wx.stc.STC_CMD_VCHOMERECTEXTEND, wx.stc.STC_CMD_LINECUT, wx.stc.STC_CMD_LINEDELETE, \
	wx.stc.STC_CMD_LINEDOWN, wx.stc.STC_CMD_LINEDOWNEXTEND, wx.stc.STC_CMD_LINEDOWNRECTEXTEND, \
	wx.stc.STC_CMD_LINEDUPLICATE, wx.stc.STC_CMD_LINEEND, \
	wx.stc.STC_CMD_LINEENDDISPLAY, wx.stc.STC_CMD_LINEENDDISPLAYEXTEND, \
	wx.stc.STC_CMD_LINEENDEXTEND, wx.stc.STC_CMD_LINEENDRECTEXTEND, wx.stc.STC_CMD_LINESCROLLDOWN, \
	wx.stc.STC_CMD_LINESCROLLUP, wx.stc.STC_CMD_LINETRANSPOSE, wx.stc.STC_CMD_LINEUP, \
	wx.stc.STC_CMD_LINEUPEXTEND, wx.stc.STC_CMD_LINEUPRECTEXTEND, wx.stc.STC_CMD_LOWERCASE, wx.stc.STC_CMD_NEWLINE, \
	wx.stc.STC_CMD_PAGEDOWN, wx.stc.STC_CMD_PAGEDOWNEXTEND, wx.stc.STC_CMD_PAGEDOWNRECTEXTEND, wx.stc.STC_CMD_PAGEUP, \
	wx.stc.STC_CMD_PAGEUPEXTEND, wx.stc.STC_CMD_PAGEUPRECTEXTEND, wx.stc.STC_CMD_PASTE, \
	wx.stc.STC_CMD_REDO, \
	wx.stc.STC_CMD_SELECTALL, \
	wx.stc.STC_CMD_TAB, wx.stc.STC_CMD_EDITTOGGLEOVERTYPE, wx.stc.STC_CMD_UNDO, \
	wx.stc.STC_CMD_UPPERCASE, \
	wx.stc.STC_CMD_VCHOME, wx.stc.STC_CMD_VCHOMEEXTEND, \
	wx.stc.STC_CMD_WORDLEFT, \
	wx.stc.STC_CMD_WORDLEFTEXTEND, wx.stc.STC_CMD_WORDPARTLEFT, \
	wx.stc.STC_CMD_WORDPARTLEFTEXTEND, \
	wx.stc.STC_CMD_WORDPARTRIGHT, wx.stc.STC_CMD_WORDPARTRIGHTEXTEND, \
	wx.stc.STC_CMD_WORDRIGHT, wx.stc.STC_CMD_WORDRIGHTEXTEND, \
	wx.stc.STC_CMD_ZOOMIN, wx.stc.STC_CMD_ZOOMOUT]

def ShortcutIsAlreadyTaken(TargetShortcut, ShortcutArrays, CurrentShortcut = None):
	if TargetShortcut.Keycode == "":
		return ""
	for ShortcutArray in ShortcutArrays:
		for Shortcut in ShortcutArray:
			if Shortcut.Compare(TargetShortcut):
				if CurrentShortcut is not None:
					if not CurrentShortcut.Compare(TargetShortcut):
						return Shortcut.Name
				else:
					return Shortcut.Name
	return ""

def SetSTCShortcuts(stc, Shortcuts, useDefault = 0):
	KeycodeArray = []
	wxDefArray = [wx.WXK_DOWN, wx.WXK_UP, wx.WXK_LEFT, wx.WXK_RIGHT, wx.WXK_HOME, wx.WXK_END, wx.WXK_PRIOR, \
	wx.WXK_NEXT, wx.WXK_DELETE, wx.WXK_INSERT, wx.WXK_ESCAPE, wx.WXK_BACK, wx.WXK_TAB, wx.WXK_RETURN, \
	wx.WXK_ADD, wx.WXK_SUBTRACT, wx.WXK_DIVIDE]
	PreDefArray = [wx.stc.STC_KEY_DOWN, wx.stc.STC_KEY_UP, wx.stc.STC_KEY_LEFT, wx.stc.STC_KEY_RIGHT, wx.stc.STC_KEY_HOME, \
	wx.stc.STC_KEY_END, wx.stc.STC_KEY_PRIOR, wx.stc.STC_KEY_NEXT, wx.stc.STC_KEY_DELETE, wx.stc.STC_KEY_INSERT, \
	wx.stc.STC_KEY_ESCAPE, wx.stc.STC_KEY_BACK, wx.stc.STC_KEY_TAB, wx.stc.STC_KEY_RETURN, wx.stc.STC_KEY_ADD, \
	wx.stc.STC_KEY_SUBTRACT, wx.stc.STC_KEY_DIVIDE]

	#Note:	If stc.CmdKeyAssign is used, then DrPython will never process
	#		that combindation in the keybinding code.

	stc.CmdKeyClearAll()

	cmdlist = GetSTCCommandList()
		
	stc.STCCOMMANDLIST = cmdlist

	l = len(Shortcuts)	
	x = 0
	while (x < l):
		modifiers = 0

		if useDefault:
			Shortcuts[x].Copy(GetDefaultSTCShortcut(x))
		KeycodeArray.append(str(Shortcuts[x].Keycode))

		keycode = Shortcuts[x].Keycode

		if len(keycode) > 0:
			if Shortcuts[x].Control:
				modifiers = modifiers | wx.stc.STC_SCMOD_CTRL
			if Shortcuts[x].Shift:
				modifiers = modifiers | wx.stc.STC_SCMOD_SHIFT
			if Shortcuts[x].Alt:
				modifiers = modifiers | wx.stc.STC_SCMOD_ALT
			if Shortcuts[x].Meta:
				#Meta wont be noticed here, so handle it in the DrPython code.
				pass
			else:
				ikeycode = int(keycode)
				if (ikeycode >= ord('A')) and (ikeycode <= ord('Z')):
					stc.CmdKeyAssign(ikeycode, modifiers, cmdlist[x])
				elif ikeycode in wxDefArray:
					i = wxDefArray.index(ikeycode)
					stc.CmdKeyAssign(PreDefArray[i], modifiers, cmdlist[x])
		x = x + 1

	return KeycodeArray

def SetShortcuts(frame, Shortcuts, useDefault = 0):

	shortcutsActionArray = []
	shortcutsArgumentsArray = []
	KeycodeArray = []

	l = len(Shortcuts)
	x = 0
	while (x < l):
		keycode = Shortcuts[x].Keycode

		#File
		if(Shortcuts[x].Name == "New"):
			if useDefault:
				Shortcuts[x].Keycode = ord('N')
				Shortcuts[x].Control = 1
			shortcutsActionArray.append(frame.OnNew)
			shortcutsArgumentsArray.append("frame, event")
		elif(Shortcuts[x].Name == "Open"):
			if useDefault:
				Shortcuts[x].Keycode = ord('O')
				Shortcuts[x].Control = 1
			shortcutsActionArray.append(frame.OnOpen)
			shortcutsArgumentsArray.append("frame, event")
		elif(Shortcuts[x].Name == "Open Imported Module"):
			if useDefault:
				Shortcuts[x].Keycode = ord('M')
				Shortcuts[x].Control = 1
			shortcutsActionArray.append(frame.OnOpenImportedModule)
			shortcutsArgumentsArray.append("frame, event")
		elif(Shortcuts[x].Name == "Save"):
			if useDefault:
				Shortcuts[x].Keycode = ord('S')
				Shortcuts[x].Control = 1
			shortcutsActionArray.append(frame.OnSave)
			shortcutsArgumentsArray.append("frame, event")
		elif(Shortcuts[x].Name == "Save As"):
			shortcutsActionArray.append(frame.OnSaveAs)
			shortcutsArgumentsArray.append("frame, event")
		elif(Shortcuts[x].Name == "Save All Documents"):
			shortcutsActionArray.append(frame.OnSaveAll)
			shortcutsArgumentsArray.append("frame, event")
		elif(Shortcuts[x].Name == "Save Prompt Output To File"):
			shortcutsActionArray.append(frame.OnSavePrompt)
			shortcutsArgumentsArray.append("frame, event")
		elif(Shortcuts[x].Name == "Reload File"):
			shortcutsActionArray.append(frame.OnReload)
			shortcutsArgumentsArray.append("frame, event")
		elif(Shortcuts[x].Name == "Restore From Backup"):
			shortcutsActionArray.append(frame.OnRestoreFromBackup)
			shortcutsArgumentsArray.append("frame, event")
		elif(Shortcuts[x].Name == "Close"):
			shortcutsActionArray.append(frame.OnClose)
			shortcutsArgumentsArray.append("frame, event")
		elif(Shortcuts[x].Name == "Close All Documents"):
			shortcutsActionArray.append(frame.OnCloseAllDocuments)
			shortcutsArgumentsArray.append("frame, event")
		elif(Shortcuts[x].Name == "Close All Other Documents"):
			shortcutsActionArray.append(frame.OnCloseAllOtherDocuments)
			shortcutsArgumentsArray.append("frame, event")
		elif(Shortcuts[x].Name == "Print Setup"):
			shortcutsActionArray.append(frame.OnPrintSetup)
			shortcutsArgumentsArray.append("frame, event")
		elif(Shortcuts[x].Name == "Print File"):
			if useDefault:
				Shortcuts[x].Keycode = ord('P')
				Shortcuts[x].Control = 1
			shortcutsActionArray.append(frame.OnPrint)
			shortcutsArgumentsArray.append("frame, event")
		elif(Shortcuts[x].Name == "Print Prompt"):
			if useDefault:
				Shortcuts[x].Keycode = ord('P')
				Shortcuts[x].Control = 1
				Shortcuts[x].Shift = 1
			shortcutsActionArray.append(frame.OnPrintPrompt)
			shortcutsArgumentsArray.append("frame, event")
		elif(Shortcuts[x].Name == "Exit"):
			shortcutsActionArray.append(frame.OnExit)
			shortcutsArgumentsArray.append("frame, event")

		#Tabs
		elif(Shortcuts[x].Name == "Next Document"):
			if useDefault:
				Shortcuts[x].Keycode = wx.WXK_F10
			shortcutsActionArray.append(frame.OnSelectDocumentNext)
			shortcutsArgumentsArray.append("frame, event")
		elif(Shortcuts[x].Name == "Previous Document"):
			if useDefault:
				Shortcuts[x].Keycode = wx.WXK_F9
			shortcutsActionArray.append(frame.OnSelectDocumentPrevious)
			shortcutsArgumentsArray.append("frame, event")
		elif(Shortcuts[x].Name == "First Document"):
			shortcutsActionArray.append(frame.OnSelectDocumentFirst)
			shortcutsArgumentsArray.append("frame, event")
		elif(Shortcuts[x].Name == "Last Document"):
			shortcutsActionArray.append(frame.OnSelectDocumentLast)
			shortcutsArgumentsArray.append("frame, event")

		#Edit
		elif(Shortcuts[x].Name == "Find"):
			if useDefault:
				Shortcuts[x].Keycode = ord('F')
				Shortcuts[x].Control = 1
			shortcutsActionArray.append(frame.OnMenuFind)
			shortcutsArgumentsArray.append("frame, event")
		elif(Shortcuts[x].Name == "Find Next"):
			if useDefault:
				Shortcuts[x].Keycode = wx.WXK_F3
			shortcutsActionArray.append(frame.OnMenuFindNext)
			shortcutsArgumentsArray.append("frame, event")
		elif(Shortcuts[x].Name == "Find Previous"):
			if useDefault:
				Shortcuts[x].Keycode = wx.WXK_F3
				Shortcuts[x].Shift = 1
			shortcutsActionArray.append(frame.OnMenuFindPrevious)
			shortcutsArgumentsArray.append("frame, event")
		elif(Shortcuts[x].Name == "Replace"):
			if useDefault:
				Shortcuts[x].Keycode = ord('R')
				Shortcuts[x].Control = 1
			shortcutsActionArray.append(frame.OnMenuReplace)
			shortcutsArgumentsArray.append("frame, event")
		elif(Shortcuts[x].Name == "Find In Files"):
			shortcutsActionArray.append(frame.OnMenuFindInFiles)
			shortcutsArgumentsArray.append("frame, event")
		elif(Shortcuts[x].Name == "Replace In Files"):
			shortcutsActionArray.append(frame.OnMenuReplaceInFiles)
			shortcutsArgumentsArray.append("frame, event")
		elif(Shortcuts[x].Name == "Insert Regular Expression"):
			shortcutsActionArray.append(frame.OnInsertRegEx)
			shortcutsArgumentsArray.append("frame, event")
		elif(Shortcuts[x].Name == "Go To"):
			if useDefault:
				Shortcuts[x].Keycode = ord('G')
				Shortcuts[x].Control = 1
			shortcutsActionArray.append(frame.OnGoTo)
			shortcutsArgumentsArray.append("frame, event")
		elif(Shortcuts[x].Name == "Comment"):
			if useDefault:
				Shortcuts[x].Keycode = ord('[')
				Shortcuts[x].Control = 1
			shortcutsActionArray.append(frame.OnCommentRegion)
			shortcutsArgumentsArray.append("frame, event")
		elif(Shortcuts[x].Name == "UnComment"):
			if useDefault:
				Shortcuts[x].Keycode = ord(']')
				Shortcuts[x].Control = 1
			shortcutsActionArray.append(frame.OnUnCommentRegion)
			shortcutsArgumentsArray.append("frame, event")
		elif(Shortcuts[x].Name == "Indent"):
			if useDefault:
				Shortcuts[x].Keycode = ord('I')
				Shortcuts[x].Control = 1
			shortcutsActionArray.append(frame.OnIndentRegion)
			shortcutsArgumentsArray.append("frame, event")
		elif(Shortcuts[x].Name == "Dedent"):
			if useDefault:
				Shortcuts[x].Keycode = ord('I')
				Shortcuts[x].Control = 1
				Shortcuts[x].Shift = 1
			shortcutsActionArray.append(frame.OnDedentRegion)
			shortcutsArgumentsArray.append("frame, event")
		elif(Shortcuts[x].Name == "Find And Complete"):
			if useDefault:
				Shortcuts[x].Keycode = wx.WXK_RETURN
				Shortcuts[x].Control = 1
			shortcutsActionArray.append(frame.OnFindAndComplete)
			shortcutsArgumentsArray.append("frame, event")

		#View
		elif(Shortcuts[x].Name == "Fold All"):
			shortcutsActionArray.append(frame.OnFoldAll)
			shortcutsArgumentsArray.append("frame, event")
		elif(Shortcuts[x].Name == "Expand All"):
			shortcutsActionArray.append(frame.OnExpandAll)
			shortcutsArgumentsArray.append("frame, event")
		elif(Shortcuts[x].Name == "Toggle Source Browser"):
			if useDefault:
				Shortcuts[x].Keycode = ord('B')
				Shortcuts[x].Control = 1
			shortcutsActionArray.append(frame.OnToggleSourceBrowser)
			shortcutsArgumentsArray.append("frame, event")
		elif(Shortcuts[x].Name == "Toggle View Whitespace"):
			if useDefault:
				Shortcuts[x].Keycode = ord('W')
				Shortcuts[x].Control = 1
			shortcutsActionArray.append(frame.OnToggleViewWhiteSpace)
			shortcutsArgumentsArray.append("frame, event")
		elif(Shortcuts[x].Name == "Toggle Prompt"):
			if useDefault:
				Shortcuts[x].Keycode = wx.WXK_F6
			shortcutsActionArray.append(frame.OnTogglePrompt)
			shortcutsArgumentsArray.append("frame, event")
		elif(Shortcuts[x].Name == "Clear Prompt"):
			shortcutsActionArray.append(frame.OnClearPrompt)
			shortcutsArgumentsArray.append("frame, event")
			
		elif(Shortcuts[x].Name == "View In Left Panel"):
			shortcutsActionArray.append(frame.OnViewInLeftPanel)
			shortcutsArgumentsArray.append("frame, event")
		elif(Shortcuts[x].Name == "View In Right Panel"):
			shortcutsActionArray.append(frame.OnViewInRightPanel)
			shortcutsArgumentsArray.append("frame, event")
		elif(Shortcuts[x].Name == "View In Top Panel"):
			shortcutsActionArray.append(frame.OnViewInTopPanel)
			shortcutsArgumentsArray.append("frame, event")
		elif(Shortcuts[x].Name == "View In Bottom Panel"):
			shortcutsActionArray.append(frame.OnViewInBottomPanel)
			shortcutsArgumentsArray.append("frame, event")

		#Program
		elif(Shortcuts[x].Name == "Run"):
			if useDefault:
				Shortcuts[x].Keycode = ord('E')
				Shortcuts[x].Control = 1
			shortcutsActionArray.append(frame.OnRun)
			shortcutsArgumentsArray.append("frame, event")
		elif(Shortcuts[x].Name == "Set Arguments"):
			shortcutsActionArray.append(frame.OnSetArgs)
			shortcutsArgumentsArray.append("frame, event")
		elif(Shortcuts[x].Name == "Python"):
			if useDefault:
				Shortcuts[x].Keycode = wx.WXK_F7
			shortcutsActionArray.append(frame.OnPython)
			shortcutsArgumentsArray.append("frame, event")
		elif(Shortcuts[x].Name == "End"):
			if useDefault:
				Shortcuts[x].Keycode = ord('D')
				Shortcuts[x].Control = 1
			shortcutsActionArray.append(frame.OnEnd)
			shortcutsArgumentsArray.append("frame, event")

		#DrScript
		elif(Shortcuts[x].Name == "Dynamic DrScript"):
			shortcutsActionArray.append(frame.dynamicdrscript)
			shortcutsArgumentsArray.append("frame, event")

		#Prefs
		elif(Shortcuts[x].Name == "Preferences"):
			shortcutsActionArray.append(frame.OnPrefs)
			shortcutsArgumentsArray.append("frame, event")
		elif(Shortcuts[x].Name == "Customize Shortcuts"):
			shortcutsActionArray.append(frame.OnCustomizeShortcuts)
			shortcutsArgumentsArray.append("frame, event")
		elif(Shortcuts[x].Name == "Customize Pop Up Menu"):
			shortcutsActionArray.append(frame.OnCustomizePopUpMenu)
			shortcutsArgumentsArray.append("frame, event")
		elif(Shortcuts[x].Name == "Customize ToolBar"):
			shortcutsActionArray.append(frame.OnCustomizeToolBar)
			shortcutsArgumentsArray.append("frame, event")

		#Docs
		elif(Shortcuts[x].Name == "Help"):
			shortcutsActionArray.append(frame.OnViewHelp)
			shortcutsArgumentsArray.append("frame, event")
		elif(Shortcuts[x].Name == "View Python Docs"):
			if useDefault:
				Shortcuts[x].Keycode = wx.WXK_F8
			shortcutsActionArray.append(frame.OnViewPythonDocs)
			shortcutsArgumentsArray.append("frame, event")
		elif(Shortcuts[x].Name == "View WxWidgets Docs"):
			shortcutsActionArray.append(frame.OnViewWxWidgetsDocs)
			shortcutsArgumentsArray.append("frame, event")
		elif(Shortcuts[x].Name == "View Regular Expression Howto"):
			shortcutsActionArray.append(frame.OnViewREHowtoDocs)
			shortcutsArgumentsArray.append("frame, event")

		#General
		elif(Shortcuts[x].Name == "Toggle Maximize"):
			if useDefault:
				Shortcuts[x].Keycode = wx.WXK_F5
			shortcutsActionArray.append(frame.Maximize)
			shortcutsArgumentsArray.append("maximize")

		Shortcuts[x].Keycode = str(Shortcuts[x].Keycode)
		KeycodeArray.append(str(Shortcuts[x].Keycode))
		x = x + 1

	return KeycodeArray, shortcutsActionArray, shortcutsArgumentsArray

def RunShortcuts(frame, event, stc, SplitView):
	keycode = event.GetKeyCode()
	strkeycode = str(keycode)
	keyindex = -1
	allowControl = not (frame.ShortcutsIgnoreString.find("Control") > -1)
	allowShift = not (frame.ShortcutsIgnoreString.find("Shift") > -1)
	allowMeta = not (frame.ShortcutsIgnoreString.find("Meta") > -1)
	allowAlt = not (frame.ShortcutsIgnoreString.find("Alt") > -1)

	drstc = -1
	drpy = -1
	drscript = -1
	plugin = -1

	drstclast = 0
	drpylast = 0
	drscriptlast = 0
	pluginlast = 0
	cont = True

	while (cont):
		if strkeycode in frame.STCKeycodeArray[drstclast:]:
			drstc = drstclast + frame.STCKeycodeArray[drstclast:].index(strkeycode)
		else:
			drstc = -1		
		if strkeycode in frame.KeycodeArray[drpylast:]:
			drpy = drpylast + frame.KeycodeArray[drpylast:].index(strkeycode)
		else:
			drpy = -1
		if strkeycode in frame.DrScriptKeycodeArray[drscriptlast:]:
			drscript = drscriptlast + frame.DrScriptKeycodeArray[drscriptlast:].index(strkeycode)
		else:
			drscript = -1
		if strkeycode in frame.PluginKeycodeArray[pluginlast:]:
			plugin = pluginlast + frame.PluginKeycodeArray[pluginlast:].index(strkeycode)
		else:
			plugin = -1

		if (drpy < 0) and (drscript < 0) and (plugin < 0):
			cont = False
			
		if drstc > -1:
			if ((not frame.STCShortcuts[drstc].Shift == event.ShiftDown()) and allowShift) or \
			((not frame.STCShortcuts[drstc].Control == event.ControlDown()) and allowControl) or \
			((not frame.STCShortcuts[drstc].Meta == event.MetaDown()) and allowMeta) or \
			((not frame.STCShortcuts[drstc].Alt == event.AltDown()) and allowAlt):
				drstclast = drstc + 1
				drstc = -1
			else:
				cont = False
		if drpy > -1:
			if ((not frame.Shortcuts[drpy].Shift == event.ShiftDown()) and allowShift) or \
			((not frame.Shortcuts[drpy].Control == event.ControlDown()) and allowControl) or \
			((not frame.Shortcuts[drpy].Meta == event.MetaDown()) and allowMeta) or \
			((not frame.Shortcuts[drpy].Alt == event.AltDown()) and allowAlt):
				drpylast = drpy + 1
				drpy = -1
			else:
				cont = False
		if (drscript > -1):
			if ((not frame.DrScriptShortcuts[drscript].Shift == event.ShiftDown()) and allowShift) or \
			((not frame.DrScriptShortcuts[drscript].Control == event.ControlDown()) and allowControl) or \
			((not frame.DrScriptShortcuts[drscript].Meta == event.MetaDown()) and allowMeta) or \
			((not frame.DrScriptShortcuts[drscript].Alt == event.AltDown()) and allowAlt):
				drscriptlast = drscript + 1
				drscript = -1
			else:
				cont = False
		if (plugin > -1):
			if ((not frame.PluginShortcuts[plugin].Shift == event.ShiftDown()) and allowShift) or \
			((not frame.PluginShortcuts[plugin].Control == event.ControlDown()) and allowControl) or \
			((not frame.PluginShortcuts[plugin].Meta == event.MetaDown()) and allowMeta) or \
			((not frame.PluginShortcuts[plugin].Alt == event.AltDown()) and allowAlt):
				pluginlast = plugin + 1
				plugin = -1
			else:
				cont = False

	if (frame.txtDocument.STCCOMMANDLIST[drstc] == wx.stc.STC_CMD_NEWLINE) or \
	(frame.txtDocument.STCCOMMANDLIST[drstc] == wx.stc.STC_CMD_CHARLEFT) or \
	(frame.txtDocument.STCCOMMANDLIST[drstc] == wx.stc.STC_CMD_CHARRIGHT) or \
	(frame.txtDocument.STCCOMMANDLIST[drstc] == wx.stc.STC_CMD_LINEUP) or \
	(frame.txtDocument.STCCOMMANDLIST[drstc] == wx.stc.STC_CMD_LINEDOWN) or \
	(frame.txtDocument.STCCOMMANDLIST[drstc] == wx.stc.STC_CMD_DELETEBACK) or \
	(frame.txtDocument.STCCOMMANDLIST[drstc] == wx.stc.STC_CMD_HOME):	
		return 0

	if drstc > -1 and (not drpy > -1) and (not plugin > -1) and (not drscript > -1):
		try:
			if stc is None:
				if (frame.txtPrompt.GetSTCFocus()):
					frame.txtPrompt.CmdKeyExecute(frame.txtPrompt.STCCOMMANDLIST[drstc])
				else:			
					frame.txtDocument.CmdKeyExecute(frame.txtDocument.STCCOMMANDLIST[drstc])
			else:
				stc.CmdKeyExecute(stc.STCCOMMANDLIST[drstc])
		except:
			return 0		
		return 1
	if SplitView:
		return 0
	if drpy > -1 and (not drscript > -1) and (not plugin > -1) and (not drstc > -1):
		if (frame.ShortcutsArgumentsArray[drpy] == "frame, event"):
			frame.ShortcutsActionArray[drpy](event)
		elif (frame.ShortcutsArgumentsArray[drpy] == "maximize"):
			#Work Around Bug in wx.Python 2.5.1
			try:
				frame.ShortcutsActionArray[drpy](not frame.IsMaximized())
			except:
				pass
		return 1
	if drscript > -1 and (not drpy > -1) and (not plugin > -1) and (not drstc > -1):
		event.SetId(frame.ID_SCRIPT_BASE + drscript)
		frame.DrScriptShortcutsAction(event)
		return 1
	if plugin > -1 and (not drscript > -1) and (not drpy > -1) and (not drstc > -1):
		frame.PluginAction[plugin](event)
		return 1

	return 0