#	Programmer:	Daniel Pozmanter
#	E-mail:		drpython@bluebottle.com
#	Note:		You must reply to the verification e-mail to get through.
#
#	Copyright 2003-2004 Daniel Pozmanter
#
#	Distributed under the terms of the GPL (GNU Public License)
#
#	DrPython is free software; you can redistribute it and/or modify
#	it under the terms of the GNU General Public License as published by
#	the Free Software Foundation; either version 2 of the License, or
#	(at your option) any later version.
#
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#
#	You should have received a copy of the GNU General Public License
#	along with this program; if not, write to the Free Software
#	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
#Some Folding Code From demo.py by Robin Dunn
#Some more from pype by Josiah Carlson
	
#The StyledTextControl

import os.path, re, locale
import wx
import wx.stc
from drProperty import *
import drPopUp
import drKeywords
import drShortcuts, drShortcutsFile
import drScrolledMessageDialog
from drDragAndDrop import drDropTarget

#*******************************************************************************************************

class DrText(wx.stc.StyledTextCtrl):
	def __init__(self, parent, id, grandparent, DynamicScript = 0, SplitView=0):
		wx.stc.StyledTextCtrl.__init__(self, parent, id)
				
		self.needtoindent = 0
		self.grandparent = grandparent
		self.notebookparent = grandparent.mdinotebook
						
		self.filename = ""
		
		self.mtime = -1
		
		self.untitlednumber = 0
		
		self.SourceBrowser = None
				
		#Encoding (Dan, 3.6.2)
		self.locale = grandparent.defaultlocale
		
		self.stclabelarray = drShortcutsFile.GetSTCShortcutList()
		self.stcactionarray = drShortcuts.GetSTCCommandList()
				
		self.ID_POPUP_BASE = 33000
		
		#Speed Optimization Submitted by Franz
		self.SetModEventMask(wx.stc.STC_PERFORMED_UNDO | wx.stc.STC_PERFORMED_REDO |\
		wx.stc.STC_MOD_DELETETEXT | wx.stc.STC_MOD_INSERTTEXT)
		
		self.lineendingsaremixed = 0
		
		self.IsActive = True

		self.SetDropTarget(drDropTarget(self))
		
		self.locale = 3
		
		self.currentlanguage = 0
				
		#Right Click Menu
		self.UsePopUp(0)
								
		self.SetMarginType(0, wx.stc.STC_MARGIN_SYMBOL)
		self.SetMarginType(1, wx.stc.STC_MARGIN_NUMBER)
		
		self.SetMarginWidth(0, 0)
		self.SetMarginWidth(1, 0)
		self.SetMarginWidth(2, 0)
		
		self.SetMarginType(2, wx.stc.STC_MARGIN_SYMBOL)
		self.SetMarginMask(2, wx.stc.STC_MASK_FOLDERS)
		
		self.SetScrollWidth(1)
		
		self.SetupTabs()
						
		self.usestyles = (self.grandparent.prefs.docusestyles == 1)			
				
		if (self.grandparent.prefs.eolmode == 1):
			self.SetEOLMode(wx.stc.STC_EOL_CRLF)
		elif (self.grandparent.prefs.eolmode == 2):
			self.SetEOLMode(wx.stc.STC_EOL_CR)
		else:
			self.SetEOLMode(wx.stc.STC_EOL_LF)
		
		self.retab = re.compile('^\t+', re.MULTILINE)
		self.respaces = re.compile('^ +', re.MULTILINE)
		self.remixedoutright = re.compile('(^\t+ )|(^ +\t)', re.MULTILINE)
		
		self.indentationstring = ""
		self.indentationtype = 2
		
		#Keyword Search/Context Sensitive Autoindent.
		self.rekeyword = re.compile(r"(\sreturn\b)|(\sbreak\b)|(\spass\b)|(\scontinue\b)|(\sraise\b)", re.MULTILINE)
		self.reslash = re.compile(r"\\\Z")
		
		self.DisableShortcuts = (SplitView == 1)
			
		if SplitView == -1:
			SplitView = 1
		
		self.IsSplitView = SplitView
				
		if not DynamicScript:		
			self.targetPosition = 0
			self.Bind(wx.stc.EVT_STC_MODIFIED, self.OnModified, id=id)
			self.Bind(wx.EVT_KEY_UP, self.OnPositionChanged)
			self.Bind(wx.EVT_LEFT_UP, self.OnPositionChanged)
		self.Bind(wx.EVT_UPDATE_UI,  self.OnUpdateUI, id=id)
		self.Bind(wx.EVT_KEY_DOWN, self.OnKeyDown)
		self.Bind(wx.stc.EVT_STC_CHARADDED, self.OnCharAdded, id=id)
		self.Bind(wx.stc.EVT_STC_MARGINCLICK, self.OnMarginClick, id=id)
		self.Bind(wx.EVT_RIGHT_DOWN, self.OnPopUp)
		self.Bind(wx.EVT_LEFT_DOWN, self.OnLeftDown)
		
	def CheckIndentation(self, text=None):
		if text is None:
			text = self.GetText()
		if len(text) < 1:
			return 2				
			
		tabs = (self.retab.search(text) is not None)
		spaces = (self.respaces.search(text) is not None)		
		mixed = (self.remixedoutright.search(text) is not None)
				
		if mixed or (tabs and spaces):
			return 0
		elif tabs:
			return 1
		elif spaces:
			return -1
		return 2	

	def CheckIndentationFor(self, type):
		text = self.GetText()
		if len(text) < 1:
			return False
		
		if type == -1:
			return (self.respaces.search(text) is not None)
		else:
			return (self.retab.search(text) is not None)	

	def GetEndOfLineCharacter(self):
		emode = self.GetEOLMode()
		if emode == wx.stc.STC_EOL_CR:
			return '\r'
		elif emode == wx.stc.STC_EOL_CRLF:
			return '\r\n'
		return '\n'

	def GetIndentationString(self):
		return self.addchar

	def GetIndentationEventText(self):
		cline, cpos = self.GetCurLine()
		nextline = self.GetLine(self.LineFromPosition(cpos)+1)
		
		return cline + nextline

	def GetFilename(self):
		if len(self.filename) > 0:
			return self.filename
		return "Untitled " + str(self.untitlednumber)
	
	def GetFilenameTitle(self):
		if len(self.filename) > 0:
			return os.path.split(self.filename)[1]
		return "Untitled " + str(self.untitlednumber)
		
	def OnLeftDown(self, event):
		if self.grandparent.prefs.draganddropmode != 1:
			pos = self.PositionFromPoint(wx.Point(event.GetX(), event.GetY()))
			s, e = self.GetSelection()
			if (pos > s) and (pos < e):
				self.SetSelection(pos, pos)
				return
		event.Skip()

	def OnModified(self, event):
		if not self.IsSplitView:
			if self.GetModify():
				if self.IsActive:
					self.notebookparent.SetPageImage(self.targetPosition, 3)
				else:
					self.notebookparent.SetPageImage(self.targetPosition, 1)
				if (len(self.filename) <= 0):
					self.notebookparent.SetPageText(self.targetPosition, "Untitled " + str(self.untitlednumber))
					self.grandparent.SetTitle("DrPython - Untitled " + str(self.untitlednumber) + ' [Modified]')
				elif (self.grandparent.GetTitle().find('[Modified]') == -1):
					self.notebookparent.SetPageText(self.targetPosition, os.path.basename(self.filename))
					self.grandparent.SetTitle("DrPython - " + self.filename + " [Modified]")
			else:
				if self.IsActive:
					self.notebookparent.SetPageImage(self.targetPosition, 2)
				else:
					self.notebookparent.SetPageImage(self.targetPosition, 0)
				self.SetSavePoint()
				if (len(self.filename) <= 0):
					self.notebookparent.SetPageText(self.targetPosition, "Untitled " + str(self.untitlednumber))
					self.grandparent.SetTitle("DrPython - Untitled " + str(self.untitlednumber))
				else:
					self.notebookparent.SetPageText(self.targetPosition, os.path.basename(self.filename))
					self.grandparent.SetTitle("DrPython - " + self.filename)
			if not (self.grandparent.prefs.docwordwrap):
				ll = self.TextWidth(wx.stc.STC_STYLE_DEFAULT, "OOO")
				#franz: x not referenced
				current_width = self.GetScrollWidth()
				line = self.GetCurLine()[0].expandtabs(self.tabwidth)
				actual_width = self.TextWidth(wx.stc.STC_STYLE_DEFAULT, line)
				if (current_width < actual_width):
					self.SetScrollWidth(actual_width + ll)

		if self.grandparent.prefs.docupdateindentation:
			#If deleting text, or undo/redo:
			if event is not None:
				modtype = event.GetModificationType()
				if (modtype & wx.stc.STC_MOD_DELETETEXT) or (modtype & wx.stc.STC_PERFORMED_UNDO) or \
				(modtype & wx.stc.STC_PERFORMED_REDO):
					if self.indentationtype == 0:
						result = self.CheckIndentation(self.GetText())
					else:
						hasit = self.CheckIndentationFor(self.indentationtype)
						result = self.CheckIndentation(self.GetIndentationEventText())
						if (result != self.indentationtype) and (result != 2):
							result = 0
						elif hasit:
							result = self.indentationtype
						else:
							result = 2
					self.indentationtype = result
					self.setIndentationString()				
					return
				else:					
					result = self.CheckIndentation(self.GetIndentationEventText())
			else:
				result = self.CheckIndentation(self.GetText())

			if (result != self.indentationtype) and (result != 2):
				if (self.indentationtype == 0) or (result == 0) or \
				((self.indentationtype + result) == 0):
					self.indentationstring = "->MIXED"
					result = 0
				else:		
					if result == -1:
						self.indentationstring = "->SPACES"
					elif result == 1:
						self.indentationstring = "->TABS"
				self.indentationtype = result
			else:
				self.setIndentationString()
		else:
			self.indentationstring = ""

		if event is None:
			try:			
				self.OnPositionChanged(None)
			except:
				pass

	def OnPositionChanged(self, event):	
		if self.lineendingsaremixed:
			eolmodestr = "MIX"
		else:
			emode = self.GetEOLMode()
			if emode == wx.stc.STC_EOL_CR:
				eolmodestr = "MAC"
			elif emode == wx.stc.STC_EOL_CRLF:
				eolmodestr = "WIN"
			else:
				eolmodestr = "UNIX"
			
		if self.GetOvertype():
			ovrstring = "OVR"
		else:
			ovrstring = "INS"
				
		self.grandparent.SetStatusText(("Line: %(line)s, Col: %(col)s   %(mode)s   %(ovrstring)s   %(ind)s" \
		% {"line": self.GetCurrentLine()+1, "col": self.GetColumn(self.GetCurrentPos()), \
		"mode": eolmodestr, "ovrstring": ovrstring, "ind": self.indentationstring}), 1)	
		
		if event is not None:
			event.Skip()

	def OnUpdateUI(self, event):
		if (self.usestyles) and (self.grandparent.prefs.docparenthesismatching):
			#Code for parenthesis matching from wxPython Demo.
			# check for matching braces
			braceAtCaret = -1
			braceOpposite = -1
			charBefore = None
			caretPos = self.GetCurrentPos()
	
			if caretPos > 0:
				charBefore = self.GetCharAt(caretPos - 1)
				styleBefore = self.GetStyleAt(caretPos - 1)
	
			# check before
			if charBefore and chr(charBefore) in "[]{}()" and styleBefore == wx.stc.STC_P_OPERATOR:
				braceAtCaret = caretPos - 1
	
			# check after
			if braceAtCaret < 0:
				charAfter = self.GetCharAt(caretPos)
				styleAfter = self.GetStyleAt(caretPos)
	
				if charAfter and chr(charAfter) in "[]{}()" and styleAfter == wx.stc.STC_P_OPERATOR:
					braceAtCaret = caretPos
	
			if braceAtCaret >= 0:
				braceOpposite = self.BraceMatch(braceAtCaret)
	
			if braceAtCaret != -1  and braceOpposite == -1:
				self.BraceBadLight(braceAtCaret)
			else:
				self.BraceHighlight(braceAtCaret, braceOpposite)
		event.Skip()
			
	def OnKeyDown(self, event):
		if (not self.grandparent.RunShortcuts(event, self, self.DisableShortcuts)):
			keycode = event.GetKeyCode()
			if (keycode == wx.WXK_RETURN) and (self.grandparent.prefs.docautoindent):
				self.needtoindent = 1
			event.Skip()

	def OnCharAdded(self, event):		
		#Auto Indent Code
		pos = self.GetCurrentPos()
		if (self.needtoindent == 1):
			self.needtoindent = 0
			#Look at last line
			pos = pos - 1
			cp = chr(self.GetCharAt(pos))
			linenumber = self.GetCurrentLine()
			if cp != '\n' and cp !='\r' and linenumber > 0:			
				#Do Not AutoIndent
				event.Skip()
				return	
			self.GotoPos(pos)
			linenumber = self.LineFromPosition(pos)
			self.GotoLine(linenumber)
			numtabs = self.GetLineIndentation(linenumber) / self.tabwidth
			if self.grandparent.prefs.docautoindent == 2:
				checkat = pos - 1
				if self.GetEOLMode() == wx.stc.STC_EOL_CRLF:
					checkat = checkat - 1					
				if self.GetCharAt(checkat) == ord(':'):
					numtabs = numtabs + 1
				else:
					lastline = self.GetLine(linenumber)
					#Remove Comment:
					comment = lastline.find('#')
					if comment > -1:
						lastline = lastline[:comment]					
					if self.reslash.search(lastline.rstrip()) is None:					
						if self.rekeyword.search(lastline) is not None:
							numtabs = numtabs - 1
			#Go to current line to add tabs
			pos = pos + 1
			self.GotoPos(pos)
			x = 0
			while (x < numtabs):
				self.AddText(self.addchar)
				x = x + 1
		#/Auto Indent Code
		event.Skip()
		
	def OnMarginClick(self, event):
		# fold and unfold as needed
		if event.GetMargin() == 2:
			lineClicked = self.LineFromPosition(event.GetPosition())
			if self.GetFoldLevel(lineClicked) & wx.stc.STC_FOLDLEVELHEADERFLAG:
				self.ToggleFold(lineClicked)

	def OnPopUp(self, event):
		drPopUp.OnPopUp(self, event)

	def OnPopUpMenu(self, event):
		drPopUp.OnPopUpMenu(self, event)

	def setIndentationString(self):
		if self.indentationtype == 2:
			self.indentationstring = "->NONE"
		elif self.indentationtype == 1:
			self.indentationstring = "->TABS"
		elif self.indentationtype == 0:
			self.indentationstring = "->MIXED"
		elif self.indentationtype == -1:
			self.indentationstring = "->SPACES"

	def SetupPrefsDocument(self, notmdiupdate = 1):
		if self.grandparent.prefs.doconlyusedefaultsyntaxhighlighting:
			self.currentlanguage = self.grandparent.prefs.docdefaultsyntaxhighlighting
		self.SetEndAtLastLine(not self.grandparent.prefs.docscrollextrapage)
		self.SetIndentationGuides(self.grandparent.prefs.docuseindentationguides)
		if (len(self.filename) == 0) and not self.GetModify():
			self.SetUseTabs(self.grandparent.prefs.docusetabs)
			self.SetupTabs(self.grandparent.prefs.docusetabs)
		if (self.grandparent.prefs.docfolding):
			self.grandparent.viewmenu.Enable(self.grandparent.ID_FOLDING, True)
			self.SetMarginWidth(2, 12)
			self.SetMarginSensitive(2, True)
			#WIERD!
			self.SetProperty("fold", "1")
			self.SetProperty("tab.timmy.whinge.level", "1")	
		else:
			self.grandparent.viewmenu.Enable(self.grandparent.ID_FOLDING, False)
			self.SetMarginWidth(2, 0)
			self.SetMarginSensitive(2, False)
			#WIERD!
			self.SetProperty("fold", "0")
			self.SetProperty("tab.timmy.whinge.level", "0")	
		
		#LongLineCol from Chris McDonough
		
		#Adding if statement, else section myself, also added code to use line and/or background method:
		#I put the set edge color section in under styles.
		
		if self.grandparent.prefs.doclonglinecol > 0:
			self.SetEdgeColumn(self.grandparent.prefs.doclonglinecol)
			self.SetEdgeMode(wx.stc.STC_EDGE_LINE)
		elif self.grandparent.prefs.doclonglinecol < 0:
			self.SetEdgeColumn(abs(self.grandparent.prefs.doclonglinecol))
			self.SetEdgeMode(wx.stc.STC_EDGE_BACKGROUND)
		else:
			self.SetEdgeMode(wx.stc.STC_EDGE_NONE)			
				
		#/LongLineCol from Chris McDonough
				
		self.SetMarginWidth(1, self.grandparent.prefs.docmarginwidth)
		
		if notmdiupdate:			
			self.SetViewWhiteSpace(self.grandparent.prefs.docwhitespaceisvisible)
			
		self.SetTabWidth(self.grandparent.prefs.tabwidth)
		
		if (self.grandparent.prefs.docwordwrap):
			self.SetWrapMode(wx.stc.STC_WRAP_WORD)
		else:
			self.SetWrapMode(wx.stc.STC_WRAP_NONE)
						
		self.SetKeyWords(0, drKeywords.GetKeyWords(self.currentlanguage))
					
		self.SetLexer(drKeywords.GetLexer(self.currentlanguage))
	
		if (self.currentlanguage == 0) or (self.currentlanguage == 3):
			self.grandparent.prefs.txtDocumentStyleArray = self.grandparent.prefs.PythonStyleArray
			cursorstyle = self.grandparent.prefs.txtDocumentStyleArray[13]
			foldingstyle = self.grandparent.prefs.txtDocumentStyleArray[15]
			self.SetEdgeColour(self.grandparent.prefs.txtDocumentStyleArray[16])
			highlightlinestyle = self.grandparent.prefs.txtDocumentStyleArray[17]
		elif self.currentlanguage == 1:
			self.grandparent.prefs.txtDocumentStyleArray = self.grandparent.prefs.CPPStyleArray
			cursorstyle = self.grandparent.prefs.txtDocumentStyleArray[14]
			foldingstyle = self.grandparent.prefs.txtDocumentStyleArray[16]
			self.SetEdgeColour(self.grandparent.prefs.txtDocumentStyleArray[17])
			highlightlinestyle = self.grandparent.prefs.txtDocumentStyleArray[18]
		elif self.currentlanguage == 2:
			self.grandparent.prefs.txtDocumentStyleArray = self.grandparent.prefs.HTMLStyleArray
			cursorstyle = self.grandparent.prefs.txtDocumentStyleArray[18]
			foldingstyle = self.grandparent.prefs.txtDocumentStyleArray[20]
			self.SetEdgeColour(self.grandparent.prefs.txtDocumentStyleArray[21])
			highlightlinestyle = self.grandparent.prefs.txtDocumentStyleArray[22]

		#Folding:
		foldback = getStyleProperty("back", foldingstyle)
		foldfore = getStyleProperty("fore", foldingstyle)
		self.MarkerDefine(wx.stc.STC_MARKNUM_FOLDEREND, wx.stc.STC_MARK_BOXPLUSCONNECTED, foldback, foldfore)
		self.MarkerDefine(wx.stc.STC_MARKNUM_FOLDEROPENMID, wx.stc.STC_MARK_BOXMINUSCONNECTED, foldback, foldfore)
		self.MarkerDefine(wx.stc.STC_MARKNUM_FOLDERMIDTAIL, wx.stc.STC_MARK_TCORNER, foldback, foldfore)
		self.MarkerDefine(wx.stc.STC_MARKNUM_FOLDERTAIL,wx.stc.STC_MARK_LCORNER, foldback, foldfore)
		self.MarkerDefine(wx.stc.STC_MARKNUM_FOLDERSUB, wx.stc.STC_MARK_VLINE, foldback, foldfore)
		self.MarkerDefine(wx.stc.STC_MARKNUM_FOLDER,wx.stc.STC_MARK_BOXPLUS, foldback, foldfore)
		self.MarkerDefine(wx.stc.STC_MARKNUM_FOLDEROPEN,wx.stc.STC_MARK_BOXMINUS, foldback, foldfore)
		
		#Margin:
		self.marginbackground = foldback
		self.marginforeground = foldfore
						
		if self.grandparent.prefs.docusestyles:
		
			self.StyleSetSpec(wx.stc.STC_STYLE_DEFAULT, self.grandparent.prefs.txtDocumentStyleArray[0])
			self.StyleSetSpec(wx.stc.STC_STYLE_INDENTGUIDE, self.grandparent.prefs.txtDocumentStyleArray[0])

			self.StyleClearAll()

			self.StartStyling(0, 0xff)

			self.SetCaretForeground(cursorstyle)
				
			if self.grandparent.prefs.dochighlightcurrentline:
				self.SetCaretLineBack(highlightlinestyle)
				self.SetCaretLineVisible(True)
			else:
				self.SetCaretLineVisible(False)
					
			self.SetCaretWidth(self.grandparent.prefs.doccaretwidth)
			
			if (self.grandparent.prefs.docusestyles < 2) or (not self.currentlanguage == 4):
				self.StyleSetSpec(wx.stc.STC_STYLE_LINENUMBER, self.grandparent.prefs.txtDocumentStyleArray[1])
				self.StyleSetSpec(wx.stc.STC_STYLE_BRACELIGHT, self.grandparent.prefs.txtDocumentStyleArray[2])
				self.StyleSetSpec(wx.stc.STC_STYLE_BRACEBAD, self.grandparent.prefs.txtDocumentStyleArray[3])
				drKeywords.SetSTCStyles(self.grandparent, self, self.currentlanguage)

	def SetupTabs(self, UseTabs=-1):
		if UseTabs == -1:
			UseTabs = self.grandparent.prefs.docusetabs
		self.tabwidth = self.grandparent.prefs.tabwidth
		self.addchar = '\t'
		if (not UseTabs):
			#franz: x not referenced
			self.addchar = "\t".expandtabs(self.tabwidth)		

	def SetSelectedText(self, text):
		self.SetTargetStart(self.GetSelectionStart())
		self.SetTargetEnd(self.GetSelectionEnd())
		self.ReplaceTarget(text)

	def SetTargetPosition(self, pos):
		self.targetPosition = pos

	def FoldAll(self, expanding):
		lineCount = self.GetLineCount()

		#Yup, this is different from the  demo.py stuff.
		#This is a really messed up hack of the pype.py and demo.py stuff to act
		#the way I want it to...
		#Folding is just ugly.
				
		#Set stuff up first...
		lines = []
		#franz: lineNum not referenced
		for line in xrange(lineCount):
			lines.append(line)		
		lines.reverse()
		
		if (not expanding):
			#Code Inspired by pype.py...Wake wx.stc.STC Up Before we fold!
			self.HideLines(0, lineCount-1)
			wx.Yield()
			self.ShowLines(0, lineCount-1)
		
			for line in xrange(lineCount):
				if self.GetFoldLevel(line) & wx.stc.STC_FOLDLEVELHEADERFLAG:
					self.SetFoldExpanded(line, 1)
				
		#Back to demo.py...mmmm, open source...Modified ever so slightly
		
		if (expanding):
			#Modify the demo.py stuff to act like pype.py:
			for line in lines:
				a = self.GetLastChild(line, -1)
				self.ShowLines(line+1,a)
				self.SetFoldExpanded(line, True)
		else:
			#Get pype.py funky(Ever so slightly modified old bean)!
			for line in lines:
				a = self.GetLastChild(line, -1)
				self.HideLines(line+1,a)
				self.SetFoldExpanded(line, False)

	def Expand(self, line, doExpand, force=False, visLevels=0, level=-1):
		#From demo.py (pype.py 1.1.8 uses it too!)
		lastChild = self.GetLastChild(line, level)
		line = line + 1
		while line <= lastChild:
			if force:
				if visLevels > 0:
					self.ShowLines(line, line)
				else:
					self.HideLines(line, line)
			else:
				if doExpand:
					self.ShowLines(line, line)
			if level == -1:
				level = self.GetFoldLevel(line)
			if level & wx.stc.STC_FOLDLEVELHEADERFLAG:
				if force:
					if visLevels > 1:
						self.SetFoldExpanded(line, True)
					else:
						self.SetFoldExpanded(line, False)
					line = self.Expand(line, doExpand, force, visLevels-1)
				else:
					if doExpand and self.GetFoldExpanded(line):
						line = self.Expand(line, True, force, visLevels-1)
					else:
						line = self.Expand(line, False, force, visLevels-1)
			else:
				line = line + 1
		return line