CREATE TABLE IF NOT EXISTS domain (
  name varchar(64) NOT NULL default '',
  safe_mode enum('yes','no') default 'yes',
  sbox_protect enum('yes','no') default 'yes',
  owner varchar(64) NOT NULL default '',
  default_subdomain varchar(64) default 'www',
  generate_flag enum('yes','no') NOT NULL default 'yes',
  quota bigint(20) NOT NULL default '50',
  max_email int(11) NOT NULL default '9',
  max_lists int(11) NOT NULL default '3',
  max_ftp int(11) NOT NULL default '3',
  max_subdomain int(11) NOT NULL default '5',
  max_ssh int(11) NOT NULL default '3',
  ip_addr varchar(16) NOT NULL default '213.215.47.212',
  backup_ip_addr varchar(16) default NULL,
  primary_dns varchar(255) NOT NULL default 'default',
  other_dns varchar(255) NOT NULL default 'default',
  primary_mx varchar(255) NOT NULL default 'default',
  other_mx varchar(255) NOT NULL default 'default',
  whois enum('here','away','linked') NOT NULL default 'away',
  hosting enum('here','away') NOT NULL default 'here',
  du_stat bigint(20) NOT NULL default '0',
  gen_unresolved_domain_alias enum('yes','no') NOT NULL default 'no',
  txt_root_entry varchar(128) NOT NULL default 'GPLHost:>_ Opensource hosting worldwide',
  txt_root_entry2 varchar(128) NOT NULL default 'This domain is hosted using Domain Technologie Control http://www.gplhost.com/software-dtc.html',
  catchall_email varchar(128) NOT NULL default '',
  domain_parking varchar(255) NOT NULL default 'no-parking',
  registrar_password varchar(255) NOT NULL default '',
  stats_login varchar(32) NOT NULL default '',
  stats_pass varchar(16) NOT NULL default '',
  stats_subdomain enum('yes','no') NOT NULL default 'no',
  UNIQUE KEY name (name)
) TYPE=MyISAM
