/*==============================================================================

FICHIER     : [message.c]

DATE        : 2004/07/0013 22:39:27

CREATEUR    : [Linux!jef]

COMMENTAIRE :
		Released under GPL license, see gnu.org
================================================================================

==============================================================================*/
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif
#include <stdio.h>
#include <stdlib.h>

#include <gnome.h>
#include <gtk/gtk.h>

#include <stdarg.h>

#include "support.h"
#include "message.h"
#include "interface.h"

#define CTEST(x)		/****/

#define GLADE_HOOKUP_OBJECT(component,widget,name) \
  g_object_set_data_full (G_OBJECT (component), name, \
    gtk_widget_ref (widget), (GDestroyNotify) gtk_widget_unref)

#define GLADE_HOOKUP_OBJECT_NO_REF(component,widget,name) \
  g_object_set_data (G_OBJECT (component), name, widget)

#include "globals.h"
#include "uitools.h"


static int AlerteRet = 0;
static GtkWidget * Parent = NULL;
static GtkWidget * PatientWindow = NULL;
static char * MsgBuf = NULL;
static GtkWidget * AnalyseWindow = NULL;

#define COUNTDOWN_TIMER		60
static int CountSec;

/*------------------------------------------------------------------------------
	ON_OK_CLICKED-
Linux!jef 2004/07/0012 21:31:08
------------------------------------------------------------------------------*/

static void on_alerte_ok_clicked ( GtkButton * button, gpointer user_data )
{
	GtkWidget * w = (GtkWidget *)user_data;

	gtk_widget_destroy( GTK_WIDGET(w) );
	AlerteRet = 1;
	gtk_main_quit();
}

/*------------------------------------------------------------------------------
	ON_OK_CLICKED-
Linux!jef 2004/07/0012 21:31:08
------------------------------------------------------------------------------*/

static void on_alerte_cancel_clicked ( GtkButton * button, gpointer user_data )
{
	GtkWidget * w = (GtkWidget *)user_data;

	gtk_widget_destroy( GTK_WIDGET(w) );
	AlerteRet = 0;
	gtk_main_quit();
}

/*------------------------------------------------------------------------------
	CREATEALERTE-
Linux!jef 2004/07/0013 22:59:18
------------------------------------------------------------------------------*/

static GtkWidget * CreateAlerte ( int flags, char * string )
{
	GtkWidget *alerte;
	GtkWidget *fixed5;
	GtkWidget *text2;
	GtkWidget *hseparator2;
	GtkWidget *alerte_ok;
	GtkWidget *alerte_cancel;
	GtkAccelGroup *accel_group;
	GtkTextBuffer * buffer;

	accel_group = gtk_accel_group_new ();

	alerte = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_object_set_data (GTK_OBJECT (alerte), "alerte", alerte);
	gtk_window_set_title (GTK_WINDOW (alerte), _("Alerte"));
	gtk_window_set_position (GTK_WINDOW (alerte), GTK_WIN_POS_CENTER);
	gtk_window_set_modal (GTK_WINDOW (alerte), TRUE);

	fixed5 = gtk_fixed_new ();
	gtk_widget_ref (fixed5);
	gtk_object_set_data_full (GTK_OBJECT (alerte), "fixed5", fixed5,
                            (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (fixed5);
	gtk_container_add (GTK_CONTAINER (alerte), fixed5);

	text2 = gtk_text_view_new();
	gtk_widget_ref (text2);
	gtk_object_set_data_full (GTK_OBJECT (alerte), "text2", text2,
                            (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (text2);
	gtk_fixed_put (GTK_FIXED (fixed5), text2, 0, 0);
	gtk_widget_set_uposition (text2, 0, 0);
	gtk_widget_set_usize (text2, 408, 176);

	buffer =  gtk_text_buffer_new( NULL );
	gtk_text_buffer_set_text( buffer, string, -1 );
	gtk_text_view_set_buffer( GTK_TEXT_VIEW(text2), buffer );

	hseparator2 = gtk_hseparator_new ();
	gtk_widget_ref (hseparator2);
	gtk_object_set_data_full (GTK_OBJECT (alerte), "hseparator2", hseparator2,
                            (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (hseparator2);
	gtk_fixed_put (GTK_FIXED (fixed5), hseparator2, 8, 184);
	gtk_widget_set_uposition (hseparator2, 8, 184);
	gtk_widget_set_usize (hseparator2, 392, 16);

	alerte_ok = gtk_button_new_with_label (_("Ok"));
	gtk_widget_ref (alerte_ok);
	gtk_object_set_data_full (GTK_OBJECT (alerte), "alerte_ok", alerte_ok,
                            (GtkDestroyNotify) gtk_widget_unref);
	gtk_widget_show (alerte_ok);
	gtk_fixed_put (GTK_FIXED (fixed5), alerte_ok, 8, 200);
	gtk_widget_set_uposition (alerte_ok, 8, 200);
	gtk_widget_set_usize (alerte_ok, 152, 40);
	gtk_widget_add_accelerator (alerte_ok, "clicked", accel_group,
                              GDK_Return, 0, GTK_ACCEL_VISIBLE);

	if( flags & ALERTE_FLG_CANCEL ) {
		alerte_cancel = gtk_button_new_with_label (_("Cancel"));
		gtk_widget_ref (alerte_cancel);
		gtk_object_set_data_full (GTK_OBJECT (alerte), "alerte_cancel", alerte_cancel,
	                            (GtkDestroyNotify) gtk_widget_unref);
		gtk_widget_show (alerte_cancel);
		gtk_fixed_put (GTK_FIXED (fixed5), alerte_cancel, 224, 200);
		gtk_widget_set_uposition (alerte_cancel, 224, 200);
		gtk_widget_set_usize (alerte_cancel, 176, 40);
		gtk_widget_add_accelerator (alerte_cancel, "clicked", accel_group,
	                              GDK_Escape, 0, GTK_ACCEL_VISIBLE);
		gtk_signal_connect (GTK_OBJECT (alerte_cancel), "clicked",
	                      GTK_SIGNAL_FUNC (on_alerte_cancel_clicked),
	                      alerte);
	}
	gtk_signal_connect (GTK_OBJECT (alerte_ok), "clicked",
                      GTK_SIGNAL_FUNC (on_alerte_ok_clicked),
                     alerte);

	gtk_widget_grab_default (alerte_ok);
	gtk_window_add_accel_group (GTK_WINDOW (alerte), accel_group);

	return( alerte );
}


/*------------------------------------------------------------------------------
	MESSAGE-
Linux!jef 2004/07/0013 22:41:30
------------------------------------------------------------------------------*/

int Alerte( int flags, char * format, ... )
{
	GtkWidget * w;
	char buffer[4096];
	va_list args;

	AlerteRet = 0;
	va_start( args, format );
	vsnprintf( buffer, sizeof(buffer), format, args );

	w = CreateAlerte( flags, buffer );
	if( w ) {
		if( Parent )	gtk_window_set_transient_for( GTK_WINDOW(w), GTK_WINDOW(Parent));
		gtk_widget_show( w );
		gtk_main();
	}
	va_end( args );
	return( AlerteRet );
}

/*------------------------------------------------------------------------------
	ALERTESETPARENT-
Linux!jef 2006/02/14 22:38:01
------------------------------------------------------------------------------*/

GtkWidget * AlerteSetParent( GtkWidget * parent )
{
	GtkWidget * old = Parent;

	Parent = parent;

	return( old );
}


/*------------------------------------------------------------------------------
	CREATEPATIENT-
Linux!jef 2004/07/0013 22:43:52
------------------------------------------------------------------------------*/

static GtkWidget * CreatePatient( char * string )
{
  GtkWidget *patient;
  GtkWidget *fixed1;
  GtkWidget *text;
  GtkTextBuffer * buffer;

  patient = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  GLADE_HOOKUP_OBJECT_NO_REF (patient, patient, "patient");
  gtk_window_set_title (GTK_WINDOW (patient), _("Informations"));
  gtk_window_set_position (GTK_WINDOW (patient), GTK_WIN_POS_CENTER);
  gtk_window_set_modal (GTK_WINDOW (patient), TRUE);

  fixed1 = gtk_fixed_new ();
  GLADE_HOOKUP_OBJECT (patient, fixed1, "fixed1");
  gtk_widget_show (fixed1);
  gtk_container_add (GTK_CONTAINER (patient), fixed1);

  text = gtk_text_view_new ();
  GLADE_HOOKUP_OBJECT (patient, text, "text");
  gtk_widget_show (text);
  gtk_fixed_put (GTK_FIXED (fixed1), text, 0, 0);
  gtk_widget_set_size_request (text, 416, 48);
  gtk_text_view_set_editable (GTK_TEXT_VIEW (text), FALSE);
  gtk_text_view_set_justification (GTK_TEXT_VIEW (text), GTK_JUSTIFY_CENTER);

  buffer =  gtk_text_buffer_new( NULL );
  gtk_text_buffer_set_text( buffer, string, -1 );
  gtk_text_view_set_buffer( GTK_TEXT_VIEW(text), buffer );


  return( patient );
}

/*------------------------------------------------------------------------------
	OPENPATIENT-
Linux!jef 2006/02/28 22:52:06
------------------------------------------------------------------------------*/

void OpenPatient( char * format, ... )
{
	char buffer[4096];
	va_list args;

	ClosePatient();
	va_start( args, format );
	vsnprintf( buffer, sizeof(buffer), format, args );
//!! fprintf(stderr,"Buffer(%s)\n", buffer );
	va_end( args );
	MsgBuf = strdup( buffer );
	PatientWindow = CreatePatient( MsgBuf );
	if( Parent )	gtk_window_set_transient_for( GTK_WINDOW(PatientWindow), GTK_WINDOW(Parent));
	gtk_widget_show_now( PatientWindow );
	while( gtk_events_pending() )	gtk_main_iteration();
}
/*------------------------------------------------------------------------------
	CLOSEPATIENT-
Linux!jef 2006/02/28 22:53:50
------------------------------------------------------------------------------*/

void ClosePatient()
{
	if( PatientWindow ) {
//		sleep( 10 );
		gtk_widget_destroy( GTK_WIDGET(PatientWindow) );
		PatientWindow = NULL;
		if( MsgBuf ) { free( MsgBuf ); MsgBuf = NULL; }
	}
}

/*------------------------------------------------------------------------------
	COUNTDOWN-
Linux!jef 2007/08/09 21:53:26
------------------------------------------------------------------------------*/

static gboolean CountDown( gpointer data )
{
	GtkWidget * msg = (GtkWidget *)data;
	char string[100];

// fprintf(stderr,"tick: %d\n", CountSec);
	if( --CountSec == 0 ) {
		Phase2 = PHASE2_AVANCER;
		gtk_dialog_response( GTK_DIALOG( msg ), 2 );
		return( FALSE );
	}
	sprintf( string, _("Premi\303\250re phase termin\303\251e (%d)"), CountSec );
	gtk_window_set_title (GTK_WINDOW (msg), string );

	return( TRUE );
}

/*------------------------------------------------------------------------------
	PHASE2-
Linux!jef 2007/01/21 22:17:16
------------------------------------------------------------------------------*/

int MessagePhase2( char * targetDir )
{
	GtkWidget * msg;
	guint id;

	Phase2 = 0;
	TargetDir = targetDir;
	msg = create_alerte_deuxiemephase();

	CountSec = COUNTDOWN_TIMER;
	id = g_timeout_add( 1000, CountDown, msg );

	while( 1 ) {
		gtk_dialog_run( GTK_DIALOG( msg ) );
// fprintf(stderr,"blip\n");
		if( Phase2 )	break;
	}
	gtk_widget_destroy( GTK_WIDGET( msg ) );
	g_source_remove( id );
// fprintf(stderr,"Phase2=%d\n", Phase2 );
	return( Phase2 );
}

/*------------------------------------------------------------------------------
	OPENANALYSE-
Linux!jef 2007/01/21 23:18:07
------------------------------------------------------------------------------*/

int OpenAnalyse()
{
	AnalyseWindow = create_alerte_analyse();
	gtk_widget_show_now( AnalyseWindow );
	GtkFlush();
	return( 0 );
}
/*------------------------------------------------------------------------------
	CLOSEANALYSE-
Linux!jef 2007/01/21 23:18:14
------------------------------------------------------------------------------*/

int CloseAnalyse()
{
	if( AnalyseWindow ) {
		gtk_widget_destroy( AnalyseWindow );
		AnalyseWindow = NULL;
	}
	return( 0 );
}

/*------------------------------------------------------------------------------
	ENCODAGEFINI-
Linux!jef 2007/01/21 23:29:42
------------------------------------------------------------------------------*/

void EncodageFini()
{
	GtkWidget * msg;

	msg = create_alerte_termine();
	gtk_dialog_run( GTK_DIALOG( msg ) );
	gtk_widget_destroy( GTK_WIDGET( msg ) );
}

