/////////////////////////////////////////////////////////////////////////////
// Name:        CellPropDlg.h
// Purpose:     DVD cell properties dialog
// Author:      Alex Thuering
// Created:     23.04.2011
// RCS-ID:      $Id: CellPropDlg.h,v 1.2 2011/05/15 13:41:21 ntalex Exp $
// Copyright:   (c) Alex Thuering
// Licence:     GPL
/////////////////////////////////////////////////////////////////////////////
 
#ifndef CELL_PROP_DLG_H
#define CELL_PROP_DLG_H

#include <wx/wx.h>
#include <wx/image.h>
#include "DVD.h"

// begin wxGlade: ::dependencies
#include <wx/spinbutt.h>
#include <wx/spinctrl.h>
// end wxGlade

// begin wxGlade: ::extracode

// end wxGlade

class CellPropDlg: public wxDialog {
public:
    // begin wxGlade: CellPropDlg::ids
    // end wxGlade
	
	/** Constructor */
    CellPropDlg(wxWindow* parent, DVD* dvd, int tsi, int pgci, Vob* vob, Cell* cell);

private:
    // begin wxGlade: CellPropDlg::methods
    void set_properties();
    void do_layout();
    // end wxGlade

    // begin wxGlade: CellPropDlg::attributes
    wxStaticText* m_typeLabel;
    wxRadioButton* m_regularRadioBt;
    wxRadioButton* m_chapterRadioBt;
    wxRadioButton* m_programRadioBt;
    wxStaticText* m_startLabel;
    wxTextCtrl* m_startCtrl;
    wxSpinButton* m_startSpinBt;
    wxStaticText* m_endLabel;
    wxTextCtrl* m_endCtrl;
    wxSpinButton* m_endSpinBt;
    wxStaticText* m_pauseLabel;
    wxSpinCtrl* m_pauseSpin;
    wxStaticText* m_secLabel;
    wxStaticText* m_commandLabel;
    wxComboBox* m_commandsCtrl;
    wxButton* m_okBt;
    wxButton* m_cancelBt;
    // end wxGlade
    
    DVD* m_dvd;
    int m_tsi;
    int m_pgci;
    Vob* m_vob;
    Cell* m_cell;
	virtual void OnChangeStart(wxCommandEvent &event); // wxGlade: <event_handler>
	virtual void OnStartSpin(wxSpinEvent &event); // wxGlade: <event_handler>
	virtual void OnChangeEnd(wxCommandEvent &event); // wxGlade: <event_handler>
	virtual void OnEndSpin(wxSpinEvent &event); // wxGlade: <event_handler>
	virtual void OnOkBt(wxCommandEvent &event); // wxGlade: <event_handler>
	DECLARE_EVENT_TABLE();
}; // wxGlade: end class


#endif // CELL_PROP_DLG_H
