/////////////////////////////////////////////////////////////////////////////
// Name:		BurnDlg.h
// Purpose:		Burn dialog
// Author:		Alex Thuering
// Created:		23.03.2003
// RCS-ID:		$Id: BurnDlg.h,v 1.18 2013/10/23 20:26:33 ntalex Exp $
// Copyright:	(c) Alex Thuering
// Licence:		GPL
/////////////////////////////////////////////////////////////////////////////

#ifndef BURNDLG_H
#define BURNDLG_H

#include <wx/wx.h>
#include <wx/image.h>
#include "DVD.h"
#include "Cache.h"

//(*Headers(BurnDlg)
#include <wx/combobox.h>
#include <wx/checkbox.h>
#include <wx/dialog.h>
#include <wx/sizer.h>
#include <wx/button.h>
#include <wx/radiobut.h>
#include <wx/stattext.h>
#include <wx/textctrl.h>
//*)

class BurnDlg: public wxDialog {
public:
	/** Constructor */
	BurnDlg(wxWindow* parent, DVD* dvd, Cache* cache);
	virtual ~BurnDlg();
	
    wxString GetTempDir() { return m_tempDirText->GetValue(); }
    wxString GetOutputDir() { return m_outputDirText->GetValue(); }
	bool DoPreview() { return m_previewCheck->GetValue(); }
	bool DoGenerate() { return m_generateRadioBt->GetValue(); }
	bool DoCreateIso() { return m_isoRadioBt->GetValue(); }
	wxString GetIsoFile() { return m_isoText->GetValue(); }
	bool DoAddECC() { return m_addECCCheck->GetValue(); }
	bool DoBurn() { return m_burnRadioBt->GetValue(); }
	bool DoFormat() { return m_formatCheck->GetValue(); }
	wxString GetDevice();
	int GetSpeed();

	//(*Declarations(BurnDlg)
	wxStaticText* m_isoRequiredSpaceText;
	wxStaticText* m_isoLabel;
	wxStaticText* tempDirLabel;
	wxComboBox* m_deviceChoice;
	wxStaticText* m_requiredSpaceText;
	wxTextCtrl* m_isoText;
	wxCheckBox* m_previewCheck;
	wxStaticText* m_deviceLabel;
	wxTextCtrl* m_tempDirText;
	wxStaticText* m_isoFreeSpaceText;
	wxStaticText* m_outputRequiredSpaceTitle;
	wxRadioButton* m_isoRadioBt;
	wxRadioButton* m_burnRadioBt;
	wxStaticText* m_isoRequiredSpaceTitle;
	wxStaticText* m_speedLabel;
	wxRadioButton* m_generateRadioBt;
	wxCheckBox* m_addECCCheck;
	wxCheckBox* m_formatCheck;
	wxStaticText* m_outputLabel;
	wxTextCtrl* m_outputDirText;
	wxStaticText* m_outputFreeSpaceTitle;
	wxComboBox* m_speedChoice;
	wxStaticText* m_outputFreeSpaceText;
	wxStaticText* m_isoFreeSpaceTitle;
	wxButton* m_isoBt;
	wxStaticText* m_freeSpaceText;
	wxStaticText* m_outputRequiredSpaceText;
	wxButton* m_tempDirBt;
	wxButton* m_outputDirBt;
	//*)

protected:
	//(*Identifiers(BurnDlg)
	static const long ID_STATICTEXT1;
	static const long TEMP_DIR_FIELD_ID;
	static const long TEMP_DIR_BT_ID;
	static const long ID_STATICTEXT3;
	static const long ID_STATICTEXT4;
	static const long PREVIEW_CHECK_ID;
	static const long GENERATE_RADIO_BT_ID;
	static const long ID_TEXTCTRL1;
	static const long ID_BUTTON1;
	static const long ID_STATICTEXT6;
	static const long ID_STATICTEXT7;
	static const long ISO_RADIO_BT_ID;
	static const long ISO_FILE_FIELD_ID;
	static const long ISO_BT_ID;
	static const long ID_STATICTEXT2;
	static const long ID_STATICTEXT5;
	static const long BURN_RADIO_BT_ID;
	static const long ID_CHECKBOX1;
	static const long ID_COMBOBOX1;
	static const long ID_COMBOBOX2;
	static const long ID_CHECKBOX2;
	//*)

private:
    DVD* m_dvd;
    Cache* m_cache;
	wxArrayString m_devices;
	bool m_eccCheckEnabled;
	void SetDevice(wxString device);
	void SetSpeed(int speed);
	void UpdateCtrls(bool def = false);
	bool UpdateSpaceLabels(bool showErrors = false);

	//(*Handlers(BurnDlg)
	void OnTempDirChange(wxCommandEvent& event);
	void OnChooseTempDir(wxCommandEvent& event);
	void OnRadioBt(wxCommandEvent& event);
	void OnChooseIsoFile(wxCommandEvent& event);
	void OnChooseOutputDir(wxCommandEvent& event);
	//*)
	void OnActivate(wxActivateEvent &event);
    virtual void OnOk(wxCommandEvent &event);
    virtual void OnReset(wxCommandEvent &event);

	DECLARE_EVENT_TABLE()
};

#endif
