/////////////////////////////////////////////////////////////////////////////
// Name:        MenuObjectPropDlg.h
// Purpose:     DVD menu button properties dialog
// Author:      Alex Thuering
// Created:	20.11.2003
// RCS-ID:      $Id: MenuObjectPropDlg.h,v 1.23 2014/02/04 13:37:26 ntalex Exp $
// Copyright:   (c) Alex Thuering
// Licence:     GPL
/////////////////////////////////////////////////////////////////////////////

#ifndef BUTTON_PROP_DLG_H
#define BUTTON_PROP_DLG_H

#include <wx/wx.h>
#include <wxVillaLib/PropDlg.h>
#include "DVD.h"

class MenuObjectPropDlg: public wxPropDlg {
public:
	MenuObjectPropDlg(wxWindow *parent, wxString id, bool multObjects, Menu *menu, DVD* dvd, int tsi, int pgci);
	virtual ~MenuObjectPropDlg() {}
	
private:
	wxString m_id;
	bool m_multObjects;
	MenuObject* m_object;
	Menu* m_menu;
	DVD* m_dvd;
	int m_tsi; // tsi of menu
	int m_pgci; // pgci of menu
	void CreatePropPanel(wxSizer* sizer);
    void CreateLook(wxBoxSizer* mainSizer, wxFlexGridSizer* grid);
	void CreateLocAndSize(wxBoxSizer* mainSizer);
	
	wxChoice* m_targetChoice;
	wxChoice* m_chapterChoice;
	/** Returns titleset id of selected target */
	int GetSelectedTsi();
	/** Returns PGC id of selected target */
	int GetSelectedPgci();
	/** Returns true if selected target is menu */
	bool IsSelectedMenu();
	/** Returns selected chapter number */
	int GetSelectedChapter();
	
	void* TargetToPtr(int tsi, int pgci, bool menu);
	void FillTargets(wxChoice* ctrl);
	void UpdateChapters();
	void OnChangeTarget(wxCommandEvent& evt);
	void OnChangeChapter(wxCommandEvent& evt);
	
	bool m_displayVideoFrame; // shows if video frame must be automatically selected if it is available
	long m_defaultPos;
	long m_videoPos;
	int m_videoDuration;
	wxTextCtrl* m_imageEdit;
	int m_imageEditIdx;
	wxRadioButton* m_imageRadio;
	wxRadioButton* m_videoFrameRadio;
	wxButton* m_videoFrameBt;
	wxString GetVideoFilename(bool withTimestamp = false, long position = -1);
	void OnImageRadio(wxCommandEvent& evt);
	void OnVideoFrame(wxCommandEvent& evt);
	void OnJustifyText(wxCommandEvent& evt);
	bool CanJustifyText(wxString paramName);
	
	wxTextCtrl* m_customActionEdit;
	void OnJumpActionSelected(wxCommandEvent& evt);
	void OnCustomActionSelected(wxCommandEvent& evt);
	
	wxTextCtrl* m_widthEdit;
	wxTextCtrl* m_heightEdit;
	void OnKeepAspectRatio(wxCommandEvent& evt);
	
	void AddNavigationProp(wxSizer* sizer, NavigationButton navButton);
	bool SetValues();
	
	DECLARE_EVENT_TABLE()
};

#endif // BUTTON_PROP_DLG_H
