/*  $Header: /cvsroot/dvipdfmx/src/pdfspecial.h,v 1.7 2004/03/11 11:50:24 hirata Exp $

    This is dvipdfmx, an eXtended version of dvipdfm by Mark A. Wicks.

    Copyright (C) 2002 by Jin-Hwan Cho and Shunsaku Hirata,
    the dvipdfmx project team <dvipdfmx@project.ktug.or.kr>
    
    Copyright (C) 1998, 1999 by Mark A. Wicks <mwicks@kettering.edu>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.
    
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
    
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
*/
	
#ifndef _PDFSPECIAL_H_
#define _PDFSPECIAL_H_

#include "numbers.h"
#include "pdfobj.h"

/* The name transform_info is misleading too. */
typedef struct
{
  /* Physical dimensions
   *
   * If those values are given, images will be scaled
   * and/or shifted to fit within a box described by
   * those values.
   */
  double width;
  double height;
  double depth;

  /* Should switch to pdf_tmatrix... */
  double scale;
  double xscale;
  double yscale;
  double rotate;

  double xoffset;
  double yoffset;

  /* dvipdfmx keep original image's bounding box.
   * This is actually crop box for forms. Must be same
   * as width/height/depth for raster images.
   */
  int user_bbox;
  double u_llx, u_lly, u_urx, u_ury;

  /* When the image is form type and when user supplied
   * bounding box does not agree with the one the form
   * image has. The variable "clip" is set and the image
   * is clipped to user's bounding box.
   */
  int clip;
} transform_info;

extern void transform_info_clear (transform_info *tf_info);

extern void pdf_special_set_verbose(void);

extern int pdf_parse_special(char *buffer, UNSIGNED_QUAD size,
			     double x_user, double y_user);

extern pdf_obj *lookup_reference (const char *ident);

extern void transform_info_clear (transform_info *info);

extern double parse_length (char **start, char *end);

extern void   pdf_special_init  (void);
extern void   pdf_special_close (void);
extern double pdf_special_tell_grow (void);

#ifndef M_PI
#define M_PI (4.0*atan(1.0))
#endif /* M_PI */

#endif /* _PDFSPECIAL_H_ */
