% Usage:
%       out = test1_ff(params, y)
%   where
%       out    is a (6,6) matrix of the first order
%              derivatives of the static system residuals
%              columns correspond to endo variables in
%              the ordering as declared
%       params is a (8,1) vector of parameter values
%              in the ordering as declared
%       y      is a (6,1) vector of endogenous variables
%              in the ordering as declared
%
% Created by Dynare++ v. 4.3.0

% params ordering
% =====================
% beta
% rho
% alpha
% delta
% theta
% psi
% tau
% phi
%
% y ordering
% =====================
% y
% c
% k
% a
% h
% b

function out = test1_ff(params, y)
if size(y) ~= [6,1]
	error('Wrong size of y, must be [6,1]');
end
if size(params) ~= [8,1]
	error('Wrong size of params, must be [8,1]');
end

% hardwired constants
a0 =            0;
a1 =            1;
a2 = NaN;
a3 =    1.1283792;
% numerical constants
a8 =            1;
% parameter values
a19 = params(1); % beta
a51 = params(2); % rho
a13 = params(3); % alpha
a31 = params(4); % delta
a5 = params(5); % theta
a9 = params(6); % psi
a54 = params(7); % tau
% phi not used in the model
% exogenous variables to zeros
a58 = 0.0; % e
a64 = 0.0; % u
% endogenous variables to y
a15 = y(1); % y
a29 = y(1); % y
a4 = y(2); % c
a25 = y(2); % c
a40 = y(3); % k
a18 = y(3); % k
a52 = y(4); % a
a38 = y(4); % a
a7 = y(5); % h
a55 = y(6); % b
a20 = y(6); % b
a23 = y(6); % b

t6 = a4 * a5;
t10 = a8 + a9;
t69 = t10 - a1;
t70 = a7 ^ t69;
t71 = t10 * t70;
t72 = t6 * t71;
t14 = a8 - a13;
t73 = -(t14);
t11 = a7 ^ t10;
t74 = a5 * t11;
t21 = exp(a20);
t22 = a4 * t21;
t24 = exp(a23);
t26 = t24 * a25;
t27 = t22 / t26;
t28 = a13 * t24;
t30 = t28 * a29;
t79 = t27 * t30;
t32 = a8 - a31;
t33 = a18 * t32;
t34 = t30 + t33;
t75 = t22 * t26;
t76 = -(t75);
t77 = t26 * t26;
t78 = t76 / t77;
t80 = t34 * t78;
t81 = t79 + t80;
t82 = a19 * t81;
t83 = -(t82);
t84 = t27 * t28;
t85 = a19 * t84;
t86 = -(t85);
t87 = t22 * t24;
t88 = -(t87);
t89 = t88 / t77;
t90 = t34 * t89;
t91 = a19 * t90;
t92 = -(t91);
t93 = t27 * t32;
t94 = a19 * t93;
t95 = a1 - t94;
t35 = t27 * t34;
t36 = a19 * t35;
t96 = -(t36);
t97 = t21 / t26;
t98 = t34 * t97;
t99 = a19 * t98;
t100 = -(t99);
t39 = exp(a38);
t41 = a40 ^ a13;
t42 = t39 * t41;
t102 = t14 - a1;
t103 = a7 ^ t102;
t104 = t14 * t103;
t105 = t42 * t104;
t106 = -(t105);
t43 = a7 ^ t14;
t44 = t42 * t43;
t107 = -(t44);
t1 = a1;
t110 = a13 - a1;
t111 = a40 ^ t110;
t112 = a13 * t111;
t113 = t39 * t112;
t114 = t43 * t113;
t115 = -(t114);
t46 = a15 - a4;
t47 = t21 * t46;
t116 = -(t47);
t117 = -(t21);
t118 = -(a1);
t119 = t21 * t118;
t120 = -(t119);
t121 = -(t32);
t122 = -(a51);
t123 = -(a54);
% setting the output variable
out = zeros(6, 6);
out(1,5) = out(1,5) + t72; % h(0)
out(1,1) = out(1,1) + t73; % y(0)
out(1,2) = out(1,2) + t74; % c(0)
out(2,6) = out(2,6) + t83; % b(1)
out(2,1) = out(2,1) + t86; % y(1)
out(2,2) = out(2,2) + t92; % c(1)
out(2,3) = out(2,3) + t95; % k(0)
out(2,6) = out(2,6) + t96; % b(0)
out(2,2) = out(2,2) + t100; % c(0)
out(3,5) = out(3,5) + t106; % h(0)
out(3,4) = out(3,4) + t107; % a(0)
out(3,1) = out(3,1) + t1; % y(0)
out(3,3) = out(3,3) + t115; % k(-1)
out(4,3) = out(4,3) + t1; % k(0)
out(4,6) = out(4,6) + t116; % b(0)
out(4,1) = out(4,1) + t117; % y(0)
out(4,2) = out(4,2) + t120; % c(0)
out(4,3) = out(4,3) + t121; % k(-1)
out(5,4) = out(5,4) + t1; % a(0)
out(5,4) = out(5,4) + t122; % a(-1)
out(5,6) = out(5,6) + t123; % b(-1)
out(6,6) = out(6,6) + t1; % b(0)
out(6,4) = out(6,4) + t123; % a(-1)
out(6,6) = out(6,6) + t122; % b(-1)
