/***********************************************************************************/
/* $Id: Adiutil.h,v 1.4 2003/06/03 22:59:40 sleeper Exp $                   */
/*										   */
/* Adiutil.h									   */
/*										   */
/* Includes all headers necessary for using Adiutil				   */
/*										   */
/* This file is part of the "ADI USB ADSL Driver for Linux".			   */
/*										   */
/* "ADI USB ADSL Driver for Linux" is free software; you can redistribute it       */
/* and/or modify it under the terms of the GNU General Public License as           */
/* published by the Free Software Foundation; either version 2 of the License,     */
/* or (at your option) any later version.					   */
/*										   */
/* "ADI USB ADSL Driver for Linux" is distributed in the hope that it will be      */
/* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of	   */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the		   */
/* GNU General Public License for more details.					   */
/*										   */
/* You should have received a copy of the GNU General Public License		   */
/* along with "ADI USB ADSL Driver for Linux"; if not, write to the Free Software  */
/* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA       */
/***********************************************************************************/

#ifndef __ADIHEADERS_H__
#define __ADIHEADERS_H__

/*Include OS includes here ...*/
#include <linux/config.h>
#if defined(CONFIG_MODVERSIONS) && !defined(MODVERSIONS)
#define MODVERSIONS
#endif
#if defined(MODVERSIONS)
#include <linux/modversions.h>
#endif

#include <linux/kernel.h>
#include <linux/types.h>
#include <linux/slab.h>
#include <linux/vmalloc.h>
#include <linux/usb.h>
#include <linux/init.h>
#include <linux/timer.h>
#include <linux/param.h>
#include <linux/netdevice.h>
#include <linux/etherdevice.h>
#include <linux/spinlock.h>
#include <asm/semaphore.h>
#include <linux/ctype.h>
#include <asm/byteorder.h>

/* Types definition */
typedef uint8_t		UInt8;
typedef uint16_t	UInt16;
typedef uint32_t	UInt32;
typedef int32_t		SInt32;
typedef unsigned int	Boolean;
#define FALSE                       0
#define TRUE                        1

typedef struct list_head QHdr;

/*Include ADIUTIL includes here ...*/
#include "Macros.h"
#include "Konst.h"
#include "Buffers.h"
#include "Structs.h"
#include "Hardware.h"
#include "Oam.h"

#endif /*ADIUTIL_H*/

/********************************************************
$Log: Adiutil.h,v $
Revision 1.4  2003/06/03 22:59:40  sleeper
Removal of Zaps.h inclusion

Revision 1.3  2003/03/11 00:38:03  sleeper
Add OAM modifs as present in Sagemn 2.0.1 driver

Revision 1.2  2003/03/10 23:21:00  sleeper
First fix for architecture independance

Revision 1.1.1.1  2003/02/10 23:29:49  sleeper
Imported sources

Revision 2.00  2002/05/24 21:59:30  Anoosh Naderi
Clean up the code.

Revision 1.9  2002/01/14 21:59:30  chris.edgington
Added GPL header.

Revision 1.8  2002/01/14 17:39:36  chris.edgington
Moved support of MODVERSIONS from Makefile into here.

Revision 1.7  2002/01/08 20:07:25  chris.edgington
Added include of linux/ctype.h.

Revision 1.6  2002/01/02 22:03:54  chris.edgington
Changed load order of Structs.h.

Revision 1.5  2001/12/28 22:09:30  chris.edgington
Added includes for netdevice.h and etherdevice.h.

Revision 1.4  2001/12/26 22:48:02  chris.edgington
Added kernel timer support.

Revision 1.3  2001/12/22 19:48:46  chris.edgington
Removed include of linux/module.h - all files don't need this.

Revision 1.2  2001/12/20 22:37:23  chris.edgington
Added include of linux/vmalloc.h.

Revision 1.1.1.1  2001/12/14 21:27:08  chris.edgington
Initial import
*****************************************************************/
