/************************************************************************************/
/* $Id: Hardware.h,v 1.11 2003/06/03 22:57:09 sleeper Exp $                          */
/*										    */
/* Copyright (c) 2001, Analog Devices Inc., All Rights Reserved			    */
/*										    */
/* Hardware.h									    */
/*										    */
/* Holds our Hardware structure definition.					    */
/*										    */
/* This file is part of the "ADI USB ADSL Driver for Linux".			    */
/*										    */
/* "ADI USB ADSL Driver for Linux" is free software; you can redistribute it 	    */
/* and/or modify it under the terms of the GNU General Public License as 	    */
/* published by the Free Software Foundation; either version 2 of the License,      */
/* or (at your option) any later version.					    */
/*										    */
/* "ADI USB ADSL Driver for Linux" is distributed in the hope that it will be       */
/* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of	    */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the		    */
/* GNU General Public License for more details.					    */
/*										    */
/* You should have received a copy of the GNU General Public License		    */
/* along with "ADI USB ADSL Driver for Linux"; if not, write to the Free Software   */
/* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA        */
/************************************************************************************/

#ifndef HARDWARE_H
#define HARDWARE_H

struct _FIRMWARE_RECORD;
    
typedef struct
{

    /* Linked list hook */
    struct list_head list;

    /*Holds USB device information (dev, interfaces, pipes, etc.)*/
    struct usb_device *usbdev;

    /*URBs allocated for this device*/
    struct urb  urbInt;
    struct urb  urbIdma;
    struct urb  urbWrite;
    struct urb  urbOAMWrite;
#ifdef USEBULK
    struct urb  urbRead[INCOMING_Q_SIZE];
#else
    struct urb *pUrbReadIso[INCOMING_Q_SIZE];
#endif

    /*Info for when we're using ISO for receive*/
    UInt32 IsoPipeSize;
    UInt32 IsoFramesPerUrb;

    /*Device's endpoints*/
    UInt32 pipeIntIn;
    UInt32 pipeBulkIdmaOut;
    UInt32 pipeBulkDataOut;
    UInt32 pipeBulkDataIn;
    UInt32 pipeIsoDataIn;

    /*Data allocated at startup*/
    CDC_NOTIFY *pInterruptData;
    void       *pIncomingData[INCOMING_Q_SIZE];
    void       *pReadyData;
    void       *pOutgoingData;
    unsigned int mru;
    
    /**************************************************************************/
    /* MacOS is asyncronous for reads - we tell it there's data ready, then he*/
    /* reads it when he's ready. This forced us to queue incoming packets.    */
    /* Linux is much simpler - when we've got data - we send it to the stack. */
    /* So, we don't have to keep an incoming queue. To keep from modifying the*/
    /* Uni code too much, we alloc a static struct here			      */
    /**************************************************************************/
    ETHERNET_PACKET_BUFFER ReassemblyBuffer;
    /****************************************************************************/
    /* The same is true with writes - in Mac land we had to queue writes, 'cause*/
    /* they came in from the OS faster than we could send them out over usb.    */
    /* In linux, we can stop the OS from sending us packets until we're done    */
    /* sending the current one, so we don't need to manage a send queue either  */
    /****************************************************************************/
    OUTGOING_BUFFER        SegmentationBuffer;

    /*Modem state machine info*/
    AdiMSM            AdiModemSm;
    wait_queue_head_t OperationalQueue;

    
    Boolean   MsgInitialized;
    CmvMsg   *pDriverCMVs;

    /*DSP code info*/
    rwlock_t  DSPLock;
    IDMAPage  MainPage;
    IDMAPage *pSwapPages;
    UInt32    SwapPageCount;

    /*URB queues*/
    struct list_head ctrl_urb_free_q;  /* Free queued_urb_t queue */
    struct list_head ctrl_urb_ipg_q;  /* In-progress control urb queue */
    struct urb      *ctrl_urb_failed;
    spinlock_t       ctrl_q_lock;
    
    

    /*Kernel timer(s)*/
    struct timer_list CtrlUrbQueueTimer;
    struct timer_list ctrl_urb_retry;
    
    
    /*Misc data*/
    volatile Boolean IsOpen;
    volatile Boolean HasIntURB;
    Boolean          IsReading;
    Boolean	     IsWriting;
#ifdef DELAY_ISO_STARTUP
    Boolean          IsReadPipeStarted;
#endif
    UInt32           MpoaMode;
    UInt8            MAC[ETH_LENGTH_OF_ADDRESS];
    Boolean          MonitoringApp;

    /*Ethernet interface data*/
    spinlock_t               NetLock;
    struct semaphore         NetSem;
    UInt32                   OutgoingPacketSize;
    struct net_device       *pLinuxNet;
    struct net_device_stats  LinuxStats;

    /*Statistics*/
    UInt32 Statistics[STAT_COUNT];

    /*ATM data*/
    ATMVC Vc;

    // State variables used for OAM stuff
    Boolean     OAMState_TimerOn;
    Boolean     OAMState_SendingCC;
    Boolean     OAMState_ReceiveCC;
    Boolean     OAMState_AIS;
    UInt32      OAMState_CCSink;
    UInt8       OAMCell[ATM_CELL_SIZE*2];
    UInt8       *pOAMCell;                      // FFD nov26 DC                                 
    UInt8       OAMCellHeader[ATM_CELL_HEADER_SIZE*2];
    struct timer_list OAMTimer;
    Boolean     FakePacketReady;
    UInt32      FakePacketSize;
    UInt8       *pPacket; // [ETHERNET_MAX_PACKET_SIZE];
    ETHERNET_MAC_HEADER FakeHeader;

	Boolean		LowRateFlag; //Low bit Rate: 04042003
	Boolean		UnplugFlag;  //04152003

} Hardware;

/*Comment out this line to build for 930 hardware*/
#define EAGLE 1

#endif /*HARDWARE_H*/

/*******************************************************************
$Log: Hardware.h,v $
Revision 1.11  2003/06/03 22:57:09  sleeper
Remove semaphore on Firmware

Revision 1.10  2003/04/08 23:10:53  sleeper
Add mru

Revision 1.9  2003/04/23 22:24:39  sleeper
Ctrl USB submission rewrite

Revision 1.8  2003/03/20 22:07:55  sleeper
Merge routed mode modfis + info statements added

Revision 1.7  2003/03/11 00:38:03  sleeper
Add OAM modifs as present in Sagemn 2.0.1 driver

Revision 1.6  2003/03/10 23:20:24  sleeper
Change Control URB submission

Revision 1.5  2003/02/24 23:54:53  sleeper
Remove duplicate line

Revision 1.4  2003/02/21 21:51:45  sleeper
Add Renaud Guerin(rguerin@freebox.fr) support for multi-modem

Revision 1.3  2003/02/20 22:18:37  sleeper
Fix a bug that occured when options were not loader and DSP was sent to driver

Revision 1.2  2003/02/14 23:30:56  sleeper
Merge CC5 diffs

Revision 1.1.1.1  2003/02/10 23:29:49  sleeper
Imported sources

Revision 1.20  2002/05/24 17:56:45  Anoosh Naderi
Clean up the code

Revision 1.15  2002/03/12 17:56:45  chris.edgington
Added ISO support for incoming data.

Revision 1.14  2002/02/11 21:15:13  chris.edgington
Turned urbRead and pIncomingData into arrays to support variable number of read urbs.

Revision 1.13  2002/01/18 18:01:58  chris.edgington
Removed ifdef around pDriverOptions.

Revision 1.12  2002/01/14 21:59:31  chris.edgington
Added GPL header.

Revision 1.11  2002/01/08 16:24:48  chris.edgington
Added MAC field.
Re-added MonitoringApp - state machine expects it to be there.

Revision 1.10  2002/01/08 15:52:30  chris.edgington
Removed unused Qs.
Removed MonitoringApp flag.

Revision 1.9  2002/01/04 20:54:02  chris.edgington
Added urbRead, urbWrite since we're not keeping a local queue.
Added pIncomingData, pReadyData, and pOugoingData for data trasnfers.
Added ReassemblyBuffer and SegmentationBuffer to simulate queues for Uni.
Added IsReading boolean.

Revision 1.8  2002/01/02 22:06:41  chris.edgington
Added MpoaMode, Statistics, and Vc fields.
Removed ifdef LATER from around Q fields.

Revision 1.7  2001/12/28 22:10:19  chris.edgington
Added IsOpen, pLinuxNet, and LinuxStats fields.

Revision 1.6  2001/12/28 19:34:19  chris.edgington
Added CtrlUrbFreeQ, CtrlUrbPendQ, and CtrlUrbQueueTimer.

Revision 1.5  2001/12/22 21:31:31  chris.edgington
Added state machine data.
Removed DspLoadQ - we're not using it.

Revision 1.4  2001/12/22 19:45:03  chris.edgington
Removed ifdef from around Q's - since we're using them now.

Revision 1.3  2001/12/21 23:49:54  chris.edgington
Added pipe holders, interrupt data pointer, and static urbs.

Revision 1.2  2001/12/17 22:10:12  chris.edgington
Added usb_device * to Hardware.

Revision 1.1.1.1  2001/12/14 21:27:19  chris.edgington
Initial import
*******************************************************************/
