/************************************************************************************/
/* $Id: Konst.h,v 1.6 2003/06/03 23:04:39 sleeper Exp $                      */
/*										    */
/* Konst.h									    */
/*										    */
/* Various constants used throughout the drivers.				    */
/* I used "Konst" so I wouldn't conflict with standard "Const" named files.         */
/*										    */
/* This file is part of the "ADI USB ADSL Driver for Linux".			    */
/*										    */
/* "ADI USB ADSL Driver for Linux" is free software; you can redistribute it        */
/* and/or modify it under the terms of the GNU General Public License as            */
/* published by the Free Software Foundation; either version 2 of the License,      */
/* or (at your option) any later version.					    */
/*										    */
/* "ADI USB ADSL Driver for Linux" is distributed in the hope that it will be       */
/* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of	    */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the		    */
/* GNU General Public License for more details.					    */
/*										    */
/* You should have received a copy of the GNU General Public License		    */
/* along with "ADI USB ADSL Driver for Linux"; if not, write to the Free Software   */
/* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA	    */
/************************************************************************************/

#ifndef KONST_H
#define KONST_H

/*USB misc*/
#define kUSBATMControlModel     7
#define kADI_COMM_IF            1
#define kCDC_REQ_SEND_ENCAPSULATED_COMMAND 0

/*Firmware loading*/
#define kEZUSB_LOAD_INTERNAL 0xA0
#define k8051_USBCS          0x7f92
#define k8051RetryCount      3

/*Custom ADI vendor control commands*/
#define kADI_CMD_GET_BLOCK      0x00
#define kADI_CMD_SET_BLOCK      0x01
#define kADI_CMD_GET_STAT       0x02
#define kADI_CMD_SET_MODE       0x03
#define kADI_CMD_SET_2183_DATA  0x04
#define kADI_CMD_GET_2183_DATA  0x05
#define kADI_CMD_GET_STAT_VAR   0x06
#define kADI_CMD_GET_INTERRUPT  0x07
#define kADI_CMD_SET_FPGA_DATA  0x0E
#define kADI_CMD_SET_TIMEOUT    0x11

/*Modes for kADI_CMD_SET_MODE*/
#define kMODE_LOOPBACK_OFF      0x02
#define kMODE_LOOPBACK_ON       0x03
#define kMODE_BOOTMODE_IDMA     0x06
#define kMODE_START_RESET       0x07
#define kMODE_END_RESET         0x08

/*Mailbox addrs*/
#define kDSP_MP_TX_MAILBOX      0x3FD6
#define kDSP_MP_TX_START        0x3FCE
#define kDSP_MP_RX_MAILBOX      0x3FDF
#define kDSP_SWAP_MAILBOX       0x3FCD

/*Mailbox states*/
#define kMAILBOX_EMPTY          0
#define kMAILBOX_FULL           1

/*Maximums*/
#define kMAX_DSP_ALLOCS 128

/*Interrupts*/
#define kADI_INT_LOADSWAPPAGE   0x01
#define kADI_INT_INCOMINGCMV    0x02

/*Hardcoded endpoint addresses*/
#define kEP_BULK_IDMA_OUT       0x04
#define kEP_BULK_DATA_OUT       0x02
#define kEP_BULK_DATA_IN        0x82
#define kEP_ISOC_DATA_IN        0x88
#define kEP_INT_IN              0x84

/*Misc*/
#define kUSB_INTF_CTRL          0x00
#define kUSB_INTF_OUT           0x01
#define kUSB_INTF_IN            0x02
#define kFASTEST_ISO_INTF       0x08
#define kFASTEST_ISO_RATE       1007
#define kFRAMES_PER_ISO_URB     16
#define kCMV_DATA_WORDS 8
#define kTAB "   "
#define CRC_INITIAL_VALUE  0xFFFFFFFF
#define CRC_RESIDUE        0xC704DD7B
#define kMAC_ADDRESS_INDEX 4
#define kTRANSMIT_TIMEOUT (HZ*5) /* 5 seconds */

/*For msg processing ... from old MsgProtocol.h*/
#define kWRITE_DSP                                  0x04

#define END_ENCODE                                  0xFFFF
#define END_DECODE                                  0xFFFF

#define MSG_PREAMBLE                                0x535C

#define MP_STAGE_PREAMBLE                           0x0000
#define MP_STAGE_FUNCTION_TYPE                      0x0001
#define MP_STAGE_FUNCTION_SUBTYPE                   0x0002
#define MP_STAGE_FUNCTION_SENDERID                  0x0003
#define MP_STAGE_FUNCTION_RECEIVERID                0x0004
#define MP_STAGE_INDEX                              0x0005
#define MP_STAGE_SYMBOLIC_ADDR                      0x0006
#define MP_STAGE_OFFSET_ADDR                        0x0007
#define MP_STAGE_DATA                               0x0008

/*MP raw buffer offset definitions - zero based*/
#define MP_RAW_PREAMBLE                             0x0
#define MP_RAW_FUNCTION                             0x1
#define MP_RAW_INDEX                                0x2
#define MP_RAW_SYMB_ADDR_HIGH                       0x3
#define MP_RAW_SYMB_ADDR_LOW                        0x4
#define MP_RAW_OFFSET_ADDR                          0x5
#define MP_RAW_DATA_HIGH                            0x6
#define MP_RAW_DATA_LOW                             0x7

/*mp_msg_encode/decode function return values*/
#define MP_ENCODE_OK                                0x00000000
#define MP_ENCODE_ERROR                             0x00000001
#define MP_ENCODE_PREAMBLE_ERROR                    0x00000002
#define MP_ENCODE_TYPE_ERROR                        0x00000004
#define MP_ENCODE_SUBTYPE_ERROR                     0x00000008
#define MP_ENCODE_SENDERID_ERROR                    0x00000010
#define MP_ENCODE_RECEIVERID_ERROR                  0x00000020
#define MP_ENCODE_SYMB_ADDR                         0x00000040

#define MP_DECODE_OK                                0x00000000
#define MP_DECODE_ERROR                             0x00000001
#define MP_DECODE_PREAMBLE_ERROR                    0x00000002
#define MP_DECODE_TYPE_ERROR                        0x00000004
#define MP_DECODE_SUBTYPE_ERROR                     0x00000008
#define MP_DECODE_SENDERID_ERROR                    0x00000010
#define MP_DECODE_RECEIVERID_ERROR                  0x00000020
#define MP_DECODE_SYMB_ADDR                         0x00000040

/*MP command/response block bit definitions & masks*/

/*function field, type subfield*/

#define MP_FUNCTION_TYPE_WAITING_4_REPLY              0
#define MP_FUNCTION_TYPE_MEMACCESS                  0x1
#define MP_FUNCTION_TYPE_MSGDECERR                  0x2
#define MP_FUNCTION_TYPE_MSGACCERR                  0x3
#define MP_FUNCTION_TYPE_FLASHACC                   0x4
#define MP_FUNCTION_TYPE_FLASHACCERR                0x5
#define MP_FUNCTION_TYPE_MEDIRECTIVE                0x6
#define MP_FUNCTION_TYPE_ADSLDIRECTIVE              0x7

/*function field, subtype subfield*/

#define SUBTYPE_MEMACCESS_REQREAD                   0x0
#define SUBTYPE_MEMACCESS_REQWRITE                  0x1
#define SUBTYPE_MEMACCESS_REPLYREAD                 0x2
#define SUBTYPE_MEMACCESS_REPLYWRITE                0x3

#define SUBTYPE_MEMACCESSERROR_UNKNOWNADDR          0x1
#define SUBTYPE_MEMACCESSERROR_DATANOTRDY           0x2
#define SUBTYPE_MEMACCESSERROR_ILLEGALREAD          0x3
#define SUBTYPE_MEMACCESSERROR_ILLEGALWRITE         0x4
#define SUBTYPE_MEMACCESSERROR_DATANOTAVAIL         0x5

#define SUBTYPE_MSGDECERR_LENGTHERROR               0x1
#define SUBTYPE_MSGDECERR_PREAMBLEERROR             0x2
#define SUBTYPE_MSGDECERR_UNKNOWNTYPE               0x3
#define SUBTYPE_MSGDECERR_CRCERROR                  0x4

#define SUBTYPE_FLASHACC_ENKERNELREBOOTREQ          0x0
#define SUBTYPE_FLASHACC_ENMODEMREBOOTREQ           0x1
#define SUBTYPE_FLASHACC_DECOMPMODEMAPPLREQ         0x2
#define SUBTYPE_FLASHACC_STREAMEDDATAWRREQ          0x3
#define SUBTYPE_FLASHACC_STREAMEDDATAWRBLOCK        0x4
#define SUBTYPE_FLASHACC_READREQ                    0x5
#define SUBTYPE_FLASHACC_CALCMODEMCRCREQ            0x7
#define SUBTYPE_FLASHACC_ENKERNELREBOOTREPLY        0x8
#define SUBTYPE_FLASHACC_ENMODEMREBOOTREPLY         0x9
#define SUBTYPE_FLASHACC_DECOMPMODEMAPPLREPLY       0xa
#define SUBTYPE_FLASHACC_STREAMEDDATAWRREPLY        0xb
#define SUBTYPE_FLASHACC_STREAMEDDATAWRBLOCKREPLY   0xc
#define SUBTYPE_FLASHACC_READREPLY                  0xd
#define SUBTYPE_FLASHACC_CALCMODEMCRCREPLY          0xf

#define SUBTYPE_FLASHACCERR_READCOMPERR             0x0
#define SUBTYPE_FLASHACCERR_DECOMPRESSERR           0x1

#define SUBTYPE_MEDIRECTIVE_REBOOT                  0x0

#define SUBTYPE_ADSLDIRECTIVE_KERNELREADY           0x0
#define SUBTYPE_ADSLDIRECTIVE_MODEMREADY            0x1
#define SUBTYPE_ADSLDIRECTIVE_MODEMCRCERROR         0x2

/*function field, sender/receiver_id subfield*/

#define SUBTYPE_ID_ADSL                             0x0
#define SUBTYPE_ID_ME                               0x1

/*bit positions, masks and shift counts*/

#define MP_FUNCTION_TYPE_MASK                       0xf000
#define MP_FUNCTION_SUBTYPE_MASK                    0x0f00
#define MP_FUNCTION_SENDERID_MASK                   0x00f0
#define MP_FUNCTION_RECEIVER_MASK                   0x000f

#define MP_FUNCTION_TYPE_LSB                        0xc
#define MP_FUNCTION_SUBTYPE_LSB                     0x8
#define MP_FUNCTION_SENDERID_LSB                    0x4
#define MP_FUNCTION_RECEIVER_LSB                    0x0

#define NUM_CMVS                                    20

/*Transmit related*/
#define IDMA_MP_TX_START                            0x3FCE
#define IDMA_MP_TX_BUFFER_SIZE                      0x8
#define IDMA_MP_TX_MAILBOX                          0x3FD6

/*Receive related*/
#define IDMA_MP_RX_START                            0x3FD7
#define IDMA_MP_RX_BUFFER_SIZE                      0x8
#define IDMA_MP_RX_MAILBOX                          0x3FDF

/*Swap related*/
#define IDMA_SWAP_MAILBOX                           0x3FCD

/*************************************************************************/
/*  Times for transition from state to state - for watchdog timer (msec) */
/*************************************************************************/

#define TRANS_TIME_2_BEGINRESET         50  /* time to begin reset */
#define TRANS_TIME_4_RESETINIT        5000  /* time for BootMachine completion */
#define TRANS_TIME_4_BOOTWAIT         8000  /* time to wait for MODEM_READY */
#define TRANS_TIME_BOOTWAIT_2_UNTRAIN   10  /* pause before UNTRAIN starts */

#define TRANS_TIME_2_BOOT_STAGE_1      200  /* From beginning to Boot to Stage 1 */
#define TRANS_TIME_2_BOOT_STAGE_2      200  /* Stage 1 to Stage 2              */
#define TRANS_TIME_2_BOOT_STAGE_3     1000  /* Stage 2 to Stage 3              */

#define TRANS_TIME_4_UNTRAIN           200  /* time for UNTRAIN CMV completion */
#define TRANS_TIME_B4_UNTRAIN          400

#define TRANS_TIME_4_INITIALIZE      60000  /* time for STAT CMV completion */
#define TRANS_TIME_B4_INITIALIZE      5000  /* time to wait before INIT retry */

#define TRANS_TIME_4_ENAFAST            50  /* time for ENAFAST completion */
#define TRANS_TIME_B4_ENAFAST          500

#define TRANS_TIME_4_FASTRETRAIN      5000  /* time to wait for FASTRETRAIN */
#define TRANS_TIME_B4_FASTRETRAIN      500  /* pause before FASTRETRAIN starts */

#define TRANS_TIME_4_OPERATIONAL        50  /* time for oper CMV completion */
#define TRANS_TIME_B4_OPERATIONAL      100  /* time before sending out 1st CMV */

#define TRANS_TIME_4_OPSTAT             80  /* time for each next completion */
#define TRANS_TIME_B4_OPSTAT          2000  /* time to wait before 1st completes */

#define TRANS_TIME_5MSEC_PAUSE           5
#define TRANS_TIME_50MSEC_PAUSE         50

#define TRANS_TIME_HEARTBEAT          3000  /* timer heartbeat is 3 secs */

#define TRANS_TIME_AFTER_PAGE_SWAP     750  /* requested pause after time swap */

/******************************************************************/
/*  Events accepted by modem state machine - bitmask type         */
/******************************************************************/

#define EVENT_NONE              0
#define EVENT_TIMER_TICK        0x0001
#define EVENT_RX_SYNC           0x0002
#define EVENT_RX_SYNC_ERROR     0x0003
#define EVENT_RX_ASYNC          0x0004
#define EVENT_RX_ASYNC_ERROR    0x0005
#define EVENT_HARD_RESET        0x0008

#define EVENT_SOFT_RESET        0x000F

/********************************************************************/
/*  Modem state machine possible states for <DMT_***_state> members */
/********************************************************************/

#define STATE_UNDEFINED             0x0000
#define STATE_BOOT_STAGE_1          0x0001
#define STATE_BOOT_STAGE_2          0x0002
#define STATE_BOOT_STAGE_3          0x0003
#define STATE_STALLED_FOREVER       0xFFFF

/* ---- Startup/Reboot related states ----*/

#define STATE_HARD_RESET_INITIATE   0x8000 /* reset modem */
#define STATE_HARD_RESET_END        0x8001
#define STATE_BOOT_WAIT             0x8002
#define STATE_JUST_PLUGGED_IN       0x8003

#define STATE_KERNEL                0x4000 /* user controls the CMVs */
#define STATE_KERNEL_TX             0x4001
#define STATE_KERNEL_RX             0x4002

#define STATE_UNTRAIN               0x2000 /* sends CMVs to train */
#define STATE_UNTRAIN_TX            0x2001
#define STATE_UNTRAIN_RX            0x2002

#define STATE_TEST                  0x1000 /* send out test tones */
#define STATE_TEST_TX               0x1001
#define STATE_TEST_RX               0x1002

/* ---- User interface related states ----*/

#define STATE_USER_CONTROL          0x0800 /* user controls all */
#define STATE_USER_CONTROL_TX       0x0801
#define STATE_USER_CONTROL_RX       0x0802

/* #define   STATE_IDMABOOT              0x0400 */

#define STATE_EN_FASTTRAIN          0x0100 /* send fast retrain enable */
#define STATE_EN_FASTTRAIN_TX       0x0101
#define STATE_EN_FASTTRAIN_RX       0x0102

/* ---- Functional states ----*/

#define STATE_INITIALIZING          0x0080 /* read STAT CMV to find out if we are trained or not */
#define STATE_INITIALIZING_TX       0x0081
#define STATE_INITIALIZING_RX       0x0082

#define STATE_OPERATIONAL           0x0040 /* read STAT, DIAG, ...etc to see if we stay in sync or not */
#define STATE_OPERATIONAL_TX        0x0041
#define STATE_OPERATIONAL_RX        0x0042

#define STATE_FAST_RETRAIN          0x0020 /* read STAT only */
#define STATE_FAST_RETRAIN_TX       0x0021
#define STATE_FAST_RETRAIN_RX       0x0022


/*******************************************************/
/*  Definitions used in the embedded modules           */
/*******************************************************/

#define RETRY_LIMIT             10

#define MAX_IDLE_COUNT          100
#define RETRAIN_ATTEMPTS        160

#define DMT_SM_USER_CMV         0x00000001
#define DMT_SM_USER_RESET       0x00000002
#define DMT_SM_USER_CONTROL     0x00000004
#define DMT_SM_EN_FASTTRAIN     0x02800000

/********************************************************/
/* Statistics counters				        */
/********************************************************/

/* Received ATM Cells */
#define STAT_CELLS_RX               0x0000
/* Transmited ATM Cells */
#define STAT_CELLS_TX               0x0001

/* Number of cells drop because of CRC error */
#define STAT_CELLS_LOST_CRC         0x0002
/* Stats Lost because of invalid VPI/VCI */
#define STAT_CELLS_LOST_VPIVCI      0x0003
/* Number of cells lost because reassembly buffer is to short */
#define STAT_CELLS_LOST_OTHER       0x0004

/* Received Ethernet/IP Packets */
#define STAT_PAKTS_RX               0x0005
/* Transmited Ethernet/IP Packets */
#define STAT_PAKTS_TX               0x0006
/* Packets lost because over-sized */
#define STAT_PAKTS_LOST_OSIZE       0x0007
/* Nb Packets droped after filter */
#define STAT_PAKTS_FILTERED         0x0008

#define STAT_ATMVCI                 0x0009
#define STAT_ATMVPI                 0x000A
#define STAT_ATMHEC                 0x000B
#define STAT_ATMDELIN               0x000C

#define STAT_DSLMARGIN              0x000D
#define STAT_DSLATTEN               0x000E
#define STAT_DSLFEC                 0x000F
#define STAT_DSLVIDCPE              0x0010
#define STAT_DSLVIDCO               0x0011
#define STAT_DSLTXRATE              0x0012
#define STAT_DSLRXRATE              0x0013
/* Number of OAM cells received */
#define STAT_CELLS_OAM_RCVD	    0x0014

#define STAT_COUNT                  0x0015

/* For processing network data*/
#define MPOA_LLC_ENCAP_BRIDGED_ETH_SIZE     10
#define MPOA_LLC_ENCAP_ROUTED_IP_SIZE        8
#define MPOA_VC_ENCAP_BRIDGED_ETH_SIZE       2
#define MPOA_MAX_ENCAP_SIZE                 10
#define ETH_LENGTH_OF_ADDRESS 6

/**************************************************/
/*Added on April30,2002 by Anoosh to support PPPoA*/
#define MPOA_LLC_ENCAP_PPPOA_SIZE            4
/**************************************************/

#define ATM_CELL_SIZE                       53
#define ATM_CELL_PAYLOAD_SIZE               48
#define ATM_CELL_HEADER_SIZE                5
#define ATM_CELL_HEADER_PT_OFFSET           3
#define ATM_CELL_HEADER_CLP_OFFSET          3
#define ATM_CELL_REMOVE_GFC_MASK         	0x00FFFFFF

#define ATM_PT_AAL_INDICATE                 2
#define ATM_CLP_SET                         1

#define ATM_AAL5_TRAILER_SIZE               8
#define ATM_AAL5_TRAILER_CPCS_UU_OFFSET     0
#define ATM_AAL5_TRAILER_CPI_OFFSET         1
#define ATM_AAL5_TRAILER_PDU_LENGTH_OFFSET  2
#define ATM_AAL5_TRAILER_CRC_OFFSET         4
#define ATM_AAL5_CRC_SIZE                   4

/* Encapsulation modes */
#define MPOA_MODE_BRIDGED_ETH_LLC   1
#define MPOA_MODE_BRIDGED_ETH_VC    2
#define MPOA_MODE_ROUTED_IP_LLC     3
#define MPOA_MODE_ROUTED_IP_VC      4
/**************************************************/
/* Note, if more MPOA_MODE values are added, they */
/* should be added before the PPPoX modes, and    */
/* MPOA_MODE_PPPOX_START and MPOA_MODE_PPPO*      */
/* should be modified appropriately. Note, the    */
/*Added on April30,2002 by Anoosh to support PPPoA*/
#define MPOA_MODE_PPPOA_LLC         5
#define MPOA_MODE_PPPOA_VC          6
/**************************************************/

/*Default driver options*/
#define DEFAULT_OPTN0    0x80020066
#define DEFAULT_OPTN2    0x23700000
#define DEFAULT_OPTN3    0x00000000
#define DEFAULT_OPTN4    0x00000000
#define DEFAULT_OPTN5    0x00000000
#define DEFAULT_OPTN6    0x00000000
#define DEFAULT_OPTN7    0x02CD8044
#define DEFAULT_OPTN15   0x00000000
#define DEFAULT_VPI      0x00000008
#define DEFAULT_VCI      0x00000023
#define DEFAULT_ENCAPS   MPOA_MODE_PPPOA_VC
#define DEFAULT_LINETYPE 0x00000001
#define DEFAULT_POLLFREQ 0x0000000A


#endif /* KONST_H */

/***************************************************************************
$Log: Konst.h,v $
Revision 1.6  2003/06/03 23:04:39  sleeper
Changed default value

Revision 1.5  2003/04/23 22:24:13  sleeper
comments beautification

Revision 1.4  2003/03/31 22:01:55  sleeper
Sagem 2.0.1 merge

Revision 1.3  2003/03/11 00:38:03  sleeper
Add OAM modifs as present in Sagemn 2.0.1 driver

Revision 1.2  2003/02/24 23:41:33  sleeper
Remove nasty mdelays

Revision 1.1.1.1  2003/02/10 23:29:49  sleeper
Imported sources

Revision 2.00  2002/05/24 17:56:45  Anoosh Naderi
Added support for PPPoA (LLC & VC)
Clean up the code. 

Revision 1.12  2002/03/12 17:56:45  chris.edgington
Added ISO support for incoming data.

Revision 1.11  2002/01/18 18:02:49  chris.edgington
Moved enums for Options data into here.

Revision 1.10  2002/01/17 20:19:06  chris.edgington
Added filename of config file.

Revision 1.9  2002/01/14 21:59:33  chris.edgington
Added GPL header.

Revision 1.8  2002/01/09 20:18:25  chris.edgington
Added kTRANSMIT_TIMEOUT for transmit timeout support.

Revision 1.7  2002/01/08 20:08:33  chris.edgington
Added define for kMAC_ADDRESS_INDEX - string index of MAC address in descriptor.

Revision 1.6  2002/01/02 22:07:48  chris.edgington
Added constants from User.h, Crc.h, and Atm.h from MacOS9 project.

Revision 1.5  2001/12/28 19:35:20  chris.edgington
Added TRANS_TIME_50MSEC_PAUSE.

Revision 1.4  2001/12/22 21:32:31  chris.edgington
Added defines for Msg, Me, and Sm modules.

Revision 1.3  2001/12/21 23:48:39  chris.edgington
Added constants required for interrupts and endpoint addresses.

Revision 1.2  2001/12/17 22:16:22  chris.edgington
Added kADI_COMM_IF - comm interface number.

Revision 1.1.1.1  2001/12/14 21:27:19  chris.edgington
Initial import
**********************************************************************************/
