/*************************************************************************************/
/* $Id: Macros.h,v 1.2 2003/04/23 22:25:49 sleeper Exp $                      */
/*										     */
/* Macros.h									     */
/*										     */
/* Various macros used throughout the code					     */
/*										     */
/* This file is part of the "ADI USB ADSL Driver for Linux".			     */
/*										     */
/* "ADI USB ADSL Driver for Linux" is free software; you can redistribute it         */
/* and/or modify it under the terms of the GNU General Public License as             */
/* published by the Free Software Foundation; either version 2 of the License,       */
/* or (at your option) any later version.					     */
/*										     */
/* "ADI USB ADSL Driver for Linux" is distributed in the hope that it will be        */
/* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of	     */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the		     */
/* GNU General Public License for more details.					     */
/*										     */
/* You should have received a copy of the GNU General Public License		     */
/* along with "ADI USB ADSL Driver for Linux"; if not, write to the Free Software    */
/* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA	     */
/*************************************************************************************/

#ifndef MACROS_H
#define MACROS_H

/*Compatibility macros (USB changed in kernel 2.4.20)*/
#if LINUX_VERSION_CODE > KERNEL_VERSION(2,4,19)

typedef struct usb_ctrlrequest devrequest;
#define FILL_USB_CTRL_REQUEST(p, t, r, v, i, l)         \
	{                                               \
            p->bRequestType = t;                        \
            p->bRequest     = r;                        \
            p->wValue       = cpu_to_le16 ((UInt16) v); \
            p->wIndex       = cpu_to_le16 ((UInt16) i); \
            p->wLength      = cpu_to_le16 ((UInt16) l); \
	}

#else
#define FILL_USB_CTRL_REQUEST(p, t, r, v, i, l)         \
	{                                               \
            p->requesttype = t;                         \
            p->request     = r;                         \
            p->value       = cpu_to_le16 ((UInt16)v);   \
            p->index       = cpu_to_le16 ((UInt16)i);   \
            p->length      = cpu_to_le16 ((UInt16)l);   \
	}

#endif

#define GET_KBUFFER(_memsize_) kmalloc((_memsize_), in_interrupt() ? GFP_ATOMIC : GFP_KERNEL)
#define FREE_KBUFFER(_ptr_) \
    if (_ptr_) \
    { \
        kfree(_ptr_); \
        (_ptr_) = NULL; \
    }

#define GET_VBUFFER(_memsize_) vmalloc(_memsize_)
#define FREE_VBUFFER(_ptr_) \
    if (_ptr_) \
    { \
        vfree(_ptr_); \
        (_ptr_) = NULL; \
    }

/*quasi-function to obtain current status of SM*/
#define GetOpStatusSM(_ADAPTER_) ((_ADAPTER_->CurrentAdiState&STATE_OPERATIONAL)!=0)

/*Macro for cancelling the StateMachine timer*/
#define CancelTimerSM(_ADAPTER_) SetTimerInterval(_ADAPTER_,0)

/*quasi-function to signal beginning of SM reset*/
/*actual processing would happen later, on next refresh*/
#define ResetModemSM(_ADAPTER_) if(_ADAPTER_->CurrentAdiState!=STATE_STALLED_FOREVER) \
                                { (_ADAPTER_->CurrentAdiState=STATE_HARD_RESET_INITIATE); }

#define MSEC_TO_JIFFIES(_msec_) ((HZ*_msec_)/1000)

#endif /*MACROS_H*/

/********************************************************************
$Log: Macros.h,v $
Revision 1.2  2003/04/23 22:25:49  sleeper
PPC support

Revision 1.1.1.1  2003/02/10 23:29:49  sleeper
Imported sources

Revision 1.60  2002/05/24 21:59:33  Anoosh Naderi
Clean up the code

Revision 1.5  2002/01/14 21:59:33  chris.edgington
Added GPL header.

Revision 1.4  2002/01/02 22:13:55  chris.edgington
Added additional endian-conversion macros.
Added memory operation macros.
Added min/max macros.

Revision 1.3  2001/12/26 22:48:02  chris.edgington
Added kernel timer support.

Revision 1.2  2001/12/22 21:33:15  chris.edgington
Added state machine macros.

Revision 1.1.1.1  2001/12/14 21:27:19  chris.edgington
Initial import
**************************************************************/
