/*************************************************************************************/
/*										     */
/* Sar.h									     */
/*										     */
/* Helper functions for AAL5 segmentation and reassembly.		     	     */
/*										     */
/* This file is part of the "ADI USB ADSL Driver for Linux".			     */
/*										     */
/* "ADI USB ADSL Driver for Linux" is free software; you can redistribute it 	     */
/* and/or modify it under the terms of the GNU General Public License as 	     */
/* published by the Free Software Foundation; either version 2 of the License,       */
/* or (at your option) any later version.					     */
/*										     */
/* "ADI USB ADSL Driver for Linux" is distributed in the hope that it will be 	     */
/* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of	     */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the		     */
/* GNU General Public License for more details.					     */
/*										     */
/* You should have received a copy of the GNU General Public License		     */
/* along with "ADI USB ADSL Driver for Linux"; if not, write to the Free Software    */
/* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA	     */
/*************************************************************************************/

#ifndef __ADISAR_H__
#define __ADISAR_H__

extern void Aal5InitSegmenter(SarSegmenter *pSar, UInt32 PduLength, UInt8 *pOutputBuffer, UInt8 *pCellHeader);
extern void Aal5Segment(SarSegmenter *pSar, UInt8 *pInputBuffer, UInt32 InputLength);
extern void Aal5InitReassembler(SarReassembler *pSar, ETHERNET_PACKET_BUFFER *pBuf);
extern UInt16 Aal5WritePadAndTrailer(SarSegmenter *pSar, UInt8 CpcsUu, UInt8 Cpi);
extern void Aal5ReassembleNonFinalCell(SarReassembler *pSar, UInt8 *pCellPayload);
extern void Aal5ReassembleFinalCell(SarReassembler *pSar, UInt8 *pCellPayload);

#endif
