/***********************************************************************************/
/* $Id: Structs.h,v 1.3 2003/06/03 23:05:35 sleeper Exp $ 		   */
/*										   */
/* Copyright (c) 2001, Analog Devices Inc., All Rights Reserved			   */
/*										   */
/* Structs.h									   */
/*										   */
/* Miscellaneous structures needed throughout the driver.			   */
/*										   */
/* This file is part of the "ADI USB ADSL Driver for Linux".			   */
/*										   */
/* "ADI USB ADSL Driver for Linux" is free software; you can redistribute it 	   */
/* and/or modify it under the terms of the GNU General Public License as 	   */
/* published by the Free Software Foundation; either version 2 of the License,     */
/* or (at your option) any later version.					   */
/*										   */
/* "ADI USB ADSL Driver for Linux" is distributed in the hope that it will be 	   */
/* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of	   */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the		   */
/* GNU General Public License for more details.					   */
/*										   */
/* You should have received a copy of the GNU General Public License		   */
/* along with "ADI USB ADSL Driver for Linux"; if not, write to the Free Software  */
/* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA	   */
/***********************************************************************************/

#ifndef STRUCTS_H
#define STRUCTS_H

#include "AdiUsbAdslDriver.h"

/* Represents a block of IDMA memory, either Program or Data Memory (PM or DM)*/
typedef struct
{
    UInt8  *MemOffset;
    UInt32  DSPAddr;
    UInt32  DSPSize;
    UInt32  DSPExtendedSize;
} IDMABlock;

/* Represents a page of IDMA memory, either a Main page or a Swap page*/
typedef struct
{
    UInt32  BlockCount;
    UInt32  PageOffset;
    IDMABlock *Blocks;
} IDMAPage;

/* Structure required by the IDMA boot engine to load pages*/
typedef struct
{
    UInt16  ADIHeader;
    UInt16  Addr;
    UInt16  Size;
    UInt16  OvlOffset;
    UInt16  Ovl;
    UInt16  LastBlock;
} IDMALoadBlockInfo;

/* Comm Device Class Notification Buffer structure			        */
/* Note that ADI passes some data through here, so the struct has been expanded!*/
typedef struct
{
    UInt8   bmRequestType;
    UInt8   bNotification;
    UInt16  wValue;
    UInt16  wIndex;
    UInt16  wLength;
    UInt8   Data[20]; /* normal CDC_NOTIFICATION has Data[1]*/
} CDC_NOTIFY;

/* Structs used for interrupt processing*/
typedef struct
{
    UInt16 SwapData;
} INT_IDMA_SWAP_INFO;

typedef struct
{
    UInt16  CmvData[kCMV_DATA_WORDS];
} INT_IDMA_CMV_INFO;

typedef struct
{
    UInt16 Interrupt;
    union
    {
        INT_IDMA_SWAP_INFO SwapIntInfo;
        INT_IDMA_CMV_INFO  CmvIntInfo;
    } IntInfo ;
		/* pierre */
    UInt16 DataSize;
} DeviceInt;

/* For msg handling*/
typedef struct 
{

    /* Message function field*/
    UInt32 preamble;
    UInt32 type;
    UInt32 sub_type;
    UInt32 sender_id;
    UInt32 receiver_id;
    
    /* Message index Field*/
    UInt32 index;
    
    /* Message symbolic address and offset fields*/
    union
    {
        UInt8  symb_addr[4];
        UInt32 fourcc;
    } MsaOf;
		/* pierre */
    UInt32 offset_addr;
    
    /* Message data field*/
    UInt32 data;

}  mp_message;

#define MAX_CMV_MESSAGES    20
#define CMV_DATA_WORDS      8

typedef struct
{
    UInt16 Preamble;
    UInt16 Function;
    UInt16 Index;
    UInt8  SymAddrHiHi;
    UInt8  SymAddrHiLo;
    UInt8  SymAddrLoHi;
    UInt8  SymAddrLoLo;
    UInt16 Offset;
    UInt32 Data;
} CmvMsg;

typedef struct
{
    union
    {
        CmvMsg *Msgs[ MAX_CMV_MESSAGES ];
        UInt16 *RawCmd[ MAX_CMV_MESSAGES ];
    } MsgMax;
    UInt32 MsgCount;
} MsgSequence;


/*  State machine control structure*/
typedef struct
{
    /* state machine flags and options*/
    UInt32   ADPT0;
    UInt32   ADPT1;
    UInt32   ADPT2;
    UInt32   INFO9;
    UInt32   CNTL0;
    UInt32   OPTN0;
    UInt32   OPTN2;
    UInt32   OPTN4;
    UInt32   OPTN7;
    UInt32   OPTN3;
    UInt32   OPTN5;
    UInt32   OPTN6;
    UInt32   OPTN15;
    UInt32   PFCL1;
    UInt32   MASK8;
    UInt32   MASK9;
             
    UInt32   INFO8;
    UInt32   PSDM0;
    UInt32   UNH;
    UInt32   ISDN;
    UInt32   FLAG0;
    
    /* OPERATIONAL values*/
    UInt32   sw_status;
    UInt32   crc_status;
    UInt32   flags;

    /* statistics*/
    UInt32   stats_ES_count;
    UInt32   stats_Cur_Atten;
    UInt32   stats_Cur_SNR;
    UInt32   stats_Rx_Blks;
    UInt32   stats_Tx_Blks;
    UInt32   stats_Corr_Blks;
    UInt32   stats_Uncorr_Blks;

    UInt32   stats_Rx_Blks_Delta;
    UInt32   stats_Corr_Blks_Delta;
    UInt32   stats_Uncorr_Blks_Delta;

    /* transfer rate*/
    UInt32   XferRate0;
    UInt32   DownRate;
    UInt32   UpRate;
    UInt32   FwRxTimeout;

    /* miscell*/
    UInt32   DIAG03;
    UInt32   DIAG47;
    UInt32   DIAG49;
    UInt32   INFO10;
    UInt32   PSDM01;
    UInt32   INFO08;
    UInt32   INFO14;

    /* following counters work in single digits before reset is tridgerred*/
    UInt8    LOS_count;
    UInt8    CRC_count;

    UInt8    Block_CRC90;
    UInt8    Block_CRC97;

    Boolean  stats_Ne_Fast_Lod_Failure;
    Boolean  stats_Ne_Fast_Hec_Failure;

    /* -------- status variables ------------------------*/
    UInt8    LineType;

    UInt16   ModemReplyExpected;
    UInt16   CurrentAdiState;
    UInt16   PrevAdiState;

    UInt16   MsgStage;
    UInt16   ReTrain;
    UInt16   RetryCount;

    UInt32   HeartbeatCounter;

    /* pre-composed messages used for fast retrain sequence*/
    MsgSequence MsgSeq_Retrainer;
    MsgSequence MsgSeq_SoftReset;
    MsgSequence MsgSeq_OpStat;
    MsgSequence MsgSeq_Stat;
    MsgSequence MsgSeq_ModemEna;
    MsgSequence MsgSeq_EnaFR;

    struct timer_list timerSM;

    /* flags and handles*/
    UInt32   CurrentExpirationTime;
    UInt32   SwapPageRequiredTime;

    Boolean  OutboundPending;
    Boolean  InboundAsyncPending;
    Boolean  InboundSyncPending;

    Boolean  watchBadBlocks;
}  AdiMSM;    

typedef struct LLC_HEADER 
{
    UInt8 Llc[3];
    UInt8 Oui[3];
    UInt8 Pid[2];
    UInt8 Pad[2];
} LLC_HEADER;

typedef struct ETHERNET_MAC_HEADER
{
    UInt8  DstAddress[ETH_LENGTH_OF_ADDRESS];
    UInt8  SrcAddress[ETH_LENGTH_OF_ADDRESS];
    UInt16 EtherType;
} ETHERNET_MAC_HEADER;

//================ ROUTED MODE CODE START ================================
// FFD120402 Routed Mode

#define ETHERTYPE_IP    0x0008
#define ETHERTYPE_ARP   0x0608
#define MAC_SIZE    6
#define IP_SIZE     4

#define ETHERNET_HEADER_SIZE        14
#define ETHERNET_MAX_PACKET_SIZE    1500
#define ETHERNET_MIN_PACKET_SIZE    64
#define ETHERNET_LAN_FCS_SIZE       4

#define ARP_OP_REQUEST  0x0100 // ffd change dec 04
#define ARP_OP_REPLY    0x0200 // ffd change dec 04


// Field names taken from RFC826
typedef struct ARP_PACKET
{
    UInt16  Hrd;
    UInt16  Pro;
    UInt8   Hln;
    UInt8   Pln;
    UInt16  Op;
    UInt8   Sha[MAC_SIZE];
    UInt8   Spa[IP_SIZE];
    UInt8   Tha[MAC_SIZE];
    UInt8   Tpa[IP_SIZE];
} ARP_PACKET;
//=============== ROUTED MODE CODE END ===================================

typedef struct SarSegmenter
{
    UInt8   *pOutputBuffer;
    UInt8   *pCellHeader;
    UInt32  RawPduLength;
    UInt32  PaddingLength;
    UInt32  BytesLeftInCurrentCell;
    UInt32  CellCount;
    UInt32  RunningCRC;
} SarSegmenter;

typedef struct SarReassembler
{
    ETHERNET_PACKET_BUFFER *pQueueEntry;
    UInt8   *pReassemblyBuffer;
    UInt32  ReassemblyBufferSize;
    UInt32  BytesLeftInReassembly;
    UInt32  PduLengthFromTrailer;
    UInt32  RunningCRC;
    UInt32  CellCount;
} SarReassembler;

typedef struct Aal5Trailer
{
    UInt8   CpcsUu;
    UInt8   Cpi;
    UInt16  PduLength;
    UInt32  Crc;
} Aal5Trailer;

typedef struct ATMVC
{
    SarReassembler Reassembler;
    UInt32  EncapSize;
    UInt32  Vpi;
    UInt32  Vci;
    UInt32  VpiVci;
    UInt32  MaxSduSize;
    UInt8  *pEncapHdr;
    Boolean ReassemblyInProgress;
    UInt8   CellHeader[ATM_CELL_HEADER_SIZE];
    UInt8   CpcsUu;
    UInt8   Cpi;
} ATMVC;

#endif /* STRUCTS_H*/

/*******************************************************************************************
$Log: Structs.h,v $
Revision 1.3  2003/06/03 23:05:35  sleeper
Changed LineType type

Revision 1.2  2003/03/20 22:07:55  sleeper
Merge routed mode modfis + info statements added

Revision 1.1.1.1  2003/02/10 23:29:49  sleeper
Imported sources

Revision 1.80  2002/05/27 18:04:06  Anoosh Naderi
Clean up the code

Revision 1.7  2002/01/18 18:04:06  chris.edgington
Moved DriverOption struct into here.

Revision 1.6  2002/01/14 21:59:34  chris.edgington
Added GPL header.

Revision 1.5  2002/01/02 22:11:58  chris.edgington
Added structs for Atm and Sar code.

Revision 1.4  2001/12/26 22:53:45  chris.edgington
Added kernel timer support in state machine struct.

Revision 1.3  2001/12/22 21:34:53  chris.edgington
Added structs for Msg and Sm modules.

Revision 1.2  2001/12/21 23:46:43  chris.edgington
Added CDC_NOTIFY, INT_IDMA_SWAP_INFO, INT_IDMA_CMV_INFO, and DeviceInt - all
structs required for dealing with USB interrupts.

Revision 1.1.1.1  2001/12/14 21:27:20  chris.edgington
Initial import
************************************************************************************************/
