/**************************************************************************************/
/* $Id: Zaps.h,v 1.2 2003/03/21 00:22:41 sleeper Exp $ 			      */
/*										      */
/* Zaps.h									      */
/*										      */
/* ZAP* macro definitions (similar to DBGPRINT macros from NDIS code)		      */
/*										      */
/* This file is part of the "ADI USB ADSL Driver for Linux".			      */
/*										      */
/* "ADI USB ADSL Driver for Linux" is free software; you can redistribute it 	      */
/* and/or modify it under the terms of the GNU General Public License as 	      */
/* published by the Free Software Foundation; either version 2 of the License, 	      */
/* or (at your option) any later version.					      */
/*										      */
/* "ADI USB ADSL Driver for Linux" is distributed in the hope that it will be 	      */
/* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of	      */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the		      */
/* GNU General Public License for more details.					      */
/*										      */
/* You should have received a copy of the GNU General Public License		      */
/* along with "ADI USB ADSL Driver for Linux"; if not, write to the Free Software     */
/* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA	      */
/**************************************************************************************/

#ifndef ZAPS_H
#define ZAPS_H

/**************************************************************************************/
/* Zappable modules and levels							      */
/**************************************************************************************/

#define DEBUG_SAR       0x00000001
#define DEBUG_UNI       0x00000002
#define DEBUG_MPOA      0x00000004
#define DEBUG_INIT      0x00000008
#define DEBUG_FIRMWARE  0x00000010
#define DEBUG_PIPES     0x00000020
#define DEBUG_IDMA      0x00000040
#define DEBUG_ENET      0x00000080
#define DEBUG_BOOT      0x00000100
#define DEBUG_UTILS     0x00000200
#define DEBUG_MSG       0x00000400
#define DEBUG_SM        0x00000800
#define DEBUG_READ      0x00001000
#define DEBUG_WRITE     0x00002000
#define DEBUG_INTS      0x00004000
#define DEBUG_CRC       0x00008000
#define DEBUG_POWER     0x00010000
#define DEBUG_CONFIG    0x00020000
/* modules added for OSX*/
#define DEBUG_MISC      0x00040000
#define DEBUG_START     0x00080000
#define DEBUG_DSP       0x00100000
/* modules added for Linux*/
#define DEBUG_MEMORY    0x00200000
#define DEBUG_URB       0x00400000

#define DEBUG_IOCTL     0x00800000 // ROUTED
#define DEBUG_OAM	0x01000000 // OAM
#define DEBUG_ROUTEIP	0x02000000 // ROUTED
#define DEBUG_FFD	0x04000000 // ROUTED

#define DEBUG_ENTRY     0x00000001
#define DEBUG_EXIT      0x00000002
#define DEBUG_MEMCOPY   0x00000004
#define DEBUG_ATTN      0x00000008
#define DEBUG_ERROR     0x00000010
#define DEBUG_ERRORS    0x00000010
#define DEBUG_INFO      0x00000020
#define DEBUG_DATA      0x00000040

#define DEBUG_ALL       0xFFFFFFFF
#define DEBUG_NONE      0x00000000

extern Boolean DoZap(UInt32 myModule, UInt32 myLevel);

#ifdef ZAPS /* make sure ZAPS is defined to include ZAP output  */
            /* (eventually these will call routines in a Zaps.c)*/

#define ZAPIF( _Condition,  _Module, _Level, _Msg ) \
    if ((_Condition) && DoZap((_Module),(_Level))) \
        printk _Msg;

#define ZAP(                _Module, _Level, _Msg ) \
    if (DoZap((_Module),(_Level))) \
        printk _Msg;

#define Zap(                                 _Msg ) \
        printk _Msg;

#ifdef DANGER
/* special tool to trap early execution*/
#define TIME_TRAP(_delay_) { \
    Duration chk = (_delay_); \
    Duration dur = InitTime(); \
    if( dur < chk ) Debugger(); \
    Zap(("\n #### Trap @%i passed; time is %i\n\n",chk,dur)); \
}
#endif

#else  /* no debug trace facilities*/
#define ZAPIF( _Condition,  _Module, _Level, _Msg )
#define ZAP(                _Module, _Level, _Msg )
#define Zap(                                 _Msg )
#define TIME_TRAP(_delay_)
#endif /* ZAPS*/

#endif /* ZAPS_H*/

/*************************************************************************************
$Log: Zaps.h,v $
Revision 1.2  2003/03/21 00:22:41  sleeper
Msg Initialization modifs from 2.0.1

Revision 1.1.1.1  2003/02/10 23:29:49  sleeper
Imported sources

Revision 1.60  2002/05/27 21:23:01  Anoosh Naderi
Clean up the code

Revision 1.5  2002/01/17 21:23:01  chris.edgington
Moved DoZap prototype to Protos.h.

Revision 1.4  2002/01/14 21:59:34  chris.edgington
Added GPL header.

Revision 1.3  2001/12/21 23:45:11  chris.edgington
Added DEBUG_URB as a valid module.

Revision 1.2  2001/12/20 22:33:41  chris.edgington
Added DEBUG_MEMORY as a valid module.

Revision 1.1.1.1  2001/12/14 21:27:20  chris.edgington
Initial import


---------------------------------------------------------------------------
 Log entries from MacOS9 project
---------------------------------------------------------------------------

Revision 1.20  2001/11/13 19:39:19  ilko.dossev
TIME_TRAP debugging macro moved here from <ModemSM.C>.

Revision 1.19  2001/10/24 21:57:13  martyn.deobald
Added DEBUG_CONFIG support to ZAPS

Revision 1.18  2001/10/18 22:42:03  martyn.deobald
Added DEBUG_POWER define for us in ZAPS

Revision 1.17  2001/10/17 22:26:06  chris.edgington
Removed define of ZAPS - this is now done in the debug versions of the Prefix include files.

Revision 1.16  2001/10/12 17:58:19  ilko.dossev
Added <Zap> macro, for absolutely important traces, idependent from flags.

Revision 1.15  2001/10/05 16:10:33  chris.edgington
Added DEBUG_CRC as a valid module.
Added DEBUG_DATA as a valid debug level.

Revision 1.14  2001/10/04 15:55:09  chris.edgington
Added functions for getting and setting the ZAP levels.
Added DEBUG_INTS and DEBUG_ENET as valid modules.

Revision 1.13  2001/10/01 18:44:56  chris.edgington
Added DEBUG_READ and DEBUG_WRITE as valid modules.

Revision 1.12  2001/09/26 23:00:00  ilko.dossev
fixed identical definitions for three module-DEBUG flags (cut-n-paste carelesness)

Revision 1.11  2001/09/26 22:27:16  ilko.dossev
Added DEBUG_zz definitions for MsgProtocol and StateMachine

Revision 1.10  2001/09/26 17:36:50  chris.edgington
Added DEBUG_UTILS as a valid module.

Revision 1.9  2001/09/26 15:42:19  chris.edgington
Added DEBUG_BOOT as a valid module.

Revision 1.8  2001/09/25 22:37:18  chris.edgington
Added DEBUG_STATE as a valid module.

Revision 1.7  2001/09/24 22:29:44  chris.edgington
Added ZAPERR_RETURN_ON_NULL macro.

Revision 1.6  2001/09/24 21:28:21  chris.edgington
Added DEBUG_IDMA as a valid module.

Revision 1.5  2001/09/23 21:55:57  chris.edgington
Added some documentation on how to use Zaps facility. 
Made DoZaps check proper masks for determining whether or not to output the debug string.

Revision 1.4  2001/09/21 21:01:27  chris.edgington
Added DEBUG_PIPES module option.

Revision 1.3  2001/09/20 21:13:42  chris.edgington
Added DCON support.

Revision 1.2  2001/08/30 22:35:27  chris.edgington
Added DEBUG_SAR and various debug level defines.

Revision 1.1  2001/08/30 20:27:38  chris.edgington
Initial version with macro placeholders.
************************************************************************************************/
