/* about.c - 2000/05/05 */
/*
 *  EasyTAG - Tag editor for MP3 and Ogg Vorbis files
 *  Copyright (C) 2000-2003  Jerome Couderc <j.couderc@ifrance.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include <stdio.h>
#include <string.h>
#include <id3.h>
#include <errno.h>

#include "about.h"
#include "easytag.h"
#include "misc.h"
#include "msgbox.h"
#include "i18n.h"

#ifndef PACKAGE_DATA_DIR
#    include "../pixmaps/EasyTAG_logo.xpm"
#endif


/****************
 * Declarations *
 ****************/
static GtkWidget *AboutWindow = NULL;


/**************
 * Prototypes *
 **************/
void About_Window_Key_Press (GtkWidget *window, GdkEvent *event);
void Quit_About_Window (void);
void About_Window_Go_To_Home_Page (void);



/*************
 * Functions *
 *************/
/*
 * Close the window when the 'escape' key is pressed.
 */
void About_Window_Key_Press (GtkWidget *window ATTRIBUTE_UNUSED, GdkEvent *event)
{
    GdkEventKey *kevent;

    if (event && event->type == GDK_KEY_PRESS)
    {
        kevent = (GdkEventKey *)event;
        switch(kevent->keyval)
        {
            case GDK_Escape:    
                Quit_About_Window();
                break;
        }
    }
}


void Quit_About_Window (void)
{
    if (AboutWindow)
    {
        gtk_widget_destroy(AboutWindow);
        AboutWindow = (GtkWidget *)NULL;
        /*gtk_widget_set_sensitive(MainWindow,TRUE);*/
    }
}

void Show_About_Window (void)
{
    GtkWidget *AboutNoteBook;
    GtkWidget *Label;
    GtkWidget *Frame;
    GtkWidget *VBox, *hbox;
    GtkWidget *ScrollWindow;
    GtkWidget *Text;
    GtkWidget *Button;
    GtkWidget *Logo;
    GdkPixmap *pixmap;
    GdkBitmap *mask;
    GdkFont   *font;
    gchar temp[MAX_STRING_LEN];
    FILE *file;
    gint i;
    gchar *description_text = 
            _(""
            "    EasyTAG is an utility for viewing and editing tags for MP3, MP2, "
            "FLAC, Ogg Vorbis, MusePack and Monkey's Audio files. Its simple and "
            "nice GTK+ interface makes tagging easier under GNU/Linux."
            "");

    
    /* Translation contributions */
    gchar *translations_thanks_text [][2]= {
            {"    - Bastian Kleineidam ",      _("(German translation)\n")},
            {"    - Adrian Bunk ",             _("(German translation)\n")},
            {"    - Colin Marquardt ",         _("(German translation)\n")},
            {"    - Philipp Thomas ",          _("(German translation)\n")},
            {"    - Sergey Zhumatiy ",         _("(Russian translation)\n")},
            {"    - Andrey Astafiev ",         _("(Russian translation)\n")},
            {"    - Vincent van Adrighem ",    _("(Dutch translation)\n")},
            {"    - Bjrn Olievier ",          _("(Dutch translation)\n")},
            {"    - Patrik Israelsson ",       _("(Swedish translation)\n")},
            {"    - Szel Miklos ",             _("(Hungarian translation)\n")},
            {"    - Nagy Boldizsar ",          _("(Hungarian translation)\n")},
            {"    - Cappelletti Lorenzo ",     _("(Italian translation)\n")},
            {"    - Kostantino ",              _("(Italian translation)\n")},
            {"    - Takeshi Aihana ",          _("(Japanese translation)\n")},
            {"    - Olexander Kunytsa ",       _("(Ukrainian translation)\n")},
            {"    - Cawko Xakep ",             _("(Ukrainian translation)\n")},
            {"    - Milan Siebenburger ",      _("(Czech translation)\n")},
            {"    - Jaime Serrano Cartagena ", _("(Spanish translation)\n")},
            {"    - Maciej Kasprzyk ",         _("(Polish translation)\n")},
            {"    - Pauliuc George ",          _("(Romanian translation)\n")},
            {NULL,NULL}
            };
    /* General contributions */
    gchar *general_thanks_text = 
            "    - Andrew Shuvalov\n"
            "    - Sergey Zhumatiy\n"
            "    - Kevin Venkiteswaran\n"
            "    - Sheikholeslami Navid\n"
            "    - Marcus Tegel\n"
            "    - Robert\n"
            "    - Lars Bohn\n"
            "    - Patrik Israelsson\n"
            "    - Adrian Bunk\n"
            "    - Alexander D Harkness\n"
            "    - Vaclav Slavik\n"
            "    - Charles Kerr\n"
            "    - Gian\n"
            "    - Thomas Zajic\n"
            "    - Szel Miklos\n"
            "    - Tore Aursand\n"
            "    - Cappelletti Lorenzo\n"
            "    - Colin Marquardt\n"
            "    - Goetz Waschk\n"
            "    - Holger Schemel\n"
            "    - Artur Polaczynski\n"
            "    - Maciej Kasprzyk\n"
            "    - Daniel Pichler\n"
            "    - Philipp Thomas\n"
            "    - Tony Mancill\n"
            "    - Pavel Minayev\n"
            "";


    /* Check if already opened */
    if (AboutWindow)
    {
        gdk_window_raise(AboutWindow->window);
        return;
    }

    /* Dialog window */
    AboutWindow = gtk_dialog_new();

    /* Config */
    gtk_window_set_title(GTK_WINDOW(AboutWindow),_("About..."));
    gtk_window_set_position(GTK_WINDOW(AboutWindow),GTK_WIN_POS_CENTER);
    gtk_window_set_policy(GTK_WINDOW(AboutWindow),FALSE,TRUE,FALSE);

    /* Signals connection */
    gtk_signal_connect(GTK_OBJECT(AboutWindow),"destroy",(GtkSignalFunc)Quit_About_Window,NULL);
    gtk_signal_connect(GTK_OBJECT(AboutWindow),"delete_event",(GtkSignalFunc)Quit_About_Window,NULL);
    gtk_signal_connect(GTK_OBJECT(AboutWindow),"key_press_event",(GtkSignalFunc)About_Window_Key_Press,NULL);

     /* The NoteBook */
    AboutNoteBook = gtk_notebook_new();
    gtk_notebook_popup_enable(GTK_NOTEBOOK(AboutNoteBook));
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(AboutWindow)->vbox),AboutNoteBook,TRUE,TRUE,0);

    /*
     * Tab for common informations
     */
    Label = gtk_label_new(_("About"));
    Frame = gtk_frame_new(NULL);
    gtk_notebook_append_page (GTK_NOTEBOOK(AboutNoteBook),Frame,Label);
    gtk_container_border_width(GTK_CONTAINER(Frame),2);

    VBox = gtk_vbox_new(FALSE,0);
    gtk_container_add(GTK_CONTAINER(Frame),VBox);

    /* EasyTAG Logo */
    gtk_widget_realize(AboutWindow);

#ifdef PACKAGE_DATA_DIR
    pixmap = gdk_pixmap_create_from_xpm(AboutWindow->window,&mask,NULL,PACKAGE_DATA_DIR"/EasyTAG_logo.xpm");
#else
    pixmap = gdk_pixmap_create_from_xpm_d(AboutWindow->window,&mask,NULL,EasyTAG_logo_xpm);
#endif

    if (pixmap)
    {
        Logo = gtk_pixmap_new(pixmap,mask);
        gdk_pixmap_unref(pixmap);
        gdk_pixmap_unref(mask);
        gtk_box_pack_start_defaults(GTK_BOX(VBox),Logo);
        gtk_misc_set_padding(GTK_MISC(Logo),2,2);
    }

    /* Infos */
    Label = gtk_label_new(APPNAME" "VERSION);
    gtk_box_pack_start_defaults(GTK_BOX(VBox),Label);

    sprintf(temp,_("(compiled: %s)"),__DATE__);
    Label = gtk_label_new(temp);
    gtk_box_pack_start_defaults(GTK_BOX(VBox),Label);

    sprintf(temp,_("(using: gtk+ %d.%d.%d and id3lib %d.%d.%d)"),GTK_MAJOR_VERSION,GTK_MINOR_VERSION,
        GTK_MICRO_VERSION,ID3LIB_MAJOR_VERSION,ID3LIB_MINOR_VERSION,ID3LIB_PATCH_VERSION);
    Label = gtk_label_new(temp);
    gtk_box_pack_start_defaults(GTK_BOX(VBox),Label);

#ifndef ENABLE_OGG
    Label = gtk_label_new(_("(Ogg Vorbis file support disabled)"));
    gtk_box_pack_start_defaults(GTK_BOX(VBox),Label);
#endif

#ifndef ENABLE_FLAC
    Label = gtk_label_new(_("(FLAC file support disabled)"));
    gtk_box_pack_start_defaults(GTK_BOX(VBox),Label);
#endif

    /* Insert a blank line */
    Label = gtk_label_new("");
    gtk_box_pack_start_defaults(GTK_BOX(VBox),Label);

    sprintf(temp,_("Author: %s"),AUTHOR);
    Label = gtk_label_new(temp);
    gtk_box_pack_start_defaults(GTK_BOX(VBox),Label);

    sprintf(temp,_("E-mail: %s"),EMAIL);
    Label = gtk_label_new(temp);
    gtk_box_pack_start_defaults(GTK_BOX(VBox),Label);

    hbox = gtk_hbox_new(FALSE,0);
    gtk_box_pack_start_defaults(GTK_BOX(VBox),hbox);
    Label = gtk_label_new(_("Web Page: "));
    gtk_misc_set_alignment(GTK_MISC(Label),1,0.5);
    gtk_box_pack_start_defaults(GTK_BOX(hbox),Label);
    Button = gtk_button_new_with_label(WEBPAGE);
    gtk_box_pack_start_defaults(GTK_BOX(hbox),Button);
    gtk_signal_connect(GTK_OBJECT(Button),"clicked",(GtkSignalFunc)About_Window_Go_To_Home_Page,NULL);
    gtk_button_set_relief(GTK_BUTTON(Button),GTK_RELIEF_NONE);

    /* Insert a blank line */
    Label = gtk_label_new("");
    gtk_box_pack_start_defaults(GTK_BOX(VBox),Label);

    Frame = gtk_frame_new(_("Description:"));
    gtk_frame_set_shadow_type(GTK_FRAME(Frame),GTK_SHADOW_IN);
    gtk_box_pack_start_defaults(GTK_BOX(VBox),Frame);
    gtk_container_border_width(GTK_CONTAINER(Frame),2);

    Label = gtk_label_new(_(description_text));
    gtk_misc_set_padding(GTK_MISC(Label),2,2);
    gtk_label_set_line_wrap(GTK_LABEL(Label),TRUE);
    gtk_container_add(GTK_CONTAINER(Frame),Label);


    /*
     * Tab for thanks
     */
    Label = gtk_label_new(_("Thanks"));
    Frame = gtk_frame_new(NULL);
    gtk_notebook_append_page (GTK_NOTEBOOK(AboutNoteBook),Frame,Label);

    ScrollWindow = gtk_scrolled_window_new(NULL,NULL);
    gtk_container_add(GTK_CONTAINER(Frame),ScrollWindow);
    gtk_container_set_border_width(GTK_CONTAINER(Frame),2);
    gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(ScrollWindow),
                                   GTK_POLICY_AUTOMATIC,GTK_POLICY_AUTOMATIC);

    Text = gtk_text_new(NULL,NULL);
    gtk_container_add(GTK_CONTAINER(ScrollWindow),Text);
    gtk_text_set_editable(GTK_TEXT(Text),FALSE);
    gtk_text_set_word_wrap(GTK_TEXT(Text),TRUE);
    gtk_text_insert(GTK_TEXT(Text),NULL,NULL,NULL,_("Translations:\n"),-1);
    for (i=0; translations_thanks_text[i][0]!=NULL; i++)
    {
        gchar *tmp = g_strconcat(translations_thanks_text[i][0],translations_thanks_text[i][1],NULL);
        gtk_text_insert(GTK_TEXT(Text),NULL,NULL,NULL,tmp,-1);
        g_free(tmp);
    }
    gtk_text_insert(GTK_TEXT(Text),NULL,NULL,NULL,"\n",-1);
    gtk_text_insert(GTK_TEXT(Text),NULL,NULL,NULL,_("General:\n"),-1);
    gtk_text_insert(GTK_TEXT(Text),NULL,NULL,NULL,general_thanks_text,-1);


    /*
     * Tab for ChangeLog
     */

#ifdef PACKAGE_DATA_DIR
    Label = gtk_label_new(_("Changes"));
    Frame = gtk_frame_new(NULL);
    gtk_notebook_append_page (GTK_NOTEBOOK(AboutNoteBook),Frame,Label);

    ScrollWindow = gtk_scrolled_window_new(NULL,NULL);
    gtk_container_add(GTK_CONTAINER(Frame),ScrollWindow);
    gtk_container_set_border_width(GTK_CONTAINER(Frame),2);
    gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(ScrollWindow),
                                   GTK_POLICY_AUTOMATIC,GTK_POLICY_AUTOMATIC);

    Text = gtk_text_new(NULL,NULL);
    gtk_container_add(GTK_CONTAINER(ScrollWindow),Text);
    gtk_text_set_editable(GTK_TEXT(Text),FALSE);
    gtk_text_set_word_wrap(GTK_TEXT(Text),TRUE);
    font = gdk_fontset_load("-*-fixed-medium-r-semicondensed-*-*-120-*-*-*-*-*-*");


    // The file 'ChangeLog' to read
    if ( (file=fopen(PACKAGE_DATA_DIR"/ChangeLog","r"))==0 )
    {
        gchar *msg = g_strdup_printf(_("Can't open file '%s' (%s)\n"),PACKAGE_DATA_DIR"/ChangeLog",g_strerror(errno));
        gtk_text_insert(GTK_TEXT(Text),NULL,NULL,NULL,msg,-1);
        g_free(msg);
    }else
    {
        while(fgets(temp,sizeof(temp),file))
        {
            if (temp[strlen(temp)-1]=='\n')
                temp[strlen(temp)-1]='\0';
            if (temp[strlen(temp)-1]=='\r')
                temp[strlen(temp)-1]='\0';
            gtk_text_insert(GTK_TEXT(Text),font,NULL,NULL,temp,-1);
            gtk_text_insert(GTK_TEXT(Text),NULL,NULL,NULL,"\n",-1);
        }
        fclose(file);
    }
#endif


    /* 
     * Close Button
     */
    Button = Create_Button_With_Pixmap(BUTTON_CLOSE);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(AboutWindow)->action_area),Button,FALSE,FALSE,0);
    gtk_signal_connect(GTK_OBJECT(Button),"clicked",(GtkSignalFunc)Quit_About_Window,NULL);
    GTK_WIDGET_SET_FLAGS(Button,GTK_CAN_DEFAULT);
    gtk_widget_grab_default(Button);


    /* Disable main window */
    /*gtk_widget_set_sensitive(MainWindow,FALSE);*/

    gtk_widget_show_all(AboutWindow);
}


void About_Window_Go_To_Home_Page (void)
{
    system("gnome-moz-remote "WEBPAGE);
}
