/*
 * easytag
 *
 * File: win32dep.h
 *
 * Copyright (C) 2002-2003, Herman Bloggs <hermanator12002@yahoo.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */
#ifndef _WIN32DEP_H_
#define _WIN32DEP_H_
#include <winsock2.h>
#include <process.h>
#include <gtk/gtk.h>
#include <gdk/gdkevents.h>

#define lstat stat
#define mkdir(a,b) mkdir(a)
#define chown(a,b,c)
#define chmod(a,b)

/*
 *  PROTOS
 */

/**
 ** win32dep.c
 **/
/* Windows helper functions */
extern int mkstemp(char *template);
extern HINSTANCE ET_win32_hinstance(void);
extern FARPROC   wgaim_find_and_loadproc(char*, char*);
extern gboolean  ET_win32_read_reg_string(HKEY key, char* sub_key, char* val_name, LPBYTE data, LPDWORD data_len);
extern char*     ET_win32_escape_dirsep(char*);
/* Determine ET paths */
extern char*     ET_win32_install_dir(void);
extern char*     ET_win32_locale_dir(void);
extern char*     ET_win32_data_dir(void);
/* UI related */
extern void      ET_win32_gtk_window_move(GtkWindow *window, gint x, gint y);
/* Misc */
extern void      ET_win32_notify_uri(const char *uri);
extern char *    ET_win32_get_audio_file_player(void);
/* init / cleanup */
extern void      ET_win32_init(HINSTANCE);
extern void      ET_win32_cleanup(void);

extern void ET_win32_path_replace_backslashes(gchar *path);
extern void ET_win32_path_remove_trailing_slash(gchar *path);

/*
 *  MACROS
 */

/*
 *  ET specific
 */
#define DATADIR ET_win32_install_dir()
#define LOCALE ET_win32_locale_dir()

#endif /* _WIN32DEP_H_ */

