/* prefs.h - 2000/05/06 */
/*
 *  EasyTAG - Tag editor for MP3 and Ogg Vorbis files
 *  Copyright (C) 2000-2003  Jerome Couderc <easytag@gmail.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifndef __PREFS_H__
#define __PREFS_H__


/***************
 * Declaration *
 ***************/

GtkWidget *OptionsWindow;
GtkWidget *OptionsNoteBook;
gint OptionsNoteBook_Scanner_Page_Num;    /* Contains the number of the page "Scanner Option" */


/* Widgets included in config */
/* Common */
GtkWidget *LoadOnStartup;
GtkWidget *DefaultPathToMp3;
GtkWidget *BrowserLineStyleOptionMenu;
GtkWidget *BrowserExpanderStyleOptionMenu;
GtkWidget *BrowseSubdir;
GtkWidget *BrowseHiddendir;
GtkWidget *OpenSelectedBrowserNode;

GtkListStore *DefaultPathModel;

/* User interface */
GtkWidget *ShowHeaderInfos;
GtkWidget *UseColoredTooltips;
GtkWidget *ChangedFilesDisplayedToRed;
GtkWidget *ChangedFilesDisplayedToBold;

/* Misc */
GtkWidget *SortingFileCombo;
GtkWidget *SortingFileCaseSensitive;

GtkWidget *MessageBoxPositionNone;
GtkWidget *MessageBoxPositionCenter;
GtkWidget *MessageBoxPositionMouse;
GtkWidget *MessageBoxPositionCenterOnParent;

GtkWidget *FilePlayerCombo;
GtkListStore *FilePlayerModel;

/* File Settings */
GtkWidget *ReplaceIllegalCharactersInFilename;
GtkWidget *FilenameExtensionNoChange;
GtkWidget *FilenameExtensionLowerCase;
GtkWidget *FilenameExtensionUpperCase;
GtkWidget *PreserveModificationTime;

GtkWidget *FilenameCharacterSetOther;
GtkWidget *FilenameCharacterSetApproximate;
GtkWidget *FilenameCharacterSetDiscard;

/* Tag Settings */
GtkWidget *WriteId3v1Tag;
GtkWidget *WriteId3v2Tag;
GtkWidget *WriteId3TagsInFlacFiles;
GtkWidget *UseId3v2Padding;
GtkWidget *StripTagWhenEmptyFields;
GtkWidget *ConvertOldId3v2TagVersion;

GtkWidget *UseId3ISO88591CharacterSet;
GtkWidget *UseId3ISO88591ThenUnicodeCharacterSet;
GtkWidget *UseId3UnicodeCharacterSet;
GtkWidget *UseNonStandardId3ReadingCharacterSet;
GtkWidget *UseNonStandardId3WritingCharacterSet;
GtkWidget *FileReadingCharacterSetCombo;
GtkWidget *FileWritingCharacterSetCombo;

GtkWidget *FileWritingCharacterSetOther;
GtkWidget *FileWritingCharacterSetApproximate;
GtkWidget *FileWritingCharacterSetDiscard;

GtkWidget *DateAutoCompletion;
GtkWidget *NumberTrackFormated;
GtkWidget *NumberTrackFormatedSpinButton;
GtkWidget *OggTagWriteXmmsComment;
GtkWidget *SetFocusToSameTagField;
GtkWidget *SetFocusToFirstTagField;


/* Scanner */
GtkWidget *FTSConvertUnderscoreAndP20IntoSpace;
GtkWidget *FTSConvertSpaceIntoUnderscore;
GtkWidget *RFSConvertUnderscoreAndP20IntoSpace;
GtkWidget *RFSConvertSpaceIntoUnderscore;
GtkWidget *PFSDontUpperSomeWords;
GtkWidget *OverwriteTagField;
GtkWidget *OpenScannerWindowOnStartup;
GtkWidget *ScannerWindowOnTop;

GtkWidget *SetDefaultComment;
GtkWidget *DefaultComment;
GtkWidget *Crc32Comment;
GtkListStore *DefaultCommentModel;

/* CDDB */
GtkWidget *CddbServerName;
GtkWidget *CddbServerPort;
GtkWidget *CddbServerCgiPath;
GtkWidget *CddbUseProxy;
GtkWidget *CddbProxyName;
GtkWidget *CddbProxyPort;
GtkWidget *CddbProxyUserName;
GtkWidget *CddbProxyUserPassword;

GtkWidget *SetCddbWindowSize;
GtkWidget *CddbWindowWidth;
GtkWidget *CddbWindowHeight;
GtkWidget *CddbWindowButton;
GtkWidget *SetCddbPaneHandlePosition;
GtkWidget *CddbPaneHandlePosition;
GtkWidget *CddbPaneHandleButton;

GtkWidget *CddbFollowFile;


/* Confirmation */
GtkWidget *ConfirmBeforeExit;
GtkWidget *ConfirmWriteTag;
GtkWidget *ConfirmRenameFile;
GtkWidget *ConfirmDeleteFile;
GtkWidget *ConfirmWritePlayList;



/**************
 * Prototypes *
 **************/

void Init_OptionsWindow (void);
void Open_OptionsWindow (void);
void OptionsWindow_Apply_Changes (void);

void File_Selection_Window_For_File      (GtkWidget *widget);
void File_Selection_Window_For_Directory (GtkWidget *widget);


#endif /* __PREFS_H__ */
