/* config.h - 2000/06/21 */
/*
 *  EasyTAG - Tag editor for MP3 and Ogg Vorbis files
 *  Copyright (C) 2000-2003  Jerome Couderc <easytag@gmail.com>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#ifndef __CONFIG_H__
#define __CONFIG_H__

#include <gtk/gtk.h>

/***************
 * Declaration *
 ***************/

typedef enum
{
    CV_TYPE_STRING=0,
    CV_TYPE_INT,
    CV_TYPE_BOOL
} Config_Variable_Type;


typedef struct _tConfigVariable tConfigVariable;
struct _tConfigVariable
{
    char *name;                 /* Variable name written in config file */
    Config_Variable_Type type; /* Variable type: Integer, Alphabetic cf:CONFIG_VARIABLE_TYPES */
    void *var;                  /* Pointer to our variable */
};


/* 
 * Config varariables
 */
/* Common */
gint     LOAD_ON_STARTUP;
gchar   *DEFAULT_PATH_TO_MP3;
gint     BROWSER_LINE_STYLE;
gint     BROWSER_EXPANDER_STYLE;
gint     WRITE_ID3V1_TAG;
gint     WRITE_ID3V2_TAG;
gint     WRITE_ID3_TAGS_IN_FLAC_FILE;
gint     USE_ID3V2_PADDING;
gint     STRIP_TAG_WHEN_EMPTY_FIELDS;
gint     CONVERT_OLD_ID3V2_TAG_VERSION;
gint     BROWSE_SUBDIR;
gint     BROWSE_HIDDEN_DIR;
gint     OPEN_SELECTED_BROWSER_NODE;
gint     SAVE_CONFIG_BEFORE_EXIT;

/* User Interface */
gint     SET_MAIN_WINDOW_SIZE;
gint     MAIN_WINDOW_HEIGHT;
gint     MAIN_WINDOW_WIDTH;
gint     SET_PANE_HANDLE_POSITION1;
gint     PANE_HANDLE_POSITION1;
gint     SET_PANE_HANDLE_POSITION2;
gint     PANE_HANDLE_POSITION2;
gint     SET_PANE_HANDLE_POSITION3;
gint     PANE_HANDLE_POSITION3;
gint     SHOW_HEADER_INFO;

gint     USE_COLORED_TOOLTIPS;
gint     USE_NEW_LIST_STYLE;

/* Scanner */
gint    FTS_CONVERT_UNDERSCORE_AND_P20_INTO_SPACE;
gint    FTS_CONVERT_SPACE_INTO_UNDERSCORE;
gint    RFS_CONVERT_UNDERSCORE_AND_P20_INTO_SPACE;
gint    RFS_CONVERT_SPACE_INTO_UNDERSCORE;
gint    PFS_DONT_UPPER_SOME_WORDS;
gint    OVERWRITE_TAG_FIELD;
gint    SET_DEFAULT_COMMENT;
gchar   *DEFAULT_COMMENT;
gint    SET_CRC32_COMMENT;
gint    OPEN_SCANNER_WINDOW_ON_STARTUP;
gint    SCANNER_WINDOW_ON_TOP;
gint    SET_SCANNER_WINDOW_POSITION;
gint    SCANNER_WINDOW_X;
gint    SCANNER_WINDOW_Y;

/* Misc */
gint     REPLACE_ILLEGAL_CHARACTERS_IN_FILENAME;
gint     FILENAME_EXTENSION_LOWER_CASE;
gint     FILENAME_EXTENSION_UPPER_CASE;
gint     FILENAME_EXTENSION_NO_CHANGE;
gint     PRESERVE_MODIFICATION_TIME;
gint     DATE_AUTO_COMPLETION;
gint     NUMBER_TRACK_FORMATED;
gint     NUMBER_TRACK_FORMATED_SPIN_BUTTON;
gint     OGG_TAG_WRITE_XMMS_COMMENT;
gint     SORTING_FILE_MODE;
gint     SORTING_FILE_CASE_SENSITIVE;
gint     USE_ISO_8859_1_CHARACTER_SET_TRANSLATION;
gint     USE_CHARACTER_SET_TRANSLATION;
gchar   *FILE_READING_CHARACTER_SET;
gchar   *FILE_WRITING_CHARACTER_SET;

gint     MESSAGE_BOX_POSITION_NONE;
gint     MESSAGE_BOX_POSITION_CENTER;
gint     MESSAGE_BOX_POSITION_MOUSE;

gchar   *AUDIO_FILE_PLAYER;

/* Confirmation */
gint     CONFIRM_BEFORE_EXIT;
gint     CONFIRM_WRITE_TAG;
gint     CONFIRM_RENAME_FILE;
gint     CONFIRM_WRITE_PLAYLIST;
gint     CONFIRM_DELETE_FILE;

/* Scanner window */
gint     PROCESS_FILENAME_FIELD;
gint     PROCESS_TITLE_FIELD;
gint     PROCESS_ARTIST_FIELD;
gint     PROCESS_ALBUM_FIELD;
gint     PROCESS_GENRE_FIELD;
gint     PROCESS_COMMENT_FIELD;
gint     PROCESS_COMPOSER_FIELD;
gint     PROCESS_ORIG_ARTIST_FIELD;
gint     PROCESS_COPYRIGHT_FIELD;
gint     PROCESS_URL_FIELD;
gint     PROCESS_ENCODED_BY_FIELD;
gint     PF_CONVERT_INTO_SPACE;
gint     PF_CONVERT_SPACE;
gint     PF_CONVERT;
gint     PF_CONVERT_ALL_UPPERCASE;
gint     PF_CONVERT_ALL_DOWNCASE;
gint     PF_CONVERT_FIRST_LETTER_UPPERCASE;
gint     PF_CONVERT_FIRST_LETTERS_UPPERCASE;
gint     PF_REMOVE_SPACE;
gint     PF_INSERT_SPACE;
gint     PF_ONLY_ONE_SPACE;

/* Playlist window */
gchar   *PLAYLIST_NAME;
gint     PLAYLIST_USE_MASK_NAME;
gint     PLAYLIST_USE_DIR_NAME;
gint     PLAYLIST_ONLY_SELECTED_FILES;
gint     PLAYLIST_FULL_PATH;
gint     PLAYLIST_RELATIVE_PATH;
gint     PLAYLIST_CREATE_IN_PARENT_DIR;
gint     PLAYLIST_USE_DOS_SEPARATOR;
gint     PLAYLIST_CONTENT_NONE;
gint     PLAYLIST_CONTENT_FILENAME;
gint     PLAYLIST_CONTENT_MASK;
gchar   *PLAYLIST_CONTENT_MASK_VALUE;

/* "Load filenames from txt" window */
gint     LOAD_FILE_RUN_SCANNER;

/* CDDB in preferences window */
gchar   *CDDB_SERVER_NAME;
gint     CDDB_SERVER_PORT;
gchar   *CDDB_SERVER_CGI_PATH;
gint     CDDB_USE_PROXY;
gchar   *CDDB_PROXY_NAME;
gint     CDDB_PROXY_PORT;
gchar   *CDDB_PROXY_USER_NAME;
gchar   *CDDB_PROXY_USER_PASSWORD;

gint     SET_CDDB_WINDOW_SIZE;
gint     CDDB_WINDOW_HEIGHT;
gint     CDDB_WINDOW_WIDTH;
gint     SET_CDDB_PANE_HANDLE_POSITION;
gint     CDDB_PANE_HANDLE_POSITION;

gint     CDDB_FOLLOW_FILE;
gint     CDDB_USE_DLM;

/* CDDB window */
gint     CDDB_SEARCH_IN_ALL_FIELDS;
gint     CDDB_SEARCH_IN_ARTIST_FIELD;
gint     CDDB_SEARCH_IN_TITLE_FIELD;
gint     CDDB_SEARCH_IN_TRACK_NAME_FIELD;
gint     CDDB_SEARCH_IN_OTHER_FIELD;

gint     CDDB_SHOW_CATEGORIES;

gint     CDDB_SEARCH_IN_ALL_CATEGORIES;
gint     CDDB_SEARCH_IN_BLUES_CATEGORY;
gint     CDDB_SEARCH_IN_CLASSICAL_CATEGORY;
gint     CDDB_SEARCH_IN_COUNTRY_CATEGORY;
gint     CDDB_SEARCH_IN_FOLK_CATEGORY;
gint     CDDB_SEARCH_IN_JAZZ_CATEGORY;
gint     CDDB_SEARCH_IN_MISC_CATEGORY;
gint     CDDB_SEARCH_IN_NEWAGE_CATEGORY;
gint     CDDB_SEARCH_IN_REGGAE_CATEGORY;
gint     CDDB_SEARCH_IN_ROCK_CATEGORY;
gint     CDDB_SEARCH_IN_SOUNDTRACK_CATEGORY;

gint     CDDB_SET_TO_ALL_FIELDS;
gint     CDDB_SET_TO_TITLE;
gint     CDDB_SET_TO_ARTIST;
gint     CDDB_SET_TO_ALBUM;
gint     CDDB_SET_TO_YEAR;
gint     CDDB_SET_TO_TRACK;
gint     CDDB_SET_TO_TRACK_TOTAL;
gint     CDDB_SET_TO_GENRE;
gint     CDDB_SET_TO_FILE_NAME;

gint     CDDB_RUN_SCANNER;


/* Other parameters */
gint     OPTIONS_NOTEBOOK_PAGE;



/**************
 * Prototypes *
 **************/

void Init_Config_Variables (void);
void Read_Config (void);
void Display_Config (void);
void Apply_Changes (void);
void Save_Changes (void);
void Save_Config_To_File (void);
void Save_Config_Now (void);

gboolean Create_Easytag_Directory (void);
void     Setting_Create_Files     (void);


/* MasksList */
void   Save_Scan_Tag_Masks_List (GtkListStore *liststore, gint colnum);
void   Load_Scan_Tag_Masks_List (GtkListStore *liststore, gint colnum, gchar **fallback);

/* RenameFileMasksList */
void   Save_Rename_File_Masks_List (GtkListStore *liststore, gint colnum);
void   Load_Rename_File_Masks_List (GtkListStore *liststore, gint colnum, gchar **fallback);

/* 'DefaultPathToMp3' combobox */
void   Load_Default_Path_To_MP3_List (GtkListStore *liststore, gint colnum);
void   Save_Default_Path_To_MP3_List (GtkListStore *liststore, gint colnum);

/* 'DefaultComment' combobox */
void   Load_Default_Tag_Comment_Text_List (GtkListStore *liststore, gint colnum);
void   Save_Default_Tag_Comment_Text_List (GtkListStore *liststore, gint colnum);

/* 'BrowserEntry' combobox */
void   Load_Path_Entry_List (GtkListStore *liststore, gint colnum);
void   Save_Path_Entry_List (GtkListStore *liststore, gint colnum);

/* 'PlayListNameEntry' combobox */
void   Load_Play_List_Name_List (GtkListStore *liststore, gint colnum);
void   Save_Play_List_Name_List (GtkListStore *liststore, gint colnum);

/* Run Program combobox (tree browser) */
void   Load_Run_Program_With_Directory_List (GtkListStore *liststore, gint colnum);
void   Save_Run_Program_With_Directory_List (GtkListStore *liststore, gint colnum);

/* Run Program combobox (file browser) */
void   Load_Run_Program_With_File_List (GtkListStore *liststore, gint colnum);
void   Save_Run_Program_With_File_List (GtkListStore *liststore, gint colnum);

/* 'FilePlayerEntry' combobox */
void   Load_Audio_File_Player_List (GtkListStore *liststore, gint colnum);
void   Save_Audio_File_Player_List (GtkListStore *liststore, gint colnum);

/* 'SearchStringEntry' combobox */
void   Load_Search_File_List (GtkListStore *liststore, gint colnum);
void   Save_Search_File_List (GtkListStore *liststore, gint colnum);

/* 'FileToLoad' combobox */
void   Load_File_To_Load_List (GtkListStore *liststore, gint colnum);
void   Save_File_To_Load_List (GtkListStore *liststore, gint colnum);

/* 'PlayListContentMaskEntry' combobox */
void   Load_Playlist_Content_Mask_List (GtkListStore *liststore, gint colnum);
void   Save_Playlist_Content_Mask_List (GtkListStore *liststore, gint colnum);

/* 'CddbSearchStringEntry' combobox */
void   Load_Cddb_Search_String_List (GtkListStore *liststore, gint colnum);
void   Save_Cddb_Search_String_List (GtkListStore *liststore, gint colnum);

/* 'CddbSearchStringInResultEntry' combobox */
void   Load_Cddb_Search_String_In_Result_List (GtkListStore *liststore, gint colnum);
void   Save_Cddb_Search_String_In_Result_List (GtkListStore *liststore, gint colnum);


#endif /* __CONFIG_H__ */
