.PHONY: all objdir cleantarget clean realclean distclean

# CORE VARIABLES

MODULE := ide
VERSION := 
CONFIG := debug
ifndef COMPILER
COMPILER := default
endif

TARGET_TYPE = executable

# FLAGS

ECFLAGS =
ifndef DEBIAN_PACKAGE
CFLAGS =
LDFLAGS =
endif
PRJ_CFLAGS =
CECFLAGS =
OFLAGS =
LIBS =

ifdef DEBUG
NOSTRIP := y
endif

CONSOLE = -mconsole

# INCLUDES

_CF_DIR = .configs/

include $(_CF_DIR)crossplatform.mk
include $(_CF_DIR)$(TARGET_PLATFORM)-$(COMPILER).cf

# POST-INCLUDES VARIABLES

OBJ = obj/$(CONFIG).$(PLATFORM)/

RES = res/

TARGET = obj/$(CONFIG).$(PLATFORM)/ide$(E)

_ECSOURCES = \
	../extras/FileSystemIterator.ec \
	../extras/gui/layout.ec \
	../extras/gui/controls/StringsBox.ec \
	../extras/types/DynamicString.ec \
	../extras/include/dpl.ec \
	src/dialogs/CompilersDetectionDialog.ec \
	src/dialogs/FindInFilesDialog.ec \
	src/dialogs/GlobalSettingsDialog.ec \
	src/dialogs/NewProjectDialog.ec \
	src/dialogs/NodeProperties.ec \
	src/dialogs/WorkspaceSettings.ec \
	src/dialogs/ProjectTabSettings.ec \
	src/project/Project.ec \
	src/project/ProjectConfig.ec \
	src/project/ProjectNode.ec \
	src/project/ProjectView.ec \
	src/project/Workspace.ec \
	$(if $(WINDOWS_TARGET),src/project/vsSupport.ec,) \
	src/designer/CodeEditor.ec \
	src/designer/CodeObject.ec \
	src/designer/Designer.ec \
	src/designer/findCtx.ec \
	src/designer/findExp.ec \
	src/designer/findParams.ec \
	src/designer/Sheet.ec \
	src/designer/ToolBox.ec \
	src/debugger/debugFindCtx.ec \
	src/debugger/Debugger.ec \
	src/debugger/debugTools.ec \
	src/debugger/GDBDialog.ec \
	src/debugger/process.ec \
	src/panels/BreakpointsView.ec \
	src/panels/CallStackView.ec \
	src/panels/OutputView.ec \
	src/panels/ThreadsView.ec \
	src/panels/WatchesView.ec \
	src/documents/ModelView.ec \
	src/documents/PictureEdit.ec \
	src/about.ec \
	src/ide.ec \
	src/IDESettings.ec \
	src/OldIDESettings.ec \
	src/ProjectSettings.ec \
	src/licensing.ec

ECSOURCES = $(call shwspace,$(_ECSOURCES))

_COBJECTS = $(addprefix $(OBJ),$(patsubst %.ec,%$(C),$(notdir $(_ECSOURCES))))

_SYMBOLS = $(addprefix $(OBJ),$(patsubst %.ec,%$(S),$(notdir $(_ECSOURCES))))

_IMPORTS = $(addprefix $(OBJ),$(patsubst %.ec,%$(I),$(notdir $(_ECSOURCES))))

_ECOBJECTS = $(addprefix $(OBJ),$(patsubst %.ec,%$(O),$(notdir $(_ECSOURCES))))

_BOWLS = $(addprefix $(OBJ),$(patsubst %.ec,%$(B),$(notdir $(_ECSOURCES))))

COBJECTS = $(call shwspace,$(_COBJECTS))

SYMBOLS = $(call shwspace,$(_SYMBOLS))

IMPORTS = $(call shwspace,$(_IMPORTS))

ECOBJECTS = $(call shwspace,$(_ECOBJECTS))

BOWLS = $(call shwspace,$(_BOWLS))

ifdef WINDOWS_TARGET

_RCSOURCES = \
	src/resources.rc

RCSOURCES = $(call shwspace,$(_RCSOURCES))

RCOBJECTS = $(call shwspace,$(addprefix $(OBJ),$(patsubst %.rc,%$(O),$(notdir $(_RCSOURCES)))))

else
RCSOURCES =
RCOBJECTS =
endif

OBJECTS = $(ECOBJECTS) $(OBJ)$(MODULE).main$(O) $(RCOBJECTS)

SOURCES = $(ECSOURCES) $(RCSOURCES)

RESOURCES = $(RESOURCES1) $(RESOURCES2)
RESOURCES1 = \
	$(RES)actions/attach.png \
	$(RES)actions/delete.png \
	$(RES)actions/detach.png \
	$(RES)actions/docNew.png \
	$(RES)actions/editCopy.png \
	$(RES)actions/editDelete.png \
	$(RES)actions/delete2.png \
	$(RES)actions/build.png \
	$(RES)actions/clean.png \
	$(RES)actions/debug.png \
	$(RES)actions/docOpen.png \
	$(RES)actions/docSave.png \
	$(RES)actions/docSaveAll.png \
	$(RES)actions/pause.png \
	$(RES)actions/projAdd.png \
	$(RES)actions/projNew.png \
	$(RES)actions/projOpen.png \
	$(RES)actions/rebuild.png \
	$(RES)actions/regMakefile.png \
	$(RES)actions/relink.png \
	$(RES)actions/restart.png \
	$(RES)actions/run.png \
	$(RES)actions/skipBreaks.png \
	$(RES)actions/stepInto.png \
	$(RES)actions/stepOut.png \
	$(RES)actions/stepOver.png \
	$(RES)actions/stopDebug.png \
	$(RES)actions/stepOverSkipBreak.png \
	$(RES)codeMarks/breakpoint.png \
	$(RES)codeMarks/breakpointDisabled.png \
	$(RES)codeMarks/breakpointHalf.png \
	$(RES)codeMarks/breakpointHalfDisabled.png \
	$(RES)codeMarks/cursor.png \
	$(RES)codeMarks/cursorError.png \
	$(RES)codeMarks/topFrame.png \
	$(RES)codeMarks/topFrameError.png \
	$(RES)codeMarks/topFrameHalf.png \
	$(RES)codeMarks/topFrameHalfError.png \
	$(RES)others/mousePointer.png \
	$(RES)status/software-update-available.png \
	locale/es.mo \
	locale/pt_BR.mo \
	locale/ru.mo \
	locale/vi.mo \
	locale/zh_CN.mo \
	../LICENSE \
	../extras/res/licenses/png.LICENSE \
	../extras/res/licenses/tango.COPYING \
	../extras/res/licenses/zlib.README \
	../extras/res/licenses/sqlite.LICENSE \
	../extras/res/licenses/jpg.LICENSE
RESOURCES2 = \
	../extras/res/licenses/ungif.LICENSE \
	../extras/res/licenses/freetype.LICENSE \
	../extras/res/licenses/harfbuzz.LICENSE \
	../extras/res/licenses/upx.LICENSE \
	../extras/res/licenses/MinGW-w64.LICENSE \
	../extras/res/licenses/tdm-gcc.LICENSE \
	../extras/res/licenses/ffi.LICENSE \
	../extras/res/types/countryCode/es.png \
	../extras/res/types/countryCode/gb.png \
	../extras/res/types/countryCode/hu.png \
	../extras/res/types/countryCode/cn.png \
	../extras/res/types/countryCode/pt.png \
	../extras/res/types/countryCode/vn.png \
	../extras/res/types/countryCode/ru.png \
	../extras/res/types/countryCode/in.png \
	../extras/res/types/countryCode/nl.png \
	../extras/res/types/countryCode/il.png \
	../extras/res/types/countryCode/br.png \
	res/ecere.jpg \
	res/ecereBack.jpg \
	res/icon.png \
	../crossplatform.mk

LIBS += $(SHAREDLIB) $(EXECUTABLE) $(LINKOPT)

ifndef STATIC_LIBRARY_TARGET
LIBS += \
	$(call _L,ecere)
endif

PRJ_CFLAGS += \
	 $(if $(LINUX_TARGET), \
			 -I/usr/X11R6/include,) \
	 $(if $(OSX_TARGET), \
			 -I/usr/X11R6/include,) \
	 -g $(FPIC) -Wall -DREPOSITORY_VERSION="\"$(REPOSITORY_VER)\"" \
			 -D_DEBUG \
			 -DGDB_DEBUG_GUI \
			 -I../extras/include

ECFLAGS += -module $(MODULE)
# PLATFORM-SPECIFIC OPTIONS

ifdef LINUX_TARGET

ifndef STATIC_LIBRARY_TARGET
OFLAGS += \
	 -L$(call quote_path,/usr/X11R6/lib)
LIBS += \
	$(call _L,X11) \
	$(call _L,m)
endif

else
ifdef OSX_TARGET

ifndef STATIC_LIBRARY_TARGET
OFLAGS += \
	 -L$(call quote_path,/usr/X11R6/lib)
LIBS += \
	$(call _L,X11) \
	$(call _L,m)
endif

endif
endif

CECFLAGS += -cpp $(_CPP)

# TARGETS

all: objdir $(TARGET)

objdir:
	$(if $(wildcard $(OBJ)),,$(call mkdirq,$(OBJ)))
	$(if $(ECERE_SDK_SRC),$(if $(wildcard $(call escspace,$(ECERE_SDK_SRC)/crossplatform.mk)),,@$(call echo,Ecere SDK Source Warning: The value of ECERE_SDK_SRC is pointing to an incorrect ($(ECERE_SDK_SRC)) location.)),)
	$(if $(ECERE_SDK_SRC),,$(if $(ECP_DEBUG)$(ECC_DEBUG)$(ECS_DEBUG),@$(call echo,ECC Debug Warning: Please define ECERE_SDK_SRC before using ECP_DEBUG, ECC_DEBUG or ECS_DEBUG),))

$(OBJ)$(MODULE).main.ec: $(SYMBOLS) $(COBJECTS)
	@$(call rmq,$(OBJ)symbols.lst)
	@$(call touch,$(OBJ)symbols.lst)
	@$(call echo,$(SYMBOLS)) >> $(OBJ)symbols.lst
	@$(call echo,$(IMPORTS)) >> $(OBJ)symbols.lst
	$(ECS) -console $(ARCH_FLAGS) $(ECSLIBOPT) @$(OBJ)symbols.lst -symbols obj/$(CONFIG).$(PLATFORM) -o $(call quote_path,$@)

$(OBJ)$(MODULE).main.c: $(OBJ)$(MODULE).main.ec
	$(ECP) $(CFLAGS) $(CECFLAGS) $(ECFLAGS) $(PRJ_CFLAGS) -c $(OBJ)$(MODULE).main.ec -o $(OBJ)$(MODULE).main.sym -symbols $(OBJ)
	$(ECC) $(CFLAGS) $(CECFLAGS) $(ECFLAGS) $(PRJ_CFLAGS) $(FVISIBILITY) -c $(OBJ)$(MODULE).main.ec -o $(call quote_path,$@) -symbols $(OBJ)

$(SYMBOLS): | objdir
$(OBJECTS): | objdir
$(TARGET): $(SOURCES) $(RCSOURCES) $(RESOURCES) $(SYMBOLS) $(OBJECTS) | objdir
	@$(call rmq,$(OBJ)objects.lst)
	@$(call touch,$(OBJ)objects.lst)
ifdef WINDOWS_TARGET
	@$(call echo,$(RCOBJECTS)) >> $(OBJ)objects.lst
endif
	@$(call echo,$(OBJ)$(MODULE).main$(O)) >> $(OBJ)objects.lst
	@$(call echo,$(ECOBJECTS)) >> $(OBJ)objects.lst
ifndef STATIC_LIBRARY_TARGET
	$(CC) $(OFLAGS) @$(OBJ)objects.lst $(LIBS) -o $(TARGET) $(INSTALLNAME)
	$(EAR) aw$(EARFLAGS) $(TARGET) res/ecere.jpg res/ecereBack.jpg res/icon.png ../crossplatform.mk ""
	$(EAR) aw$(EARFLAGS) $(TARGET) $(RES)actions/attach.png $(RES)actions/delete.png $(RES)actions/detach.png $(RES)actions/docNew.png $(RES)actions/editCopy.png $(RES)actions/editDelete.png $(RES)actions/delete2.png $(RES)actions/build.png $(RES)actions/clean.png $(RES)actions/debug.png "actions"
	$(EAR) aw$(EARFLAGS) $(TARGET) $(RES)actions/docOpen.png $(RES)actions/docSave.png $(RES)actions/docSaveAll.png $(RES)actions/pause.png $(RES)actions/projAdd.png $(RES)actions/projNew.png $(RES)actions/projOpen.png $(RES)actions/rebuild.png $(RES)actions/regMakefile.png $(RES)actions/relink.png "actions"
	$(EAR) aw$(EARFLAGS) $(TARGET) $(RES)actions/restart.png $(RES)actions/run.png $(RES)actions/skipBreaks.png $(RES)actions/stepInto.png $(RES)actions/stepOut.png $(RES)actions/stepOver.png $(RES)actions/stopDebug.png $(RES)actions/stepOverSkipBreak.png "actions"
	$(EAR) aw$(EARFLAGS) $(TARGET) $(RES)codeMarks/breakpoint.png $(RES)codeMarks/breakpointDisabled.png $(RES)codeMarks/breakpointHalf.png $(RES)codeMarks/breakpointHalfDisabled.png $(RES)codeMarks/cursor.png $(RES)codeMarks/cursorError.png $(RES)codeMarks/topFrame.png $(RES)codeMarks/topFrameError.png $(RES)codeMarks/topFrameHalf.png $(RES)codeMarks/topFrameHalfError.png "codeMarks"
	$(EAR) aw$(EARFLAGS) $(TARGET) $(RES)others/mousePointer.png "others"
	$(EAR) aw$(EARFLAGS) $(TARGET) $(RES)status/software-update-available.png "status"
	$(EAR) aw$(EARFLAGS) $(TARGET) locale/es.mo locale/pt_BR.mo locale/ru.mo locale/vi.mo locale/zh_CN.mo "locale"
	$(EAR) aw$(EARFLAGS) $(TARGET) ../LICENSE ../extras/res/licenses/png.LICENSE ../extras/res/licenses/tango.COPYING ../extras/res/licenses/zlib.README ../extras/res/licenses/sqlite.LICENSE ../extras/res/licenses/jpg.LICENSE ../extras/res/licenses/ungif.LICENSE ../extras/res/licenses/freetype.LICENSE ../extras/res/licenses/harfbuzz.LICENSE ../extras/res/licenses/upx.LICENSE "licenses"
	$(EAR) aw$(EARFLAGS) $(TARGET) ../extras/res/licenses/MinGW-w64.LICENSE ../extras/res/licenses/tdm-gcc.LICENSE ../extras/res/licenses/ffi.LICENSE "licenses"
	$(EAR) aw$(EARFLAGS) $(TARGET) ../extras/res/types/countryCode/es.png ../extras/res/types/countryCode/gb.png ../extras/res/types/countryCode/hu.png ../extras/res/types/countryCode/cn.png ../extras/res/types/countryCode/pt.png ../extras/res/types/countryCode/vn.png ../extras/res/types/countryCode/ru.png ../extras/res/types/countryCode/in.png ../extras/res/types/countryCode/nl.png ../extras/res/types/countryCode/il.png "countryCode"
	$(EAR) aw$(EARFLAGS) $(TARGET) ../extras/res/types/countryCode/br.png "countryCode"
else
	$(AR) rcs $(TARGET) @$(OBJ)objects.lst $(LIBS)
endif
ifdef SHARED_LIBRARY_TARGET
ifdef LINUX_TARGET
ifdef LINUX_HOST
	$(if $(basename $(VER)),ln -sf $(LP)$(MODULE)$(SO)$(VER) $(OBJ)$(LP)$(MODULE)$(SO)$(basename $(VER)),)
	$(if $(VER),ln -sf $(LP)$(MODULE)$(SO)$(VER) $(OBJ)$(LP)$(MODULE)$(SO),)
endif
endif
endif

# SYMBOL RULES

$(OBJ)FileSystemIterator.sym: ../extras/FileSystemIterator.ec
	$(ECP) $(CFLAGS) $(CECFLAGS) $(ECFLAGS) $(PRJ_CFLAGS) -c $(call quote_path,../extras/FileSystemIterator.ec) -o $(call quote_path,$@)

$(OBJ)layout.sym: ../extras/gui/layout.ec
	$(ECP) $(CFLAGS) $(CECFLAGS) $(ECFLAGS) $(PRJ_CFLAGS) -c $(call quote_path,../extras/gui/layout.ec) -o $(call quote_path,$@)

$(OBJ)StringsBox.sym: ../extras/gui/controls/StringsBox.ec
	$(ECP) $(CFLAGS) $(CECFLAGS) $(ECFLAGS) $(PRJ_CFLAGS) -c $(call quote_path,../extras/gui/controls/StringsBox.ec) -o $(call quote_path,$@)

$(OBJ)DynamicString.sym: ../extras/types/DynamicString.ec
	$(ECP) $(CFLAGS) $(CECFLAGS) $(ECFLAGS) $(PRJ_CFLAGS) -c $(call quote_path,../extras/types/DynamicString.ec) -o $(call quote_path,$@)

$(OBJ)dpl.sym: ../extras/include/dpl.ec
	$(ECP) $(CFLAGS) $(CECFLAGS) $(ECFLAGS) $(PRJ_CFLAGS) -c $(call quote_path,../extras/include/dpl.ec) -o $(call quote_path,$@)

$(OBJ)CompilersDetectionDialog.sym: src/dialogs/CompilersDetectionDialog.ec
	$(ECP) $(CFLAGS) $(CECFLAGS) $(ECFLAGS) $(PRJ_CFLAGS) -c $(call quote_path,src/dialogs/CompilersDetectionDialog.ec) -o $(call quote_path,$@)

$(OBJ)FindInFilesDialog.sym: src/dialogs/FindInFilesDialog.ec
	$(ECP) $(CFLAGS) $(CECFLAGS) $(ECFLAGS) $(PRJ_CFLAGS) -c $(call quote_path,src/dialogs/FindInFilesDialog.ec) -o $(call quote_path,$@)

$(OBJ)GlobalSettingsDialog.sym: src/dialogs/GlobalSettingsDialog.ec
	$(ECP) $(CFLAGS) $(CECFLAGS) $(ECFLAGS) $(PRJ_CFLAGS) -c $(call quote_path,src/dialogs/GlobalSettingsDialog.ec) -o $(call quote_path,$@)

$(OBJ)NewProjectDialog.sym: src/dialogs/NewProjectDialog.ec
	$(ECP) $(CFLAGS) $(CECFLAGS) $(ECFLAGS) $(PRJ_CFLAGS) -c $(call quote_path,src/dialogs/NewProjectDialog.ec) -o $(call quote_path,$@)

$(OBJ)NodeProperties.sym: src/dialogs/NodeProperties.ec
	$(ECP) $(CFLAGS) $(CECFLAGS) $(ECFLAGS) $(PRJ_CFLAGS) -c $(call quote_path,src/dialogs/NodeProperties.ec) -o $(call quote_path,$@)

$(OBJ)WorkspaceSettings.sym: src/dialogs/WorkspaceSettings.ec
	$(ECP) $(CFLAGS) $(CECFLAGS) $(ECFLAGS) $(PRJ_CFLAGS) -c $(call quote_path,src/dialogs/WorkspaceSettings.ec) -o $(call quote_path,$@)

$(OBJ)ProjectTabSettings.sym: src/dialogs/ProjectTabSettings.ec
	$(ECP) $(CFLAGS) $(CECFLAGS) $(ECFLAGS) $(PRJ_CFLAGS) -c $(call quote_path,src/dialogs/ProjectTabSettings.ec) -o $(call quote_path,$@)

$(OBJ)Project.sym: src/project/Project.ec
	$(ECP) $(CFLAGS) $(CECFLAGS) $(ECFLAGS) $(PRJ_CFLAGS) -c $(call quote_path,src/project/Project.ec) -o $(call quote_path,$@)

$(OBJ)ProjectConfig.sym: src/project/ProjectConfig.ec
	$(ECP) $(CFLAGS) $(CECFLAGS) $(ECFLAGS) $(PRJ_CFLAGS) -c $(call quote_path,src/project/ProjectConfig.ec) -o $(call quote_path,$@)

$(OBJ)ProjectNode.sym: src/project/ProjectNode.ec
	$(ECP) $(CFLAGS) $(CECFLAGS) $(ECFLAGS) $(PRJ_CFLAGS) -c $(call quote_path,src/project/ProjectNode.ec) -o $(call quote_path,$@)

$(OBJ)ProjectView.sym: src/project/ProjectView.ec
	$(ECP) $(CFLAGS) $(CECFLAGS) $(ECFLAGS) $(PRJ_CFLAGS) -c $(call quote_path,src/project/ProjectView.ec) -o $(call quote_path,$@)

$(OBJ)Workspace.sym: src/project/Workspace.ec
	$(ECP) $(CFLAGS) $(CECFLAGS) $(ECFLAGS) $(PRJ_CFLAGS) -c $(call quote_path,src/project/Workspace.ec) -o $(call quote_path,$@)

ifneq "$(WINDOWS_TARGET)" ""
$(OBJ)vsSupport.sym: src/project/vsSupport.ec
	$(ECP) $(CFLAGS) $(CECFLAGS) $(ECFLAGS) $(PRJ_CFLAGS) -c $(call quote_path,src/project/vsSupport.ec) -o $(call quote_path,$@)
endif

$(OBJ)CodeEditor.sym: src/designer/CodeEditor.ec
	$(ECP) $(CFLAGS) $(CECFLAGS) $(ECFLAGS) $(PRJ_CFLAGS) -c $(call quote_path,src/designer/CodeEditor.ec) -o $(call quote_path,$@)

$(OBJ)CodeObject.sym: src/designer/CodeObject.ec
	$(ECP) $(CFLAGS) $(CECFLAGS) $(ECFLAGS) $(PRJ_CFLAGS) -c $(call quote_path,src/designer/CodeObject.ec) -o $(call quote_path,$@)

$(OBJ)Designer.sym: src/designer/Designer.ec
	$(ECP) $(CFLAGS) $(CECFLAGS) $(ECFLAGS) $(PRJ_CFLAGS) -c $(call quote_path,src/designer/Designer.ec) -o $(call quote_path,$@)

$(OBJ)findCtx.sym: src/designer/findCtx.ec
	$(ECP) $(CFLAGS) $(CECFLAGS) $(ECFLAGS) $(PRJ_CFLAGS) -c $(call quote_path,src/designer/findCtx.ec) -o $(call quote_path,$@)

$(OBJ)findExp.sym: src/designer/findExp.ec
	$(ECP) $(CFLAGS) $(CECFLAGS) $(ECFLAGS) $(PRJ_CFLAGS) -c $(call quote_path,src/designer/findExp.ec) -o $(call quote_path,$@)

$(OBJ)findParams.sym: src/designer/findParams.ec
	$(ECP) $(CFLAGS) $(CECFLAGS) $(ECFLAGS) $(PRJ_CFLAGS) -c $(call quote_path,src/designer/findParams.ec) -o $(call quote_path,$@)

$(OBJ)Sheet.sym: src/designer/Sheet.ec
	$(ECP) $(CFLAGS) $(CECFLAGS) $(ECFLAGS) $(PRJ_CFLAGS) -c $(call quote_path,src/designer/Sheet.ec) -o $(call quote_path,$@)

$(OBJ)ToolBox.sym: src/designer/ToolBox.ec
	$(ECP) $(CFLAGS) $(CECFLAGS) $(ECFLAGS) $(PRJ_CFLAGS) -c $(call quote_path,src/designer/ToolBox.ec) -o $(call quote_path,$@)

$(OBJ)debugFindCtx.sym: src/debugger/debugFindCtx.ec
	$(ECP) $(CFLAGS) $(CECFLAGS) $(ECFLAGS) $(PRJ_CFLAGS) -c $(call quote_path,src/debugger/debugFindCtx.ec) -o $(call quote_path,$@)

$(OBJ)Debugger.sym: src/debugger/Debugger.ec
	$(ECP) $(CFLAGS) $(CECFLAGS) $(ECFLAGS) $(PRJ_CFLAGS) -c $(call quote_path,src/debugger/Debugger.ec) -o $(call quote_path,$@)

$(OBJ)debugTools.sym: src/debugger/debugTools.ec
	$(ECP) $(CFLAGS) $(CECFLAGS) $(ECFLAGS) $(PRJ_CFLAGS) -c $(call quote_path,src/debugger/debugTools.ec) -o $(call quote_path,$@)

$(OBJ)GDBDialog.sym: src/debugger/GDBDialog.ec
	$(ECP) $(CFLAGS) $(CECFLAGS) $(ECFLAGS) $(PRJ_CFLAGS) -c $(call quote_path,src/debugger/GDBDialog.ec) -o $(call quote_path,$@)

$(OBJ)process.sym: src/debugger/process.ec
	$(ECP) $(CFLAGS) $(CECFLAGS) $(ECFLAGS) $(PRJ_CFLAGS) -c $(call quote_path,src/debugger/process.ec) -o $(call quote_path,$@)

$(OBJ)BreakpointsView.sym: src/panels/BreakpointsView.ec
	$(ECP) $(CFLAGS) $(CECFLAGS) $(ECFLAGS) $(PRJ_CFLAGS) -c $(call quote_path,src/panels/BreakpointsView.ec) -o $(call quote_path,$@)

$(OBJ)CallStackView.sym: src/panels/CallStackView.ec
	$(ECP) $(CFLAGS) $(CECFLAGS) $(ECFLAGS) $(PRJ_CFLAGS) -c $(call quote_path,src/panels/CallStackView.ec) -o $(call quote_path,$@)

$(OBJ)OutputView.sym: src/panels/OutputView.ec
	$(ECP) $(CFLAGS) $(CECFLAGS) $(ECFLAGS) $(PRJ_CFLAGS) -c $(call quote_path,src/panels/OutputView.ec) -o $(call quote_path,$@)

$(OBJ)ThreadsView.sym: src/panels/ThreadsView.ec
	$(ECP) $(CFLAGS) $(CECFLAGS) $(ECFLAGS) $(PRJ_CFLAGS) -c $(call quote_path,src/panels/ThreadsView.ec) -o $(call quote_path,$@)

$(OBJ)WatchesView.sym: src/panels/WatchesView.ec
	$(ECP) $(CFLAGS) $(CECFLAGS) $(ECFLAGS) $(PRJ_CFLAGS) -c $(call quote_path,src/panels/WatchesView.ec) -o $(call quote_path,$@)

$(OBJ)ModelView.sym: src/documents/ModelView.ec
	$(ECP) $(CFLAGS) $(CECFLAGS) $(ECFLAGS) $(PRJ_CFLAGS) -c $(call quote_path,src/documents/ModelView.ec) -o $(call quote_path,$@)

$(OBJ)PictureEdit.sym: src/documents/PictureEdit.ec
	$(ECP) $(CFLAGS) $(CECFLAGS) $(ECFLAGS) $(PRJ_CFLAGS) -c $(call quote_path,src/documents/PictureEdit.ec) -o $(call quote_path,$@)

$(OBJ)about.sym: src/about.ec
	$(ECP) $(CFLAGS) $(CECFLAGS) $(ECFLAGS) $(PRJ_CFLAGS) -c $(call quote_path,src/about.ec) -o $(call quote_path,$@)

$(OBJ)ide.sym: src/ide.ec
	$(ECP) $(CFLAGS) $(CECFLAGS) $(ECFLAGS) $(PRJ_CFLAGS) -c $(call quote_path,src/ide.ec) -o $(call quote_path,$@)

$(OBJ)IDESettings.sym: src/IDESettings.ec
	$(ECP) $(CFLAGS) $(CECFLAGS) $(ECFLAGS) $(PRJ_CFLAGS) -c $(call quote_path,src/IDESettings.ec) -o $(call quote_path,$@)

$(OBJ)OldIDESettings.sym: src/OldIDESettings.ec
	$(ECP) $(CFLAGS) $(CECFLAGS) $(ECFLAGS) $(PRJ_CFLAGS) -c $(call quote_path,src/OldIDESettings.ec) -o $(call quote_path,$@)

$(OBJ)ProjectSettings.sym: src/ProjectSettings.ec
	$(ECP) $(CFLAGS) $(CECFLAGS) $(ECFLAGS) $(PRJ_CFLAGS) -c $(call quote_path,src/ProjectSettings.ec) -o $(call quote_path,$@)

$(OBJ)licensing.sym: src/licensing.ec
	$(ECP) $(CFLAGS) $(CECFLAGS) $(ECFLAGS) $(PRJ_CFLAGS) -c $(call quote_path,src/licensing.ec) -o $(call quote_path,$@)

# C OBJECT RULES

$(OBJ)FileSystemIterator.c: ../extras/FileSystemIterator.ec $(OBJ)FileSystemIterator.sym | $(SYMBOLS)
	$(ECC) $(CFLAGS) $(CECFLAGS) $(ECFLAGS) $(PRJ_CFLAGS) $(FVISIBILITY) -c $(call quote_path,../extras/FileSystemIterator.ec) -o $(call quote_path,$@) -symbols $(OBJ)

$(OBJ)layout.c: ../extras/gui/layout.ec $(OBJ)layout.sym | $(SYMBOLS)
	$(ECC) $(CFLAGS) $(CECFLAGS) $(ECFLAGS) $(PRJ_CFLAGS) $(FVISIBILITY) -c $(call quote_path,../extras/gui/layout.ec) -o $(call quote_path,$@) -symbols $(OBJ)

$(OBJ)StringsBox.c: ../extras/gui/controls/StringsBox.ec $(OBJ)StringsBox.sym | $(SYMBOLS)
	$(ECC) $(CFLAGS) $(CECFLAGS) $(ECFLAGS) $(PRJ_CFLAGS) $(FVISIBILITY) -c $(call quote_path,../extras/gui/controls/StringsBox.ec) -o $(call quote_path,$@) -symbols $(OBJ)

$(OBJ)DynamicString.c: ../extras/types/DynamicString.ec $(OBJ)DynamicString.sym | $(SYMBOLS)
	$(ECC) $(CFLAGS) $(CECFLAGS) $(ECFLAGS) $(PRJ_CFLAGS) $(FVISIBILITY) -c $(call quote_path,../extras/types/DynamicString.ec) -o $(call quote_path,$@) -symbols $(OBJ)

$(OBJ)dpl.c: ../extras/include/dpl.ec $(OBJ)dpl.sym | $(SYMBOLS)
	$(ECC) $(CFLAGS) $(CECFLAGS) $(ECFLAGS) $(PRJ_CFLAGS) $(FVISIBILITY) -c $(call quote_path,../extras/include/dpl.ec) -o $(call quote_path,$@) -symbols $(OBJ)

$(OBJ)CompilersDetectionDialog.c: src/dialogs/CompilersDetectionDialog.ec $(OBJ)CompilersDetectionDialog.sym | $(SYMBOLS)
	$(ECC) $(CFLAGS) $(CECFLAGS) $(ECFLAGS) $(PRJ_CFLAGS) $(FVISIBILITY) -c $(call quote_path,src/dialogs/CompilersDetectionDialog.ec) -o $(call quote_path,$@) -symbols $(OBJ)

$(OBJ)FindInFilesDialog.c: src/dialogs/FindInFilesDialog.ec $(OBJ)FindInFilesDialog.sym | $(SYMBOLS)
	$(ECC) $(CFLAGS) $(CECFLAGS) $(ECFLAGS) $(PRJ_CFLAGS) $(FVISIBILITY) -c $(call quote_path,src/dialogs/FindInFilesDialog.ec) -o $(call quote_path,$@) -symbols $(OBJ)

$(OBJ)GlobalSettingsDialog.c: src/dialogs/GlobalSettingsDialog.ec $(OBJ)GlobalSettingsDialog.sym | $(SYMBOLS)
	$(ECC) $(CFLAGS) $(CECFLAGS) $(ECFLAGS) $(PRJ_CFLAGS) $(FVISIBILITY) -c $(call quote_path,src/dialogs/GlobalSettingsDialog.ec) -o $(call quote_path,$@) -symbols $(OBJ)

$(OBJ)NewProjectDialog.c: src/dialogs/NewProjectDialog.ec $(OBJ)NewProjectDialog.sym | $(SYMBOLS)
	$(ECC) $(CFLAGS) $(CECFLAGS) $(ECFLAGS) $(PRJ_CFLAGS) $(FVISIBILITY) -c $(call quote_path,src/dialogs/NewProjectDialog.ec) -o $(call quote_path,$@) -symbols $(OBJ)

$(OBJ)NodeProperties.c: src/dialogs/NodeProperties.ec $(OBJ)NodeProperties.sym | $(SYMBOLS)
	$(ECC) $(CFLAGS) $(CECFLAGS) $(ECFLAGS) $(PRJ_CFLAGS) $(FVISIBILITY) -c $(call quote_path,src/dialogs/NodeProperties.ec) -o $(call quote_path,$@) -symbols $(OBJ)

$(OBJ)WorkspaceSettings.c: src/dialogs/WorkspaceSettings.ec $(OBJ)WorkspaceSettings.sym | $(SYMBOLS)
	$(ECC) $(CFLAGS) $(CECFLAGS) $(ECFLAGS) $(PRJ_CFLAGS) $(FVISIBILITY) -c $(call quote_path,src/dialogs/WorkspaceSettings.ec) -o $(call quote_path,$@) -symbols $(OBJ)

$(OBJ)ProjectTabSettings.c: src/dialogs/ProjectTabSettings.ec $(OBJ)ProjectTabSettings.sym | $(SYMBOLS)
	$(ECC) $(CFLAGS) $(CECFLAGS) $(ECFLAGS) $(PRJ_CFLAGS) $(FVISIBILITY) -c $(call quote_path,src/dialogs/ProjectTabSettings.ec) -o $(call quote_path,$@) -symbols $(OBJ)

$(OBJ)Project.c: src/project/Project.ec $(OBJ)Project.sym | $(SYMBOLS)
	$(ECC) $(CFLAGS) $(CECFLAGS) $(ECFLAGS) $(PRJ_CFLAGS) $(FVISIBILITY) -c $(call quote_path,src/project/Project.ec) -o $(call quote_path,$@) -symbols $(OBJ)

$(OBJ)ProjectConfig.c: src/project/ProjectConfig.ec $(OBJ)ProjectConfig.sym | $(SYMBOLS)
	$(ECC) $(CFLAGS) $(CECFLAGS) $(ECFLAGS) $(PRJ_CFLAGS) $(FVISIBILITY) -c $(call quote_path,src/project/ProjectConfig.ec) -o $(call quote_path,$@) -symbols $(OBJ)

$(OBJ)ProjectNode.c: src/project/ProjectNode.ec $(OBJ)ProjectNode.sym | $(SYMBOLS)
	$(ECC) $(CFLAGS) $(CECFLAGS) $(ECFLAGS) $(PRJ_CFLAGS) $(FVISIBILITY) -c $(call quote_path,src/project/ProjectNode.ec) -o $(call quote_path,$@) -symbols $(OBJ)

$(OBJ)ProjectView.c: src/project/ProjectView.ec $(OBJ)ProjectView.sym | $(SYMBOLS)
	$(ECC) $(CFLAGS) $(CECFLAGS) $(ECFLAGS) $(PRJ_CFLAGS) $(FVISIBILITY) -c $(call quote_path,src/project/ProjectView.ec) -o $(call quote_path,$@) -symbols $(OBJ)

$(OBJ)Workspace.c: src/project/Workspace.ec $(OBJ)Workspace.sym | $(SYMBOLS)
	$(ECC) $(CFLAGS) $(CECFLAGS) $(ECFLAGS) $(PRJ_CFLAGS) $(FVISIBILITY) -c $(call quote_path,src/project/Workspace.ec) -o $(call quote_path,$@) -symbols $(OBJ)

ifneq "$(WINDOWS_TARGET)" ""
$(OBJ)vsSupport.c: src/project/vsSupport.ec $(OBJ)vsSupport.sym | $(SYMBOLS)
	$(ECC) $(CFLAGS) $(CECFLAGS) $(ECFLAGS) $(PRJ_CFLAGS) $(FVISIBILITY) -c $(call quote_path,src/project/vsSupport.ec) -o $(call quote_path,$@) -symbols $(OBJ)
endif

$(OBJ)CodeEditor.c: src/designer/CodeEditor.ec $(OBJ)CodeEditor.sym | $(SYMBOLS)
	$(ECC) $(CFLAGS) $(CECFLAGS) $(ECFLAGS) $(PRJ_CFLAGS) $(FVISIBILITY) -c $(call quote_path,src/designer/CodeEditor.ec) -o $(call quote_path,$@) -symbols $(OBJ)

$(OBJ)CodeObject.c: src/designer/CodeObject.ec $(OBJ)CodeObject.sym | $(SYMBOLS)
	$(ECC) $(CFLAGS) $(CECFLAGS) $(ECFLAGS) $(PRJ_CFLAGS) $(FVISIBILITY) -c $(call quote_path,src/designer/CodeObject.ec) -o $(call quote_path,$@) -symbols $(OBJ)

$(OBJ)Designer.c: src/designer/Designer.ec $(OBJ)Designer.sym | $(SYMBOLS)
	$(ECC) $(CFLAGS) $(CECFLAGS) $(ECFLAGS) $(PRJ_CFLAGS) $(FVISIBILITY) -c $(call quote_path,src/designer/Designer.ec) -o $(call quote_path,$@) -symbols $(OBJ)

$(OBJ)findCtx.c: src/designer/findCtx.ec $(OBJ)findCtx.sym | $(SYMBOLS)
	$(ECC) $(CFLAGS) $(CECFLAGS) $(ECFLAGS) $(PRJ_CFLAGS) $(FVISIBILITY) -c $(call quote_path,src/designer/findCtx.ec) -o $(call quote_path,$@) -symbols $(OBJ)

$(OBJ)findExp.c: src/designer/findExp.ec $(OBJ)findExp.sym | $(SYMBOLS)
	$(ECC) $(CFLAGS) $(CECFLAGS) $(ECFLAGS) $(PRJ_CFLAGS) $(FVISIBILITY) -c $(call quote_path,src/designer/findExp.ec) -o $(call quote_path,$@) -symbols $(OBJ)

$(OBJ)findParams.c: src/designer/findParams.ec $(OBJ)findParams.sym | $(SYMBOLS)
	$(ECC) $(CFLAGS) $(CECFLAGS) $(ECFLAGS) $(PRJ_CFLAGS) $(FVISIBILITY) -c $(call quote_path,src/designer/findParams.ec) -o $(call quote_path,$@) -symbols $(OBJ)

$(OBJ)Sheet.c: src/designer/Sheet.ec $(OBJ)Sheet.sym | $(SYMBOLS)
	$(ECC) $(CFLAGS) $(CECFLAGS) $(ECFLAGS) $(PRJ_CFLAGS) $(FVISIBILITY) -c $(call quote_path,src/designer/Sheet.ec) -o $(call quote_path,$@) -symbols $(OBJ)

$(OBJ)ToolBox.c: src/designer/ToolBox.ec $(OBJ)ToolBox.sym | $(SYMBOLS)
	$(ECC) $(CFLAGS) $(CECFLAGS) $(ECFLAGS) $(PRJ_CFLAGS) $(FVISIBILITY) -c $(call quote_path,src/designer/ToolBox.ec) -o $(call quote_path,$@) -symbols $(OBJ)

$(OBJ)debugFindCtx.c: src/debugger/debugFindCtx.ec $(OBJ)debugFindCtx.sym | $(SYMBOLS)
	$(ECC) $(CFLAGS) $(CECFLAGS) $(ECFLAGS) $(PRJ_CFLAGS) $(FVISIBILITY) -c $(call quote_path,src/debugger/debugFindCtx.ec) -o $(call quote_path,$@) -symbols $(OBJ)

$(OBJ)Debugger.c: src/debugger/Debugger.ec $(OBJ)Debugger.sym | $(SYMBOLS)
	$(ECC) $(CFLAGS) $(CECFLAGS) $(ECFLAGS) $(PRJ_CFLAGS) $(FVISIBILITY) -c $(call quote_path,src/debugger/Debugger.ec) -o $(call quote_path,$@) -symbols $(OBJ)

$(OBJ)debugTools.c: src/debugger/debugTools.ec $(OBJ)debugTools.sym | $(SYMBOLS)
	$(ECC) $(CFLAGS) $(CECFLAGS) $(ECFLAGS) $(PRJ_CFLAGS) $(FVISIBILITY) -c $(call quote_path,src/debugger/debugTools.ec) -o $(call quote_path,$@) -symbols $(OBJ)

$(OBJ)GDBDialog.c: src/debugger/GDBDialog.ec $(OBJ)GDBDialog.sym | $(SYMBOLS)
	$(ECC) $(CFLAGS) $(CECFLAGS) $(ECFLAGS) $(PRJ_CFLAGS) $(FVISIBILITY) -c $(call quote_path,src/debugger/GDBDialog.ec) -o $(call quote_path,$@) -symbols $(OBJ)

$(OBJ)process.c: src/debugger/process.ec $(OBJ)process.sym | $(SYMBOLS)
	$(ECC) $(CFLAGS) $(CECFLAGS) $(ECFLAGS) $(PRJ_CFLAGS) $(FVISIBILITY) -c $(call quote_path,src/debugger/process.ec) -o $(call quote_path,$@) -symbols $(OBJ)

$(OBJ)BreakpointsView.c: src/panels/BreakpointsView.ec $(OBJ)BreakpointsView.sym | $(SYMBOLS)
	$(ECC) $(CFLAGS) $(CECFLAGS) $(ECFLAGS) $(PRJ_CFLAGS) $(FVISIBILITY) -c $(call quote_path,src/panels/BreakpointsView.ec) -o $(call quote_path,$@) -symbols $(OBJ)

$(OBJ)CallStackView.c: src/panels/CallStackView.ec $(OBJ)CallStackView.sym | $(SYMBOLS)
	$(ECC) $(CFLAGS) $(CECFLAGS) $(ECFLAGS) $(PRJ_CFLAGS) $(FVISIBILITY) -c $(call quote_path,src/panels/CallStackView.ec) -o $(call quote_path,$@) -symbols $(OBJ)

$(OBJ)OutputView.c: src/panels/OutputView.ec $(OBJ)OutputView.sym | $(SYMBOLS)
	$(ECC) $(CFLAGS) $(CECFLAGS) $(ECFLAGS) $(PRJ_CFLAGS) $(FVISIBILITY) -c $(call quote_path,src/panels/OutputView.ec) -o $(call quote_path,$@) -symbols $(OBJ)

$(OBJ)ThreadsView.c: src/panels/ThreadsView.ec $(OBJ)ThreadsView.sym | $(SYMBOLS)
	$(ECC) $(CFLAGS) $(CECFLAGS) $(ECFLAGS) $(PRJ_CFLAGS) $(FVISIBILITY) -c $(call quote_path,src/panels/ThreadsView.ec) -o $(call quote_path,$@) -symbols $(OBJ)

$(OBJ)WatchesView.c: src/panels/WatchesView.ec $(OBJ)WatchesView.sym | $(SYMBOLS)
	$(ECC) $(CFLAGS) $(CECFLAGS) $(ECFLAGS) $(PRJ_CFLAGS) $(FVISIBILITY) -c $(call quote_path,src/panels/WatchesView.ec) -o $(call quote_path,$@) -symbols $(OBJ)

$(OBJ)ModelView.c: src/documents/ModelView.ec $(OBJ)ModelView.sym | $(SYMBOLS)
	$(ECC) $(CFLAGS) $(CECFLAGS) $(ECFLAGS) $(PRJ_CFLAGS) $(FVISIBILITY) -c $(call quote_path,src/documents/ModelView.ec) -o $(call quote_path,$@) -symbols $(OBJ)

$(OBJ)PictureEdit.c: src/documents/PictureEdit.ec $(OBJ)PictureEdit.sym | $(SYMBOLS)
	$(ECC) $(CFLAGS) $(CECFLAGS) $(ECFLAGS) $(PRJ_CFLAGS) $(FVISIBILITY) -c $(call quote_path,src/documents/PictureEdit.ec) -o $(call quote_path,$@) -symbols $(OBJ)

$(OBJ)about.c: src/about.ec $(OBJ)about.sym | $(SYMBOLS)
	$(ECC) $(CFLAGS) $(CECFLAGS) $(ECFLAGS) $(PRJ_CFLAGS) $(FVISIBILITY) -c $(call quote_path,src/about.ec) -o $(call quote_path,$@) -symbols $(OBJ)

$(OBJ)ide.c: src/ide.ec $(OBJ)ide.sym | $(SYMBOLS)
	$(ECC) $(CFLAGS) $(CECFLAGS) $(ECFLAGS) $(PRJ_CFLAGS) $(FVISIBILITY) -c $(call quote_path,src/ide.ec) -o $(call quote_path,$@) -symbols $(OBJ)

$(OBJ)IDESettings.c: src/IDESettings.ec $(OBJ)IDESettings.sym | $(SYMBOLS)
	$(ECC) $(CFLAGS) $(CECFLAGS) $(ECFLAGS) $(PRJ_CFLAGS) $(FVISIBILITY) -c $(call quote_path,src/IDESettings.ec) -o $(call quote_path,$@) -symbols $(OBJ)

$(OBJ)OldIDESettings.c: src/OldIDESettings.ec $(OBJ)OldIDESettings.sym | $(SYMBOLS)
	$(ECC) $(CFLAGS) $(CECFLAGS) $(ECFLAGS) $(PRJ_CFLAGS) $(FVISIBILITY) -c $(call quote_path,src/OldIDESettings.ec) -o $(call quote_path,$@) -symbols $(OBJ)

$(OBJ)ProjectSettings.c: src/ProjectSettings.ec $(OBJ)ProjectSettings.sym | $(SYMBOLS)
	$(ECC) $(CFLAGS) $(CECFLAGS) $(ECFLAGS) $(PRJ_CFLAGS) $(FVISIBILITY) -c $(call quote_path,src/ProjectSettings.ec) -o $(call quote_path,$@) -symbols $(OBJ)

$(OBJ)licensing.c: src/licensing.ec $(OBJ)licensing.sym | $(SYMBOLS)
	$(ECC) $(CFLAGS) $(CECFLAGS) $(ECFLAGS) $(PRJ_CFLAGS) $(FVISIBILITY) -c $(call quote_path,src/licensing.ec) -o $(call quote_path,$@) -symbols $(OBJ)

# OBJECT RULES

$(OBJ)FileSystemIterator.o: $(OBJ)FileSystemIterator.c
	$(CC) $(CFLAGS) $(PRJ_CFLAGS) $(FVISIBILITY) -c $(call quote_path,$(OBJ)FileSystemIterator.c) -o $(call quote_path,$@)

$(OBJ)layout.o: $(OBJ)layout.c
	$(CC) $(CFLAGS) $(PRJ_CFLAGS) $(FVISIBILITY) -c $(call quote_path,$(OBJ)layout.c) -o $(call quote_path,$@)

$(OBJ)StringsBox.o: $(OBJ)StringsBox.c
	$(CC) $(CFLAGS) $(PRJ_CFLAGS) $(FVISIBILITY) -c $(call quote_path,$(OBJ)StringsBox.c) -o $(call quote_path,$@)

$(OBJ)DynamicString.o: $(OBJ)DynamicString.c
	$(CC) $(CFLAGS) $(PRJ_CFLAGS) $(FVISIBILITY) -c $(call quote_path,$(OBJ)DynamicString.c) -o $(call quote_path,$@)

$(OBJ)dpl.o: $(OBJ)dpl.c
	$(CC) $(CFLAGS) $(PRJ_CFLAGS) $(FVISIBILITY) -c $(call quote_path,$(OBJ)dpl.c) -o $(call quote_path,$@)

$(OBJ)CompilersDetectionDialog.o: $(OBJ)CompilersDetectionDialog.c
	$(CC) $(CFLAGS) $(PRJ_CFLAGS) $(FVISIBILITY) -c $(call quote_path,$(OBJ)CompilersDetectionDialog.c) -o $(call quote_path,$@)

$(OBJ)FindInFilesDialog.o: $(OBJ)FindInFilesDialog.c
	$(CC) $(CFLAGS) $(PRJ_CFLAGS) $(FVISIBILITY) -c $(call quote_path,$(OBJ)FindInFilesDialog.c) -o $(call quote_path,$@)

$(OBJ)GlobalSettingsDialog.o: $(OBJ)GlobalSettingsDialog.c
	$(CC) $(CFLAGS) $(PRJ_CFLAGS) $(FVISIBILITY) -c $(call quote_path,$(OBJ)GlobalSettingsDialog.c) -o $(call quote_path,$@)

$(OBJ)NewProjectDialog.o: $(OBJ)NewProjectDialog.c
	$(CC) $(CFLAGS) $(PRJ_CFLAGS) $(FVISIBILITY) -c $(call quote_path,$(OBJ)NewProjectDialog.c) -o $(call quote_path,$@)

$(OBJ)NodeProperties.o: $(OBJ)NodeProperties.c
	$(CC) $(CFLAGS) $(PRJ_CFLAGS) $(FVISIBILITY) -c $(call quote_path,$(OBJ)NodeProperties.c) -o $(call quote_path,$@)

$(OBJ)WorkspaceSettings.o: $(OBJ)WorkspaceSettings.c
	$(CC) $(CFLAGS) $(PRJ_CFLAGS) $(FVISIBILITY) -c $(call quote_path,$(OBJ)WorkspaceSettings.c) -o $(call quote_path,$@)

$(OBJ)ProjectTabSettings.o: $(OBJ)ProjectTabSettings.c
	$(CC) $(CFLAGS) $(PRJ_CFLAGS) $(FVISIBILITY) -c $(call quote_path,$(OBJ)ProjectTabSettings.c) -o $(call quote_path,$@)

$(OBJ)Project.o: $(OBJ)Project.c
	$(CC) $(CFLAGS) $(PRJ_CFLAGS) $(FVISIBILITY) -c $(call quote_path,$(OBJ)Project.c) -o $(call quote_path,$@)

$(OBJ)ProjectConfig.o: $(OBJ)ProjectConfig.c
	$(CC) $(CFLAGS) $(PRJ_CFLAGS) $(FVISIBILITY) -c $(call quote_path,$(OBJ)ProjectConfig.c) -o $(call quote_path,$@)

$(OBJ)ProjectNode.o: $(OBJ)ProjectNode.c
	$(CC) $(CFLAGS) $(PRJ_CFLAGS) $(FVISIBILITY) -c $(call quote_path,$(OBJ)ProjectNode.c) -o $(call quote_path,$@)

$(OBJ)ProjectView.o: $(OBJ)ProjectView.c
	$(CC) $(CFLAGS) $(PRJ_CFLAGS) $(FVISIBILITY) -c $(call quote_path,$(OBJ)ProjectView.c) -o $(call quote_path,$@)

$(OBJ)Workspace.o: $(OBJ)Workspace.c
	$(CC) $(CFLAGS) $(PRJ_CFLAGS) $(FVISIBILITY) -c $(call quote_path,$(OBJ)Workspace.c) -o $(call quote_path,$@)

ifneq "$(WINDOWS_TARGET)" ""
$(OBJ)vsSupport.o: $(OBJ)vsSupport.c
	$(CC) $(CFLAGS) $(PRJ_CFLAGS) $(FVISIBILITY) -c $(call quote_path,$(OBJ)vsSupport.c) -o $(call quote_path,$@)
endif

$(OBJ)CodeEditor.o: $(OBJ)CodeEditor.c
	$(CC) $(CFLAGS) $(PRJ_CFLAGS) $(FVISIBILITY) -c $(call quote_path,$(OBJ)CodeEditor.c) -o $(call quote_path,$@)

$(OBJ)CodeObject.o: $(OBJ)CodeObject.c
	$(CC) $(CFLAGS) $(PRJ_CFLAGS) $(FVISIBILITY) -c $(call quote_path,$(OBJ)CodeObject.c) -o $(call quote_path,$@)

$(OBJ)Designer.o: $(OBJ)Designer.c
	$(CC) $(CFLAGS) $(PRJ_CFLAGS) $(FVISIBILITY) -c $(call quote_path,$(OBJ)Designer.c) -o $(call quote_path,$@)

$(OBJ)findCtx.o: $(OBJ)findCtx.c
	$(CC) $(CFLAGS) $(PRJ_CFLAGS) $(FVISIBILITY) -c $(call quote_path,$(OBJ)findCtx.c) -o $(call quote_path,$@)

$(OBJ)findExp.o: $(OBJ)findExp.c
	$(CC) $(CFLAGS) $(PRJ_CFLAGS) $(FVISIBILITY) -c $(call quote_path,$(OBJ)findExp.c) -o $(call quote_path,$@)

$(OBJ)findParams.o: $(OBJ)findParams.c
	$(CC) $(CFLAGS) $(PRJ_CFLAGS) $(FVISIBILITY) -c $(call quote_path,$(OBJ)findParams.c) -o $(call quote_path,$@)

$(OBJ)Sheet.o: $(OBJ)Sheet.c
	$(CC) $(CFLAGS) $(PRJ_CFLAGS) $(FVISIBILITY) -c $(call quote_path,$(OBJ)Sheet.c) -o $(call quote_path,$@)

$(OBJ)ToolBox.o: $(OBJ)ToolBox.c
	$(CC) $(CFLAGS) $(PRJ_CFLAGS) $(FVISIBILITY) -c $(call quote_path,$(OBJ)ToolBox.c) -o $(call quote_path,$@)

$(OBJ)debugFindCtx.o: $(OBJ)debugFindCtx.c
	$(CC) $(CFLAGS) $(PRJ_CFLAGS) $(FVISIBILITY) -c $(call quote_path,$(OBJ)debugFindCtx.c) -o $(call quote_path,$@)

$(OBJ)Debugger.o: $(OBJ)Debugger.c
	$(CC) $(CFLAGS) $(PRJ_CFLAGS) $(FVISIBILITY) -c $(call quote_path,$(OBJ)Debugger.c) -o $(call quote_path,$@)

$(OBJ)debugTools.o: $(OBJ)debugTools.c
	$(CC) $(CFLAGS) $(PRJ_CFLAGS) $(FVISIBILITY) -c $(call quote_path,$(OBJ)debugTools.c) -o $(call quote_path,$@)

$(OBJ)GDBDialog.o: $(OBJ)GDBDialog.c
	$(CC) $(CFLAGS) $(PRJ_CFLAGS) $(FVISIBILITY) -c $(call quote_path,$(OBJ)GDBDialog.c) -o $(call quote_path,$@)

$(OBJ)process.o: $(OBJ)process.c
	$(CC) $(CFLAGS) $(PRJ_CFLAGS) $(FVISIBILITY) -c $(call quote_path,$(OBJ)process.c) -o $(call quote_path,$@)

$(OBJ)BreakpointsView.o: $(OBJ)BreakpointsView.c
	$(CC) $(CFLAGS) $(PRJ_CFLAGS) $(FVISIBILITY) -c $(call quote_path,$(OBJ)BreakpointsView.c) -o $(call quote_path,$@)

$(OBJ)CallStackView.o: $(OBJ)CallStackView.c
	$(CC) $(CFLAGS) $(PRJ_CFLAGS) $(FVISIBILITY) -c $(call quote_path,$(OBJ)CallStackView.c) -o $(call quote_path,$@)

$(OBJ)OutputView.o: $(OBJ)OutputView.c
	$(CC) $(CFLAGS) $(PRJ_CFLAGS) $(FVISIBILITY) -c $(call quote_path,$(OBJ)OutputView.c) -o $(call quote_path,$@)

$(OBJ)ThreadsView.o: $(OBJ)ThreadsView.c
	$(CC) $(CFLAGS) $(PRJ_CFLAGS) $(FVISIBILITY) -c $(call quote_path,$(OBJ)ThreadsView.c) -o $(call quote_path,$@)

$(OBJ)WatchesView.o: $(OBJ)WatchesView.c
	$(CC) $(CFLAGS) $(PRJ_CFLAGS) $(FVISIBILITY) -c $(call quote_path,$(OBJ)WatchesView.c) -o $(call quote_path,$@)

$(OBJ)ModelView.o: $(OBJ)ModelView.c
	$(CC) $(CFLAGS) $(PRJ_CFLAGS) $(FVISIBILITY) -c $(call quote_path,$(OBJ)ModelView.c) -o $(call quote_path,$@)

$(OBJ)PictureEdit.o: $(OBJ)PictureEdit.c
	$(CC) $(CFLAGS) $(PRJ_CFLAGS) $(FVISIBILITY) -c $(call quote_path,$(OBJ)PictureEdit.c) -o $(call quote_path,$@)

$(OBJ)about.o: $(OBJ)about.c
	$(CC) $(CFLAGS) $(PRJ_CFLAGS) $(FVISIBILITY) -c $(call quote_path,$(OBJ)about.c) -o $(call quote_path,$@)

$(OBJ)ide.o: $(OBJ)ide.c
	$(CC) $(CFLAGS) $(PRJ_CFLAGS) $(FVISIBILITY) -c $(call quote_path,$(OBJ)ide.c) -o $(call quote_path,$@)

$(OBJ)IDESettings.o: $(OBJ)IDESettings.c
	$(CC) $(CFLAGS) $(PRJ_CFLAGS) $(FVISIBILITY) -c $(call quote_path,$(OBJ)IDESettings.c) -o $(call quote_path,$@)

$(OBJ)OldIDESettings.o: $(OBJ)OldIDESettings.c
	$(CC) $(CFLAGS) $(PRJ_CFLAGS) $(FVISIBILITY) -c $(call quote_path,$(OBJ)OldIDESettings.c) -o $(call quote_path,$@)

$(OBJ)ProjectSettings.o: $(OBJ)ProjectSettings.c
	$(CC) $(CFLAGS) $(PRJ_CFLAGS) $(FVISIBILITY) -c $(call quote_path,$(OBJ)ProjectSettings.c) -o $(call quote_path,$@)

$(OBJ)licensing.o: $(OBJ)licensing.c
	$(CC) $(CFLAGS) $(PRJ_CFLAGS) $(FVISIBILITY) -c $(call quote_path,$(OBJ)licensing.c) -o $(call quote_path,$@)

ifdef WINDOWS_TARGET

$(OBJ)resources.o: src/resources.rc
	$(WINDRES) $(WINDRES_FLAGS) $< "$(call escspace,$(call quote_path,$@))"
endif

$(OBJ)$(MODULE).main$(O): $(OBJ)$(MODULE).main.c
	$(CC) $(CFLAGS) $(PRJ_CFLAGS) $(FVISIBILITY) -c $(OBJ)$(MODULE).main.c -o $(call quote_path,$@)

cleantarget: objdir
	$(call rmq,$(OBJ)$(MODULE).main.o $(OBJ)$(MODULE).main.c $(OBJ)$(MODULE).main.ec $(OBJ)$(MODULE).main$(I) $(OBJ)$(MODULE).main$(S))
	$(call rmq,$(OBJ)symbols.lst)
	$(call rmq,$(OBJ)objects.lst)
	$(call rmq,$(TARGET))
ifdef SHARED_LIBRARY_TARGET
ifdef LINUX_TARGET
ifdef LINUX_HOST
	$(call rmq,$(OBJ)$(LP)$(MODULE)$(SO)$(basename $(VER)))
	$(call rmq,$(OBJ)$(LP)$(MODULE)$(SO))
endif
endif
endif

clean: cleantarget
	$(call rmq,$(_OBJECTS))
ifdef WINDOWS_TARGET
	$(call rmq,$(_RCOBJECTS))
endif
	$(call rmq,$(_ECOBJECTS))
	$(call rmq,$(_COBJECTS))
	$(call rmq,$(_BOWLS))
	$(call rmq,$(_IMPORTS))
	$(call rmq,$(_SYMBOLS))

realclean: cleantarget
	$(call rmrq,$(OBJ))

distclean: cleantarget
	$(call rmrq,obj/)
