// Autogenerated AST node
package org.python.pydev.parser.jython.ast;
import org.python.pydev.parser.jython.SimpleNode;
import java.io.DataOutputStream;
import java.io.IOException;

public class FunctionDef extends stmtType {
    public NameTokType name;
    public argumentsType args;
    public stmtType[] body;
    public decoratorsType[] decs;

    public FunctionDef(NameTokType name, argumentsType args, stmtType[]
    body, decoratorsType[] decs) {
        this.name = name;
        this.args = args;
        this.body = body;
        this.decs = decs;
    }

    public FunctionDef(NameTokType name, argumentsType args, stmtType[]
    body, decoratorsType[] decs, SimpleNode parent) {
        this(name, args, body, decs);
        this.beginLine = parent.beginLine;
        this.beginColumn = parent.beginColumn;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("FunctionDef[");
        sb.append("name=");
        sb.append(dumpThis(this.name));
        sb.append(", ");
        sb.append("args=");
        sb.append(dumpThis(this.args));
        sb.append(", ");
        sb.append("body=");
        sb.append(dumpThis(this.body));
        sb.append(", ");
        sb.append("decs=");
        sb.append(dumpThis(this.decs));
        sb.append("]");
        return sb.toString();
    }

    public void pickle(DataOutputStream ostream) throws IOException {
        pickleThis(7, ostream);
        pickleThis(this.name, ostream);
        pickleThis(this.args, ostream);
        pickleThis(this.body, ostream);
        pickleThis(this.decs, ostream);
    }

    public Object accept(VisitorIF visitor) throws Exception {
        return visitor.visitFunctionDef(this);
    }

    public void traverse(VisitorIF visitor) throws Exception {
        if (name != null)
            name.accept(visitor);
        if (args != null)
            args.accept(visitor);
        if (body != null) {
            for (int i = 0; i < body.length; i++) {
                if (body[i] != null)
                    body[i].accept(visitor);
            }
        }
        if (decs != null) {
            for (int i = 0; i < decs.length; i++) {
                if (decs[i] != null)
                    decs[i].accept(visitor);
            }
        }
    }

}
