/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb;

import java.math.BigInteger;
import org.sat4j.pb.IPBSolver;
import org.sat4j.pb.ObjectiveFunction;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.IteratorInt;
import org.sat4j.tools.DimacsStringSolver;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OPBStringSolver
extends DimacsStringSolver
implements IPBSolver {
    private static final long serialVersionUID = 1L;
    private int indxConstrObj;
    private int nbOfConstraints;
    private ObjectiveFunction obj;
    private boolean inserted = false;
    private static IConstr FAKE_CONSTR;
    static final /* synthetic */ boolean $assertionsDisabled;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.sat4j.pb.OPBStringSolver");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        FAKE_CONSTR = new IConstr(){

            public int size() {
                throw new UnsupportedOperationException("Fake IConstr");
            }

            public boolean learnt() {
                throw new UnsupportedOperationException("Fake IConstr");
            }

            public double getActivity() {
                throw new UnsupportedOperationException("Fake IConstr");
            }

            public int get(int n) {
                throw new UnsupportedOperationException("Fake IConstr");
            }
        };
    }

    public OPBStringSolver() {
    }

    public OPBStringSolver(int n) {
        super(n);
    }

    @Override
    public IConstr addPseudoBoolean(IVecInt iVecInt, IVec<BigInteger> iVec, boolean bl, BigInteger bigInteger) throws ContradictionException {
        StringBuffer stringBuffer = this.getOut();
        if (!$assertionsDisabled && iVecInt.size() != iVec.size()) {
            throw new AssertionError();
        }
        ++this.nbOfConstraints;
        if (bl) {
            int n = 0;
            while (n < iVecInt.size()) {
                stringBuffer.append(new StringBuffer().append(iVec.get(n)).append(" x").append(iVecInt.get(n)).append(" ").toString());
                ++n;
            }
            stringBuffer.append(new StringBuffer(">= ").append(bigInteger).append(" ;\n").toString());
        } else {
            int n = 0;
            while (n < iVecInt.size()) {
                stringBuffer.append(new StringBuffer().append(((BigInteger)iVec.get(n)).negate()).append(" x").append(iVecInt.get(n)).append(" ").toString());
                ++n;
            }
            stringBuffer.append(new StringBuffer(">= ").append(bigInteger.negate()).append(" ;\n").toString());
        }
        return FAKE_CONSTR;
    }

    @Override
    public void setObjectiveFunction(ObjectiveFunction objectiveFunction) {
        this.obj = objectiveFunction;
    }

    public IConstr addAtLeast(IVecInt iVecInt, int n) throws ContradictionException {
        StringBuffer stringBuffer = this.getOut();
        ++this.nbOfConstraints;
        IteratorInt iteratorInt = iVecInt.iterator();
        while (iteratorInt.hasNext()) {
            stringBuffer.append(new StringBuffer("+1 x").append(iteratorInt.next()).append(" ").toString());
        }
        stringBuffer.append(new StringBuffer(">= ").append(n).append(" ;\n").toString());
        return FAKE_CONSTR;
    }

    public IConstr addAtMost(IVecInt iVecInt, int n) throws ContradictionException {
        StringBuffer stringBuffer = this.getOut();
        ++this.nbOfConstraints;
        IteratorInt iteratorInt = iVecInt.iterator();
        while (iteratorInt.hasNext()) {
            stringBuffer.append(new StringBuffer("-1 x").append(iteratorInt.next()).append(" ").toString());
        }
        stringBuffer.append(new StringBuffer(">= ").append(-n).append(" ;\n").toString());
        return FAKE_CONSTR;
    }

    public IConstr addClause(IVecInt iVecInt) throws ContradictionException {
        StringBuffer stringBuffer = this.getOut();
        ++this.nbOfConstraints;
        for (int n : iVecInt) {
            if (n > 0) {
                stringBuffer.append(new StringBuffer("+1 x").append(n).append(" ").toString());
                continue;
            }
            stringBuffer.append(new StringBuffer("+1 ~x").append(-n).append(" ").toString());
        }
        stringBuffer.append(">= 1 ;\n");
        return FAKE_CONSTR;
    }

    public String getExplanation() {
        return null;
    }

    public void setListOfVariablesForExplanation(IVecInt iVecInt) {
    }

    public String toString() {
        StringBuffer stringBuffer = this.getOut();
        if (!this.inserted) {
            StringBuffer stringBuffer2 = new StringBuffer();
            stringBuffer2.append(new StringBuffer("* #variable= ").append(this.nVars()).toString());
            stringBuffer2.append(new StringBuffer(" #constraint= ").append(this.nbOfConstraints).append(" \n").toString());
            if (this.obj != null) {
                stringBuffer2.append("min: ");
                stringBuffer2.append(this.obj);
                stringBuffer2.append(" ;\n");
            }
            stringBuffer.insert(this.indxConstrObj, stringBuffer2.toString());
            this.inserted = true;
        }
        return stringBuffer.toString();
    }

    public String toString(String string) {
        return "OPB output solver";
    }

    public int newVar(int n) {
        StringBuffer stringBuffer = this.getOut();
        this.setNbVars(n);
        this.indxConstrObj = stringBuffer.length();
        stringBuffer.append("\n");
        return n;
    }

    public void setExpectedNumberOfClauses(int n) {
    }

    @Override
    public ObjectiveFunction getObjectiveFunction() {
        return this.obj;
    }
}

