#include <stdio.h>
#include <ecryptfs.h>

void usage(void)
{
	printf("Usage:\n"
	       "\n"
	       "ecryptfs-add-passphrase [passphrase]\n"
	       "\n");
}

int main(int argc, char *argv[])
{
	char passphrase[ECRYPTFS_MAX_PASSWORD_LENGTH + 1];
	char auth_tok_sig_hex[ECRYPTFS_SIG_SIZE_HEX + 1];
	char salt[ECRYPTFS_SALT_SIZE];
	char salt_hex[ECRYPTFS_SALT_SIZE_HEX];
	int rc = 0;

	if (argc != 2) {
		usage();
		goto out;
	}
	memcpy(passphrase, argv[1], ECRYPTFS_MAX_PASSWORD_LENGTH);
	passphrase[ECRYPTFS_MAX_PASSWORD_LENGTH] = '\0';
	rc = ecryptfs_read_salt_hex_from_rc(salt_hex);
	if (rc) {
		printf("Unable to read salt value from user's "
		       ".ecryptfsrc file; using default\n");
		from_hex(salt, ECRYPTFS_DEFAULT_SALT_HEX, ECRYPTFS_SALT_SIZE);
	} else
		from_hex(salt, salt_hex, ECRYPTFS_SALT_SIZE);
	if ((rc = ecryptfs_add_passphrase_key_to_keyring(auth_tok_sig_hex,
							 passphrase, salt))) {
		printf("Error attempting to insert passphrase "
		       "into the user session keyring; rc = [%d]. "
		       "Check the system log for more information from "
		       "libecryptfs.\n", rc);
		rc = 1;
		goto out;
	}
	auth_tok_sig_hex[ECRYPTFS_SIG_SIZE_HEX] = '\0';
	printf("Inserted auth tok with sig [%s] into the user session "
	       "keyring\n", auth_tok_sig_hex);
out:
	return rc;
}
