#include <stdio.h>
#include <ecryptfs.h>

void usage(void)
{
	printf("Usage:\n"
	       "\n"
	       "ecryptfs_rewrap_passphrase [file] [old wrapping passphrase] [new wrapping passphrase]\n"
	       "\n");
}

int main(int argc, char *argv[])
{
	char *file;
	char passphrase[ECRYPTFS_MAX_PASSWORD_LENGTH + 1];
	char *old_wrapping_passphrase;
	char *new_wrapping_passphrase;
	char salt[ECRYPTFS_SALT_SIZE];
	char salt_hex[ECRYPTFS_SALT_SIZE_HEX];
	int rc = 0;

	if (argc != 4) {
		usage();
		goto out;
	}
	file = argv[1];
	old_wrapping_passphrase = argv[2];
	new_wrapping_passphrase = argv[3];
	rc = ecryptfs_read_salt_hex_from_rc(salt_hex);
	if (rc) {
		printf("Unable to read salt value from user's "
		       ".ecryptfsrc file; using default\n");
		from_hex(salt, ECRYPTFS_DEFAULT_SALT_HEX, ECRYPTFS_SALT_SIZE);
	} else
		from_hex(salt, salt_hex, ECRYPTFS_SALT_SIZE);
	if ((rc = ecryptfs_unwrap_passphrase(passphrase, file,
					     old_wrapping_passphrase, salt))) {
		printf("Error attempting to unwrap passphrase; rc = [%d]. "
		       "Check the system log for more information from "
		       "libecryptfs.\n", rc);
		rc = 1;
		goto out;
	}
	if ((rc = ecryptfs_wrap_passphrase(file, new_wrapping_passphrase, salt,
					   passphrase))) {
		printf("Error attempting to wrap passphrase; rc = [%d]. "
		       "Check the system log for more information from "
		       "libecryptfs.\n", rc);
		rc = 1;
		goto out;
	}
out:
	return rc;
}
