dnl Copyright (C) 2008 EDF
dnl
dnl This file is part of the Code_Saturne Preprocessor.  For license
dnl information, see the LICENSE file in the top level directory of the
dnl Code_Saturne Preprocessor source distribution.

# ECS_AC_TEST_CCM
#----------------
# modifies or sets have_ccm, CCM_CPPFLAGS, CCM_LDFLAGS, and CCM_LIBS
# depending on libraries found

AC_DEFUN([ECS_AC_TEST_CCM], [

have_ccm=no
have_ccm_headers=no

AC_ARG_ENABLE(CCM,
  [  --disable-ccm           do not use CCM when available],
  [
    case "${enableval}" in
      yes) ccm=true ;;
      no)  ccm=false ;;
      *)   AC_MSG_ERROR([bad value ${enableval} for --enable-ccm]) ;;
    esac
  ],
  [ ccm=true ]
)

AC_ARG_WITH(ccm,
  [  --with-ccm=DIR          specify prefix directory for CCMIO],[
])

AC_ARG_WITH(ccm-include,
  [  --with-ccm-include=DIR  specify directory for CCMIO include files],[
])

AC_ARG_WITH(ccm-lib,
  [  --with-ccm-lib=DIR      specify directory for CCMIO library],[
])

if test "x$ccm" = "xtrue" -a "x$have_adf" = "xno" ; then
  if test "x$with_ccm" != "x" \
     -o "x$with_ccm_include" != "x" -o  "x$with_ccm_lib" != "x" ; then
    AC_MSG_ERROR([no ADF library found; required for CCM])
  else
    ccm=false
  fi
fi

if test "x$ccm" = "xtrue" ; then

  saved_CPPFLAGS="$CPPFLAGS"
  saved_LDFLAGS="$LDFLAGS"
  saved_LIBS="$LIBS"

  if test "x$with_ccm_include" != "x" ; then
    CCM_CPPFLAGS="-I$with_ccm_include"
  elif test "x$with_cgns" != "x" ; then
    CCM_CPPFLAGS="-I$with_ccm/include"
  fi

  if test "x$with_ccm_lib" != "x" ; then
    CCM_LDFLAGS="-L$with_ccm_lib"
  elif test "x$with_cgns" != "x" ; then
    CCM_LDFLAGS="-L$with_ccm/lib"
  fi

  CCM_LIBS="-lccmio $ADF_LIBS"
  CPPFLAGS="${CPPFLAGS} ${CCM_CPPFLAGS}"
  LDFLAGS="${LDFLAGS} ${CCM_LDFLAGS} $ADF_LDFLAGS"
  LIBS="${LIBS} ${CCM_LIBS}"

# Check that CCMIO header files exist

  AC_COMPILE_IFELSE([AC_LANG_PROGRAM(
[[#include <libccmio/ccmio.h>]],
[[int i = kCCMIONoErr;]])],
                    [AC_MSG_RESULT([CCMIO headers found])
                     have_ccm_headers=yes
                    ],
                    [AC_MSG_RESULT([CCMIO headers not found])
                    ])

  if test "x$have_ccm_headers" = "xyes"; then
    AC_CHECK_LIB(ccmio, CCMIOOpenFile, 
                 [ AC_DEFINE([HAVE_CCM], 1, [CCM file support])
                   have_ccm=yes
                 ], 
                 [ AC_MSG_WARN([no CCM file support])
                   have_ccm=no
                 ],
                 )
  fi

  if test "x$have_ccm" != "xyes"; then
    CCM_CPPFLAGS=""
    CCM_LDFLAGS=""
    CCM_LIBS=""
  fi

  CPPFLAGS="$saved_CPPFLAGS"
  LDFLAGS="$saved_LDFLAGS"
  LIBS="$saved_LIBS"

  unset saved_CPPFLAGS
  unset saved_LDFLAGS
  unset saved_LIBS

fi

AM_CONDITIONAL(HAVE_CCM, test x$have_ccm = xyes)

AC_SUBST(CCM_CPPFLAGS)
AC_SUBST(CCM_LDFLAGS)
AC_SUBST(CCM_LIBS)

])dnl

