dnl Copyright (C) 2004-2008 EDF
dnl
dnl This file is part of the Code_Saturne Preprocessor.  For license
dnl information, see the LICENSE file in the top level directory of the
dnl Code_Saturne Preprocessor source distribution.

# ECS_AC_CONFIG_INFO_INIT([OUTPUT FILE NAME])
#------------------------
# Write main config info file header.

AC_DEFUN([ECS_AC_CONFIG_INFO_INIT], [

# First arg is output file name
if test "$1" = "" ; then
  ecs_ac_config_info="ecs-config"
else
  ecs_ac_config_info=$1
fi

outfile="$ecs_ac_config_info"-tmp

  cat > $outfile <<\_______EOF
#!/bin/sh

# This file is generated by the configure script.
_______EOF

AC_MSG_NOTICE([initializing $ecs_ac_config_info])

])

# ECS_AC_CONFIG_INFO_EXTRA([extra config info strings])
#-------------------------
# Write extra info to config info file header.

AC_DEFUN([ECS_AC_CONFIG_INFO_EXTRA], [

AC_REQUIRE([ECS_AC_CONFIG_INFO_INIT])dnl

outfile="$ecs_ac_config_info"-tmp

echo "$1" >> $outfile

])

# ECS_AC_CONFIG_INFO_CC([cc], [version], [version_full])
#----------------------
# Write available compiler info to config info file header.

AC_DEFUN([ECS_AC_CONFIG_INFO_CC], [

AC_REQUIRE([ECS_AC_CONFIG_INFO_INIT])dnl

outfile="$ecs_ac_config_info"-tmp

if test "$2" != "" -o "$3" != "" ; then
  echo "" >> $outfile
  echo "# C compiler used for build: $2" >> $outfile
  echo "# --------------------------"    >> $outfile
  if test "$3" != "" ; then
    echo "$3" | sed 's/^/# /' >> $outfile
  fi
  echo "" >> $outfile
else
  AC_MSG_NOTICE([C compiler version info unavailable for configuration file])
fi

echo "cc=$1" >> $outfile
echo "" >> $outfile
])

# ECS_AC_CONFIG_INFO_VERSION([version])
#------------------------------
# Write version info.

AC_DEFUN([ECS_AC_CONFIG_INFO_VERSION], [

AC_REQUIRE([ECS_AC_CONFIG_INFO_INIT])dnl

outfile="$ecs_ac_config_info"-tmp

echo ""                  >> $outfile
echo "# Package Version" >> $outfile
echo "#----------------" >> $outfile
echo ""                  >> $outfile

echo "version=\"$1\"" >> $outfile
echo "" >> $outfile

])

# ECS_AC_CONFIG_INFO_DIRS([prefix], [exec_prefix])
#------------------------
# Write install path info.

AC_DEFUN([ECS_AC_CONFIG_INFO_DIRS], [

AC_REQUIRE([ECS_AC_CONFIG_INFO_INIT])dnl

outfile="$ecs_ac_config_info"-tmp

echo ""                           >> $outfile
echo "# Installation directories" >> $outfile
echo "#-------------------------" >> $outfile
echo ""                           >> $outfile

echo "prefix=\"$1\"" >> $outfile
if test "$2" = "NONE" ; then
  echo "exec_prefix=\"\${prefix}\"" >> $outfile
else
  echo "exec_prefix=\"$2\"" >> $outfile
fi
echo "" >> $outfile

])

# ECS_AC_CONFIG_INFO_FLAGS([cppflags], [cflags], [ldflags], [libs])
#-------------------------
# Write compiler and linker flags.

AC_DEFUN([ECS_AC_CONFIG_INFO_FLAGS], [

AC_REQUIRE([ECS_AC_CONFIG_INFO_INIT])dnl

outfile="$ecs_ac_config_info"-tmp

echo "cppflags=\"$1\"" >> $outfile
echo "cflags=\"$2\""   >> $outfile
echo "ldflags=\"$3\""  >> $outfile
echo "libs=\"$4\""     >> $outfile

echo "" >> $outfile

])

# ECS_AC_CONFIG_INFO_FINALIZE
#----------------------------
# Write main config info file body (script part).

AC_DEFUN([ECS_AC_CONFIG_INFO_FINALIZE], [

AC_REQUIRE([ECS_AC_CONFIG_INFO_INIT])dnl

outfile="$ecs_ac_config_info"-tmp

cat >> $outfile <<\_______EOF

# Output info depending on command-line options
#----------------------------------------------

if test [$]# -eq 0; then
  show_help=yes

else
  for opt in [$]*
  do
    case [$]opt in
      --prefix)
        output="${output} $prefix"
        ;;
      --exec-prefix)
        if test "$exec_prefix" != "" ; then
          output="${output} $exec_prefix"
        else
          output="${output} $prefix/bin"
        fi
        ;;
      --version)
        output="${output} $version"
        ;;
      --cppflags)
        echo_cppflags=yes
        ;;
      --cflags)
        echo_cflags=yes
        ;;
      --ldflags)
        echo_ldflags=yes
        ;;
      --libs)
        echo_libs=yes
        ;;
      --cc)
        output="${output} $cc"
        ;;
      -*)
        show_help=yes
        ;;
    esac
  done
fi

if test "[$]show_help" = "yes"; then
  cat <<EOF
Usage: ecs-config [options]

Options:
        --prefix            installation path prefix
        --exec-prefix       system-dependent path prefix
        --version           version

        --cppflags          C preprocessor flags (e.g. -D<macro>, ...)
        --cflags            C flags (e.g. -O, -g, ...)
        --ldflags           linker flags (e.g. -g, -L<path>, ...)
        --libs              librairies used (e.g. -l<libname>)

        --cc                C compiler used for build

EOF
  exit 1
fi

if test "$echo_cppflags" = "yes" ; then
  output="${output} $cppflags"
fi
if test "$echo_cflags" = "yes" ; then
  output="${output} $cflags"
fi
if test "$echo_ldflags" = "yes" ; then
  output="${output} $ldflags"
fi
if test "$echo_libs" = "yes" ; then
  output="${output} $libs"
fi

if test "$output" != "" ; then
  echo $output
fi

_______EOF

AC_MSG_NOTICE([closing $ecs_ac_config_info])

diff $outfile $ecs_ac_config_info > /dev/null 2>&1
if test $? -eq 0 ; then
  AC_MSG_NOTICE([$ecs_ac_config_info is unchanged])
  rm -f $outfile
else
  mv $outfile $ecs_ac_config_info
  chmod +x $ecs_ac_config_info
fi

])dnl

