#ifndef _ECS_CHAMP_PUBL_H_
#define _ECS_CHAMP_PUBL_H_

/*============================================================================
 *  Dfinition publique de la structure `ecs_champ_t' dcrivant un champ
 *============================================================================*/

/*
  This file is part of the Code_Saturne Preprocessor, element of the
  Code_Saturne CFD tool.

  Copyright (C) 1999-2007 EDF S.A., France

  contact: saturne-support@edf.fr

  The Code_Saturne Preprocessor is free software; you can redistribute it
  and/or modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2 of
  the License, or (at your option) any later version.

  The Code_Saturne Preprocessor is distributed in the hope that it will be
  useful, but WITHOUT ANY WARRANTY; without even the implied warranty
  of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with the Code_Saturne Preprocessor; if not, write to the
  Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor,
  Boston, MA  02110-1301  USA
*/


/*============================================================================
 *                         Dclaration de la structure
 *============================================================================*/

typedef struct _ecs_champ_t  ecs_champ_t ;


/*============================================================================
 *                         Dfinitions d'numrations
 *============================================================================*/

typedef enum {

  ECS_CHAMP_NUL = -1 ,
  ECS_CHAMP_DEF      ,
  ECS_CHAMP_ATT      ,
  ECS_CHAMP_FIN

} ECS_CHAMP_E ;


#define ECS_CHAMP_DEB ECS_CHAMP_DEF


typedef enum {

  ECS_CHAMP_STATUT_INDEFINI     = -1 ,
  ECS_CHAMP_STATUT_REF_ELT           , /* Champ de numros d'lments         */
  ECS_CHAMP_STATUT_HERITABLE           /* Champ qui peut tre hrit          */

} ECS_CHAMP_STATUT_E ;


/*============================================================================
 *                         Dfinition de macros
 *============================================================================*/

/* Noms des champs */
/*-----------------*/

/*  Champs principaux */

#define ECS_CHAMP_NOM_DEFINIT                                  "definition"


/*  Champs "attribut" */

#define ECS_CHAMP_NOM_CONNECT                                "connectivite"
#define ECS_CHAMP_NOM_CONNECT_INVERSE                "connectivite inverse"
#define ECS_CHAMP_NOM_COULEUR                                     "couleur"
#define ECS_CHAMP_NOM_FILIATION                                 "filiation"
#define ECS_CHAMP_NOM_FAMILLE                                     "famille"
#define ECS_CHAMP_NOM_GROUPE                                       "groupe"
#define ECS_CHAMP_NOM_LABEL                                         "label"
#define ECS_CHAMP_NOM_FAC_PERIO            "faces initiales -> periodiques"


#endif /* _ECS_CHAMP_PUBL_H_ */
