#ifndef _ECS_CONNECT_H_
#define _ECS_CONNECT_H_

/*============================================================================
 *  Prototypes des fonctions de base
 *   associes  la structure `ecs_connect_t' dcrivant une connectivit
 *============================================================================*/

/*
  This file is part of the Code_Saturne Preprocessor, element of the
  Code_Saturne CFD tool.

  Copyright (C) 1999-2007 EDF S.A., France

  contact: saturne-support@edf.fr

  The Code_Saturne Preprocessor is free software; you can redistribute it
  and/or modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2 of
  the License, or (at your option) any later version.

  The Code_Saturne Preprocessor is distributed in the hope that it will be
  useful, but WITHOUT ANY WARRANTY; without even the implied warranty
  of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with the Code_Saturne Preprocessor; if not, write to the
  Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor,
  Boston, MA  02110-1301  USA
*/


/*============================================================================
 *                                 Visibilit
 *============================================================================*/

/*----------------------------------------------------------------------------
 *  Fichiers `include' librairie standard C ou BFT
 *----------------------------------------------------------------------------*/

#include <bft_file.h>


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  du  paquetage global "Utilitaire"
 *----------------------------------------------------------------------------*/

#include "ecs_def.h"


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  des paquetages visibles
 *----------------------------------------------------------------------------*/

#include "ecs_entmail_publ.h"


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  du  paquetage courant
 *----------------------------------------------------------------------------*/

#include "ecs_connect_publ.h"


/*============================================================================
 *                       Prototypes de fonctions publiques
 *============================================================================*/

/*----------------------------------------------------------------------------
 *  Fonction qui cre une structure `ecs_connect_t'
 *----------------------------------------------------------------------------*/

ecs_connect_t * ecs_connect__cree
(                                     /* <-- Reference sur la connect. creee  */
 ecs_entmail_t      * entmail       , /* --> Pointeur sur elements maillage   */
 ecs_entmail_t      * entmail_inf   , /* --> Pointeur sur elements `fils'     */
 ECS_CONNECT_NAT_E    connect_nat_e   /* --> Type de connect. entre entites   */
) ;


/*----------------------------------------------------------------------------
 *  Fonction librant une structure `ecs_connect_t' donne en argument.
 *  Elle renvoie un pointeur NULL
 *----------------------------------------------------------------------------*/

ecs_connect_t * ecs_connect__detruit
(
 ecs_connect_t * this_connect
) ;


/*----------------------------------------------------------------------------
 *  Fonction imprimant le contenu d'une structure `ecs_connect_t' donne
 *   sur le flux dcrit par la structure `bft_file_t'
 *----------------------------------------------------------------------------*/

void ecs_connect__imprime
(
 const ecs_connect_t *const this_connect ,      /* --> Structure a imprimer   */
       ecs_int_t            imp_col      ,
       bft_file_t    *const fic_imp             /* --> Descripteur du fichier */
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui renvoie la taille en octets d'une structure `ecs_connect_t'
 *----------------------------------------------------------------------------*/

float ecs_connect__ret_taille
(
 const ecs_connect_t *const this_connect
) ;


/*----------------------------------------------------------------------------
 *  Fonction ralisant, pour une connectivit donne,
 *   une transformation entre ses 2 entits de maillage membres
 *----------------------------------------------------------------------------*/

void ecs_connect__cree_indice
(
 ecs_connect_t    *this_connect  /* <-> Connectivit concerne par la transf. */
) ;


/*----------------------------------------------------------------------------
 *  Fonction ralisant la transformation d'une connectivit donne
 *   en une "sous-connectivit"
 *
 *  Elle renvoie la nouvelle connectivit associant
 *   l'entit de maillage des lments      avec
 *   l'entit de maillage des sous-lments
 *
 *  La connectivit donne met en jeu des lments dfinis
 *   par des lments d'une entit de maillage lmentaire
 *  La "sous-connectivit" correspondante met en jeu les sous-lments dfinis
 *   par des lments de  l'entit de maillage lmentaire
 *
 *  Exemple :
 *  -------
 *
 * connectivit donne                : Cellule->Sommet (ECS_CONNECT_CEL_SOM)
 *                           lments : cellules
 *     Entit de maillage lmentaire : Sommet
 *
 * "sous-connectivit" correspondante : Face->Sommet    (ECS_CONNECT_FAC_SOM)
 *                      Sous-lments : faces
 *----------------------------------------------------------------------------*/

ecs_connect_t * ecs_connect__cree_sous_connect
(                                 /* <-- Nouvelle connectivit associant      */
                                  /*      les lments  leurs sous-lments  */
 ecs_connect_t   * this_connect , /* --> Connectivit donne  transformer    */
 ecs_connect_t  ** sous_connect , /* <-> Sous-connectivit                    */
 ecs_entmail_t  ** ent_sous_elt , /* <-- Entit de maillage des sous-lments */
 ECS_CONNECT_E     connect_typ    /* --> Type de connectivit de dpart       */
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui cre la liste des connectivits
 *   dans une reprsentation du maillage en connectivit nodale
 *    partir du vecteur des entits de maillage
 *         et de la nature de la connectivit (par tiquette ou par indice)
 *----------------------------------------------------------------------------*/

ecs_connect_t * * ecs_connect__cree_nodal
(
 ecs_entmail_t     * *const vect_entmail  ,
 ECS_CONNECT_NAT_E          connect_nat_e
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui cre la liste des connectivits
 *   dans une reprsentation du maillage en connectivit descendante
 *    partir du vecteur des entits de maillage
 *----------------------------------------------------------------------------*/

ecs_connect_t * * ecs_connect__cree_descendant
(
 ecs_entmail_t * *const vect_entmail
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui retourne le type de la connectivit :
 *  - connectivit nodale      : ECS_CONNECT_TYP_NODALE
 *  - connectivit descendante : ECS_CONNECT_TYP_DESCENDANTE
 *   associe au tableau des connectivits
 *
 *  Si le maillage ne comporte que des artes,
 *   la fonction ne peut pas dterminer le type de la connectivit
 *   et retourne ECS_CONNECT_TYP_NUL
 *----------------------------------------------------------------------------*/

ECS_CONNECT_TYP_E ecs_connect__ret_connect_typ
(
 ecs_connect_t *const liste_connect[] ,
 ecs_entmail_t *const liste_entmail[]
) ;


#endif /* _ECS_CONNECT_H_ */
