#ifndef _ECS_DESCR_CHAINE_H_
#define _ECS_DESCR_CHAINE_H_

/*============================================================================
 *  Prototypes des fonctions de base
 *   associes  une liste chane de structures `ecs_descr_t' dcrivant
 *   un descripteur de champ
 *============================================================================*/

/*
  This file is part of the Code_Saturne Preprocessor, element of the
  Code_Saturne CFD tool.

  Copyright (C) 1999-2007 EDF S.A., France

  contact: saturne-support@edf.fr

  The Code_Saturne Preprocessor is free software; you can redistribute it
  and/or modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2 of
  the License, or (at your option) any later version.

  The Code_Saturne Preprocessor is distributed in the hope that it will be
  useful, but WITHOUT ANY WARRANTY; without even the implied warranty
  of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with the Code_Saturne Preprocessor; if not, write to the
  Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor,
  Boston, MA  02110-1301  USA
*/


/*============================================================================
 *                                 Visibilit
 *============================================================================*/


/*----------------------------------------------------------------------------
 *  Fichiers `include' librairie standard C ou BFT
 *----------------------------------------------------------------------------*/

#include <bft_file.h>


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  du  paquetage global "Utilitaire"
 *----------------------------------------------------------------------------*/

#include "ecs_tab_glob.h"


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  des paquetages visibles
 *----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  du  paquetage courant
 *----------------------------------------------------------------------------*/

#include "ecs_descr_publ.h"


/*============================================================================
 *                       Prototypes de fonctions publiques
 *============================================================================*/


/*----------------------------------------------------------------------------
 *  Fonction librant la portion d'une liste chane de descripteurs
 *    partir d'un noeud dont le pointeur est donn en argument.
 *  Le noeud est  NULL au retour de la fonction
 *----------------------------------------------------------------------------*/

void ecs_descr_chaine__detruit
(
 ecs_descr_t * * this_descr_noeud
) ;


/*----------------------------------------------------------------------------
 *  Fonction imprimant  partir d'un noeud `ecs_descr_t' donn
 *   une liste chane de champs
 *   sur le flux dcrit par la structure `bft_file_t'
 *----------------------------------------------------------------------------*/

void ecs_descr_chaine__imprime
(
 const ecs_descr_t *const this_descr_noeud ,
       ecs_int_t          imp_col          ,
       bft_file_t  *const fic_imp
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui renvoie la taille en octets
 *   d'une chane de structures `ecs_descr_t'
 *----------------------------------------------------------------------------*/

float ecs_descr_chaine__ret_taille
(
 const ecs_descr_t *const this_descr_noeud
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui ajoute  la fin d'une liste chane de descripteurs de champ
 *   rceptrice dont la tte est donne,
 *   une liste chane de descripteurs de champ  concatner
 *    dont la tte est donne
 *
 *  Elle renvoie l'incrment des numros de descripteurs de la liste ajoute
 *   pour l'incrmentation des valeurs de l'attribut des lments
 *
 *  Les numros des descripteurs de la liste  concatner sont incrments
 *    partir du nombre de descripteur de la liste rceptrice
 *
 *  Remarque: cette fonction se contente d'ajouter des descripteurs sans
 *            vrifier si le descripteur ajoute a le mme contenu qu'un autre
 *            descripteur dj prsent dans la liste.
 *            Pour une vrification, utiliser `ecs_descr_chaine__concat()'
 *----------------------------------------------------------------------------*/

void ecs_descr_chaine__ajoute
(
 ecs_descr_t *      * this_descr_tete   ,
 ecs_descr_t *const   descr_concat_tete
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui renvoie le nombre de descripteurs
 *   de la liste chane des descripteurs dont la tte est donne
 *----------------------------------------------------------------------------*/

ecs_int_t ecs_descr_chaine__ret_nbr
(
 const ecs_descr_t *const this_descr_tete
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui copie une liste chane de descripteurs
 *   dont la tte est donne
 *----------------------------------------------------------------------------*/

ecs_descr_t * ecs_descr_chaine__copie
(
 ecs_descr_t * descr_tete
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui concatne,
 *    la fin d'une liste chane de descripteurs dont la tte est donne,
 *   une autre liste chane de descripteurs dont la tte est donne,
 *   en supprimant les descripteurs dj prsents dans la 1re liste
 *   et en dcalant la renumrotation des descripteurs de la 2nde liste
 *
 *  La fonction renvoie la renumrotation des descripteurs de la 2nde liste
 *----------------------------------------------------------------------------*/

ecs_tab_int_t ecs_descr_chaine__concatene
(
 ecs_descr_t * *const descr_recept_tete ,
 ecs_descr_t * *const descr_concat_tete
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui affiche les contenus des descripteurs
 *   de la liste chane des descripteurs dont la tte est donne
 *----------------------------------------------------------------------------*/

void ecs_descr_chaine__affiche
(
       ecs_descr_t  *const descr_tete ,
 const int                 decal
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui recherche dans une liste chane de descripteurs
 *   dont la tte est donne,
 *   un numro de descripteur donn
 *
 *  La fonction renvoie :
 *  -    le pointeur du descripteur si le numro de descripteur a t trouve
 *  - ou NULL                       sinon
 *----------------------------------------------------------------------------*/

ecs_descr_t * ecs_descr_chaine__cherche_num
(
       ecs_descr_t *const descr_tete ,
 const ecs_int_t          num
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui recherche dans une liste chane de descripteurs
 *   dont la tte est donne,
 *   un descripteur ayant les mmes identificateur et nom
 *   que le descripteur donn
 *
 *  La fonction renvoie :
 *  -    le numro du descripteur si le descripteur   a     t trouve
 *  - ou ECS_DESCR_NUM_NUL        si le descripteur n'a pas t trouve
 *----------------------------------------------------------------------------*/

ecs_int_t ecs_descr_chaine__trouve_num
(
       ecs_descr_t *const descr_tete ,
 const ecs_descr_t *const descr_rech
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui cre une nouvelle chane de descripteurs
 *    partir d'une chane de descripteurs dont la tte est donne
 *  Un descripteur est copi dans la nouvelle chane si son numro
 *   ne se transforme pas par le vecteur de transformation donn
 *   en `ECS_DESCR_NUM_NUL'
 *  Les membres du descripteur sont copies dans le nouveau sans modification
 *   sauf le numro qui devient celui transforme par le vecteur
 *----------------------------------------------------------------------------*/

ecs_descr_t * ecs_descr_chaine__renumerote
(
       ecs_descr_t   *const this_descr_tete ,
 const ecs_tab_int_t        vect_transf
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui renvoie le nombre et la liste des identificateurs
 *   des descripteurs de type couleur d'une liste chane dont la tte est
 *   donne en argument
 *----------------------------------------------------------------------------*/

ecs_tab_int_t ecs_descr_chaine__ret_ide
(
 ecs_descr_t  *const descr_tete
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui renvoie le nombre et la liste des pointeurs sur les noms
 *   des descripteurs de type groupe d'une liste chane dont la tte est
 *   donne en argument
 *----------------------------------------------------------------------------*/

ecs_tab_char_t ecs_descr_chaine__ret_nom
(
 ecs_descr_t  *const descr_tete
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui renvoie la liste des rfrences des descripteurs
 *   de la liste chane des descripteurs dont la tte est donne
 *----------------------------------------------------------------------------*/

ecs_descr_t * * ecs_descr_chaine__ret_ref
(
 ecs_descr_t  *const descr_tete ,
 ecs_int_t    *const nbr_descr
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui retourne la tte de la liste chane des descripteurs
 *   de type donn `descr_typ_e'
 *   contenus dans la liste chane des descripteurs dont la tte est donne
 *----------------------------------------------------------------------------*/

ecs_descr_t * ecs_descr_chaine__ret_descr_typ
(
 ecs_descr_t      *const this_descr_tete ,
 ECS_DESCR_TYP_E         descr_typ_e
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui indique si une chane de descripteurs contient l'un des
 *   attributs (couleur ou groupe) fournis en argument.
 *----------------------------------------------------------------------------*/

ecs_bool_t ecs_descr_chaine__select
(
 const ecs_descr_t     *const descr_tete    ,
 const ecs_tab_int_t          liste_couleur ,
 const ecs_tab_char_t         liste_groupe
) ;


#endif /* _ECS_DESCR_CHAINE_H_ */
