#ifndef _ECS_ENTMAIL_H_
#define _ECS_ENTMAIL_H_

/*============================================================================
 *  Prototypes des fonctions de base
 *   associes  la structure `ecs_entmail_t' dcrivant une entit de maillage
 *   quelconque (une entit principale ou une sous-entit)
 *============================================================================*/

/*
  This file is part of the Code_Saturne Preprocessor, element of the
  Code_Saturne CFD tool.

  Copyright (C) 1999-2007 EDF S.A., France

  contact: saturne-support@edf.fr

  The Code_Saturne Preprocessor is free software; you can redistribute it
  and/or modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2 of
  the License, or (at your option) any later version.

  The Code_Saturne Preprocessor is distributed in the hope that it will be
  useful, but WITHOUT ANY WARRANTY; without even the implied warranty
  of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with the Code_Saturne Preprocessor; if not, write to the
  Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor,
  Boston, MA  02110-1301  USA
*/


/*============================================================================
 *                                 Visibilit
 *============================================================================*/


/*----------------------------------------------------------------------------
 *  Fichiers `include' librairie standard C ou BFT
 *----------------------------------------------------------------------------*/

#include <bft_file.h>


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  du  paquetage global "Utilitaire"
 *----------------------------------------------------------------------------*/

#include "ecs_tab_glob.h"


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  des paquetages visibles
 *----------------------------------------------------------------------------*/

#include "ecs_champ_publ.h"


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  du  paquetage courant
 *----------------------------------------------------------------------------*/

#include "ecs_entmail_publ.h"


/*============================================================================
 *                       Prototypes de fonctions publiques
 *============================================================================*/


/*----------------------------------------------------------------------------
 *  Fonction allouant et initialisant une structure `ecs_entmail_t'
 *----------------------------------------------------------------------------*/

ecs_entmail_t * ecs_entmail__cree
(
 void
) ;


/*----------------------------------------------------------------------------
 *  Fonction librant une structure `ecs_entmail_t'donne en argument.
 *  Elle renvoie un pointeur NULL
 *----------------------------------------------------------------------------*/

ecs_entmail_t * ecs_entmail__detruit
(
 ecs_entmail_t * this_entmail
) ;


/*----------------------------------------------------------------------------
 *  Fonction imprimant le contenu d'une structure `ecs_entmail_t' donne
 *   sur le flux dcrit par la structure `bft_file_t'
 *----------------------------------------------------------------------------*/

void ecs_entmail__imprime
(
 const ecs_entmail_t  *const this_entmail ,     /* --> Structure a imprimer   */
       ecs_int_t             imp_col      ,
 const ecs_int_t             nbr_imp      ,
       bft_file_t     *const fic_imp            /* --> Descripteur du fichier */
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui retourne le nombre d'lments d'une structure `ecs_entmail_t'
 *----------------------------------------------------------------------------*/


size_t ecs_entmail__ret_nbr_ele
(
 const ecs_entmail_t * const this_entmail
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui renvoie la taille en octets d'une structure `ecs_entmail_t'
 *----------------------------------------------------------------------------*/

float ecs_entmail__ret_taille
(
 const ecs_entmail_t *const this_entmail
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui ajoute un champ donn dans une entit de maillage donne
 *----------------------------------------------------------------------------*/

void ecs_entmail__ajoute_champ
(
 ecs_entmail_t * this_entmail ,     /* <-> Structure a remplir                */
 ecs_champ_t   * champ        ,     /* --> Reference du champ a a jouter      */
 ECS_CHAMP_E     champ_e            /* --> Identificateur du champ            */
) ;


/*----------------------------------------------------------------------------
 *  Fonction supprimant un champ d'une entit de maillage.
 *----------------------------------------------------------------------------*/

void ecs_entmail__supprime_champ
(
       ecs_entmail_t   *const  this_entmail , /* <-> Entit de maillage       */
 const char            *const  nom_champ    , /* --> Nom du champ             */
       ECS_CHAMP_E             champ_e        /* --> Identificateur du champ  */
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui retourne la rfrence du champ correspondant
 *   a l'identificateur de champ donn d'une entit de maillage donne
 *----------------------------------------------------------------------------*/

ecs_champ_t * ecs_entmail__ret_champ
(
 ecs_entmail_t * this_entmail ,    /* --> Entite de maillage du champ         */
 ECS_CHAMP_E     champ_e           /* --> Identificateur du champ a retourner */
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui affiche des nombres d'lments par entit
 *----------------------------------------------------------------------------*/

void ecs_entmail__aff_nbr_par_ent
(
 const size_t nbr_elt_ent[] ,
 int          lng_imp
) ;


#endif /* _ECS_ENTMAIL_H_ */
