#ifndef _ECS_ENTMAIL_PUBL_H_
#define _ECS_ENTMAIL_PUBL_H_

/*============================================================================
 *  Dfinition publique de la structure `ecs_entmail_t' dcrivant
 *   une entit de maillage
 *============================================================================*/

/*
  This file is part of the Code_Saturne Preprocessor, element of the
  Code_Saturne CFD tool.

  Copyright (C) 1999-2007 EDF S.A., France

  contact: saturne-support@edf.fr

  The Code_Saturne Preprocessor is free software; you can redistribute it
  and/or modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2 of
  the License, or (at your option) any later version.

  The Code_Saturne Preprocessor is distributed in the hope that it will be
  useful, but WITHOUT ANY WARRANTY; without even the implied warranty
  of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with the Code_Saturne Preprocessor; if not, write to the
  Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor,
  Boston, MA  02110-1301  USA
*/


/*============================================================================
 *                         Dclaration de la structure
 *============================================================================*/

typedef struct _ecs_entmail_t    ecs_entmail_t ;


/*============================================================================
 *                         Dfinition d'numeration
*============================================================================*/

/*----------------------------------------------------------------------------
 *  Dfinition d'numeration lie au tableau des entits de maillage
 *---------------------------------------------------------------------------*/

typedef enum {

  ECS_ENTMAIL_SOM ,  /* Entit sommet               */
  ECS_ENTMAIL_ARE ,  /* Entit arte                */
  ECS_ENTMAIL_FAC ,  /* Entit face                 */
  ECS_ENTMAIL_CEL ,  /* Entit cellule              */
  ECS_ENTMAIL_FIN    /* Nombre des entits dfinies */

} ECS_ENTMAIL_E ;


#define ECS_ENTMAIL_DEB  ECS_ENTMAIL_SOM


#endif /* _ECS_ENTMAIL_PUBL_H_ */
