#ifndef _ECS_FAMILLE_H_
#define _ECS_FAMILLE_H_

/*============================================================================
 *  Prototypes des fonctions de base
 *   associes  la structure `ecs_famille_t' dcrivant une famille
 *============================================================================*/

/*
  This file is part of the Code_Saturne Preprocessor, element of the
  Code_Saturne CFD tool.

  Copyright (C) 1999-2007 EDF S.A., France

  contact: saturne-support@edf.fr

  The Code_Saturne Preprocessor is free software; you can redistribute it
  and/or modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2 of
  the License, or (at your option) any later version.

  The Code_Saturne Preprocessor is distributed in the hope that it will be
  useful, but WITHOUT ANY WARRANTY; without even the implied warranty
  of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with the Code_Saturne Preprocessor; if not, write to the
  Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor,
  Boston, MA  02110-1301  USA
*/


/*============================================================================
 *                                 Visibilit
 *============================================================================*/

/*---------------------------------------------------------------------------
 *  Fichiers `include' librairie standard C ou BFT
 *----------------------------------------------------------------------------*/

#include <bft_file.h>


/*---------------------------------------------------------------------------
 *  Fichiers `include' publics  du  paquetage global "Utilitaire"
 *----------------------------------------------------------------------------*/

#include "ecs_def.h"
#include "ecs_tab_glob.h"


/*---------------------------------------------------------------------------
 *  Fichiers `include' publics  des paquetages visibles
 *----------------------------------------------------------------------------*/

#include "ecs_descr_publ.h"


/*---------------------------------------------------------------------------
 *  Fichiers `include' publics  du  paquetage courant
 *----------------------------------------------------------------------------*/

#include "ecs_famille_publ.h"


/*============================================================================
 *                       Prototypes de fonctions publiques
 *============================================================================*/

/*---------------------------------------------------------------------------
 *    Fonction de cration d'une structure de famille `ecs_famille_t'
 *----------------------------------------------------------------------------*/

ecs_famille_t * ecs_famille__cree
(
 ecs_int_t          num        ,        /* --> Numro de la famille           */
 ecs_descr_t *const descr_tete          /* --> Tte de la liste chane       */
                                        /*      de descripteurs d'attributs   */
) ;


/*---------------------------------------------------------------------------
 *  Fonction librant la structure `ecs_famille_t' donne en argument.
 *  Elle renvoie un pointeur NULL
 *----------------------------------------------------------------------------*/

ecs_famille_t * ecs_famille__detruit
(
 ecs_famille_t * this_fam
) ;


/*---------------------------------------------------------------------------
 *  Fonction imprimant le contenu d'une structure `ecs_famille_t' donne
 *   sur le flux dcrit par la structure `bft_file_t'
 *----------------------------------------------------------------------------*/

void ecs_famille__imprime
(
 const ecs_famille_t *const this_fam ,          /* --> Structure  imprimer   */
       ecs_int_t            imp_col  ,
       bft_file_t    *const fic_imp             /* --> Descripteur du fichier */
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui renvoie la taille en octets d'une structure `ecs_famille_t'
 *----------------------------------------------------------------------------*/

float ecs_famille__ret_taille
(
  const ecs_famille_t *const this_fam
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui alloue une structure `ecs_famille_t' et qui remplit
 *   son contenu en copiant le contenu de la structure donne en argument
 *----------------------------------------------------------------------------*/

ecs_famille_t * ecs_famille__copie
(                                     /* <-- Renvoie la structure copie      */
 ecs_famille_t * this_famille         /* --> Structure  copier               */
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui affiche la dfinition de la famille
 *----------------------------------------------------------------------------*/

void ecs_famille__affiche
(
 const ecs_famille_t *const this_fam
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui renvoie le nombre et la liste des identificateurs des
 *   descripteurs de la famille donne en argument
 *----------------------------------------------------------------------------*/

ecs_tab_int_t ecs_famille__ret_ide
(
 const ecs_famille_t *const this_fam
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui renvoie le nombre et la liste des des pointeurs sur les noms
 *   des descripteurs de la famille donne en argument
 *----------------------------------------------------------------------------*/

ecs_tab_char_t ecs_famille__ret_nom
(
 const ecs_famille_t *const this_fam
) ;


/*----------------------------------------------------------------------------
 *  Fonction qui construit les 2 listes chanes de descripteurs
 *   de type "couleur" et "groupe"  partir de la famille donne
 *----------------------------------------------------------------------------*/

void ecs_famille__cree_descr
(
 ecs_famille_t   *const this_fam           ,
 ecs_descr_t   * *const descr_tete_couleur ,
 ecs_descr_t   * *const descr_tete_groupe
) ;


#endif /* _ECS_FAMILLE_H_ */
