#ifndef _ECS_PARAM_RC_GLOB_H_
#define _ECS_PARAM_RC_GLOB_H_

/*============================================================================
 *  Dfinition publique de la structure `ecs_param_rc_t' contenant
 *   les paramtres relatifs au recollement conforme
 *============================================================================*/

/*
  This file is part of the Code_Saturne Preprocessor, element of the
  Code_Saturne CFD tool.

  Copyright (C) 1999-2007 EDF S.A., France

  contact: saturne-support@edf.fr

  The Code_Saturne Preprocessor is free software; you can redistribute it
  and/or modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2 of
  the License, or (at your option) any later version.

  The Code_Saturne Preprocessor is distributed in the hope that it will be
  useful, but WITHOUT ANY WARRANTY; without even the implied warranty
  of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with the Code_Saturne Preprocessor; if not, write to the
  Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor,
  Boston, MA  02110-1301  USA
*/


/*============================================================================
 *                                 Visibilit
 *============================================================================*/

/*----------------------------------------------------------------------------
 *  Fichiers `include' librairie standard C
 *----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  du  paquetage global "Utilitaire"
 *----------------------------------------------------------------------------*/

#include "ecs_def.h"
#include "ecs_tab_glob.h"


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  des paquetages visibles
 *----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------
 *  Fichiers `include' publics  du  paquetage courant
 *----------------------------------------------------------------------------*/

#include "ecs_param_perio_glob.h"


/*============================================================================
 *                          Dfinition de macros
 *============================================================================*/


/*============================================================================
 *                       Dfinition de la structure
 *============================================================================*/


typedef struct _ecs_param_rc_t {

  ecs_int_t            num_rc ;         /* Numro du recollement              */
  ecs_real_t           fraction_dist ;  /* Tolrance pour intersections       */
                                        /* (distance locale)                  */
  ecs_real_t           epsilon_plan  ;  /* Tolrance pour la planit         */
                                        /* (reconstruction faces)             */
  ecs_param_perio_t  * param_perio ;    /* Paramtres de priodicit          */
  ecs_bool_t           semi_conforme ;  /* Connectivit initiale partielle-
                                           ment conforme (i.e. faces
                                           et artes partagent un sommet)     */

} ecs_param_rc_t ;



/*============================================================================
 *                         Dfinitions d'numerations
 *============================================================================*/


#endif /* _ECS_PARAM_RC_GLOB_H_ */
